/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTEntrypoint;
import com.adobe.air.ADTPackager;
import com.adobe.air.AIRMigrationSigner;
import com.adobe.air.AIRPackager;
import com.adobe.air.CertificateCreator;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Utils;
import com.adobe.air.nai.DEBPackager;
import com.adobe.air.nai.DMGPackager;
import com.adobe.air.nai.EXEPackager;
import com.adobe.air.nai.NativePackager;
import com.adobe.air.nai.RPMPackager;
import com.adobe.argv.UsageError;
import com.adobe.ucf.ISigner;
import com.adobe.ucf.Packager;
import com.adobe.ucf.UCF;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;

public final class ADT
extends ADTEntrypoint {
    public static final String PATH_DESCRIPTOR = "META-INF/AIR/application.xml";
    public static final String PATH_HASH = "META-INF/AIR/hash";
    public static final String PATH_DEBUG = "META-INF/AIR/debug";
    public static final String DEFAULT_TSA_URL = "https://timestamp.geotrust.com/tsa";
    private static final String EXT_AIR = "air";
    private static final String EXT_AIRI = "airi";
    private static final String EXT_EXE = "exe";
    private static final String EXT_DMG = "dmg";
    private static final String EXT_RPM = "rpm";
    private static final String EXT_DEB = "deb";
    private static final String ARG_NATIVE = "native";
    private static final String ARG_PREPARE = "-prepare";
    private static final String ARG_SIGN = "-sign";
    private static final String ARG_MIGRATE = "-migrate";
    private static final String ARG_CERT = "-certificate";
    private static final String ARG_CHECK_PASS = "-checkstore";
    private static final String ARG_NO_VALIDATE = "-Xnovalidate";
    private static final String ARG_DEBUG = "-Xdebug";
    private static final String ARG_RUNTIME = "-Xruntime";
    private static String Adobe_patent_P817 = "AdobePatentId=\"P817\"";
    private static String Adobe_patent_P851 = "AdobePatentId=\"P851\"";
    private boolean m_debug;
    private Target m_target;
    private CertificateCreator m_creator;
    private boolean m_signingApp = false;

    public static void main(String[] args) {
        ADT adt = new ADT();
        int result = adt.run(args);
        System.exit(result);
    }

    public String getExecutableName() {
        return "adt";
    }

    protected void printUsage() {
        System.err.println("usage:");
        System.err.println("  adt -checkstore SIGNING_OPTIONS");
        System.err.println("  adt -certificate -cn <name> ( -ou <org-unit> )? ( -o <org-name> )? ( -c <country> )? <key-type> <pfx-file> <password>");
        System.err.println("  adt -help");
        System.err.println("  adt -migrate SIGNING_OPTIONS <air-file-in> <air-file-out>");
        System.err.println("  adt -package SIGNING_OPTIONS ( -target air )? <output-package> ( FILE_OPTIONS | <input-package> )");
        System.err.println("  adt -package SIGNING_OPTIONS? -target native SIGNING_OPTIONS? <output-package> ( FILE_OPTIONS | <input-package> )");
        System.err.println("  adt -prepare <airi-file> FILE_OPTIONS");
        System.err.println("  adt -sign SIGNING_OPTIONS <airi-file> <air-file>");
        System.err.println("  adt -version");
        System.err.println();
        System.err.println("SIGNING_OPTIONS: -storetype <type> ( -keystore <store> )? ( -storepass <pass> )? ( -alias <aliasName> )? ( -keypass <pass> )? ( -providerName <name> )? ( -tsa <url> )?");
        System.err.println("FILE_OPTIONS:    <app-desc> <fileOrDir>* (( -C <dir> <fileOrDir>+ ) | ( -e <file> <path> ))*");
    }

    protected void parseArgsAndGo() throws UsageError, GeneralSecurityException, IOException {
        if (this.args.peek(ARG_PREPARE)) {
            this.parsePrepare();
            this.getAIRPackager().createIntermediate();
        } else if (this.args.peek(ARG_SIGN)) {
            this.parseSign();
            this.getAIRPackager().createPackage();
        } else if (this.args.peek(ARG_MIGRATE)) {
            this.parseMigrate();
        } else if (this.args.peek(ARG_CHECK_PASS)) {
            this.parseCheckPass();
        } else if (this.args.peek(ARG_CERT)) {
            this.m_creator = new CertificateCreator();
            this.parseCertificate();
            this.m_creator.create();
        } else {
            super.parseArgsAndGo();
        }
    }

    protected void parsePackage() throws UsageError {
        this.m_target = Target.AIR;
        if (this.args.seek("-target")) {
            this.args.accept("-target");
            String targetValue = this.args.accept();
            this.m_target = Target.getTargetFromArg(targetValue);
            if (this.m_target == null || this.m_target == Target.AIRI) {
                throw new UsageError("unknown package target " + targetValue + "; should be air or native");
            }
        }
        this.args.reset();
        super.parsePackage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseUndocumentedParam() throws UsageError {
        if (this.args.peek(ARG_NO_VALIDATE)) {
            this.args.accept(ARG_NO_VALIDATE);
            if (!this.m_target.isAIR()) throw new UsageError("-Xnovalidate not supported for this target");
            this.getAIRPackager().setValidate(false);
            return true;
        } else if (this.args.peek(ARG_DEBUG)) {
            this.args.accept(ARG_DEBUG);
            this.getADTPackager().setDebug(true);
            this.m_debug = true;
            return true;
        } else {
            if (!this.args.peek(ARG_RUNTIME)) return false;
            this.args.accept(ARG_RUNTIME);
            this.getADTPackager().setRuntimeDir(new File(this.args.accept()));
        }
        return true;
    }

    protected void parseAppSigningOptions() throws UsageError {
        if (this.signingOptionNext(this.args)) {
            this.m_signingApp = true;
        }
        super.parseAppSigningOptions();
    }

    protected void parseTarget() throws UsageError {
        if (this.args.peek("-target")) {
            this.args.accept("-target");
            this.args.accept();
        }
    }

    protected void parseNativeSigningOptions() throws UsageError {
        if (this.signingOptionNext(this.args)) {
            if (this.m_target == Target.EXE) {
                UCF.SigningOptions nativeSigningOptions = this.cacheSigningOptions();
                if (!new File(nativeSigningOptions.keyStoreFile).exists()) {
                    throw new UsageError("Keystore file does not exist: " + nativeSigningOptions.keyStoreFile);
                }
                this.getNativePackager().setNativeSigningOptions(nativeSigningOptions);
            } else {
                if (this.m_target == Target.DMG) {
                    throw new UsageError("Native signing not supported on mac");
                }
                throw new UsageError("Found misplaced signing arguments");
            }
        }
    }

    protected String getExtension() {
        return this.m_target.getExtension();
    }

    protected void parseDescriptorAndFileset(File appXml) throws UsageError {
        if (this.m_target != Target.AIRI && !this.m_signingApp) {
            throw new UsageError("Signing options required to package from descriptor and fileset");
        }
        super.parseDescriptorAndFileset(appXml);
    }

    protected void parseAIRFile(File airFile) throws UsageError {
        if (this.m_target == Target.AIR) {
            throw new UsageError("Found an AIR file as input. Expected an AIRI file or descriptor and some content");
        }
        if (this.m_target == Target.AIRI) {
            throw new UsageError("Found an AIR file as input. Cannot package an AIR file as AIRI");
        }
        if (this.m_signingApp) {
            throw new UsageError("Found signing arguments and an AIR file as input. AIR files are already signed");
        }
        if (this.m_debug) {
            throw new UsageError("-Xdebug not supported with an AIR file as input. Repackage your AIR file with -Xdebug and use that instead");
        }
        super.parseAIRFile(airFile);
    }

    protected void parseAIRIFile(File airiFile) throws UsageError {
        if (!this.m_signingApp) {
            throw new UsageError("An AIRI file was specified without signing arguments. AIRI files must be signed to be processed further");
        }
        super.parseAIRIFile(airiFile);
    }

    private void parsePrepare() throws UsageError {
        this.args.accept(ARG_PREPARE);
        this.m_target = Target.AIRI;
        this.parseUndocumentedParams();
        this.parseOutput(this.getPackager(), this.m_target.getExtension());
        this.parseInput();
    }

    private void parseSign() throws UsageError {
        this.args.accept(ARG_SIGN);
        this.m_target = Target.AIR;
        this.parseSigningOptions(this.getPackager());
        File airiFile = new File(this.args.accept());
        if (!airiFile.exists()) {
            throw new UsageError("no such file " + airiFile.getPath());
        }
        this.getAIRPackager().setAIRIFile(airiFile);
        this.parseOutput(this.getPackager(), EXT_AIR);
    }

    private void parseMigrate() throws UsageError {
        this.args.accept(ARG_MIGRATE);
        AIRMigrationSigner signer = new AIRMigrationSigner();
        this.parseSigningOptions((ISigner)signer);
        File input = new File(this.args.accept());
        if (!input.exists()) {
            throw new UsageError("no such file " + input.getPath());
        }
        signer.setInput(input);
        this.parseOutput((ISigner)signer, EXT_AIR);
        try {
            signer.sign();
        }
        catch (CertificateExpiredException ex) {
            throw new UsageError("certificate has expired", 8);
        }
        catch (CertificateNotYetValidException ex) {
            throw new UsageError("certificate is not yet valid", 8);
        }
        catch (CertificateException ex) {
            throw new UsageError("not an X509 code-signing certificate", 8);
        }
        catch (GeneralSecurityException ex) {
            throw new UsageError(ex.getMessage(), 9);
        }
        catch (InvalidInputException ex) {
            throw new UsageError(ex.getMessage(), 12);
        }
        catch (IOException ex) {
            throw new UsageError(ex.getMessage(), 6);
        }
    }

    private void parseCheckPass() throws UsageError {
        this.args.accept(ARG_CHECK_PASS);
        this.parseSigningOptions(null);
        System.err.println("valid password");
    }

    private void parseCertificate() throws UsageError {
        String cn = null;
        String ou = null;
        String o2 = null;
        String c2 = null;
        this.args.accept(ARG_CERT);
        while (true) {
            if (this.args.peek("-cn")) {
                if (cn != null) {
                    throw new UsageError("-cn already specified");
                }
                this.args.accept("-cn");
                cn = this.args.accept();
                continue;
            }
            if (this.args.peek("-ou")) {
                if (ou != null) {
                    throw new UsageError("-ou already specified");
                }
                this.args.accept("-ou");
                ou = this.args.accept();
                continue;
            }
            if (this.args.peek("-o")) {
                if (o2 != null) {
                    throw new UsageError("-o already specified");
                }
                this.args.accept("-o");
                o2 = this.args.accept();
                continue;
            }
            if (!this.args.peek("-c")) break;
            if (c2 != null) {
                throw new UsageError("-c already specified");
            }
            this.args.accept("-c");
            c2 = this.args.accept();
        }
        if (cn == null) {
            throw new UsageError("-cn is required");
        }
        String keyType = this.args.accept();
        try {
            this.m_creator.setKeyType(keyType);
        }
        catch (IllegalArgumentException e2) {
            throw new UsageError("key type not recognized: " + keyType + " -- valid types are 1024-RSA and 2048-RSA");
        }
        this.m_creator.setOutput(new File(this.args.accept()));
        this.m_creator.setPassword(this.args.accept());
        this.m_creator.setName(cn);
        if (ou != null) {
            this.m_creator.setOrganizationalUnit(ou);
        }
        if (o2 != null) {
            this.m_creator.setOrganizationName(o2);
        }
        try {
            if (c2 != null) {
                this.m_creator.setCountry(c2);
            }
        }
        catch (IllegalArgumentException e3) {
            throw new UsageError(e3.getMessage());
        }
    }

    private AIRPackager getAIRPackager() {
        return (AIRPackager)this.getPackager();
    }

    private NativePackager getNativePackager() {
        return (NativePackager)this.getPackager();
    }

    protected Packager newPackager() {
        assert (this.m_target != null);
        return this.m_target.newPackager();
    }

    static class Target {
        public static final Target AIR = new Target("air", true);
        public static final Target AIRI = new Target("airi", true);
        public static final Target EXE = new Target("exe", false);
        public static final Target DMG = new Target("dmg", false);
        public static final Target RPM = new Target("rpm", false);
        public static final Target DEB = new Target("deb", false);
        private String m_extension;
        private boolean m_isAIR;

        private static Target getLinuxTarget() {
            int dpkgStatus;
            int rpmStatus;
            try {
                Process rpmChecker = new ProcessBuilder(ADT.EXT_RPM, "-q", ADT.EXT_RPM).start();
                Utils.consumeOutput(rpmChecker);
                rpmStatus = rpmChecker.waitFor();
            }
            catch (IOException e2) {
                rpmStatus = 1;
            }
            catch (InterruptedException e3) {
                rpmStatus = 1;
            }
            try {
                Process dpkgChecker = new ProcessBuilder("dpkg", "-l", "dpkg").start();
                Utils.consumeOutput(dpkgChecker);
                dpkgStatus = dpkgChecker.waitFor();
            }
            catch (IOException e4) {
                dpkgStatus = 1;
            }
            catch (InterruptedException e5) {
                dpkgStatus = 1;
            }
            if (rpmStatus == 0) {
                return RPM;
            }
            if (dpkgStatus == 0) {
                return DEB;
            }
            return null;
        }

        public static Target getTargetFromArg(String arg) {
            if (ADT.EXT_AIR.equals(arg)) {
                return AIR;
            }
            if (ADT.EXT_AIRI.equals(arg)) {
                return AIRI;
            }
            if (ADT.ARG_NATIVE.equals(arg)) {
                if (System.getProperty("os.name").indexOf("Windows") != -1) {
                    return EXE;
                }
                if (System.getProperty("os.name").indexOf("Mac") != -1) {
                    return DMG;
                }
                if (System.getProperty("os.name").indexOf("Linux") != -1) {
                    return Target.getLinuxTarget();
                }
            }
            return null;
        }

        public String getExtension() {
            return "." + this.m_extension;
        }

        public boolean isAIR() {
            return this.m_isAIR;
        }

        public ADTPackager newPackager() {
            if (this == AIR || this == AIRI) {
                return new AIRPackager();
            }
            if (this == DMG) {
                return new DMGPackager();
            }
            if (this == EXE) {
                return new EXEPackager();
            }
            if (this == RPM) {
                return new RPMPackager();
            }
            if (this == DEB) {
                return new DEBPackager();
            }
            assert (false);
            return null;
        }

        private Target(String extension, boolean isAIR) {
            this.m_extension = extension;
            this.m_isAIR = isAIR;
        }
    }
}

