/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug.xml;

import com.adobe.authoring.debug.xml.ReadContext;
import com.adobe.authoring.debug.xml.XMLHandler;
import com.adobe.authoring.debug.xml.XMLReadElement;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BkptXMLReader {
    private InputStream stream;
    private Map breakpoints = new HashMap();
    XMLReadElement defaultReadElement = new MainReader();
    private BkptReader bkptReader = new BkptReader();

    public BkptXMLReader(InputStream stream) {
        this.stream = stream;
    }

    public void doRead() {
        try {
            this.read();
        }
        catch (IOException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void read() throws IOException, ParserConfigurationException, SAXException {
        if (this.stream == null) {
            return;
        }
        XMLHandler handler = new XMLHandler(this);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(this.stream, (DefaultHandler)handler);
        handler.clear();
    }

    public Map getBreakpoints() {
        return this.breakpoints;
    }

    public static String readAttribute(String name, Attributes attributes, boolean required) {
        String val = attributes.getValue(name);
        if (val != null || required) {
            // empty if block
        }
        return val;
    }

    public static Long readAttributeLong(String name, Attributes attributes, boolean required) {
        Long val = null;
        String str = BkptXMLReader.readAttribute(name, attributes, required);
        if (str != null) {
            val = new Long(str);
        }
        return val;
    }

    public static Double readAttributeDouble(String name, Attributes attributes, boolean required) {
        Double val = null;
        String str = BkptXMLReader.readAttribute(name, attributes, required);
        if (str != null) {
            val = new Double(str);
        }
        return val;
    }

    public static int readAttributeInt(String name, Attributes attributes, boolean required) {
        int val = -1;
        String str = BkptXMLReader.readAttribute(name, attributes, required);
        if (str != null) {
            val = Integer.parseInt(str);
        }
        return val;
    }

    class BkptReader
    extends XMLReadElement {
        private String name;
        private String lineNo;

        BkptReader() {
        }

        public XMLReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("fl".equals(current)) {
                Attributes attrib = context.getCurrentAttributes();
                this.name = BkptXMLReader.readAttribute("n", attrib, true);
            } else if ("bp".equals(current)) {
                Attributes attrib = context.getCurrentAttributes();
                this.lineNo = BkptXMLReader.readAttribute("l", attrib, true);
                String bkptStr = this.name + ":" + this.lineNo;
                BkptXMLReader.this.breakpoints.put(bkptStr, bkptStr);
            }
            return this;
        }
    }

    class MainReader
    extends XMLReadElement {
        MainReader() {
        }

        public XMLReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("bps".equals(current)) {
                return BkptXMLReader.this.bkptReader;
            }
            return null;
        }
    }
}

