/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug;

import com.adobe.authoring.debug.AuthBkptMgr;
import com.adobe.authoring.debug.AuthContextMgr;
import com.adobe.authoring.debug.AuthDebugException;
import com.adobe.authoring.debug.AuthXMLWriter;
import com.adobe.authoring.debug.djapi.wrappers.ThreadSafeBootstrap;
import com.adobe.authoring.debug.djapi.wrappers.ThreadSafeSessionManager;
import com.adobe.authoring.debug.launching.AuthDebuggerCallbacks;
import com.adobe.authoring.debug.model.AuthDebugTarget;
import com.adobe.authoring.debug.model.AuthStackFrame;
import com.adobe.authoring.debug.model.AuthThread;
import com.adobe.authoring.debug.model.AuthVariable;
import com.adobe.authoring.debug.model.DebugElementNoLongerExistsException;
import com.adobe.authoring.debug.model.IAuthVariable;
import flash.localization.LocalizationManager;
import flash.swf.Tag;
import flash.swf.TagDecoder;
import flash.swf.TagHandler;
import flash.swf.tags.EnableDebugger;
import flash.swf.tags.FileAttributes;
import flash.tools.debugger.AIRLaunchInfo;
import flash.tools.debugger.DebuggerLocalizer;
import flash.tools.debugger.Session;
import flash.tools.debugger.VersionException;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.events.SwfLoadedEvent;
import flash.tools.debugger.events.SwfUnloadedEvent;
import flash.tools.debugger.events.TraceEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.SocketTimeoutException;
import java.text.NumberFormat;
import java.util.HashMap;

public class AuthDebugMgr {
    public static final int MSG_OUTPUT = 0;
    public static final int MSG_TRACE = 1;
    public static final int MSG_FDBLISTENING = 2;
    public static final int MSG_SWFLOADED = 3;
    public static final int MSG_SWFUNLOADED = 4;
    public static final int MSG_CALLSTACKUPDATE = 5;
    public static final int MSG_VARIABLESUPDATE = 6;
    public static final int MSG_MEMBERSUPDATE = 7;
    public static final int MSG_EXPANDEDUPDATE = 8;
    public static final int MSG_SESSIONTERMINATED = 9;
    public static final int MSG_UPDATECONTROLSTATE = 10;
    public static final int MSG_FDBLAUNCHING = 11;
    public static final int MSG_BREAKPOINTNOTSET = 12;
    public static final int ERR_GENCONNECTIONERROR = 0;
    public static final int ERR_DEBUGSOCKETINUSE = 1;
    public static final int ERR_SESSIONINPROGRESS = 2;
    public static final int ERR_SESSIONTIMEDOUT = 3;
    public static final int ERR_FILENOTFOUND = 4;
    public static final int ERR_SWFNOTDEBUGGABLE = 5;
    public static final int ERR_GENJAVAEXCEPTION = 6;
    public static final int LAUNCH_FDBLISTEN = 0;
    public static final int LAUNCH_PLAYER = 1;
    public static final int LAUNCH_AIR = 2;
    public static final int LAUNCH_MOBILE = 3;
    public static final byte VAR_SHOWHEXDISPLAY = 1;
    public static final byte VAR_SHOWQUALIFIED = 2;
    public static final byte VAR_SHOWCONSTANTS = 4;
    public static final byte VAR_SHOWSTATICS = 8;
    public static final byte VAR_SHOWINACCESSIBLE = 16;
    PrintStream m_err;
    PrintStream m_out;
    boolean m_swfLoaded = false;
    boolean m_isMacOSX;
    boolean m_forDebugging;
    boolean m_showQualifiedNames = true;
    boolean m_showHexDisplay = false;
    boolean m_showConstants = false;
    boolean m_showStatics = false;
    boolean m_showInaccessibleMembers = false;
    private AcceptLaunchInfo m_acceptLaunchInfo;
    private AcceptThread fAcceptThread;
    private Thread fThread;
    private AuthDebugTarget fAuthDebugTarget;
    private AuthBkptMgr m_bkptMgr = new AuthBkptMgr();
    private AuthXMLWriter m_xmlWriter = new AuthXMLWriter();
    private static final LocalizationManager m_localizationManager = new LocalizationManager();
    private static final AuthContextMgr m_contextMgr = new AuthContextMgr();
    public static final String m_newline = System.getProperty("line.separator");
    public static final String m_systemEncoding = System.getProperty("file.encoding");
    public static final String m_macLaunchEncoding = "MacRoman";
    private static AuthDebugMgr fAuthDebugMgr;

    public static AuthDebugMgr getAuthMgr() {
        return fAuthDebugMgr;
    }

    public static LocalizationManager getLocalizationManager() {
        return m_localizationManager;
    }

    public static AuthContextMgr getContextMgr() {
        return m_contextMgr;
    }

    public AuthBkptMgr getBkptMgr() {
        return this.m_bkptMgr;
    }

    public AuthDebugTarget getDebugTarget() {
        return AuthDebugMgr.fAuthDebugMgr.fAuthDebugTarget;
    }

    public boolean showQualifiedMembers() {
        return this.m_showQualifiedNames;
    }

    public boolean showHexDisplay() {
        return this.m_showHexDisplay;
    }

    public boolean showConstants() {
        return this.m_showConstants;
    }

    public boolean showStatics() {
        return this.m_showStatics;
    }

    public boolean showInaccessibleMembers() {
        return this.m_showInaccessibleMembers;
    }

    public AuthDebugMgr() {
        this.m_acceptLaunchInfo = new AcceptLaunchInfo();
        String osName = System.getProperty("os.name").toLowerCase();
        this.m_isMacOSX = osName.startsWith("mac os x");
        this.m_err = System.err;
        this.m_out = System.out;
        fAuthDebugMgr = this;
    }

    boolean doSetLaunchInfo(String launchURI, String bkptXML, int flags, boolean forDebugging) {
        boolean result = true;
        if (launchURI != null) {
            this.m_acceptLaunchInfo.m_launchURI = launchURI;
            this.m_bkptMgr.setBkptXMLSource(bkptXML);
            this.doSetVariableFlags(flags);
            this.m_forDebugging = forDebugging;
        } else {
            result = false;
        }
        return result;
    }

    boolean doSetLaunchPlayerInfo(String playerURI) {
        boolean result = true;
        if (playerURI != null) {
            this.m_acceptLaunchInfo.m_launchType = 1;
            this.m_acceptLaunchInfo.m_playerInfo = playerURI;
        } else {
            result = false;
        }
        return result;
    }

    boolean doSetAIRLaunchInfo(String debugLauncher, String runtimeDir, String appContentRootDir, String securityPolicy, String profileName, String pubidName) {
        this.m_acceptLaunchInfo.m_launchType = 2;
        this.m_acceptLaunchInfo.m_airInfo = new AIRLaunchInfo();
        if (this.m_acceptLaunchInfo.m_airInfo != null) {
            if (debugLauncher.length() > 0) {
                this.m_acceptLaunchInfo.m_airInfo.airDebugLauncher = new File(debugLauncher);
            }
            if (runtimeDir.length() > 0) {
                this.m_acceptLaunchInfo.m_airInfo.airRuntimeDir = new File(runtimeDir);
            }
            if (appContentRootDir.length() > 0) {
                this.m_acceptLaunchInfo.m_airInfo.applicationContentRootDir = new File(appContentRootDir);
            }
            if (securityPolicy.length() > 0) {
                this.m_acceptLaunchInfo.m_airInfo.airSecurityPolicy = new File(securityPolicy);
            }
            if (profileName.length() > 0) {
                this.m_acceptLaunchInfo.m_airInfo.profile = profileName;
            }
            if (pubidName.length() > 0) {
                this.m_acceptLaunchInfo.m_airInfo.airPublisherID = pubidName;
            }
        }
        return true;
    }

    boolean doSetMobileLaunchInfo(String mobileLauncher, String mobileSettingsXML) {
        this.m_acceptLaunchInfo.m_launchType = 3;
        this.m_acceptLaunchInfo.m_mobileInfo = new MobileLaunchInfo();
        if (this.m_acceptLaunchInfo.m_mobileInfo != null) {
            if (mobileLauncher.length() > 0) {
                this.m_acceptLaunchInfo.m_mobileInfo.m_launcherPath = mobileLauncher;
            }
            if (mobileSettingsXML.length() > 0) {
                this.m_acceptLaunchInfo.m_mobileInfo.m_mobileSettingsXML = mobileSettingsXML;
            }
        }
        return true;
    }

    void doSetVariableFlag(int flag, boolean value, int stackIndex) {
        switch (flag) {
            case 1: {
                this.m_showHexDisplay = value;
                this.doRequestVars(stackIndex);
                break;
            }
            case 2: {
                this.m_showQualifiedNames = value;
                this.doRequestVars(stackIndex);
                break;
            }
            case 4: {
                this.m_showConstants = value;
                this.doRequestVars(stackIndex);
                break;
            }
            case 8: {
                this.m_showStatics = value;
                this.doRequestVars(stackIndex);
                break;
            }
            case 16: {
                this.m_showInaccessibleMembers = value;
                this.doRequestVars(stackIndex);
                break;
            }
        }
    }

    void doSetVariableFlags(int flags) {
        this.m_showHexDisplay = (flags & 1) == 1;
        this.m_showQualifiedNames = (flags & 2) == 2;
        this.m_showConstants = (flags & 4) == 4;
        this.m_showStatics = (flags & 8) == 8;
        this.m_showInaccessibleMembers = (flags & 0x10) == 16;
    }

    boolean doRun(boolean launchPlayer) throws IOException {
        if (!this.continueWithLaunch()) {
            return false;
        }
        if (this.m_acceptLaunchInfo.m_launchURI != null) {
            this.launchAcceptThread(launchPlayer);
            return true;
        }
        return false;
    }

    boolean doRunLaunch() throws IOException {
        if (!this.continueWithLaunch()) {
            return false;
        }
        if (this.m_acceptLaunchInfo.m_launchURI != null) {
            this.launchAcceptThread(true);
            return true;
        }
        return false;
    }

    boolean doRunAccept() throws IOException {
        if (!this.continueWithLaunch()) {
            return false;
        }
        if (this.m_acceptLaunchInfo.m_launchURI != null) {
            this.launchAcceptThread(false);
            return true;
        }
        return false;
    }

    public void doResume() {
        this.getDebugTarget().resume();
    }

    public void doPause() {
        this.getDebugTarget().suspend();
    }

    public void doDisconnect() {
        this.m_bkptMgr.shutdown();
        if (this.haveConnection()) {
            this.getDebugTarget().shutdown();
        } else {
            try {
                ThreadSafeSessionManager mgr = ThreadSafeBootstrap.sessionManager();
                if (mgr != null && mgr.isListening()) {
                    mgr.stopListening();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void doStepInto() {
        this.getDebugTarget().stepInto();
    }

    public void doStepOver() {
        this.getDebugTarget().stepOver();
    }

    public void doStepOut() {
        this.getDebugTarget().stepReturn();
    }

    public void doRequestVars(int stackIndex) {
        AuthStackFrame stackFrame = this.getStackFrameAtIndex(stackIndex);
        if (stackFrame == null) {
            return;
        }
        String outXML = this.m_xmlWriter.dumpStackFrameVars(stackFrame);
        AuthDebugMgr.getAuthMgr().notify(outXML, 6);
    }

    public void doRequestTopLevelMembers(int stackIndex, int varID) {
        AuthStackFrame stackFrame = this.getStackFrameAtIndex(stackIndex);
        if (stackFrame == null) {
            return;
        }
        String outXML = this.m_xmlWriter.dumpRequestedTopLevelMembers(stackFrame, varID);
        this.notify(outXML, 7);
    }

    public void doRequestMembers(int stackIndex, int[] idArray) {
        AuthStackFrame stackFrame = this.getStackFrameAtIndex(stackIndex);
        if (stackFrame == null) {
            return;
        }
        String outXML = this.m_xmlWriter.dumpRequestedMembers(stackFrame, idArray);
        AuthDebugMgr.getAuthMgr().notify(outXML, 7);
    }

    public void doRequestExpandedMembers(int stackIndex, int[] indexArray, int[] idArray) {
        AuthStackFrame stackFrame = this.getStackFrameAtIndex(stackIndex);
        if (stackFrame == null) {
            return;
        }
        String outXML = this.m_xmlWriter.dumpRequestedExpandedMembers(stackFrame, indexArray, idArray);
        AuthDebugMgr.getAuthMgr().notify(outXML, 8);
    }

    public void doSetTopLevelVariable(String varName, String newValue) {
        AuthStackFrame stackFrame = this.getStackFrameAtIndex(0);
        if (stackFrame == null) {
            return;
        }
        IAuthVariable[] varList = stackFrame.getVariables();
        AuthVariable var = m_contextMgr.lookupVariableByName(varName, varList);
        try {
            var.setValue(newValue);
        }
        catch (AuthDebugException e) {
            // empty catch block
        }
    }

    public void doSetVariable(int[] idArray, String varName, String newValue) {
        AuthStackFrame stackFrame = this.getStackFrameAtIndex(0);
        if (stackFrame == null) {
            return;
        }
        AuthVariable parentVar = m_contextMgr.lookupRequestedVariable(stackFrame, idArray, false);
        AuthVariable var = m_contextMgr.lookupVariableByName(varName, parentVar.getNestedMembers());
        try {
            var.setValue(newValue);
        }
        catch (AuthDebugException e) {
            // empty catch block
        }
    }

    public void doSetSingleBreak(String module, int line) {
        this.m_bkptMgr.setSingleBreak(module, line);
    }

    public void doRemoveSingleBreak(String module, int line) {
        this.m_bkptMgr.removeSingleBreak(module, line);
    }

    public void doSetMultipleBreaks(String module, int[] lines) {
        this.m_bkptMgr.setMultipleBreaks(module, lines);
    }

    public void doRemoveMultipleBreaks(String module, int[] lines) {
        this.m_bkptMgr.removeMultipleBreaks(module, lines);
    }

    public boolean checkPaused() {
        return !this.m_swfLoaded;
    }

    boolean continueWithLaunch() {
        if (this.haveConnection()) {
            this.err(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("sessionInProgress"), 2);
            return false;
        }
        if (!this.swfIsDebuggable()) {
            this.err("", 5);
            return false;
        }
        return true;
    }

    boolean swfIsDebuggable() {
        boolean isDebuggable = false;
        try {
            isDebuggable = this.checkSwfIsDebuggable(this.m_acceptLaunchInfo.m_launchURI);
        }
        catch (AuthDebugException authDebugException) {
            // empty catch block
        }
        return isDebuggable;
    }

    public void createAuthDebugTarget(Session s) {
        this.initSession(s);
        try {
            this.fAuthDebugTarget = new AuthDebugTarget(this.m_acceptLaunchInfo.m_launchURI, s);
        }
        catch (AuthDebugException authDebugException) {
            // empty catch block
        }
    }

    private void initSession(Session s) {
        this.m_bkptMgr.initFileInfoCache(s);
        try {
            s.bind();
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void handleHalt(AuthThread authThread) {
        if (this.m_forDebugging) {
            AuthStackFrame[] stack = authThread.getStackFrames();
            StringBuffer sb = new StringBuffer();
            AuthStackFrame topFrame = this.m_xmlWriter.dumpCallStack(sb, stack);
            this.notify(sb.toString(), 5);
            StringBuffer sb2 = new StringBuffer();
            this.m_xmlWriter.dumpPanelControlStates(sb2, authThread);
            this.notify(sb2.toString(), 10);
            if (topFrame != null) {
                String outXML = this.m_xmlWriter.dumpStackFrameVars(topFrame);
                AuthDebugMgr.getAuthMgr().notify(outXML, 6);
            }
        } else {
            this.doResume();
        }
    }

    private AuthStackFrame getStackFrameAtIndex(int stackIndex) {
        AuthThread main = this.getDebugTarget().getMainThread();
        AuthStackFrame[] stack = main.getStackFrames();
        if (stackIndex < 0 || stackIndex > stack.length) {
            return null;
        }
        return stack[stackIndex];
    }

    public void notifyTraceEvent(TraceEvent e) {
        this.notify(e.information, 0);
    }

    public void notifySwfLoaded(SwfLoadedEvent e) {
        this.m_swfLoaded = true;
        int at = e.path.lastIndexOf(63);
        String name = at > -1 ? e.path.substring(0, at) : e.path;
        StringBuffer sb = new StringBuffer();
        sb.append(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("linePrefixWhenSwfLoaded"));
        sb.append(' ');
        sb.append(name);
        sb.append(" - ");
        sb.append(e.swfSize);
        this.notify(sb.toString(), 3);
    }

    public void notifySwfUnloaded(SwfUnloadedEvent e) {
        int at = e.path.lastIndexOf(63);
        String name = at > -1 ? e.path.substring(0, at) : e.path;
        StringBuffer sb = new StringBuffer();
        sb.append(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("linePrefixWhenSwfUnloaded"));
        sb.append(' ');
        sb.append(name);
        if (e.index == 0) {
            this.notify(sb.toString(), 4);
        } else {
            this.notify(sb.toString(), 0);
        }
    }

    public void notifyFaultEvent(FaultEvent e) {
        this.notify(e.information, 0);
        if (e.stackTrace().length() > 0) {
            this.notify(e.stackTrace(), 0);
        }
    }

    boolean isConnectionLost() {
        boolean lost = false;
        try {
            if (this.getDebugTarget() != null && this.getDebugTarget().getSession() != null && !this.getDebugTarget().getSession().isConnected()) {
                lost = true;
            }
        }
        catch (DebugElementNoLongerExistsException debugElementNoLongerExistsException) {
            // empty catch block
        }
        return lost;
    }

    boolean haveConnection() {
        boolean have = false;
        try {
            if (this.getDebugTarget() != null && this.getDebugTarget().getSession() != null && this.getDebugTarget().getSession().isConnected()) {
                have = true;
            }
        }
        catch (DebugElementNoLongerExistsException debugElementNoLongerExistsException) {
            // empty catch block
        }
        return have;
    }

    public void err(String s, int errType) {
        this.error(s, errType);
    }

    public void error(String msg, int msgtype) {
        this.nativeError(msgtype);
    }

    native void nativeError(int var1);

    public void out(String s) {
        if (s.length() > 0 && s.charAt(s.length() - 1) == '\n') {
            this.m_out.print(s);
        } else {
            this.m_out.println(s);
        }
        this.notify(s, 0);
    }

    public void notify(String msg, int msgtype) {
        try {
            byte[] byteArray = msg.getBytes("UTF-8");
            this.nativeNotify(byteArray, msgtype);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    native void nativeNotify(byte[] var1, int var2);

    static String uft() {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        long used = total - free;
        NumberFormat nf = NumberFormat.getInstance();
        return "Used " + nf.format(used) + " - free " + nf.format(free) + " - total " + nf.format(total);
    }

    public static String getUniqueIdentifier() {
        return "com.adobe.authoring.debug";
    }

    public static void log(String s) {
    }

    public static void log(Throwable e) {
    }

    public static void log(String s, Throwable e) {
    }

    protected void toggleSystemEncoding(boolean beforeLaunch) {
        if (!this.m_isMacOSX) {
            return;
        }
        if (beforeLaunch) {
            if (m_systemEncoding.compareTo(m_macLaunchEncoding) != 0) {
                System.setProperty("file.encoding", m_macLaunchEncoding);
            }
        } else {
            System.setProperty("file.encoding", m_systemEncoding);
        }
    }

    protected void launchAcceptThread(boolean launchPlayer) {
        if (launchPlayer) {
            this.toggleSystemEncoding(true);
        }
        this.fAcceptThread = new AcceptThread(launchPlayer, true, this.m_acceptLaunchInfo);
        this.fThread = new Thread((Runnable)this.fAcceptThread, "AcceptThread");
        this.fThread.start();
    }

    private boolean checkSwfIsDebuggable(String launchURI) throws AuthDebugException {
        boolean continueLaunch = true;
        try {
            BufferedInputStream urlInputStream = new BufferedInputStream(this.GetInputStreamForURI(launchURI));
            if (AuthDebugMgr.mayBeSwf(urlInputStream) && !AuthDebugMgr.isSwfDebuggable(urlInputStream)) {
                continueLaunch = false;
            }
        }
        catch (IOException e) {
            return continueLaunch;
        }
        return continueLaunch;
    }

    public static boolean mayBeSwf(InputStream in) {
        DataInputStream data = new DataInputStream(in);
        byte[] b = new byte[3];
        data.mark(b.length);
        try {
            data.readFully(b);
        }
        catch (EOFException e) {
            return false;
        }
        catch (IOException e) {
            return true;
        }
        try {
            data.reset();
        }
        catch (IOException e) {
            return true;
        }
        return b[0] == 67 && b[1] == 87 && b[2] == 83 || b[0] == 70 && b[1] == 87 && b[2] == 83;
    }

    public static boolean isSwfDebuggable(InputStream in) throws IOException {
        DebugTagChecker debugTagChecker = new DebugTagChecker();
        TagDecoder t = new TagDecoder(in);
        try {
            t.parse(debugTagChecker);
        }
        catch (AbortSwfParseException abortSwfParseException) {
            // empty catch block
        }
        return debugTagChecker.swfStatus == 1;
    }

    private InputStream GetInputStreamForURI(String path) {
        File f = null;
        boolean exists = false;
        f = new File(path);
        exists = f.exists();
        if (exists) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        m_localizationManager.addLocalizer(new DebuggerLocalizer("flex.tools.debugger.cli.fdb."));
        fAuthDebugMgr = null;
    }

    private static class DebugTagChecker
    extends TagHandler {
        public static final int DEBUGGABLE = 1;
        public static final int NOT_DEBUGGABLE = 2;
        public static final int ERROR_PARSING_SWF = 3;
        public int swfStatus = 2;

        public void fileAttributes(FileAttributes tag) {
            if (!tag.actionScript3) {
                // empty if block
            }
        }

        public void enableDebugger2(EnableDebugger tag) {
            this.swfStatus = 1;
            throw new AbortSwfParseException();
        }

        public void error(String s) {
            this.swfStatus = 3;
        }

        public void any(Tag tag) {
        }
    }

    private static class AbortSwfParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1370426084618318381L;

        private AbortSwfParseException() {
        }
    }

    private class AcceptThread
    implements Runnable {
        private boolean fLaunchPlayer;
        private boolean fForDebugging;
        private AcceptLaunchInfo fLaunchInfo;
        private boolean fAcceptResult;
        private boolean fAcceptException;
        private Session fAcceptedSession;
        private int fSleepLength = 25;

        public AcceptThread(boolean launchPlayer, boolean forDebugging, AcceptLaunchInfo launchInfo) {
            this.fLaunchPlayer = launchPlayer;
            this.fForDebugging = forDebugging;
            this.fLaunchInfo = launchInfo;
            this.fAcceptResult = false;
            this.fAcceptException = false;
            this.fAcceptedSession = null;
        }

        public void run() {
            boolean success = false;
            if (this.fLaunchInfo != null) {
                success = this.eventLoop();
            }
            if (success) {
                AuthDebugMgr.getAuthMgr().createAuthDebugTarget(this.fAcceptedSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean eventLoop() {
            do {
                try {
                    ThreadSafeSessionManager mgr = ThreadSafeBootstrap.sessionManager();
                    try {
                        mgr.startListening();
                        if (this.fLaunchInfo.m_launchURI != null) {
                            switch (this.fLaunchInfo.m_launchType) {
                                case 0: {
                                    AuthDebugMgr.getAuthMgr().notify(this.fLaunchInfo.m_launchURI, 2);
                                    this.fAcceptedSession = mgr.accept(null);
                                    break;
                                }
                                case 1: {
                                    if (this.fLaunchInfo.m_playerInfo != null) {
                                        AuthDebuggerCallbacks specifiedPlayerCallbacks = new AuthDebuggerCallbacks();
                                        specifiedPlayerCallbacks.setHttpExe(this.fLaunchInfo.m_playerInfo);
                                        specifiedPlayerCallbacks.setPlayerExe(this.fLaunchInfo.m_playerInfo);
                                        mgr.setDebuggerCallbacks(specifiedPlayerCallbacks);
                                    }
                                    AuthDebugMgr.getAuthMgr().notify(this.fLaunchInfo.m_launchURI, 11);
                                    this.fAcceptedSession = mgr.launch(this.fLaunchInfo.m_launchURI, null, this.fForDebugging, null, null);
                                    if (!this.fLaunchPlayer) break;
                                    AuthDebugMgr.this.toggleSystemEncoding(false);
                                    break;
                                }
                                case 2: {
                                    if (((AuthDebugMgr)AuthDebugMgr.this).m_acceptLaunchInfo.m_airInfo == null) break;
                                    AuthDebugMgr.getAuthMgr().notify(this.fLaunchInfo.m_launchURI, 11);
                                    this.fAcceptedSession = mgr.launch(((AuthDebugMgr)AuthDebugMgr.this).m_acceptLaunchInfo.m_launchURI, ((AuthDebugMgr)AuthDebugMgr.this).m_acceptLaunchInfo.m_airInfo, this.fForDebugging, null, null);
                                    if (!this.fLaunchPlayer) break;
                                    AuthDebugMgr.this.toggleSystemEncoding(false);
                                    break;
                                }
                                case 3: {
                                    if (this.fLaunchInfo.m_mobileInfo == null) break;
                                    AuthDebugMgr.getAuthMgr().notify(this.fLaunchInfo.m_launchURI, 11);
                                    String launcherPath = this.fLaunchInfo.m_mobileInfo.m_launcherPath;
                                    String mobSetting = this.fLaunchInfo.m_mobileInfo.m_mobileSettingsXML;
                                    String swfPath = this.fLaunchInfo.m_launchURI;
                                    String[] cmd = new String[]{launcherPath, mobSetting, swfPath};
                                    Process p = Runtime.getRuntime().exec(cmd);
                                    this.fAcceptedSession = mgr.accept(null);
                                    break;
                                }
                            }
                            if (this.fAcceptedSession != null) {
                                this.fAcceptResult = true;
                            }
                        }
                    }
                    catch (FileNotFoundException fnf) {
                        HashMap<String, String> args = new HashMap<String, String>();
                        args.put("uri", this.fLaunchInfo.m_launchURI);
                        AuthDebugMgr.this.err(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("fileDoesNotExist", args), 4);
                        this.fAcceptException = true;
                    }
                    catch (SocketTimeoutException ste) {
                        AuthDebugMgr.this.err(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("failedToConnect"), 3);
                        this.fAcceptException = true;
                    }
                    catch (BindException e) {
                        AuthDebugMgr.this.err(e.getMessage(), 1);
                        this.fAcceptException = true;
                    }
                    catch (IOException io) {
                        AuthDebugMgr.this.err(io.getMessage(), 0);
                        this.fAcceptException = true;
                    }
                    finally {
                        mgr.stopListening();
                    }
                    try {
                        Thread.sleep(this.fSleepLength);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Exception e) {
                    AuthDebugMgr.this.err(e.getMessage(), 0);
                }
            } while (!this.fAcceptResult && !this.fAcceptException);
            return this.fAcceptResult;
        }
    }

    public class MobileLaunchInfo {
        public String m_launcherPath;
        public String m_mobileSettingsXML;
    }

    public class AcceptLaunchInfo {
        public int m_launchType = 0;
        public String m_launchURI;
        public String m_playerInfo;
        public AIRLaunchInfo m_airInfo;
        public MobileLaunchInfo m_mobileInfo;
    }
}

