/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import flash.css.LocalSource;
import flash.css.URLSource;
import flash.fonts.FontDescription;
import flash.fonts.FontManager;
import flash.swf.tags.DefineFont;
import flash.util.Trace;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.FontsConfiguration;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.AbstractTranscoder;
import flex2.compiler.swc.SwcFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontTranscoder
extends AbstractTranscoder {
    private FontsConfiguration fontsConfig;
    private int compatibilityVersion;
    private boolean showShadowedDeviceFontWarnings;
    public static final String UNICODERANGE = "unicodeRange";
    public static final String SYSTEMFONT = "systemFont";
    public static final String SOURCELIST = "sourceList";
    public static final String FLASHTYPE = "flashType";
    public static final String ADVANTIALIASING = "advancedAntiAliasing";
    public static final String EMBEDASCFF = "embedAsCFF";

    public FontTranscoder(Configuration config) {
        super(new String[]{"application/x-font-truetype", "application/x-font-opentype", "application/x-font", "application/x-font-truetype-collection", "application/x-dfont"}, DefineFont.class, true);
        CompilerConfiguration compilerConfig = config.getCompilerConfiguration();
        this.fontsConfig = compilerConfig.getFontsConfiguration();
        this.compatibilityVersion = compilerConfig.getCompatibilityVersion();
        this.showShadowedDeviceFontWarnings = compilerConfig.showShadowedDeviceFontWarnings();
    }

    @Override
    public boolean isSupportedAttribute(String attr) {
        return "fontName".equals(attr) || "fontStyle".equals(attr) || "fontWeight".equals(attr) || "fontFamily".equals(attr) || UNICODERANGE.equals(attr) || FLASHTYPE.equals(attr) || ADVANTIALIASING.equals(attr) || SYSTEMFONT.equals(attr) || SOURCELIST.equals(attr) || EMBEDASCFF.equals(attr);
    }

    @Override
    public Transcoder.TranscodingResults doTranscode(PathResolver context, SymbolTable symbolTable, Map<String, Object> args, String className, boolean generateSource) throws TranscoderException {
        List<Serializable> locations;
        Transcoder.TranscodingResults results = new Transcoder.TranscodingResults();
        String systemFont = null;
        if (args.containsKey("source")) {
            if (args.containsKey(SYSTEMFONT) || args.containsKey(SOURCELIST)) {
                throw new BadParameters();
            }
            results.assetSource = this.resolveSource(context, args);
            results.modified = results.assetSource.getLastModified();
            locations = new LinkedList<Serializable>();
            locations.add(this.getURL(results.assetSource));
        } else if (args.containsKey(SYSTEMFONT)) {
            if (args.containsKey("source") || args.containsKey(SOURCELIST)) {
                throw new BadParameters();
            }
            systemFont = (String)args.get(SYSTEMFONT);
            locations = new LinkedList<Serializable>();
            locations.add((Serializable)((Object)systemFont));
        } else if (args.containsKey(SOURCELIST)) {
            locations = this.resolveSourceList(context, args);
        } else {
            throw new BadParameters();
        }
        String family = (String)args.get("fontFamily");
        String alias = (String)args.get("fontName");
        if (alias == null) {
            alias = systemFont;
        }
        if (alias == null) {
            alias = family;
        }
        if (alias == null) {
            throw new BadParameters();
        }
        if (systemFont != null && systemFont.equals(alias) && this.showShadowedDeviceFontWarnings) {
            EmbeddedFontShadowsDeviceFont embeddedFontShadowsDeviceFont = new EmbeddedFontShadowsDeviceFont(alias);
            String path = (String)args.get("_file");
            String pathSep = (String)args.get("_pathsep");
            if ("true".equals(pathSep)) {
                path = path.replace('/', '\\');
            }
            embeddedFontShadowsDeviceFont.path = path;
            if (args.containsKey("_line")) {
                int line;
                embeddedFontShadowsDeviceFont.line = line = Integer.parseInt((String)args.get("_line"));
            }
            ThreadLocalToolkit.log(embeddedFontShadowsDeviceFont);
        }
        FontDescription fontDesc = new FontDescription();
        fontDesc.alias = alias;
        fontDesc.style = FontTranscoder.getFontStyle(args);
        fontDesc.unicodeRanges = (String)args.get(UNICODERANGE);
        fontDesc.advancedAntiAliasing = this.useAdvancedAntiAliasing(args);
        fontDesc.compactFontFormat = FontTranscoder.useCompactFontFormat(args, this.compatibilityVersion);
        DefineFont defineFont = this.getDefineFont(fontDesc, locations, args);
        try {
            results.defineTag = defineFont;
            if (generateSource) {
                this.generateSource(results, className, args);
            }
        }
        catch (TranscoderException te) {
            throw te;
        }
        catch (Exception e) {
            if (Trace.error) {
                e.printStackTrace();
            }
            throw new AbstractTranscoder.ExceptionWhileTranscoding(e);
        }
        return results;
    }

    private URL getURL(VirtualFile virtualFile) throws TranscoderException {
        URL result;
        if (virtualFile instanceof SwcFile) {
            try {
                String name = virtualFile.getName();
                String path = name.substring(name.indexOf("$") + 1);
                File file = File.createTempFile(path.replace('/', '_'), null);
                FileUtil.writeBinaryFile(file, virtualFile.getInputStream());
                result = file.toURL();
            }
            catch (IOException ioException) {
                if (Trace.error) {
                    ioException.printStackTrace();
                }
                throw new UnableToExtract(virtualFile.getName());
            }
        }
        try {
            result = new URL(virtualFile.getURL());
        }
        catch (MalformedURLException e) {
            throw new AbstractTranscoder.UnableToReadSource(virtualFile.getName());
        }
        return result;
    }

    private DefineFont getDefineFont(FontDescription fontDesc, List<Serializable> locations, Map<String, Object> args) throws TranscoderException {
        FontManager fontManager = this.fontsConfig.getTopLevelManager();
        int defineFontTag = 75;
        DefineFont defineFont = null;
        for (Serializable fontSource : locations) {
            try {
                if (fontManager == null) {
                    throw new NoFontManagerException();
                }
                fontDesc.source = fontSource;
                defineFont = fontManager.createDefineFont(defineFontTag, fontDesc);
            }
            catch (FontManager.InvalidUnicodeRangeException e) {
                throw new InvalidUnicodeRangeException(e.range);
            }
            catch (Exception e) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                AbstractTranscoder.ExceptionWhileTranscoding exceptionWhileTranscoding = new AbstractTranscoder.ExceptionWhileTranscoding(e);
                String path = (String)args.get("_file");
                String pathSep = (String)args.get("_pathsep");
                if ("true".equals(pathSep)) {
                    path = path.replace('/', '\\');
                }
                exceptionWhileTranscoding.path = path;
                if (args.containsKey("_line")) {
                    int line;
                    exceptionWhileTranscoding.line = line = Integer.parseInt((String)args.get("_line"));
                }
                ThreadLocalToolkit.log(exceptionWhileTranscoding);
            }
            if (defineFont == null) continue;
            return defineFont;
        }
        throw new UnableToBuildFont(fontDesc.alias);
    }

    private List<Serializable> resolveSourceList(PathResolver context, Map<String, Object> args) throws TranscoderException {
        LinkedList<Serializable> result = new LinkedList<Serializable>();
        for (Object source : (List)args.get(SOURCELIST)) {
            if (source instanceof URLSource) {
                URLSource urlSource = (URLSource)source;
                VirtualFile virtualFile = this.resolve(context, urlSource.getValue());
                result.add(this.getURL(virtualFile));
                continue;
            }
            LocalSource localSource = (LocalSource)source;
            result.add((Serializable)((Object)localSource.getValue()));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean useAdvancedAntiAliasing(Map<String, Object> args) throws TranscoderException {
        boolean useAdvanced = true;
        boolean flashTypeAsName = true;
        String advancedStr = (String)args.get(ADVANTIALIASING);
        if (advancedStr == null) {
            advancedStr = (String)args.get(FLASHTYPE);
        } else {
            flashTypeAsName = false;
        }
        if (advancedStr == null) return this.fontsConfig.getFlashType();
        if (advancedStr.equalsIgnoreCase("true")) {
            return true;
        }
        if (advancedStr.equalsIgnoreCase("false")) {
            return false;
        }
        if (!flashTypeAsName) throw new BadAdvancedAntiAliasing();
        throw new BadFlashType();
    }

    private static boolean useCompactFontFormat(Map<String, Object> args, int compatibilityVersion) {
        String value = (String)args.get(EMBEDASCFF);
        boolean useCFF = true;
        if (compatibilityVersion < 0x4000000) {
            useCFF = false;
        }
        if (value != null) {
            useCFF = Boolean.parseBoolean(value.trim());
        }
        return useCFF;
    }

    public static int getFontStyle(Map<String, Object> args) {
        String weight;
        int s = 0;
        String style = (String)args.get("fontStyle");
        if (style == null) {
            style = "normal";
        }
        if ((weight = (String)args.get("fontWeight")) == null) {
            weight = "normal";
        }
        if (FontTranscoder.isBold(weight)) {
            ++s;
        }
        if (FontTranscoder.isItalic(style)) {
            s += 2;
        }
        return s;
    }

    public static boolean isBold(String value) {
        boolean bold = false;
        if (value != null) {
            String b = value.trim().toLowerCase();
            if (b.startsWith("bold")) {
                bold = true;
            } else {
                try {
                    int w = Integer.parseInt(b);
                    if (w >= 700) {
                        bold = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return bold;
    }

    public static boolean isItalic(String value) {
        String ital;
        boolean italic = false;
        if (value != null && ((ital = value.trim().toLowerCase()).equals("italic") || ital.equals("oblique"))) {
            italic = true;
        }
        return italic;
    }

    public static final class EmbeddedFontShadowsDeviceFont
    extends CompilerMessage.CompilerWarning
    implements ILocalizableMessage {
        private static final long serialVersionUID = -1125821048682931471L;
        public final String alias;

        public EmbeddedFontShadowsDeviceFont(String alias) {
            this.alias = alias;
        }
    }

    public static final class UnableToExtract
    extends TranscoderException {
        private static final long serialVersionUID = -4585845590777360978L;
        public String fileName;

        public UnableToExtract(String fileName) {
            this.fileName = fileName;
        }
    }

    public static final class UnableToBuildFont
    extends TranscoderException {
        private static final long serialVersionUID = 1520596054636875393L;
        public String fontName;

        public UnableToBuildFont(String fontName) {
            this.fontName = fontName;
        }
    }

    public static final class BadAdvancedAntiAliasing
    extends TranscoderException {
        private static final long serialVersionUID = 8425867739365188050L;
    }

    public static final class BadFlashType
    extends TranscoderException {
        private static final long serialVersionUID = 3971519462447951564L;
    }

    public static final class BadParameters
    extends TranscoderException {
        private static final long serialVersionUID = -2390481014380505531L;
    }

    public static final class InvalidUnicodeRangeException
    extends TranscoderException {
        private static final long serialVersionUID = 3173208110428813980L;
        public String range;

        public InvalidUnicodeRangeException(String range) {
            this.range = range;
        }
    }

    public static final class NoFontManagerException
    extends RuntimeException {
        private static final long serialVersionUID = 755054716704678420L;

        public NoFontManagerException() {
            super("No FontManager provided. Cannot build font.");
        }
    }
}

