/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MetadataConfiguration {
    private Set<String> contributors = new TreeSet<String>();
    private Set<String> creators = new TreeSet<String>();
    public String date = null;
    private Map<String, String> localizedDescriptions = new HashMap<String, String>();
    public TreeSet<String> langs = new TreeSet();
    private Set<String> publishers = new TreeSet<String>();
    private Map<String, String> localizedTitles = new HashMap<String, String>();

    public boolean isSet() {
        return this.localizedTitles.size() > 0 || this.localizedDescriptions.size() > 0 || this.publishers.size() > 0 || this.creators.size() > 0 || this.contributors.size() > 0 || this.langs.size() > 0 || this.date != null;
    }

    private static String f(String in) {
        return (in = in.trim()).indexOf(60) == -1 && in.indexOf(62) == -1 ? in : "<![CDATA[" + in + "]]>";
    }

    public String toString() {
        if (!this.isSet()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>");
        sb.append("<rdf:Description rdf:about='' xmlns:dc='http://purl.org/dc/elements/1.1'>");
        sb.append("<dc:format>application/x-shockwave-flash</dc:format>");
        if (this.localizedTitles.size() > 0) {
            if (this.localizedTitles.size() == 1 && this.localizedTitles.get("x-default") != null) {
                sb.append("<dc:title>" + MetadataConfiguration.f(this.localizedTitles.get("x-default")) + "</dc:title>");
            } else {
                sb.append("<dc:title><rdf:Alt>");
                for (Map.Entry entry : this.localizedTitles.entrySet()) {
                    sb.append("<rdf:li xml:lang='" + entry.getKey() + "'>" + MetadataConfiguration.f((String)entry.getValue()) + "</rdf:li>");
                }
                sb.append("</rdf:Alt></dc:title>");
            }
        }
        if (this.localizedDescriptions.size() > 0) {
            if (this.localizedDescriptions.size() == 1 && this.localizedDescriptions.get("x-default") != null) {
                sb.append("<dc:description>" + MetadataConfiguration.f(this.localizedDescriptions.get("x-default")) + "</dc:description>");
            } else {
                sb.append("<dc:description><rdf:Alt>");
                for (Map.Entry entry : this.localizedDescriptions.entrySet()) {
                    sb.append("<rdf:li xml:lang='" + (String)entry.getKey() + "'>" + MetadataConfiguration.f((String)entry.getValue()) + "</rdf:li>");
                }
                sb.append("</rdf:Alt></dc:description>");
            }
        }
        Iterator<Object> it = this.publishers.iterator();
        while (it.hasNext()) {
            sb.append("<dc:publisher>" + MetadataConfiguration.f((String)it.next()) + "</dc:publisher>");
        }
        it = this.creators.iterator();
        while (it.hasNext()) {
            sb.append("<dc:creator>" + MetadataConfiguration.f((String)it.next()) + "</dc:creator>");
        }
        it = this.contributors.iterator();
        while (it.hasNext()) {
            sb.append("<dc:contributor>" + MetadataConfiguration.f((String)it.next()) + "</dc:contributor>");
        }
        it = this.langs.iterator();
        while (it.hasNext()) {
            sb.append("<dc:language>" + MetadataConfiguration.f((String)it.next()) + "</dc:language>");
        }
        if (this.date == null) {
            this.date = DateFormat.getDateInstance().format(new Date());
        }
        sb.append("<dc:date>" + MetadataConfiguration.f(this.date) + "</dc:date>");
        sb.append("</rdf:Description></rdf:RDF>");
        return sb.toString();
    }

    public void cfgContributor(ConfigurationValue cv, String name) {
        this.contributors.add(name);
    }

    public static ConfigurationInfo getContributorInfo() {
        return new ConfigurationInfo(1, "name"){

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgCreator(ConfigurationValue cv, String name) {
        this.creators.add(name);
    }

    public static ConfigurationInfo getCreatorInfo() {
        return new ConfigurationInfo(1, "name"){

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgDate(ConfigurationValue cv, String text) {
        this.date = text;
    }

    public static ConfigurationInfo getDateInfo() {
        return new ConfigurationInfo(1, "text"){

            public boolean isAdvanced() {
                return false;
            }
        };
    }

    public void cfgDescription(ConfigurationValue cv, String text) {
        this.localizedDescriptions.put("x-default", text);
    }

    public static ConfigurationInfo getDescriptionInfo() {
        return new ConfigurationInfo(1, "text"){

            public boolean isAdvanced() {
                return false;
            }
        };
    }

    public void cfgLanguage(ConfigurationValue cv, String code) {
        this.langs.add(code);
    }

    public static ConfigurationInfo getLanguageInfo() {
        return new ConfigurationInfo(1, "code"){

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgLocalizedDescription(ConfigurationValue cv, String text, String lang) {
        this.localizedDescriptions.put(lang, text);
    }

    public static ConfigurationInfo getLocalizedDescriptionInfo() {
        return new ConfigurationInfo(2, new String[]{"text", "lang"}){

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgLocalizedTitle(ConfigurationValue cv, String title, String lang) {
        this.localizedTitles.put(lang, title);
    }

    public static ConfigurationInfo getLocalizedTitleInfo() {
        return new ConfigurationInfo(2, new String[]{"title", "lang"}){

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgPublisher(ConfigurationValue cv, String name) {
        this.publishers.add(name);
    }

    public static ConfigurationInfo getPublisherInfo() {
        return new ConfigurationInfo(1, "name"){

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgTitle(ConfigurationValue cv, String title) {
        this.localizedTitles.put("x-default", title);
    }

    public static ConfigurationInfo getTitleInfo() {
        return new ConfigurationInfo(1, "text"){

            public boolean isAdvanced() {
                return false;
            }
        };
    }
}

