/*
 * Decompiled with CFR 0.152.
 */
package flash.css;

import flash.css.Descriptor;
import flash.css.LocalSource;
import flash.css.Rule;
import flash.css.StyleDeclaration;
import flash.css.StyleParser;
import flash.css.URLSource;
import flash.util.Trace;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.LexicalUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontFaceRule
extends Rule {
    private String family = null;
    private int style = -1;
    private List<Object> locations = null;
    private Map<String, Object> embedParams = null;

    public FontFaceRule(String path, int lineNumber) {
        super((short)5, path, lineNumber);
        this.declaration = new StyleDeclaration(path, lineNumber);
    }

    public Map<String, Object> getEmbedParams() {
        return this.embedParams;
    }

    public void initialize(StyleParser parser) {
        String cff;
        String flashType;
        String alias = this.getFamily();
        List<Object> locations = this.getLocations();
        this.embedParams = new HashMap<String, Object>();
        this.embedParams.put("mimeType", "application/x-font");
        if (locations == null && alias != null) {
            this.embedParams.put("fontName", alias);
            this.embedParams.put("systemFont", alias);
        } else if (alias != null) {
            this.embedParams.put("fontName", alias);
            if (locations.size() == 1) {
                Object source = locations.get(0);
                if (source instanceof URLSource) {
                    URLSource urlSource = (URLSource)source;
                    this.embedParams.put("source", urlSource.getValue());
                    if (urlSource.getValue().toLowerCase().endsWith(".swf")) {
                        this.embedParams.put("mimeType", "application/x-shockwave-flash");
                    }
                } else {
                    LocalSource localSource = (LocalSource)source;
                    this.embedParams.put("systemFont", localSource.getValue());
                }
            } else {
                this.embedParams.put("sourceList", locations);
            }
        }
        String unicodeRange = this.getUnicodeRange();
        if (unicodeRange != null) {
            this.embedParams.put("unicodeRange", unicodeRange);
        }
        if ((flashType = this.getFlashType()) != null) {
            this.embedParams.put("advancedAntiAliasing", flashType);
        }
        if ((cff = this.getCompactFontFormat()) != null) {
            this.embedParams.put("embedAsCFF", cff);
        }
        this.checkForIgnoredDescriptors(parser);
        if (this.isBold()) {
            this.embedParams.put("fontWeight", "bold");
        }
        if (this.isItalic()) {
            this.embedParams.put("fontStyle", "italic");
        }
        if (Trace.font) {
            Trace.trace((String)("@fontface rule parsed for family '" + alias + "'"));
        }
    }

    public String getFamily() {
        if (this.family == null) {
            Descriptor f = this.declaration.getDescriptorValue("font-family");
            if (f == null) {
                f = this.declaration.getDescriptorValue("fontFamily");
            }
            if (f != null) {
                this.family = f.getIdentAsString();
            }
        }
        return this.family;
    }

    public List<Object> getLocations() {
        if (this.locations == null) {
            Descriptor src = this.declaration.getDescriptorValue("src");
            ArrayList<Object> result = null;
            if (src != null) {
                result = new ArrayList<Object>(2);
                for (LexicalUnit lu = src.getValue(); lu != null; lu = lu.getNextLexicalUnit()) {
                    if (lu.getLexicalUnitType() == 41) {
                        result.add(new LocalSource(lu.getParameters().getStringValue().trim()));
                        continue;
                    }
                    if (lu.getLexicalUnitType() != 24) continue;
                    result.add(new URLSource(lu.getStringValue()));
                }
            }
            this.locations = result;
        }
        return this.locations;
    }

    public String formatFontStyle() {
        Descriptor s = this.declaration.getDescriptorValue("font-style");
        if (s == null) {
            s = this.declaration.getDescriptorValue("fontStyle");
        }
        return s == null ? "" : "fontStyle='" + s + "'";
    }

    public String formatFontWeight() {
        Descriptor w = this.declaration.getDescriptorValue("font-weight");
        if (w == null) {
            w = this.declaration.getDescriptorValue("fontWeight");
        }
        return w == null ? "" : "fontWeight='" + w + "'";
    }

    public int getFontStyle() {
        if (this.style < 0) {
            StringTokenizer weights;
            String thisWeight;
            StringTokenizer styles;
            String thisStyle;
            Descriptor w;
            this.style = 0;
            Descriptor s = this.declaration.getDescriptorValue("font-style");
            if (s == null) {
                s = this.declaration.getDescriptorValue("fontStyle");
            }
            if ((w = this.declaration.getDescriptorValue("font-weight")) == null) {
                w = this.declaration.getDescriptorValue("fontWeight");
            }
            if (s != null && FontFaceRule.isItalic(thisStyle = ((String)(styles = new StringTokenizer(s.getIdentAsString(), ",")).nextElement()).trim().toLowerCase())) {
                this.style += 2;
            }
            if (w != null && FontFaceRule.isBold(thisWeight = ((String)(weights = new StringTokenizer(w.getIdentAsString(), ",")).nextElement()).trim().toLowerCase())) {
                ++this.style;
            }
        }
        return this.style;
    }

    public boolean isBold() {
        if (this.style < 0) {
            this.getFontStyle();
        }
        return this.style == 1 || this.style == 3;
    }

    public boolean isItalic() {
        if (this.style < 0) {
            this.getFontStyle();
        }
        return this.style == 2 || this.style == 3;
    }

    public static boolean isItalic(String value) {
        boolean italic = false;
        if (value != null) {
            String ital = value.trim().toLowerCase();
            if (ital.startsWith("\"") && (ital = ital.substring(1)).endsWith("\"")) {
                ital = ital.substring(0, ital.length() - 1);
            }
            if (ital.equals("italic") || ital.equals("oblique")) {
                italic = true;
            }
        }
        return italic;
    }

    public static boolean isBold(String value) {
        boolean bold = false;
        if (value != null) {
            String b = value.trim().toLowerCase();
            if (b.startsWith("\"") && (b = b.substring(1)).endsWith("\"")) {
                b = b.substring(0, b.length() - 1);
            }
            if (b.startsWith("bold")) {
                bold = true;
            } else {
                try {
                    int w = Integer.parseInt(b);
                    if (w >= 700) {
                        bold = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return bold;
    }

    public String getUnicodeRange() {
        Descriptor property = this.declaration.getDescriptorValue("unicode-range");
        if (property == null) {
            property = this.declaration.getDescriptorValue("unicodeRange");
        }
        if (property != null) {
            String unicodeRange = property.getIdentAsString();
            int semicolon = (unicodeRange = unicodeRange.trim()).indexOf(";");
            if (semicolon != -1) {
                unicodeRange = unicodeRange.substring(0, semicolon);
            }
            return unicodeRange;
        }
        return null;
    }

    private String getFlashType() {
        String flashType = null;
        Descriptor flashTypeDesc = this.declaration.getDescriptorValue("advanced-anti-aliasing");
        if (flashTypeDesc == null) {
            flashTypeDesc = this.declaration.getDescriptorValue("advancedAntiAliasing");
        }
        if (flashTypeDesc == null) {
            flashTypeDesc = this.declaration.getDescriptorValue("flash-type");
        }
        if (flashTypeDesc == null) {
            flashTypeDesc = this.declaration.getDescriptorValue("flashType");
        }
        if (flashTypeDesc != null) {
            flashType = flashTypeDesc.getIdentAsString();
        }
        return flashType;
    }

    private String getCompactFontFormat() {
        String cff = null;
        Descriptor cffDesc = this.declaration.getDescriptorValue("embedAsCFF");
        if (cffDesc != null) {
            cff = cffDesc.getIdentAsString();
        }
        return cff;
    }

    private void checkForIgnoredDescriptors(StyleParser parser) {
        String descriptor = null;
        if (this.declaration.getDescriptorValue("font-size") != null) {
            descriptor = "font-size";
        } else if (this.declaration.getDescriptorValue("fontSize") != null) {
            descriptor = "fontSize";
        } else if (this.declaration.getDescriptorValue("panose-1") != null) {
            descriptor = "panose-1";
        } else if (this.declaration.getDescriptorValue("stemv") != null) {
            descriptor = "stemv";
        } else if (this.declaration.getDescriptorValue("stemh") != null) {
            descriptor = "stemh";
        } else if (this.declaration.getDescriptorValue("slope") != null) {
            descriptor = "slope";
        } else if (this.declaration.getDescriptorValue("cap-height") != null) {
            descriptor = "cap-height";
        } else if (this.declaration.getDescriptorValue("capHeight") != null) {
            descriptor = "capHeight";
        } else if (this.declaration.getDescriptorValue("x-height") != null) {
            descriptor = "x-height";
        } else if (this.declaration.getDescriptorValue("xHeight") != null) {
            descriptor = "xHeight";
        } else if (this.declaration.getDescriptorValue("ascent") != null) {
            descriptor = "ascent";
        } else if (this.declaration.getDescriptorValue("descent") != null) {
            descriptor = "descent";
        } else if (this.declaration.getDescriptorValue("widths") != null) {
            descriptor = "widths";
        } else if (this.declaration.getDescriptorValue("bbox") != null) {
            descriptor = "bbox";
        } else if (this.declaration.getDescriptorValue("definition-src") != null) {
            descriptor = "definition-src";
        } else if (this.declaration.getDescriptorValue("definitionSrc") != null) {
            descriptor = "definitionSrc";
        } else if (this.declaration.getDescriptorValue("baseline") != null) {
            descriptor = "baseline";
        } else if (this.declaration.getDescriptorValue("centerline") != null) {
            descriptor = "centerline";
        } else if (this.declaration.getDescriptorValue("mathline") != null) {
            descriptor = "mathline";
        } else if (this.declaration.getDescriptorValue("topline") != null) {
            descriptor = "topline";
        }
        if (descriptor != null) {
            IgnoredDescriptor ignoredDescriptor = new IgnoredDescriptor(descriptor);
            String text = ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)ignoredDescriptor);
            parser.warning(new CSSException(CSSException.SAC_UNSPECIFIED_ERR, text, null));
        }
    }

    public static FontFaceRule getRule(Collection<FontFaceRule> rules, String family, boolean bold, boolean italic) {
        for (FontFaceRule ffr : rules) {
            if (!family.equals(ffr.getFamily()) || bold != ffr.isBold() || italic != ffr.isItalic()) continue;
            return ffr;
        }
        return null;
    }

    public static class UnicodeRangeNotSupported
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -7817266835618855999L;
    }

    public static class IgnoredDescriptor
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4627590989999828547L;
        public String descriptor;

        public IgnoredDescriptor(String descriptor) {
            this.descriptor = descriptor;
        }
    }
}

