/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.io.Serializable;
import java.security.SecureRandom;

public class EncryptedValue
implements Cloneable,
Serializable {
    private CertJ a;
    private JSAFE_PublicKey b = null;
    private JSAFE_PrivateKey c = null;
    private byte[] d = null;
    private byte[] e = null;
    private byte[] f = null;
    private byte[] g = null;
    private byte[] h = null;
    private byte[] i = null;
    private JSAFE_SecretKey j = null;
    private JSAFE_PrivateKey k = null;
    private ASN1Template l = null;
    private int m = 0;
    private byte[] n = null;

    public EncryptedValue(CertJ certJ, JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) throws CRMFException {
        if (certJ == null) {
            throw new CRMFException("The specified CertJ value is NULL in EncryptedValue.");
        }
        if (jSAFE_PublicKey != null) {
            this.b = jSAFE_PublicKey;
        }
        if (jSAFE_PrivateKey != null) {
            this.c = jSAFE_PrivateKey;
        }
        this.a = certJ;
    }

    public void decodeEncryptedValue(byte[] byArray, int n2, int n3) throws CRMFException {
        this.m = n3;
        if (byArray == null) {
            throw new CRMFException("EncryptedValue Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n3);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(8466432);
            EncodedContainer encodedContainer2 = new EncodedContainer(8466433);
            BitStringContainer bitStringContainer = new BitStringContainer(8454146);
            EncodedContainer encodedContainer3 = new EncodedContainer(8466435);
            OctetStringContainer octetStringContainer = new OctetStringContainer(8466436);
            BitStringContainer bitStringContainer2 = new BitStringContainer(0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, bitStringContainer, encodedContainer3, octetStringContainer, bitStringContainer2, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (encodedContainer.dataPresent && encodedContainer.data != null && encodedContainer.dataLen != 0) {
                this.d = new byte[encodedContainer.dataLen];
                this.d[0] = 48;
                System.arraycopy(encodedContainer.data, encodedContainer.dataOffset + 1, this.d, 1, encodedContainer.dataLen - 1);
            }
            if (encodedContainer2.dataPresent && encodedContainer2.data != null && encodedContainer2.dataLen != 0) {
                this.e = new byte[encodedContainer2.dataLen];
                this.e[0] = 48;
                System.arraycopy(encodedContainer2.data, encodedContainer2.dataOffset + 1, this.e, 1, encodedContainer2.dataLen - 1);
            }
            if (encodedContainer3.dataPresent && encodedContainer3.data != null && encodedContainer3.dataLen != 0) {
                this.f = new byte[encodedContainer3.dataLen];
                this.f[0] = 48;
                System.arraycopy(encodedContainer3.data, encodedContainer3.dataOffset + 1, this.f, 1, encodedContainer3.dataLen - 1);
            }
            if (bitStringContainer2.data == null || bitStringContainer2.dataLen == 0) {
                throw new CRMFException("Encrypted Private Key value is missing.");
            }
            this.h = new byte[bitStringContainer2.dataLen];
            System.arraycopy(bitStringContainer2.data, bitStringContainer2.dataOffset, this.h, 0, bitStringContainer2.dataLen);
            if (bitStringContainer.data != null && bitStringContainer.dataLen != 0) {
                this.i = new byte[bitStringContainer.dataLen];
                System.arraycopy(bitStringContainer.data, bitStringContainer.dataOffset, this.i, 0, bitStringContainer.dataLen);
            }
            if (octetStringContainer.data != null && octetStringContainer.dataLen != 0) {
                this.g = new byte[octetStringContainer.dataLen];
                System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.g, 0, octetStringContainer.dataLen);
            }
            if (this.e != null && this.f != null && this.h != null && this.i != null) {
                this.decryptPrivateKey();
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot decode the BER of the Encrypted Value.");
        }
    }

    public void decryptPrivateKey() throws CRMFException {
        try {
            if (this.c == null) {
                throw new CRMFException("Private Key is not set in EncryptedValue");
            }
            if (this.e == null || this.i == null || this.h == null) {
                throw new CRMFException("Values are not set.");
            }
            String string = AlgorithmID.berDecodeAlgID(this.e, 0, 6, null);
            if (string == null) {
                throw new CRMFException("Invalid Symmetric Algorithm OID.");
            }
            int n2 = string.indexOf("/");
            String string2 = string.substring(0, n2);
            JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher = this.a.getDevice() != null ? JSAFE_AsymmetricCipher.getInstance(this.f, 0, this.a.getDevice()) : JSAFE_AsymmetricCipher.getInstance(this.f, 0, "Java");
            jSAFE_AsymmetricCipher.decryptInit(this.c, this.a.getPKCS11Sessions());
            this.j = jSAFE_AsymmetricCipher.unwrapSecretKey(this.i, 0, this.i.length, false, string2);
            jSAFE_AsymmetricCipher.clearSensitiveData();
            JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance(this.e, 0, "Java");
            JSAFE_SecureRandom jSAFE_SecureRandom = this.a.getRandomObject();
            jSAFE_SymmetricCipher.decryptInit(this.j, jSAFE_SecureRandom);
            try {
                this.k = jSAFE_SymmetricCipher.unwrapPrivateKey(this.h, 0, this.h.length, false);
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                try {
                    jSAFE_SymmetricCipher.decryptReInit();
                    int n3 = jSAFE_SymmetricCipher.getOutputBufferSize(this.h.length);
                    this.n = new byte[n3];
                    int n4 = jSAFE_SymmetricCipher.decryptUpdate(this.h, 0, this.h.length, this.n, 0);
                    jSAFE_SymmetricCipher.decryptFinal(this.n, n4);
                }
                catch (JSAFE_Exception jSAFE_Exception2) {
                    throw new CRMFException("Could not decode encrypted value" + jSAFE_Exception2.getMessage());
                }
                finally {
                    jSAFE_SymmetricCipher.clearSensitiveData();
                }
            }
        }
        catch (NoServiceException noServiceException) {
            throw new CRMFException("Cannot get random object from CertJ." + noServiceException.getMessage());
        }
        catch (RandomException randomException) {
            throw new CRMFException("Cannot get random object from CertJ." + randomException.getMessage());
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not decode encrypted key" + jSAFE_Exception.getMessage());
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    public void setPrivateKey(JSAFE_PrivateKey jSAFE_PrivateKey) throws CRMFException {
        if (jSAFE_PrivateKey == null) {
            throw new CRMFException("The private key is NULL.");
        }
        try {
            this.k = (JSAFE_PrivateKey)jSAFE_PrivateKey.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Invalid Private Key." + cloneNotSupportedException.getMessage());
        }
    }

    public JSAFE_PrivateKey getPrivateKey() throws CRMFException {
        if (this.k == null) {
            return null;
        }
        try {
            return (JSAFE_PrivateKey)this.k.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Invalid Private Key." + cloneNotSupportedException.getMessage());
        }
    }

    public byte[] getDecryptedValue() {
        if (this.n == null) {
            return null;
        }
        byte[] byArray = new byte[this.n.length];
        System.arraycopy(this.n, 0, byArray, 0, this.n.length);
        return byArray;
    }

    public void setSymmetricKey(JSAFE_SecretKey jSAFE_SecretKey) throws CRMFException {
        if (jSAFE_SecretKey == null) {
            throw new CRMFException("The secret key is NULL.");
        }
        try {
            this.j = (JSAFE_SecretKey)jSAFE_SecretKey.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Invalid Symmetric Key." + cloneNotSupportedException.getMessage());
        }
    }

    public JSAFE_SecretKey getSecretKey() throws CRMFException {
        if (this.j == null) {
            return null;
        }
        try {
            return (JSAFE_SecretKey)this.j.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Invalid Symmetric Key." + cloneNotSupportedException.getMessage());
        }
    }

    public void setEncryptedSecretKey(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null || n3 == 0) {
            throw new CRMFException("The specified EncryptedSecretKey values are null.");
        }
        this.i = new byte[n3];
        System.arraycopy(byArray, n2, this.i, 0, n3);
    }

    public byte[] getEncryptedSecretKey() {
        if (this.i == null) {
            return null;
        }
        byte[] byArray = new byte[this.i.length];
        System.arraycopy(this.i, 0, byArray, 0, this.i.length);
        return byArray;
    }

    public void setEncryptedPrivateKey(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null || n3 == 0) {
            throw new CRMFException("The specified EncryptedPrivateKey values are null.");
        }
        this.h = new byte[n3];
        System.arraycopy(byArray, n2, this.h, 0, n3);
    }

    public byte[] getEncryptedPrivateKey() {
        if (this.h == null) {
            return null;
        }
        byte[] byArray = new byte[this.h.length];
        System.arraycopy(this.h, 0, byArray, 0, this.h.length);
        return byArray;
    }

    public void setValueHint(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null || n3 == 0) {
            throw new CRMFException("Value hint is null.");
        }
        this.g = new byte[n3];
        System.arraycopy(byArray, n2, this.g, 0, n3);
    }

    public byte[] getValueHint() {
        if (this.g == null) {
            return null;
        }
        byte[] byArray = new byte[this.g.length];
        System.arraycopy(this.g, 0, byArray, 0, this.g.length);
        return byArray;
    }

    public void setKeyEncryptionAlgorithm(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null || n3 == 0) {
            throw new CRMFException("The specified KeyEncryptionAlgorithm OID is null.");
        }
        this.f = new byte[n3];
        System.arraycopy(byArray, n2, this.f, 0, n3);
    }

    public byte[] getKeyEncryptionAlgorithm() {
        if (this.f == null) {
            return null;
        }
        byte[] byArray = new byte[this.f.length];
        System.arraycopy(this.f, 0, byArray, 0, this.f.length);
        return byArray;
    }

    public void setValueEncryptionAlgorithm(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null || n3 == 0) {
            throw new CRMFException("The specified ValueEncryptionAlgorithm OID is null.");
        }
        this.e = new byte[n3];
        System.arraycopy(byArray, n2, this.e, 0, n3);
    }

    public byte[] getValueEncryptionAlgorithm() {
        if (this.e == null) {
            return null;
        }
        byte[] byArray = new byte[this.e.length];
        System.arraycopy(this.e, 0, byArray, 0, this.e.length);
        return byArray;
    }

    public void setIntendedAlgorithm(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null || n3 == 0) {
            throw new CRMFException("The specified IntendedAlgorithm OID is null.");
        }
        this.d = new byte[n3];
        System.arraycopy(byArray, n2, this.d, 0, n3);
    }

    public byte[] getIntendedAlgorithm() {
        if (this.d == null) {
            return null;
        }
        byte[] byArray = new byte[this.d.length];
        System.arraycopy(this.d, 0, byArray, 0, this.d.length);
        return byArray;
    }

    public byte[] encryptPrivateKey() throws CRMFException {
        if (this.j == null || this.k == null || this.e == null) {
            return null;
        }
        try {
            JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance(this.e, 0, "Java");
            jSAFE_SymmetricCipher.encryptInit(this.j);
            byte[] byArray = jSAFE_SymmetricCipher.wrapPrivateKey(this.k, false);
            jSAFE_SymmetricCipher.clearSensitiveData();
            return byArray;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Cannot encrypt the PrivateKey. " + jSAFE_Exception.getMessage());
        }
    }

    public byte[] encryptSecretKey() throws CRMFException {
        if (this.j == null || this.f == null || this.b == null) {
            return null;
        }
        try {
            JSAFE_SecureRandom jSAFE_SecureRandom = this.a.getRandomObject();
            JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher = this.a.getDevice() != null ? JSAFE_AsymmetricCipher.getInstance(this.f, 0, this.a.getDevice()) : JSAFE_AsymmetricCipher.getInstance(this.f, 0, "Java");
            jSAFE_AsymmetricCipher.encryptInit(this.b, (SecureRandom)jSAFE_SecureRandom, this.a.getPKCS11Sessions());
            byte[] byArray = jSAFE_AsymmetricCipher.wrapSecretKey(this.j, false);
            jSAFE_AsymmetricCipher.clearSensitiveData();
            return byArray;
        }
        catch (NoServiceException noServiceException) {
            throw new CRMFException("Cannot get random object from CertJ." + noServiceException.getMessage());
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not encrypt the secret key. " + jSAFE_Exception.getMessage());
        }
        catch (RandomException randomException) {
            throw new CRMFException("Could not encrypt the secret key. " + randomException.getMessage());
        }
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("EncryptedValue Encoding is null.");
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not read the BER encoding." + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n2) throws CRMFException {
        this.m = n2;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Specified array is null in EncryptedValue.");
        }
        this.m = n3;
        int n4 = 0;
        try {
            if (this.l == null) {
                this.getDERLen(n3);
            }
            n4 = this.l.derEncode(byArray, n2);
            this.l = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.l = null;
            throw new CRMFException("Unable to encode EncryptedValue." + aSN_Exception.getMessage());
        }
        return n4;
    }

    private int a() throws CRMFException {
        try {
            if (this.h == null) {
                this.h = this.encryptPrivateKey();
            }
            if (this.i == null) {
                this.i = this.encryptSecretKey();
            }
            boolean bl2 = false;
            int n2 = 0;
            byte[] byArray = null;
            if (this.d != null) {
                bl2 = true;
                n2 = this.d.length;
                byArray = new byte[n2];
                byArray[0] = -96;
                System.arraycopy(this.d, 1, byArray, 1, n2 - 1);
            }
            EncodedContainer encodedContainer = new EncodedContainer(8466432, bl2, 0, byArray, 0, n2);
            bl2 = false;
            n2 = 0;
            if (this.g != null) {
                bl2 = true;
                n2 = this.g.length;
            }
            OctetStringContainer octetStringContainer = new OctetStringContainer(8466436, bl2, 0, this.g, 0, n2);
            bl2 = false;
            n2 = 0;
            if (this.e != null) {
                bl2 = true;
                n2 = this.e.length;
                byArray = new byte[n2];
                byArray[0] = -95;
                System.arraycopy(this.e, 1, byArray, 1, n2 - 1);
            }
            EncodedContainer encodedContainer2 = new EncodedContainer(8466433, bl2, 0, byArray, 0, n2);
            bl2 = false;
            n2 = 0;
            if (this.f != null) {
                bl2 = true;
                n2 = this.f.length;
                byArray = new byte[n2];
                byArray[0] = -93;
                System.arraycopy(this.f, 1, byArray, 1, n2 - 1);
            }
            EncodedContainer encodedContainer3 = new EncodedContainer(8466435, bl2, 0, byArray, 0, n2);
            bl2 = false;
            n2 = 0;
            SequenceContainer sequenceContainer = new SequenceContainer(this.m, true, 0);
            EndContainer endContainer = new EndContainer();
            if (this.i != null) {
                bl2 = true;
                n2 = this.i.length;
            }
            BitStringContainer bitStringContainer = new BitStringContainer(8454146, bl2, 0, this.i, 0, n2);
            if (this.h == null) {
                throw new CRMFException("The encrypted private key value is missing.");
            }
            BitStringContainer bitStringContainer2 = new BitStringContainer(0, true, 0, this.h, 0, this.h.length);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, bitStringContainer, encodedContainer3, octetStringContainer, bitStringContainer2, endContainer};
            this.l = new ASN1Template(aSN1ContainerArray);
            return this.l.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            EncryptedValue encryptedValue = new EncryptedValue(this.a, this.b, this.c);
            if (this.d != null) {
                encryptedValue.d = new byte[this.d.length];
                System.arraycopy(this.d, 0, encryptedValue.d, 0, this.d.length);
            }
            if (this.e != null) {
                encryptedValue.e = new byte[this.e.length];
                System.arraycopy(this.e, 0, encryptedValue.e, 0, this.e.length);
            }
            if (this.f != null) {
                encryptedValue.f = new byte[this.f.length];
                System.arraycopy(this.f, 0, encryptedValue.f, 0, this.f.length);
            }
            if (this.g != null) {
                encryptedValue.g = new byte[this.g.length];
                System.arraycopy(this.g, 0, encryptedValue.g, 0, this.g.length);
            }
            if (this.h != null) {
                encryptedValue.h = new byte[this.h.length];
                System.arraycopy(this.h, 0, encryptedValue.h, 0, this.h.length);
            }
            if (this.i != null) {
                encryptedValue.i = new byte[this.i.length];
                System.arraycopy(this.i, 0, encryptedValue.i, 0, this.i.length);
            }
            if (this.j != null) {
                encryptedValue.j = (JSAFE_SecretKey)this.j.clone();
            }
            if (this.k != null) {
                encryptedValue.k = (JSAFE_PrivateKey)this.k.clone();
            }
            if (this.l != null) {
                encryptedValue.a();
            }
            encryptedValue.m = this.m;
            return encryptedValue;
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EncryptedValue)) {
            return false;
        }
        EncryptedValue encryptedValue = (EncryptedValue)object;
        if (!CertJUtils.byteArraysEqual(this.d, encryptedValue.d)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.e, encryptedValue.e)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.f, encryptedValue.f)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.g, encryptedValue.g)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.h, encryptedValue.h)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.i, encryptedValue.i)) {
            return false;
        }
        if (this.j != null) {
            byte[][] byArray;
            if (encryptedValue.j == null) {
                return false;
            }
            byte[][] byArray2 = this.j.getKeyData();
            if (!CertJUtils.byteArraysEqual(byArray2[0], (byArray = encryptedValue.j.getKeyData())[0])) {
                return false;
            }
        } else if (encryptedValue.j != null) {
            return false;
        }
        return !(this.k != null ? !this.k.equals(encryptedValue.k) : encryptedValue.k != null);
    }
}

