/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Date;

public class PrivateKeyUsagePeriod
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private Date a;
    private Date b;
    private static final int c = 0x810000;
    private static final int d = 0x810001;
    ASN1Template e;

    public PrivateKeyUsagePeriod() {
        this.extensionTypeFlag = 16;
        this.criticality = false;
        this.setStandardOID(16);
        this.extensionTypeString = "PrivateKeyUsagePeriod";
    }

    public PrivateKeyUsagePeriod(Date date, Date date2, boolean bl2) {
        this.extensionTypeFlag = 16;
        this.criticality = bl2;
        this.setStandardOID(16);
        if (date != null) {
            this.a = new Date(date.getTime());
        }
        if (date2 != null) {
            this.b = new Date(date2.getTime());
        }
        this.extensionTypeString = "PrivateKeyUsagePeriod";
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        GenTimeContainer genTimeContainer = new GenTimeContainer(0x810000);
        GenTimeContainer genTimeContainer2 = new GenTimeContainer(0x810001);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, genTimeContainer, genTimeContainer2, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode PrivateKeyUsagePeriod extension.");
        }
        if (genTimeContainer.dataPresent) {
            this.a = new Date(genTimeContainer.theTime.getTime());
        }
        if (genTimeContainer2.dataPresent) {
            this.b = new Date(genTimeContainer2.theTime.getTime());
        }
    }

    public void setNotBefore(Date date) {
        if (date != null) {
            this.a = new Date(date.getTime());
        }
    }

    public Date getNotBefore() {
        if (this.a == null) {
            return null;
        }
        return new Date(this.a.getTime());
    }

    public void setNotAfter(Date date) {
        if (date != null) {
            this.b = new Date(date.getTime());
        }
    }

    public Date getNotAfter() {
        if (this.b == null) {
            return null;
        }
        return new Date(this.b.getTime());
    }

    public int derEncodeValueInit() {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        GenTimeContainer genTimeContainer = null;
        GenTimeContainer genTimeContainer2 = null;
        int n2 = 0;
        if (this.a != null) {
            genTimeContainer = new GenTimeContainer(0x810000, true, 0, this.a);
            n2 = 1;
        }
        if (this.b != null) {
            genTimeContainer2 = new GenTimeContainer(0x810001, true, 0, this.b);
            n2 = n2 == 1 ? 3 : 2;
        }
        switch (n2) {
            case 0: {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, endContainer};
                this.e = new ASN1Template(aSN1ContainerArray);
                break;
            }
            case 1: {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, genTimeContainer, endContainer};
                this.e = new ASN1Template(aSN1ContainerArray);
                break;
            }
            case 2: {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, genTimeContainer2, endContainer};
                this.e = new ASN1Template(aSN1ContainerArray);
                break;
            }
            case 3: {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, genTimeContainer, genTimeContainer2, endContainer};
                this.e = new ASN1Template(aSN1ContainerArray);
                break;
            }
        }
        try {
            return this.e.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.e == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.e.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PrivateKeyUsagePeriod privateKeyUsagePeriod = new PrivateKeyUsagePeriod();
        privateKeyUsagePeriod.a = this.a;
        privateKeyUsagePeriod.b = this.b;
        if (this.e != null) {
            privateKeyUsagePeriod.derEncodeValueInit();
        }
        super.copyValues(privateKeyUsagePeriod);
        return privateKeyUsagePeriod;
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.b = null;
        this.e = null;
    }
}

