/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.ucf.CodeSigner;
import com.adobe.ucf.UCFSigner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class UCFOutputStream {
    protected static long LOCAL_FILE_HEADER_MAGIC = 67324752L;
    protected static long CENTRAL_DIRECTORY_HEADER_MAGIC = 33639248L;
    protected static long DEFAULT_FILE_PERMISSONS = -2119958528L;
    protected static long EXECUTABLE_FILE_PERMISSIONS = -2115174400L;
    protected static long SYMLINK_FILE_PERMISSIONS = -1577254912L;
    protected static long FOLDER_FILE_PERMISSIONS = 1106051072L;
    protected File outputDir = null;
    protected RandomAccessFile raf = null;
    protected LittleEndianOutputStream os = null;
    protected CRC32 crc = new CRC32();
    protected List<FileRecord> files = new ArrayList<FileRecord>();
    protected CodeSigner codeSigner = null;

    public UCFOutputStream() {
        this.os = new LittleEndianOutputStream();
    }

    public void setOutput(File output) throws FileNotFoundException {
        this.outputDir = output.getParentFile();
        if (this.raf != null) {
            throw new IllegalStateException("output already set");
        }
        this.raf = new RandomAccessFile(output, "rw");
    }

    public void setPrivateKey(PrivateKey key) {
        if (this.files.size() > 0) {
            throw new IllegalStateException("files already added");
        }
        if (this.codeSigner != null) {
            throw new IllegalStateException("private key already set");
        }
        this.codeSigner = this.getCodeSigner();
        this.codeSigner.setPrivateKey(key);
    }

    protected CodeSigner getCodeSigner() {
        return new UCFSigner();
    }

    public void setAlsoIncludeOldStyleTimestamp() {
        if (this.codeSigner == null) {
            throw new IllegalStateException("private key not set");
        }
        this.codeSigner.setTimestampUriFlags(CodeSigner.FLAG_TIMESTAMP_URI_PACKAGE_VALUE | CodeSigner.FLAG_TIMESTAMP_URI_SIGNATURE_VALUE);
    }

    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        if (this.codeSigner == null) {
            throw new IllegalStateException("private key not yet set");
        }
        this.codeSigner.setCertificateChain(certchain);
    }

    public void setSignerCertificate(Certificate cert) throws CertificateException {
        if (this.codeSigner == null) {
            throw new IllegalStateException("private key not yet set");
        }
        this.codeSigner.setSignerCertificate(cert);
    }

    public void setTimestampURL(String url) {
        if (this.codeSigner == null) {
            throw new IllegalStateException("private key not yet set");
        }
        this.codeSigner.setTimestampURL(url);
    }

    public void addMimeTypeFile(String mimeType, boolean addToSignature) throws IOException {
        this.addData(mimeType.getBytes("UTF-8"), "mimetype", new Date(), addToSignature, false);
    }

    public void addFile(File file, String path, boolean addToSignature) throws IOException {
        this.addFile(file, path, addToSignature, this.determineFilePermissions(file));
    }

    protected long determineFilePermissions(File file) {
        return this.isFileExecutable(file) ? EXECUTABLE_FILE_PERMISSIONS : DEFAULT_FILE_PERMISSONS;
    }

    public void addFile(File file, String path, boolean addToSignature, long permissions) throws IOException {
        FileRecord record = new FileRecord(new Date(file.lastModified()));
        record.path = path;
        record.size = file.length();
        record.permissions = permissions;
        this.addFile(record, new FileInputStream(file), addToSignature, true);
    }

    private boolean isFileExecutable(File file) {
        if (!file.exists()) {
            return false;
        }
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            return false;
        }
        try {
            Process test = new ProcessBuilder("test", "-x", file.getAbsolutePath()).start();
            test.waitFor();
            return test.exitValue() == 0;
        }
        catch (IOException e2) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public void addString(String string, String encoding, String path, Date date, boolean addToSignature) throws IOException {
        this.addData(string.getBytes(encoding), path, date, addToSignature, true);
    }

    public void addData(byte[] data, String path, Date date, boolean addToSignature, boolean compress) throws IOException {
        FileRecord record = new FileRecord(date);
        record.path = path;
        record.size = data.length;
        record.permissions = DEFAULT_FILE_PERMISSONS;
        this.addFile(record, new ByteArrayInputStream(data), addToSignature, compress);
    }

    public void finalizeSig() throws IOException, GeneralSecurityException {
        if (this.codeSigner != null) {
            try {
                this.codeSigner.sign();
            }
            catch (Exception e2) {
                throw new IOException("Unable to create signature.");
            }
            byte[] signature = this.codeSigner.getSignatureXML().getBytes("UTF-8");
            FileRecord record = new FileRecord(new Date());
            record.path = this.getSignaturesPath();
            record.size = signature.length;
            record.permissions = DEFAULT_FILE_PERMISSONS;
            this.addFile(record, new ByteArrayInputStream(signature), false, true);
        }
    }

    protected String getSignaturesPath() {
        return "META-INF/signatures.xml";
    }

    public void close() throws IOException {
        if (this.raf != null) {
            long cdOffset = this.raf.getFilePointer();
            for (FileRecord r2 : this.files) {
                byte[] cdr = this.getCentralDirectoryRecord(r2);
                this.raf.write(cdr);
            }
            long cdSize = this.raf.getFilePointer() - cdOffset;
            this.os.reset();
            this.os.writeLong(101010256L);
            this.os.writeShort(0);
            this.os.writeShort(0);
            this.os.writeShort(this.files.size());
            this.os.writeShort(this.files.size());
            this.os.writeLong(cdSize);
            this.os.writeLong(cdOffset);
            this.os.writeShort(0);
            byte[] eocdr = this.os.getBytes();
            this.raf.write(eocdr);
            this.beforeClose();
            this.raf.close();
            this.raf = null;
        }
    }

    protected void beforeClose() throws IOException {
    }

    protected void processBytes(String path, byte[] bytes, int numBytes) {
    }

    protected void addFile(FileRecord record, InputStream data, boolean addToSignature, boolean compress) throws IOException {
        int bytesRead;
        if (this.raf == null) {
            throw new IllegalStateException("output not yet set");
        }
        boolean NO_ZLIB_HEADER = true;
        File tempFile = File.createTempFile("ucf", null);
        tempFile.deleteOnExit();
        OutputStream tempOutput = new FileOutputStream(tempFile);
        if (compress) {
            tempOutput = new DeflaterOutputStream(tempOutput, new Deflater(9, true));
        }
        this.crc.reset();
        byte[] buffer = new byte[4096];
        while ((bytesRead = data.read(buffer)) != -1) {
            this.crc.update(buffer, 0, bytesRead);
            tempOutput.write(buffer, 0, bytesRead);
            if (this.codeSigner != null && addToSignature) {
                this.codeSigner.updateFileDigest(buffer, 0, bytesRead);
            }
            this.processBytes(record.path, buffer, bytesRead);
        }
        data.close();
        tempOutput.close();
        record.lfhOffset = this.raf.getFilePointer();
        record.crc32 = this.crc.getValue();
        record.compressedSize = record.size;
        InputStream tempInput = new FileInputStream(tempFile);
        if (compress) {
            long compressedSize = tempFile.length();
            if (compressedSize < record.size) {
                record.compressedSize = compressedSize;
            } else {
                tempInput = new InflaterInputStream(tempInput, new Inflater(true));
            }
        }
        byte[] lfh = this.getLocalFileHeader(record);
        this.raf.write(lfh);
        while (true) {
            int bytesRead2 = -1;
            try {
                bytesRead2 = tempInput.read(buffer);
            }
            catch (EOFException e2) {
                // empty catch block
            }
            if (bytesRead2 == -1) break;
            this.raf.write(buffer, 0, bytesRead2);
        }
        tempInput.close();
        tempFile.delete();
        if (this.codeSigner != null && addToSignature) {
            byte[] digest = this.codeSigner.finalizeFileDigest();
            this.codeSigner.addFileDigestToManifest(digest, record.path);
        }
        this.files.add(record);
    }

    protected byte[] getLocalFileHeader(FileRecord r2) throws IOException {
        this.os.reset();
        this.os.writeLong(LOCAL_FILE_HEADER_MAGIC);
        this.writeCommonHeaderBlock(r2);
        this.os.writeShort(this.getLFExtraFieldLength());
        this.os.writeString(this.getZipPath(r2.path));
        this.writeLFExtraField(r2);
        return this.os.getBytes();
    }

    protected byte[] getCentralDirectoryRecord(FileRecord r2) throws IOException {
        this.os.reset();
        this.os.writeLong(CENTRAL_DIRECTORY_HEADER_MAGIC);
        this.os.writeShort(this.versionMadeBy(r2));
        this.writeCommonHeaderBlock(r2);
        this.os.writeShort(this.getCDExtraFieldLength());
        this.os.writeShort(0);
        this.os.writeShort(0);
        this.os.writeShort(1);
        this.os.writeLong(r2.permissions);
        this.os.writeLong(r2.lfhOffset);
        this.os.writeString(this.getZipPath(r2.path));
        this.writeCDExtraField(r2);
        return this.os.getBytes();
    }

    protected void writeCommonHeaderBlock(FileRecord r2) throws IOException {
        boolean NO_COMPRESSION = false;
        int DEFLATE = 8;
        this.os.writeShort(this.versionNeededToExtract(r2));
        this.os.writeShort(0);
        this.os.writeShort(r2.compressedSize == r2.size ? 0 : 8);
        this.os.writeShort(r2.lastModifiedTime);
        this.os.writeShort(r2.lastModifiedDate);
        this.os.writeLong(r2.crc32);
        this.os.writeLong(r2.compressedSize);
        this.os.writeLong(r2.size);
        byte[] utf8name = this.getZipPath(r2.path).getBytes("UTF-8");
        this.os.writeShort(utf8name.length);
    }

    protected String getZipPath(String path) {
        return path;
    }

    protected short versionMadeBy(FileRecord r2) {
        return 768;
    }

    protected short versionNeededToExtract(FileRecord r2) {
        if (r2.permissions == FOLDER_FILE_PERMISSIONS || r2.permissions == SYMLINK_FILE_PERMISSIONS) {
            return 10;
        }
        return 20;
    }

    protected short getLFExtraFieldLength() {
        return 0;
    }

    protected void writeLFExtraField(FileRecord r2) throws IOException {
    }

    protected short getCDExtraFieldLength() {
        return 0;
    }

    protected void writeCDExtraField(FileRecord r2) throws IOException {
    }

    public static class FileRecord {
        public String path;
        public long lfhOffset;
        public int lastModifiedDate;
        public int lastModifiedTime;
        public long lastModifiedUnixTime;
        public long crc32;
        public long size;
        public long compressedSize;
        public long permissions = DEFAULT_FILE_PERMISSONS;

        public FileRecord(Date date) {
            Calendar c2 = Calendar.getInstance();
            c2.setTime(date);
            this.lastModifiedTime = c2.get(11) << 11 | c2.get(12) << 5 | c2.get(13) >> 1;
            this.lastModifiedDate = c2.get(1) - 1980 << 9 | c2.get(2) + 1 << 5 | c2.get(5);
            this.lastModifiedUnixTime = date.getTime() / 1000L;
        }

        public FileRecord(FileRecord original) {
            this.path = original.path;
            this.lfhOffset = original.lfhOffset;
            this.lastModifiedDate = original.lastModifiedDate;
            this.lastModifiedTime = original.lastModifiedTime;
            this.lastModifiedUnixTime = original.lastModifiedUnixTime;
            this.crc32 = original.crc32;
            this.size = original.size;
            this.compressedSize = original.compressedSize;
            this.permissions = original.permissions;
        }
    }

    public static class LittleEndianOutputStream {
        ByteArrayOutputStream os = new ByteArrayOutputStream();

        public void writeLong(long l2) {
            this.os.write((byte)l2);
            this.os.write((byte)(l2 >> 8));
            this.os.write((byte)(l2 >> 16));
            this.os.write((byte)(l2 >> 24));
        }

        public void writeShort(int s2) {
            this.os.write((byte)s2);
            this.os.write((byte)(s2 >> 8));
        }

        public void writeString(String s2) throws IOException {
            byte[] utf8bytes = s2.getBytes("UTF-8");
            this.os.write(utf8bytes);
        }

        public void writeBuffer(byte[] data) throws IOException {
            this.os.write(data);
        }

        public void writeBuffer(byte[] data, int offset, int length) {
            this.os.write(data, offset, length);
        }

        public void writeByte(int data) {
            this.os.write(data);
        }

        public byte[] getBytes() {
            return this.os.toByteArray();
        }

        public void reset() {
            this.os.reset();
        }
    }
}

