/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pki;

import com.adobe.pki.Base64;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public final class PKIUtils
implements Serializable {
    private static final long serialVersionUID = 8321676081937506844L;

    private PKIUtils() {
    }

    public static Vector lookupPEMTokens(byte[] inBytes, String type) {
        if (inBytes == null || type == null) {
            return null;
        }
        Vector<byte[]> list = new Vector<byte[]>();
        String responseStr = new String(inBytes);
        Pattern beginTag = Pattern.compile("-----BEGIN " + type + "-----", 40);
        Matcher beginM = beginTag.matcher(responseStr);
        Pattern endTag = Pattern.compile("-----END " + type + "-----", 40);
        Matcher endM = endTag.matcher(responseStr);
        while (beginM.find() && endM.find()) {
            String pemEncoded = responseStr.substring(beginM.end(), endM.start() - 1);
            byte[] decodedBytes = Base64.decode(pemEncoded.getBytes(), 0, pemEncoded.getBytes().length, 0);
            list.add(decodedBytes);
        }
        return list;
    }

    public static PrivateKey getJCEPrivateKey(JSAFE_PrivateKey rsaPrivateKey) {
        String algorithm = rsaPrivateKey.getAlgorithm();
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[][] keyData = rsaPrivateKey.getKeyData();
            KeySpec spec = null;
            if (algorithm.equalsIgnoreCase("RSA")) {
                spec = new RSAPrivateKeySpec(new BigInteger(1, keyData[0]), new BigInteger(1, keyData[1]));
            } else if (algorithm.equalsIgnoreCase("DSA")) {
                spec = new DSAPrivateKeySpec(new BigInteger(1, keyData[3]), new BigInteger(1, keyData[0]), new BigInteger(1, keyData[1]), new BigInteger(1, keyData[2]));
            }
            if (spec != null) {
                privateKey = keyFactory.generatePrivate(spec);
            }
        }
        catch (NoSuchAlgorithmException e2) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return privateKey;
    }

    public static PublicKey getJCEPublicKey(JSAFE_PublicKey rsaPublicKey) {
        String algorithm = rsaPublicKey.getAlgorithm();
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] keyData = null;
            if (algorithm.equalsIgnoreCase("RSA")) {
                keyData = rsaPublicKey.getKeyData("RSAPublicKeyBER")[0];
            } else if (algorithm.equalsIgnoreCase("DSA")) {
                keyData = rsaPublicKey.getKeyData("DSAPublicKeyBER")[0];
            }
            if (keyData != null) {
                publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(keyData));
            }
        }
        catch (InvalidKeySpecException e2) {
        }
        catch (NoSuchAlgorithmException e3) {
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            // empty catch block
        }
        return publicKey;
    }

    public static byte[] getOIDBytesFromString(String oidString) {
        try {
            Oid oid = new Oid(oidString);
            if (oid != null) {
                OIDContainer asn1Oid = new OIDContainer(0);
                ASN1Container[] asn1Cont = new ASN1Container[]{asn1Oid};
                ASN1.berDecode(oid.getDER(), 0, asn1Cont);
                byte[] oidBytes = new byte[asn1Oid.dataLen];
                System.arraycopy(asn1Oid.data, asn1Oid.dataOffset, oidBytes, 0, asn1Oid.dataLen);
                return oidBytes;
            }
        }
        catch (GSSException e2) {
        }
        catch (ASN_Exception aSN_Exception) {
            // empty catch block
        }
        return null;
    }

    public static byte[] getSignature(byte[] derBytes) {
        BitStringContainer signatureDERCont = new BitStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{new SequenceContainer(0), new EncodedContainer(12288), new EncodedContainer(12288), signatureDERCont, new EndContainer()};
        try {
            ASN1.berDecode(derBytes, 0, asn1Def);
            if (signatureDERCont.dataPresent) {
                byte[] signature = new byte[signatureDERCont.dataLen];
                System.arraycopy(signatureDERCont.data, signatureDERCont.dataOffset, signature, 0, signatureDERCont.dataLen);
                return signature;
            }
        }
        catch (ASN_Exception aSN_Exception) {
            // empty catch block
        }
        return null;
    }
}

