/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.nai;

import com.adobe.air.Descriptor;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.nai.NativePackager;
import com.adobe.air.validator.ApplicationDescriptorValidationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class DMGPackager
extends NativePackager {
    protected Descriptor m_descriptor;

    protected void assembleInternalFiles() throws IOException, SDKDamagedException {
        File conversionOutputMoved = new File(this.getTempFile(), this.m_appName);
        this.m_conversionOutput.renameTo(conversionOutputMoved);
        this.m_conversionOutput = conversionOutputMoved;
        File bootstrapper = new File(this.getNAISDKLibDir(), "naib.app");
        if (!bootstrapper.exists()) {
            throw new SDKDamagedException(bootstrapper.getPath());
        }
        File bootstrapperContents = new File(bootstrapper, "Contents");
        if (!bootstrapperContents.exists()) {
            throw new SDKDamagedException("lib/" + bootstrapper.getName() + "/Contents");
        }
        String installAppName = "Install " + this.m_appName;
        File installApp = new File(this.getTempFile(), installAppName + ".app");
        installApp.mkdir();
        Process copy = new ProcessBuilder("rsync", "-a", bootstrapperContents.getPath(), installApp.getPath()).start();
        Utils.consumeOutput(copy);
        try {
            copy.waitFor();
        }
        catch (InterruptedException e2) {
            throw new IOException("Copy Interrupted");
        }
        if (copy.exitValue() != 0) {
            throw new IOException("Copy failed");
        }
        File naib = new File(installApp, "Contents/MacOS/naib");
        File executable = new File(installApp, "Contents/MacOS/" + installAppName);
        naib.renameTo(executable);
        File infoPlist = new File(installApp, "Contents/Info.plist");
        FileInputStream infoPlistIn = new FileInputStream(infoPlist);
        String infoPlistText = new String(Utils.readIn(infoPlistIn), "UTF-8");
        infoPlistIn.close();
        infoPlistText = infoPlistText.replaceFirst("APP_COPYRIGHT", this.m_descriptor.copyright() == null ? "" : this.m_descriptor.copyright());
        infoPlistText = infoPlistText.replaceFirst("APP_VERSION2", this.m_descriptor.version());
        infoPlistText = infoPlistText.replaceFirst("APP_ID", this.m_descriptor.id() + ".installer");
        infoPlistText = infoPlistText.replaceFirst("APP_VERSION1", this.m_descriptor.version());
        infoPlistText = infoPlistText.replaceFirst("naib", installAppName);
        FileOutputStream infoPlistOut = new FileOutputStream(infoPlist);
        infoPlistOut.write(infoPlistText.getBytes("UTF-8"));
        infoPlistOut.close();
        String appPath = "Contents/Resources/" + this.m_appName;
        File app = new File(installApp, appPath).getCanonicalFile();
        this.m_conversionOutput.renameTo(app);
        if (!app.exists()) {
            throw new IOException("Copy failed");
        }
    }

    protected void signInternalFiles() {
    }

    protected void createFinalPackage() throws IOException {
        File tempDMG1 = null;
        File tempDMG2 = null;
        try {
            File tempFile = File.createTempFile("dmg", null, this.getOutput().getAbsoluteFile().getParentFile());
            tempFile.delete();
            tempDMG1 = new File(tempFile.getAbsolutePath() + ".dmg");
            Process makeDMG = new ProcessBuilder("/usr/bin/hdiutil", "makehybrid", "-hfs", "-hfs-volume-name", "Install " + this.m_appName, "-hfs-openfolder", this.getTempFile().getAbsolutePath(), this.getTempFile().getAbsolutePath(), "-o", tempDMG1.getAbsolutePath()).start();
            Utils.consumeOutput(makeDMG);
            makeDMG.waitFor();
            if (makeDMG.exitValue() != 0) {
                throw new IOException("DMG Creation failed");
            }
            tempFile = File.createTempFile("dmg", null, this.getOutput().getAbsoluteFile().getParentFile());
            tempFile.delete();
            tempDMG2 = new File(tempFile.getAbsolutePath() + ".dmg");
            Process compressDMG = new ProcessBuilder("/usr/bin/hdiutil", "convert", tempDMG1.getAbsolutePath(), "-format", "UDBZ", "-o", tempDMG2.getAbsolutePath()).start();
            Utils.consumeOutput(compressDMG);
            compressDMG.waitFor();
            if (compressDMG.exitValue() != 0) {
                throw new IOException("DMG Creation failed");
            }
            if (this.getOutput().exists()) {
                Utils.deleteAll(this.getOutput());
            }
            tempDMG2.renameTo(this.getOutput());
        }
        catch (InterruptedException e2) {
            throw new IOException("DMG Packaging interrupted");
        }
        finally {
            if (tempDMG1 != null) {
                tempDMG1.delete();
            }
            if (tempDMG2 != null) {
                tempDMG2.delete();
            }
        }
    }

    protected void signFinalPackage() {
    }

    protected void finalizePackage() throws IOException {
    }

    protected String getPlatformConverterName() {
        return ENTRYPOINT_NAME;
    }

    protected void parseDescriptorValues() {
        try {
            this.m_descriptor = new Descriptor(new File(this.m_conversionOutput, "Contents/Resources/META-INF/AIR/application.xml"));
            this.m_appName = this.m_descriptor.filename();
        }
        catch (ApplicationDescriptorValidationException e2) {
            throw new IllegalStateException("Conversion produced an invalid descriptor");
        }
    }
}

