/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoPlist {
    private Document m_doc = null;
    private String m_executable = null;
    private String m_name = null;
    private String m_iconPath = null;
    private String m_identifier = null;
    private String m_version = null;
    private String m_orientation = null;
    private Boolean m_fullscreen = false;
    private Boolean m_visible = true;
    private Boolean m_autoOrients = false;
    private String m_infoAdditions = null;
    private String m_initialWindowTitle = null;
    private DocumentBuilder m_docBuilder = null;
    private String m_renderMode = null;

    public void setExecutable(String executable) {
        this.m_executable = executable;
    }

    public void setIdentifier(String identifier) {
        this.m_identifier = identifier;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setIcon(String path) {
        this.m_iconPath = path;
    }

    public void setVersion(String value) {
        this.m_version = value;
    }

    public void setInitialWindowTitle(String value) {
        this.m_initialWindowTitle = value;
    }

    public void setFullscreen(Boolean value) {
        if (value != null) {
            this.m_fullscreen = value;
        }
    }

    public void setVisible(Boolean value) {
        if (value != null) {
            this.m_visible = value;
        }
    }

    public void setInfoAdditions(String value) {
        this.m_infoAdditions = value;
    }

    public void setAutoOrients(Boolean value) {
        if (value != null) {
            this.m_autoOrients = value;
        }
    }

    public void setAspectRatio(String aspectRatio) {
        if (aspectRatio == null) {
            this.m_orientation = null;
        } else if (aspectRatio.equals("portait")) {
            this.m_orientation = "UIInterfaceOrientationPortrait";
        } else if (aspectRatio.equals("landscape")) {
            this.m_orientation = "UIInterfaceOrientationLandscapeRight";
        }
    }

    public void setRenderMode(String renderMode) {
        this.m_renderMode = renderMode;
    }

    private Document createPlistDoc() throws ParserConfigurationException {
        if (this.m_docBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.m_docBuilder = factory.newDocumentBuilder();
        }
        DOMImplementation domImpl = this.m_docBuilder.getDOMImplementation();
        DocumentType doctype = domImpl.createDocumentType("plist", "-//Apple Computer//DTD PLIST 1.0//EN", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
        return domImpl.createDocument(null, "plist", doctype);
    }

    private Element appendType(Node root, String type, String value) {
        Element elemType = this.m_doc.createElement(type);
        if (value != null) {
            elemType.appendChild(this.m_doc.createTextNode(value));
        }
        root.appendChild(elemType);
        return elemType;
    }

    private void appendKeyString(Node root, String key, String value) {
        this.appendType(root, "key", key);
        this.appendType(root, "string", value);
    }

    private void appendKeyBool(Node root, String key, Boolean value) {
        this.appendType(root, "key", key);
        this.appendType(root, value != false ? "true" : "false", null);
    }

    private static String join(Collection<?> s2, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = s2.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public String getXML() throws IOException {
        String result = null;
        try {
            this.m_doc = this.createPlistDoc();
            Element plist = this.m_doc.getDocumentElement();
            plist.setAttribute("version", "1.0");
            Element dict = this.appendType(plist, "dict", null);
            this.appendKeyBool(dict, "CFBundleAllowMixedLocalizations", true);
            if (this.m_iconPath != null) {
                this.appendKeyString(dict, "CFBundleIconFile", this.m_iconPath);
            }
            Pattern pattern = Pattern.compile("(\\d+)(?:\\D+(\\d+))?(?:\\D+(\\d+))?");
            Matcher matcher = pattern.matcher(this.m_version);
            List<Object> numbers = new ArrayList<Integer>();
            if (matcher.find()) {
                for (int i2 = 1; i2 <= matcher.groupCount(); ++i2) {
                    String match = matcher.group(i2);
                    if (match != null && match.length() > 0) {
                        numbers.add(new Integer(match));
                        continue;
                    }
                    numbers.add(new Integer(0));
                }
            } else {
                numbers = Arrays.asList(1, 1, 1);
            }
            if (numbers.size() > 0 && (Integer)numbers.get(0) > 99999) {
                numbers.set(0, 99999);
            }
            if (numbers.size() > 1 && (Integer)numbers.get(1) > 99) {
                numbers.set(1, 99);
            }
            if (numbers.size() > 2 && (Integer)numbers.get(2) > 99) {
                numbers.set(2, 99);
            }
            this.appendKeyString(dict, "CFBundleVersion", InfoPlist.join(numbers, "."));
            this.appendKeyString(dict, "CFBundleShortVersionString", this.m_version);
            this.appendKeyString(dict, "CFBundleIdentifier", this.m_identifier);
            this.appendKeyString(dict, "CFBundleInfoDictionaryVersion", "6.0");
            this.appendKeyString(dict, "CFBundleExecutable", this.m_executable);
            this.appendKeyString(dict, "CFBundleDisplayName", this.m_name);
            this.appendKeyString(dict, "CFBundlePackageType", "APPL");
            this.appendKeyString(dict, "DTPlatformName", "iphoneos");
            this.appendKeyString(dict, "DTSDKName", "iphoneos3.0");
            this.appendKeyString(dict, "MinimumOSVersion", "3.0");
            this.appendKeyString(dict, "NSMainNibFile", "MainWindow");
            this.appendKeyString(dict, "CFBundleResourceSpecification", "ResourceRules.plist");
            this.appendKeyBool(dict, "UIStatusBarHidden", this.m_fullscreen);
            if (this.m_orientation != null) {
                this.appendKeyString(dict, "UIInterfaceOrientation", this.m_orientation);
            }
            if (this.m_renderMode != null) {
                this.appendKeyString(dict, "renderMode", this.m_renderMode);
            }
            this.appendKeyBool(dict, "CTAutoOrients", this.m_autoOrients);
            this.appendKeyBool(dict, "CTInitialWindowVisible", this.m_visible);
            this.appendKeyString(dict, "CTInitialWindowTitle", this.m_initialWindowTitle);
            this.appendType(dict, "key", "CFBundleSupportedPlatforms");
            Element array = this.appendType(dict, "array", null);
            this.appendType(array, "string", "iPhoneOS");
            if (this.m_infoAdditions != null) {
                String infoAdditionsPList = "<plist><dict>" + this.m_infoAdditions + "</dict></plist>";
                Document document = this.m_docBuilder.parse(new InputSource(new StringReader(infoAdditionsPList)));
                Node rootNode = document.getDocumentElement().getFirstChild();
                NodeList children = rootNode.getChildNodes();
                for (int i3 = 0; i3 < children.getLength(); ++i3) {
                    Node child = children.item(i3);
                    if (child.getNodeType() != 1) continue;
                    dict.appendChild(this.m_doc.importNode(child, true));
                }
            }
            DOMSource domSource = new DOMSource(this.m_doc);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("doctype-public", "-//Apple//DTD PLIST 1.0//EN");
            transformer.setOutputProperty("doctype-system", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(domSource, sr);
            result = sw.toString();
        }
        catch (ParserConfigurationException e2) {
            throw new IOException("PLIST generation failed due to parser error:" + e2);
        }
        catch (TransformerException e3) {
            throw new IOException("PLIST generation failed due to transformer error:" + e3);
        }
        catch (SAXException e4) {
            throw new IOException("PLIST generation failed due to SAX error:" + e4);
        }
        catch (IOException e5) {
            throw new IOException("PLIST generation failed due to IO error:" + e5);
        }
        return result;
    }
}

