/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.util.LocaleData;
import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import java.util.HashMap;
import java.util.Map;

public class BaseFormatter {
    private static final Map otScriptMap = new HashMap();

    public int firstPass(AttributedRun attributedRun, int n, int n2) {
        return n2;
    }

    public int canRenderWithNotdef(AttributedRun attributedRun, int n, int n2) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        int n3;
        int n4 = attributedRun.elementAt(n);
        if (CharUtil.isControl(n4)) {
            return 1;
        }
        if (!CharUtil.isBase(n4) || n + 1 == n2 || attributedRun.getElementStyle(n + 1, ElementAttribute.isGlyph) == Boolean.TRUE || !CharUtil.isCombining(attributedRun.elementAt(n + 1))) {
            return 1;
        }
        for (n3 = n + 1; n3 < n2 && attributedRun.getElementStyle(n3, ElementAttribute.isGlyph) != Boolean.TRUE && CharUtil.isCombining(attributedRun.elementAt(n3)); ++n3) {
        }
        return n3 - n;
    }

    public int canRenderWithFont(FontData fontData, AttributedRun attributedRun, int n, int n2) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        int n3;
        int n4;
        int n5;
        if (this.shouldFormatOT(fontData) ? !this.canFormatOT() : (this.shouldFormatTT(fontData) ? !this.canFormatTT() : (this.shouldFormatT1(fontData) ? !this.canFormatT1() : !this.canFormatGeneric()))) {
            return 0;
        }
        int n6 = attributedRun.elementAt(n);
        if (CharUtil.isControl(n6) && !fontData.isSymbolic()) {
            return 1;
        }
        if (!CharUtil.isBase(n6) || n + 1 == n2 || attributedRun.getElementStyle(n + 1, ElementAttribute.isGlyph) == Boolean.TRUE || !CharUtil.isCombining(attributedRun.elementAt(n + 1))) {
            int n7 = fontData.getGlyphForChar(n6);
            return n7 == 0 ? 0 : 1;
        }
        for (n5 = n + 1; n5 < n2 && attributedRun.getElementStyle(n5, ElementAttribute.isGlyph) != Boolean.TRUE && CharUtil.isCombining(attributedRun.elementAt(n5)); ++n5) {
        }
        boolean bl = false;
        int[] nArray = new int[n5 - n];
        int[] nArray2 = new int[n5 - n];
        for (n4 = n; n4 < n5; ++n4) {
            nArray[n4 - n] = attributedRun.elementAt(n4);
            n3 = fontData.getGlyphForChar(nArray[n4 - n]);
            if (n3 == 0) {
                bl = true;
            }
            nArray2[n4 - n] = n3;
        }
        if (bl) {
            n4 = CharUtil.compose(nArray, 0, n5 - n);
            if (n4 != -1 && (n3 = fontData.getGlyphForChar(n4)) != 0) {
                return n5 - n;
            }
            return 0;
        }
        return n5 - n;
    }

    protected boolean shouldFormatOT(FontData fontData) {
        if (fontData instanceof OpenTypeFont) {
            OpenTypeFont openTypeFont = (OpenTypeFont)fontData;
            return openTypeFont.gpos != null || openTypeFont.gsub != null;
        }
        return false;
    }

    protected boolean canFormatOT() {
        return false;
    }

    protected int formatOT(OpenTypeFont openTypeFont, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        throw new UnsupportedFontException();
    }

    protected boolean shouldFormatTT(FontData fontData) {
        if (fontData instanceof OpenTypeFont) {
            OpenTypeFont openTypeFont = (OpenTypeFont)fontData;
            return openTypeFont.gpos == null && openTypeFont.gsub == null;
        }
        return false;
    }

    protected boolean canFormatTT() {
        return false;
    }

    protected int formatTT(OpenTypeFont openTypeFont, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        throw new UnsupportedFontException();
    }

    protected boolean shouldFormatT1(FontData fontData) {
        return fontData instanceof Type1Font;
    }

    protected boolean canFormatT1() {
        return false;
    }

    protected int formatT1(Type1Font type1Font, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        throw new UnsupportedFontException();
    }

    protected boolean shouldFormatGeneric(FontData fontData) {
        return !(fontData instanceof Type1Font) && !(fontData instanceof OpenTypeFont);
    }

    protected boolean canFormatGeneric() {
        return false;
    }

    protected int formatGeneric(FontData fontData, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        throw new UnsupportedFontException();
    }

    public int format(AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        while (n < n2) {
            int n3;
            int n4 = attributedRun.getSubrunLimit(n, n2, InFontFormatter.fontAtts);
            Font font = (Font)attributedRun.getElementStyle(n, ElementAttribute.font);
            FontData fontData = ((FontImpl)font).getFontData();
            if (this.shouldFormatOT(fontData)) {
                n3 = this.formatOT((OpenTypeFont)fontData, attributedRun, n, n4, bl);
            } else if (this.shouldFormatTT(fontData)) {
                n3 = this.formatTT((OpenTypeFont)fontData, attributedRun, n, n4, bl);
            } else if (this.shouldFormatT1(fontData)) {
                Type1Font type1Font = (Type1Font)fontData;
                n3 = this.formatT1(type1Font, attributedRun, n, n4, bl);
            } else {
                n3 = this.formatGeneric(fontData, attributedRun, n, n4, bl);
            }
            n = n3;
            n2 += n3 - n4;
        }
        return n2;
    }

    public void posFromAdvanceWidth(AttributedRun attributedRun, FontData fontData, int n, int n2) throws InvalidFontException, UnsupportedFontException, InvalidGlyphException {
        attributedRun.startWorkingWithPositions(n, n2);
        for (int i = n; i < n2; ++i) {
            int n3 = attributedRun.elementAt(i);
            if (n3 > fontData.getNumGlyphs()) {
                throw new InvalidFontException("gid " + n3 + " is not a valid gid (numGlyphs = " + fontData.getNumGlyphs() + ")");
            }
            attributedRun.setElementPlacementAndAdvance(i, 0.0, 0.0, fontData.getHorizontalAdvance(n3), 0.0);
        }
    }

    protected void applyKernTable(OpenTypeFont openTypeFont, AttributedRun attributedRun, int n, int n2) throws InvalidFontException, UnsupportedFontException {
        if (openTypeFont.kern == null) {
            return;
        }
        for (int i = n; i < n2 - 1; ++i) {
            int[] nArray = openTypeFont.kern.getKernVector(attributedRun.elementAt(i), attributedRun.elementAt(i + 1));
            attributedRun.adjustPlacementAndAdvance(i, 0.0, 0.0, nArray[0], nArray[1]);
        }
    }

    static int getOTScriptTag(Integer n) {
        Integer n2 = (Integer)otScriptMap.get(n);
        if (n2 != null) {
            return n2;
        }
        return Tag.script_DFLT;
    }

    static int getOTLanguageTag(ULocale uLocale) {
        int n = LocaleData.getOpenTypeData((ULocale)uLocale).getLanguageTag();
        if (n == 0) {
            n = Tag.language_ENG;
        }
        return n;
    }

    static {
        otScriptMap.put(new Integer(2), new Integer(Tag.script_arab));
        otScriptMap.put(new Integer(3), new Integer(Tag.script_armn));
        otScriptMap.put(new Integer(4), new Integer(Tag.script_beng));
        otScriptMap.put(new Integer(5), new Integer(Tag.script_bopo));
        otScriptMap.put(new Integer(46), new Integer(Tag.script_brai));
        otScriptMap.put(new Integer(40), new Integer(Tag.script_cans));
        otScriptMap.put(new Integer(6), new Integer(Tag.script_cher));
        otScriptMap.put(new Integer(8), new Integer(Tag.script_cyrl));
        otScriptMap.put(new Integer(10), new Integer(Tag.script_deva));
        otScriptMap.put(new Integer(11), new Integer(Tag.script_ethi));
        otScriptMap.put(new Integer(12), new Integer(Tag.script_geor));
        otScriptMap.put(new Integer(14), new Integer(Tag.script_grek));
        otScriptMap.put(new Integer(15), new Integer(Tag.script_gujr));
        otScriptMap.put(new Integer(16), new Integer(Tag.script_guru));
        otScriptMap.put(new Integer(17), new Integer(Tag.script_hani));
        otScriptMap.put(new Integer(18), new Integer(Tag.script_hang));
        otScriptMap.put(new Integer(19), new Integer(Tag.script_hebr));
        otScriptMap.put(new Integer(20), new Integer(Tag.script_kana));
        otScriptMap.put(new Integer(21), new Integer(Tag.script_knda));
        otScriptMap.put(new Integer(22), new Integer(Tag.script_kana));
        otScriptMap.put(new Integer(23), new Integer(Tag.script_khmr));
        otScriptMap.put(new Integer(24), new Integer(Tag.script_lao));
        otScriptMap.put(new Integer(25), new Integer(Tag.script_latn));
        otScriptMap.put(new Integer(26), new Integer(Tag.script_mlym));
        otScriptMap.put(new Integer(27), new Integer(Tag.script_mong));
        otScriptMap.put(new Integer(28), new Integer(Tag.script_mymr));
        otScriptMap.put(new Integer(29), new Integer(Tag.script_ogam));
        otScriptMap.put(new Integer(31), new Integer(Tag.script_orya));
        otScriptMap.put(new Integer(32), new Integer(Tag.script_runr));
        otScriptMap.put(new Integer(33), new Integer(Tag.script_sinh));
        otScriptMap.put(new Integer(34), new Integer(Tag.script_syrc));
        otScriptMap.put(new Integer(35), new Integer(Tag.script_taml));
        otScriptMap.put(new Integer(36), new Integer(Tag.script_telu));
        otScriptMap.put(new Integer(37), new Integer(Tag.script_thaa));
        otScriptMap.put(new Integer(38), new Integer(Tag.script_thai));
        otScriptMap.put(new Integer(39), new Integer(Tag.script_tibt));
        otScriptMap.put(new Integer(41), new Integer(Tag.script_yi));
        otScriptMap.put(new Integer(54), new Integer(Tag.script_kana));
    }
}

