/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement.platform;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.IntelligentResolver;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontResolver;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontSearchAttributes;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import com.adobe.fontengine.inlineformatting.css20.PassThroughFamilyNameNormalizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class PlatformFontResolverImpl
implements PlatformFontResolver {
    static final long serialVersionUID = 2L;
    private HashMap platformFonts;
    private FontResolutionPriority resolutionPriority = FontResolutionPriority.FIRST;
    private FamilyNameNormalizer normalizer;

    public PlatformFontResolverImpl() {
        this(new PassThroughFamilyNameNormalizer());
    }

    public PlatformFontResolverImpl(FamilyNameNormalizer familyNameNormalizer) {
        this.platformFonts = new HashMap();
        if (familyNameNormalizer == null) {
            familyNameNormalizer = new PassThroughFamilyNameNormalizer();
        }
        this.normalizer = familyNameNormalizer;
    }

    public PlatformFontResolverImpl(PlatformFontResolverImpl platformFontResolverImpl) {
        this.platformFonts = (HashMap)platformFontResolverImpl.platformFonts.clone();
        this.resolutionPriority = platformFontResolverImpl.resolutionPriority;
        this.normalizer = platformFontResolverImpl.normalizer;
    }

    public void addFont(Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        PlatformFontDescription[] platformFontDescriptionArray = font.getPlatformFontDescription();
        if (platformFontDescriptionArray == null) {
            throw new UnsupportedFontException("No Platform Descriptions avalable for font - " + font);
        }
        for (int i = 0; i < platformFontDescriptionArray.length; ++i) {
            this.addFont(platformFontDescriptionArray[i], font);
        }
    }

    public void addFont(PlatformFontDescription platformFontDescription, Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        Font font2 = (Font)this.platformFonts.get(platformFontDescription.getPlatformName());
        if (font2 != null) {
            Font font3;
            if (this.resolutionPriority == FontResolutionPriority.FIRST) {
                return;
            }
            if ((this.resolutionPriority == FontResolutionPriority.INTELLIGENT_LAST || this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST) && (font3 = IntelligentResolver.choosePreferredFont(font2, font, this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST)) == font2) {
                return;
            }
        }
        this.platformFonts.put(this.normalizer.normalize(platformFontDescription.getPlatformName()), font);
    }

    public boolean isEmpty() {
        return this.platformFonts.isEmpty();
    }

    public FontResolutionPriority setResolutionPriority(FontResolutionPriority fontResolutionPriority) {
        FontResolutionPriority fontResolutionPriority2 = this.resolutionPriority;
        this.resolutionPriority = fontResolutionPriority;
        return fontResolutionPriority2;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.platformFonts.hashCode();
        n = 31 * n + this.resolutionPriority.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PlatformFontResolverImpl)) {
            return false;
        }
        PlatformFontResolverImpl platformFontResolverImpl = (PlatformFontResolverImpl)object;
        if (!this.resolutionPriority.equals(platformFontResolverImpl.resolutionPriority)) {
            return false;
        }
        return this.platformFonts.equals(platformFontResolverImpl.platformFonts);
    }

    public String toString() {
        TreeSet treeSet = new TreeSet();
        Object object = this.platformFonts.keySet().iterator();
        while (object.hasNext()) {
            treeSet.add(object.next());
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("priority = ");
        ((StringBuffer)object).append(this.resolutionPriority.toString());
        ((StringBuffer)object).append("; platform font descriptions = ");
        String string = "";
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append((String)iterator.next());
            string = ", ";
        }
        return ((StringBuffer)object).toString();
    }

    public Font findFont(PlatformFontSearchAttributes platformFontSearchAttributes) {
        Font font = (Font)this.platformFonts.get(this.normalizer.normalize(platformFontSearchAttributes.getPlatformName()));
        return font;
    }
}

