/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.mac;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import com.adobe.internal.mac.resource.BasicResourceHandler;
import com.adobe.internal.mac.resource.ResourceParser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class sfntResourceHandler
extends BasicResourceHandler {
    private static final byte[] sfnt = new byte[]{115, 102, 110, 116};
    FontLoader loader = new FontLoader();
    Map<Integer, SfntResource> resources = new HashMap<Integer, SfntResource>();
    int idToCreate = -1;
    boolean createAllFonts = true;

    public sfntResourceHandler() {
        super(sfnt);
    }

    public sfntResourceHandler(int n) {
        this();
        this.idToCreate = n;
        this.createAllFonts = false;
    }

    public void handleResource(ResourceParser.ResourceEntry resourceEntry, long l, InputStream inputStream) {
        if (this.createAllFonts || this.idToCreate == resourceEntry.getID()) {
            SfntResource sfntResource = new SfntResource(resourceEntry.getID(), resourceEntry.getName(), resourceEntry.getScriptCode(), l);
            Font font = null;
            try {
                font = this.loader.load(inputStream, (int)l, false);
            }
            catch (FontLoadingException fontLoadingException) {
                sfntResource.setException(fontLoadingException);
            }
            sfntResource.setFont(font);
            this.resources.put(new Integer(resourceEntry.getID()), sfntResource);
        }
    }

    public Map<Integer, SfntResource> getResources() {
        return this.resources;
    }

    public static class SfntResource {
        private String name;
        private int script;
        private long size;
        private int id;
        private Font font;
        private Exception exception;

        private SfntResource(int n, String string, int n2, long l) {
            this.size = l;
            this.id = n;
            this.name = string;
            this.script = n2;
        }

        public long getSize() {
            return this.size;
        }

        public int getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getScriptCode() {
            return this.script;
        }

        void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("fontID = " + this.id);
            stringBuffer.append(", name = " + this.name);
            stringBuffer.append(", size = " + this.size);
            stringBuffer.append(", font = " + this.font);
            return stringBuffer.toString();
        }
    }
}

