/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.BitmapConsumer;
import com.adobe.fontengine.font.CatalogDescription;
import com.adobe.fontengine.font.ComparingOutlineConsumer;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.IteratingOutlineConsumer;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;

public abstract class FontData {
    private final byte[] containerFingerprint;
    protected static final int[] typicalCharactersForIdeoEmBoxComputation = new int[]{27704, 39729, 44332, 12539};
    protected static final int[] typicalCharactersForIcfBoxComputation = new int[]{27704, 39729, 44332, 12507};
    protected static final int[][] typicalCharactersForProportionalRomanDecision = new int[][]{{32, 46, 77}, {32, 46, 924}, {32, 46, 64259}};

    public FontData(byte[] byArray) {
        this.containerFingerprint = byArray == null ? null : (byte[])byArray.clone();
    }

    public byte[] getContainerFingerprint() {
        if (this.containerFingerprint == null) {
            return new byte[0];
        }
        return (byte[])this.containerFingerprint.clone();
    }

    public abstract int getNumGlyphs() throws InvalidFontException, UnsupportedFontException;

    public boolean isSymbolic() throws UnsupportedFontException, InvalidFontException {
        return false;
    }

    public abstract double getUnitsPerEmX() throws UnsupportedFontException, InvalidFontException;

    public abstract double getUnitsPerEmY() throws UnsupportedFontException, InvalidFontException;

    public double getCoolTypeUnitsPerEm() throws UnsupportedFontException, InvalidFontException {
        return 1000.0;
    }

    public abstract Rect getFontBBox() throws InvalidFontException, UnsupportedFontException;

    protected abstract Rect getCoolTypeRawFontBBox() throws InvalidFontException, UnsupportedFontException;

    public Rect getCoolTypeFontBBox() throws InvalidFontException, UnsupportedFontException {
        Rect rect = this.getCoolTypeRawFontBBox();
        if (rect.xmin == rect.xmax || rect.ymin == rect.ymax) {
            double d = this.getUnitsPerEmX();
            double d2 = this.getUnitsPerEmY();
            return new Rect(-0.5 * d, -0.5 * d2, 1.5 * d, 1.0 * d2);
        }
        return rect;
    }

    public abstract CoolTypeScript getCoolTypeScript() throws UnsupportedFontException, InvalidFontException;

    protected boolean useCoolTypeCJKHeuristics() throws UnsupportedFontException, InvalidFontException {
        CoolTypeScript coolTypeScript = this.getCoolTypeScript();
        return coolTypeScript == CoolTypeScript.JAPANESE || coolTypeScript == CoolTypeScript.SIMPLIFIED_CHINESE || coolTypeScript == CoolTypeScript.TRADITIONAL_CHINESE || coolTypeScript == CoolTypeScript.KOREAN;
    }

    protected double getCoolTypeCapHeightFromGlyphs() throws UnsupportedFontException, InvalidFontException {
        int n = this.getCoolTypeGlyphForChar(79);
        int n2 = this.getCoolTypeGlyphForChar(72);
        if (n != 0 && n2 != 0) {
            Rect rect = this.getGlyphBBox(n);
            Rect rect2 = this.getGlyphBBox(n2);
            if (!rect.equals(Rect.emptyRect) && !rect2.equals(Rect.emptyRect)) {
                return Math.min(rect.ymax, rect2.ymax);
            }
        }
        return Double.NaN;
    }

    protected double getCoolTypeXHeightFromGlyphs() throws UnsupportedFontException, InvalidFontException {
        Rect rect;
        int n = this.getCoolTypeGlyphForChar(120);
        if (n != 0 && !(rect = this.getGlyphBBox(n)).equals(Rect.emptyRect)) {
            return rect.ymax;
        }
        return Double.NaN;
    }

    public double getCoolTypeCapHeight() throws UnsupportedFontException, InvalidFontException {
        return this.getCoolTypeCapHeightFromGlyphs();
    }

    public double getCoolTypeXHeight() throws UnsupportedFontException, InvalidFontException {
        return this.getCoolTypeXHeightFromGlyphs();
    }

    protected Rect snapToKnownIdeoEmBox(double d, double d2) throws UnsupportedFontException, InvalidFontException {
        double d3 = this.getUnitsPerEmX();
        double d4 = this.getUnitsPerEmY();
        if (d4 == 1000.0 && Math.abs(d - -120.0) <= 0.004 * d4 && Math.abs(d2 - 880.0) <= 0.004 * d4) {
            return new Rect(0.0, -0.12 * d4, d3, 0.88 * d4);
        }
        if (d4 == 256.0 && Math.abs(d - -36.0) <= 0.0045 * d4 && Math.abs(d2 - 220.0) <= 0.0045 * d4) {
            return new Rect(0.0, -0.140625 * d4, d3, 0.859375 * d4);
        }
        return null;
    }

    protected Rect getCoolTypeIdeoEmBoxFromFullBoxCharacter() throws InvalidFontException, UnsupportedFontException {
        int n = this.getCoolTypeGlyphForChar(9532);
        if (n != 0) {
            Rect rect = this.getGlyphBBox(n);
            double d = this.getUnitsPerEmY();
            if (!rect.equals(Rect.emptyRect)) {
                if (rect.ymax - rect.ymin != d) {
                    return null;
                }
                return this.snapToKnownIdeoEmBox(rect.ymin, rect.ymax);
            }
        }
        return null;
    }

    protected Rect getCoolTypeIdeoEmBoxFromTypicalCharacter() throws InvalidFontException, UnsupportedFontException {
        double d = this.getUnitsPerEmX();
        double d2 = this.getUnitsPerEmY();
        for (int i = 0; i < typicalCharactersForIdeoEmBoxComputation.length; ++i) {
            Rect rect;
            int n = this.getCoolTypeGlyphForChar(typicalCharactersForIdeoEmBoxComputation[i]);
            if (n == 0 || (rect = this.getGlyphBBox(n)).equals(Rect.emptyRect)) continue;
            double d3 = rect.ymax + (d2 - (rect.ymax - rect.ymin)) / 2.0;
            Rect rect2 = this.snapToKnownIdeoEmBox(d3 - d2, d3);
            if (rect2 != null) {
                return rect2;
            }
            return new Rect(0.0, d3 - d2, d, d3);
        }
        return null;
    }

    public abstract Rect getCoolTypeIdeoEmBox() throws UnsupportedFontException, InvalidFontException;

    protected Rect getCoolTypeIcfBoxFromTypicalCharacter(Rect rect) throws InvalidFontException, UnsupportedFontException {
        for (int i = 0; i < typicalCharactersForIcfBoxComputation.length; ++i) {
            Rect rect2;
            int n = this.getCoolTypeGlyphForChar(typicalCharactersForIcfBoxComputation[i]);
            if (n == 0 || (rect2 = this.getGlyphBBox(n)).equals(Rect.emptyRect)) continue;
            double d = (rect.ymax - rect2.ymax + (rect2.ymin - rect.ymin)) / 2.0;
            if (d < 0.0 && this.useCoolTypeCJKHeuristics()) {
                return null;
            }
            return new Rect(rect.xmin + d, rect.ymin + d, rect.xmax - d, rect.ymax - d);
        }
        return null;
    }

    protected Rect getCoolTypeIcfBoxFromIdeoEmBox(Rect rect) throws InvalidFontException, UnsupportedFontException {
        double d = (1.0 - Math.sqrt(0.9)) / 2.0;
        double d2 = d * this.getUnitsPerEmX();
        double d3 = d * this.getUnitsPerEmY();
        return new Rect(rect.xmin + d2, rect.ymin + d3, rect.xmax - d2, rect.ymax - d3);
    }

    public abstract Rect getCoolTypeIcfBox() throws UnsupportedFontException, InvalidFontException;

    protected LineMetrics getCoolTypeLineMetricsFromFontBbox() throws UnsupportedFontException, InvalidFontException {
        double d;
        double d2;
        Rect rect = this.getCoolTypeFontBBox();
        if (rect == null) {
            return null;
        }
        double d3 = this.getUnitsPerEmY();
        long l = Math.round(65536.0 * rect.ymin / d3);
        long l2 = Math.round(65536.0 * rect.ymax / d3);
        long l3 = l2 - l;
        if (l3 > 78643L) {
            d2 = rect.ymax * d3 / (rect.ymax - rect.ymin);
            d = d2 - d3;
        } else if (l3 >= 65536L) {
            d = rect.ymin;
            d2 = d + d3;
        } else {
            d2 = rect.ymax;
            d = d2 - d3;
        }
        return new LineMetrics(d2, d, d3 / 5.0);
    }

    public Rect getCoolTypeGlyphBBox(int n) throws UnsupportedFontException, InvalidFontException {
        return this.getGlyphBBox(n);
    }

    public abstract LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException;

    public LineMetrics getLineMetrics() throws UnsupportedFontException, InvalidFontException {
        return null;
    }

    public abstract UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException;

    public boolean hasCoolTypeProportionalRoman() throws InvalidFontException, UnsupportedFontException {
        int n;
        double d = 0.0;
        boolean bl = false;
        int[] nArray = new int[typicalCharactersForProportionalRomanDecision[0].length];
        for (n = 0; n < typicalCharactersForProportionalRomanDecision.length; ++n) {
            int n2 = 0;
            for (int i = 0; i < typicalCharactersForProportionalRomanDecision[n].length; ++i) {
                nArray[i] = this.getGlyphForChar(typicalCharactersForProportionalRomanDecision[n][i]);
                if (nArray[i] == 0) continue;
                ++n2;
            }
            if (n2 == typicalCharactersForProportionalRomanDecision[n].length) break;
        }
        if (n > 0 && this.useCoolTypeCJKHeuristics()) {
            return false;
        }
        if (n < typicalCharactersForProportionalRomanDecision.length) {
            for (int i = 0; i < typicalCharactersForProportionalRomanDecision[n].length; ++i) {
                double d2 = this.getHorizontalAdvance(nArray[i]);
                if (!bl) {
                    if (Math.round(d2) == 0L) continue;
                    bl = true;
                    d = d2;
                    continue;
                }
                if (!(Math.abs(d - d2) > 1.0)) continue;
                return true;
            }
            return false;
        }
        return this.getCoolTypeProportionalRomanFromFontProperties();
    }

    public abstract boolean getCoolTypeProportionalRomanFromFontProperties() throws InvalidFontException;

    public abstract int getGlyphForChar(int var1) throws InvalidFontException, UnsupportedFontException;

    public int getCoolTypeGlyphForChar(int n) throws InvalidFontException, UnsupportedFontException {
        return this.getGlyphForChar(n);
    }

    public abstract double getHorizontalAdvance(int var1) throws InvalidGlyphException, UnsupportedFontException, InvalidFontException;

    public abstract void getGlyphOutline(int var1, OutlineConsumer var2) throws InvalidFontException, UnsupportedFontException;

    public abstract Rect getGlyphBBox(int var1) throws UnsupportedFontException, InvalidFontException;

    public Scaler getScaler() throws InvalidFontException, UnsupportedFontException {
        return this.getScaler(null);
    }

    public abstract Scaler getScaler(ScanConverter var1) throws InvalidFontException, UnsupportedFontException;

    public abstract SWFFontDescription getSWFFontDescription(boolean var1) throws UnsupportedFontException, InvalidFontException;

    public abstract SWFFont4Description getSWFFont4Description(boolean var1) throws UnsupportedFontException, InvalidFontException;

    public abstract Permission getEmbeddingPermission(boolean var1) throws InvalidFontException, UnsupportedFontException;

    public abstract PDFFontDescription getPDFFontDescription(Font var1) throws UnsupportedFontException, InvalidFontException;

    public abstract XDCFontDescription getXDCFontDescription(Font var1) throws UnsupportedFontException, InvalidFontException;

    public abstract Subset createSubset() throws InvalidFontException, UnsupportedFontException;

    public abstract void subsetAndStream(Subset var1, OutputStream var2, boolean var3) throws InvalidFontException, UnsupportedFontException, IOException;

    protected boolean isSmallCapFont(int n, double d) throws UnsupportedFontException, InvalidFontException {
        if (n == 0) {
            return false;
        }
        Rect rect = this.getGlyphBBox(n);
        double d2 = this.getUnitsPerEmY();
        return rect.ymax > 0.0 && Math.abs(rect.ymax - d) / d2 < 0.02;
    }

    protected boolean isAllCapFont(int n, int n2) throws InvalidFontException, UnsupportedFontException {
        if (n == 0 || n2 == 0) {
            return false;
        }
        IteratingOutlineConsumer iteratingOutlineConsumer = new IteratingOutlineConsumer();
        this.getGlyphOutline(n, iteratingOutlineConsumer);
        ComparingOutlineConsumer comparingOutlineConsumer = new ComparingOutlineConsumer(iteratingOutlineConsumer);
        this.getGlyphOutline(n2, comparingOutlineConsumer);
        return comparingOutlineConsumer.hasOutlines && comparingOutlineConsumer.compares;
    }

    protected boolean isSerifFont(int n, int n2, double d) throws InvalidFontException, UnsupportedFontException {
        if (n == 0 && n2 == 0) {
            return false;
        }
        boolean bl = true;
        SerifEvaluator serifEvaluator = new SerifEvaluator(250, d);
        Scaler scaler = this.getScaler();
        scaler.setScale(250.0, 250.0, 250.0, 0.0, 0.0);
        try {
            if (n != 0) {
                serifEvaluator.startBitmap(n);
                scaler.getBitmap(n, serifEvaluator);
                bl = serifEvaluator.hasSerif();
                serifEvaluator.endBitmap();
            }
        }
        catch (InvalidGlyphException invalidGlyphException) {
            // empty catch block
        }
        if (bl && n2 != 0) {
            serifEvaluator.startBitmap(n2);
            scaler.getBitmap(n2, serifEvaluator);
            bl = serifEvaluator.hasSerif();
            serifEvaluator.endBitmap();
        }
        return bl;
    }

    protected abstract Set getCSSFamilyNames() throws InvalidFontException, UnsupportedFontException;

    protected abstract String getPreferredCSSFamilyName() throws InvalidFontException, UnsupportedFontException;

    protected abstract boolean isCSSStyleNormal() throws InvalidFontException, UnsupportedFontException;

    protected abstract boolean isCSSStyleItalic() throws InvalidFontException, UnsupportedFontException;

    protected abstract boolean isCSSStyleOblique() throws InvalidFontException, UnsupportedFontException;

    protected abstract boolean isCSSVariantNormal() throws InvalidFontException, UnsupportedFontException;

    protected abstract boolean isCSSVariantSmallCaps() throws InvalidFontException, UnsupportedFontException;

    protected abstract int getCSSWeight() throws InvalidFontException, UnsupportedFontException;

    protected abstract CSS20Attribute.CSSStretchValue getCSSStretchValue() throws InvalidFontException, UnsupportedFontException;

    public abstract CacheSupportInfo getCacheSupportInfo() throws UnsupportedFontException, InvalidFontException;

    public abstract PostscriptFontDescription[] getPostscriptFontDescription() throws InvalidFontException, UnsupportedFontException;

    public abstract FXGFontDescription[] getFXGFontDescription(Platform var1, ULocale var2) throws InvalidFontException, UnsupportedFontException;

    public abstract PlatformFontDescription[] getPlatformFontDescription(Platform var1, ULocale var2) throws InvalidFontException, UnsupportedFontException;

    public double[] getPointSizeRange() throws InvalidFontException, UnsupportedFontException {
        return new double[]{0.0, Double.POSITIVE_INFINITY};
    }

    public CSS20FontDescription[] getCSS20FontDescription() throws InvalidFontException, UnsupportedFontException {
        Set set = this.getCSSFamilyNames();
        int n = set.size();
        int n2 = 0;
        CSS20Attribute.CSSVariantValue[] cSSVariantValueArray = new CSS20Attribute.CSSVariantValue[2];
        if (this.isCSSVariantSmallCaps()) {
            cSSVariantValueArray[n2++] = CSS20Attribute.CSSVariantValue.SMALL_CAPS;
        }
        if (this.isCSSVariantNormal()) {
            cSSVariantValueArray[n2++] = CSS20Attribute.CSSVariantValue.NORMAL;
        }
        int n3 = 0;
        CSS20Attribute.CSSStyleValue[] cSSStyleValueArray = new CSS20Attribute.CSSStyleValue[3];
        if (this.isCSSStyleOblique()) {
            cSSStyleValueArray[n3++] = CSS20Attribute.CSSStyleValue.OBLIQUE;
        }
        if (this.isCSSStyleItalic()) {
            cSSStyleValueArray[n3++] = CSS20Attribute.CSSStyleValue.ITALIC;
        }
        if (this.isCSSStyleNormal()) {
            cSSStyleValueArray[n3++] = CSS20Attribute.CSSStyleValue.NORMAL;
        }
        int n4 = this.getCSSWeight();
        CSS20Attribute.CSSStretchValue cSSStretchValue = this.getCSSStretchValue();
        int n5 = n * n3 * n2;
        CSS20FontDescription[] cSS20FontDescriptionArray = new CSS20FontDescription[n5];
        Iterator iterator = set.iterator();
        int n6 = 0;
        double[] dArray = this.getPointSizeRange();
        for (int i = 0; i < n; ++i) {
            String string = (String)iterator.next();
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    cSS20FontDescriptionArray[n6++] = new CSS20FontDescription(string, cSSStyleValueArray[j], cSSVariantValueArray[k], cSSStretchValue, n4, dArray[0] / 10.0, dArray[1] / 10.0);
                }
            }
        }
        return cSS20FontDescriptionArray;
    }

    public CSS20FontDescription getPreferredCSS20FontDescription() throws InvalidFontException, UnsupportedFontException {
        CSS20Attribute.CSSStyleValue cSSStyleValue;
        CSS20Attribute.CSSVariantValue cSSVariantValue;
        String string = this.getPreferredCSSFamilyName();
        if (string == null) {
            return null;
        }
        if (this.isCSSVariantNormal()) {
            cSSVariantValue = CSS20Attribute.CSSVariantValue.NORMAL;
        } else if (this.isCSSVariantSmallCaps()) {
            cSSVariantValue = CSS20Attribute.CSSVariantValue.SMALL_CAPS;
        } else {
            return null;
        }
        if (this.isCSSStyleNormal()) {
            cSSStyleValue = CSS20Attribute.CSSStyleValue.NORMAL;
        } else if (this.isCSSStyleItalic()) {
            cSSStyleValue = CSS20Attribute.CSSStyleValue.ITALIC;
        } else if (this.isCSSStyleOblique()) {
            cSSStyleValue = CSS20Attribute.CSSStyleValue.OBLIQUE;
        } else {
            return null;
        }
        int n = this.getCSSWeight();
        CSS20Attribute.CSSStretchValue cSSStretchValue = this.getCSSStretchValue();
        double[] dArray = this.getPointSizeRange();
        CSS20FontDescription cSS20FontDescription = new CSS20FontDescription(string, cSSStyleValue, cSSVariantValue, cSSStretchValue, n, dArray[0] / 10.0, dArray[1] / 10.0);
        return cSS20FontDescription;
    }

    public abstract CatalogDescription getSelectionDescription() throws InvalidFontException, UnsupportedFontException;

    static class SerifEvaluator
    implements BitmapConsumer {
        int[][] runs = null;
        int minY;
        int minMarked;
        int maxMarked;
        final double widthProportion;
        final int scale;
        final double minDistanceFromVertical;
        final double tangent;

        SerifEvaluator(int n, double d) {
            this.scale = n;
            this.widthProportion = (double)n * 0.005;
            this.minDistanceFromVertical = (double)n * 0.008;
            this.tangent = Math.tan(Math.toRadians(-d));
        }

        boolean hasSerif() {
            if (this.runs == null) {
                return false;
            }
            int n = this.minMarked + (this.maxMarked - this.minMarked) / 2;
            double d = (int)Math.floor((double)(this.runs[n][1] - this.runs[n][0]) * 1.2);
            for (int i = this.minMarked; i <= this.maxMarked; ++i) {
                int n2;
                int n3 = this.runs[i][1] - this.runs[i][0];
                if (!((double)n3 > d) || !((double)((n2 = (int)Math.floor((double)this.runs[n][0] + (double)(i - n) * this.tangent)) - this.runs[i][0]) > this.minDistanceFromVertical)) continue;
                return true;
            }
            return false;
        }

        public void addRun(double d, double d2, double d3) {
            int n;
            if (this.runs == null) {
                this.minY = (int)d3 - this.scale;
                this.runs = new int[this.scale * 2][2];
                for (int i = 0; i < this.scale * 2; ++i) {
                    this.runs[i][0] = Integer.MAX_VALUE;
                    this.runs[i][1] = 0;
                }
                this.minMarked = this.maxMarked = (n = this.scale);
                this.runs[n][0] = (int)d;
                this.runs[n][1] = (int)d2;
            } else if ((int)d3 < this.minY) {
                int[][] nArray = new int[this.minY - (int)d3 + this.runs.length][2];
                for (int i = 0; i < this.minY; ++i) {
                    nArray[i][0] = Integer.MAX_VALUE;
                    nArray[i][1] = 0;
                }
                this.minMarked += this.minY - (int)d3;
                this.maxMarked += this.minY - (int)d3;
                System.arraycopy(this.runs, 0, nArray, this.minY - (int)d3, this.runs.length);
                this.runs = nArray;
                this.minY = (int)d3;
                n = 0;
                this.runs[n][0] = (int)d;
                this.runs[n][1] = (int)d2;
            } else {
                n = (int)d3 - this.minY;
                if ((int)d3 >= this.minY + this.runs.length) {
                    int[][] nArray = new int[(int)d3 - this.minY + 1][2];
                    for (int i = this.runs.length; i <= (int)d3 - this.minY; ++i) {
                        nArray[i][0] = 0;
                        nArray[i][1] = 0;
                    }
                    System.arraycopy(this.runs, 0, nArray, 0, this.runs.length);
                    this.runs = nArray;
                    this.runs[n][0] = (int)d;
                    this.runs[n][1] = (int)d2;
                } else if (d <= (double)this.runs[n][0]) {
                    if (d2 < (double)this.runs[n][0]) {
                        this.runs[n][1] = (int)d2;
                    }
                    this.runs[n][0] = (int)d;
                } else if (d <= (double)this.runs[n][1] && d2 > (double)this.runs[n][1]) {
                    this.runs[n][1] = (int)d2;
                }
            }
            if (n < this.minMarked) {
                this.minMarked = n;
            }
            if (n > this.maxMarked) {
                this.maxMarked = n;
            }
        }

        public void endBitmap() {
        }

        public void startBitmap(int n) {
            this.runs = null;
        }
    }
}

