/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.codemodel.host;

import com.adobe.flash.services.IRegistrarService;
import java.util.HashMap;
import org.apache.felix.framework.Felix;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class CMApplication {
    private static CMApplication fInstance = null;
    private Felix fFelix;
    private boolean fIsDebug;

    public CMApplication() {
        fInstance = this;
    }

    public static CMApplication getApplication() {
        if (fInstance == null) {
            fInstance = new CMApplication();
        }
        return fInstance;
    }

    public void setDebugMode(boolean isDebug) {
        this.fIsDebug = isDebug;
    }

    public boolean start(String workspacePath, String bundlePath, String cachePath, int cap) {
        boolean success = this.startFelix(workspacePath, bundlePath, cachePath, cap);
        if (!success && this.fFelix != null) {
            this.stop();
            this.setDebugMode(true);
            success = this.startFelix(workspacePath, bundlePath, cachePath, cap);
        }
        return success;
    }

    private boolean startFelix(String workspacePath, String bundlePath, String cachePath, int cap) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (this.fIsDebug) {
            configMap.put("felix.log.level", "4");
            configMap.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        if (cachePath != null) {
            configMap.put("org.osgi.framework.storage", cachePath);
        }
        configMap.put("org.osgi.framework.system.packages", "javax.xml.namespace;com.adobe.flash.commands;org.xml.sax.helpers;org.xml.sax;com.adobe.flash.services;org.osgi.framework;javax.xml.namespace;");
        this.fFelix = new Felix(configMap);
        try {
            this.fFelix.start();
            BundleContext bundleContext = this.fFelix.getBundleContext();
            Bundle runtimeBundle = bundleContext.installBundle("file:" + bundlePath + "plugins/com.adobe.flash.codemodel.runtime_1.0.0.jar");
            runtimeBundle.start();
            Bundle osgiBundle = bundleContext.installBundle("file:" + bundlePath + "plugins/com.adobe.flash.codemodel.osgi_1.0.0.jar");
            osgiBundle.start();
            Bundle coreBundle = bundleContext.installBundle("file:" + bundlePath + "plugins/com.adobe.flash.codemodel.core_1.0.0.jar");
            coreBundle.start();
            Bundle ideBundle = bundleContext.installBundle("file:" + bundlePath + "plugins/com.adobe.flash.codemodel.authoring_1.0.0.jar");
            ideBundle.start();
            this.initWorkspaceLocation(workspacePath);
            this.initFileCap(cap);
        }
        catch (BundleException e) {
            return false;
        }
        return true;
    }

    public boolean stop() {
        try {
            this.fFelix.stop();
        }
        catch (BundleException e) {
            return false;
        }
        return true;
    }

    private void initWorkspaceLocation(String workspacePath) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                service.initWorkspaceLocation(workspacePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initFileCap(int cap) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                service.initFileCap(cap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean loadProject(String projectPath, String classPathInfo) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                return service.loadProject(projectPath, classPathInfo, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean loadProject(String projectPath, String classPathInfo, boolean forceLoad) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                return service.loadProject(projectPath, classPathInfo, forceLoad);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean projectChanged(String projectPath, String classPathInfo) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                return service.projectChanged(projectPath, classPathInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean deleteProject(String projectPath) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                return service.deleteProject(projectPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean unloadProject(String projectPath) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                return service.unloadProject(projectPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean openFileInProject(String projectPath, String path, boolean isFrameScript) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                return service.openFileInProject(projectPath, path, isFrameScript);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean openFile(String path) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                return service.openFile(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean closeFile(String path) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                return service.closeFile(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean diskFileChanged(String path) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                return service.diskFileChanged(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean openFileChanged(String path, String buffer) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                return service.openFileChanged(path, buffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public byte[] getCompletionProposals(String filePath, int offset, boolean explicitRequest) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                String proposals = service.getCompletionProposals(filePath, offset, explicitRequest);
                return proposals.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] getContextInformation(String filePath, int offset, boolean explicitRequest) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                String proposals = service.getContextInformation(filePath, offset, explicitRequest);
                return proposals.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] proposalInserted(String filePath, int offset, int index) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                String proposals = service.proposalInserted(filePath, offset, index);
                return proposals.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] getAutoImportProposal(String filePath, int offset, int index) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                String proposals = service.getAutoImportProposal(filePath, offset, index);
                return proposals.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] getCompletionProposals(String filePath, String buffer, int offset, boolean explicitRequest) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                String proposals = service.getCompletionProposals(filePath, buffer, offset, explicitRequest);
                return proposals.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] getContextInformation(String filePath, String buffer, int offset, boolean explicitRequest) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                String proposals = service.getContextInformation(filePath, buffer, offset, explicitRequest);
                return proposals.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] proposalInserted(String filePath, String buffer, int offset, int index) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                String proposals = service.proposalInserted(filePath, buffer, offset, index);
                return proposals.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] getAutoImportProposal(String filePath, String buffer, int offset, int index) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                String proposals = service.getAutoImportProposal(filePath, buffer, offset, index);
                return proposals.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean areBracesBalanced(String buffer) {
        try {
            IRegistrarService service = this.getRegistrarService();
            if (service != null) {
                return service.areBracesBalancedOrOverbalanced(buffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private IRegistrarService getRegistrarService() {
        ServiceReference reference = this.fFelix.getBundleContext().getServiceReference(IRegistrarService.class.getName());
        if (reference != null) {
            IRegistrarService service = (IRegistrarService)this.fFelix.getBundleContext().getService(reference);
            return service;
        }
        return null;
    }
}

