/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ParameterizedName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class DocCommentNode
extends MetaDataNode {
    MetaDataNode metaData = null;
    boolean is_default = false;

    DocCommentNode(LiteralArrayNode data) {
        super(data);
    }

    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    private StringBuilder emitMetaDataComment(StringBuilder buf, String debugName, MetaDataNode meta, boolean isAttributeOfDefinition) {
        MetaDataEvaluator.KeyValuePair kv;
        MetaDataEvaluator.KeylessValue ov;
        buf.append("\n<metadata>\n");
        String tagname = meta.id;
        buf.append("\n\t<").append(tagname).append(" ");
        buf.append("owner='").append(debugName).append("' ");
        boolean has_name = false;
        if (meta.values != null) {
            if ("SkinStates".equals(meta.id)) {
                boolean first = true;
                for (Value v : meta.values) {
                    if (!(v instanceof MetaDataEvaluator.KeylessValue)) continue;
                    MetaDataEvaluator.KeylessValue ov2 = (MetaDataEvaluator.KeylessValue)v;
                    if (first) {
                        first = false;
                        buf.append("states='");
                    } else {
                        buf.append(", ");
                    }
                    buf.append(ov2.obj);
                }
                if (!first) {
                    buf.append("'");
                }
            } else {
                Value[] arr$ = meta.values;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Value v = arr$[i$];
                    if (v instanceof MetaDataEvaluator.KeylessValue && !has_name) {
                        ov = (MetaDataEvaluator.KeylessValue)v;
                        buf.append("name='").append(ov.obj).append("' ");
                        has_name = true;
                        continue;
                    }
                    if (!(v instanceof MetaDataEvaluator.KeyValuePair)) continue;
                    kv = (MetaDataEvaluator.KeyValuePair)v;
                    buf.append(kv.key).append("='").append(kv.obj).append("' ");
                }
            }
        } else if (meta.id != null) {
            buf.append("name='").append(meta.id).append("' ");
        }
        buf.append(">\n");
        if (!isAttributeOfDefinition) {
            if (this.values != null) {
                for (Value v : this.values) {
                    if (v instanceof MetaDataEvaluator.KeylessValue) {
                        ov = (MetaDataEvaluator.KeylessValue)v;
                        buf.append(ov.obj);
                        continue;
                    }
                    if (!(v instanceof MetaDataEvaluator.KeyValuePair)) continue;
                    kv = (MetaDataEvaluator.KeyValuePair)v;
                    buf.append("\n\t<").append(kv.key).append(">").append(kv.obj).append("</").append(kv.key).append(">");
                }
            } else if (this.id != null) {
                buf.append(this.id);
            }
        }
        buf.append("\n\t</").append(tagname).append(">\n");
        buf.append("</metadata>\n");
        return buf;
    }

    public StringBuilder emit(Context cx, StringBuilder buf) {
        NamespaceDefinitionNode nd;
        AttributeListNode attrs;
        String tagname = "";
        StatementListNode metaData = null;
        String debug_name = "";
        if (this.def instanceof FunctionDefinitionNode) {
            FunctionDefinitionNode fd = (FunctionDefinitionNode)this.def;
            debug_name = fd.fexpr.debug_name;
            metaData = fd.metaData;
            tagname = "method";
            buf.append("\n<method name='");
            buf.append(fd.name.identifier.name);
            buf.append("' fullname='");
            buf.append(fd.fexpr.debug_name);
            buf.append("' ");
            AttributeListNode attrs2 = fd.attrs;
            if (attrs2 != null) {
                buf.append("isStatic='");
                buf.append(attrs2.hasStatic ? "true" : "false");
                buf.append("' ");
                buf.append("isFinal='");
                buf.append(attrs2.hasFinal ? "true" : "false");
                buf.append("' ");
                buf.append("isOverride='");
                buf.append(attrs2.hasOverride ? "true" : "false");
                buf.append("' ");
            } else {
                buf.append("isStatic='false' ");
                buf.append("isFinal='false' ");
                buf.append("isOverride='false' ");
            }
            fd.fexpr.signature.toCanonicalString(cx, buf);
            buf.append(">");
        }
        if (this.def instanceof VariableDefinitionNode) {
            VariableDefinitionNode vd = (VariableDefinitionNode)this.def;
            VariableBindingNode vb = (VariableBindingNode)vd.list.items.get(0);
            debug_name = vb.debug_name;
            metaData = vd.metaData;
            tagname = "field";
            buf.append("\n<");
            buf.append(tagname);
            buf.append(" name='");
            buf.append(vb.variable.identifier.name);
            buf.append("' fullname='");
            buf.append(vb.debug_name);
            buf.append("' type='");
            if (vb.typeref != null) {
                buf.append(DocCommentNode.getRefName(cx, vb.typeref));
            }
            buf.append("' ");
            attrs = vd.attrs;
            if (attrs != null) {
                buf.append("isStatic='");
                buf.append(attrs.hasStatic ? "true" : "false");
                buf.append("' ");
            } else {
                buf.append("isStatic='false' ");
            }
            Slot s = vb.ref.getSlot(cx);
            if (s != null) {
                buf.append("isConst='");
                buf.append(s.isConst() ? "true" : "false");
                buf.append("' ");
            }
            if (vb.initializer != null) {
                buf.append("defaultValue='");
                if (vb.initializer instanceof LiteralNumberNode) {
                    buf.append(((LiteralNumberNode)vb.initializer).value);
                } else if (vb.initializer instanceof LiteralStringNode) {
                    buf.append(DocCommentNode.escapeXml(((LiteralStringNode)vb.initializer).value));
                } else if (vb.initializer instanceof LiteralNullNode) {
                    buf.append("null");
                } else if (vb.initializer instanceof LiteralBooleanNode) {
                    buf.append(((LiteralBooleanNode)vb.initializer).value ? "true" : "false");
                } else if (vb.initializer instanceof MemberExpressionNode) {
                    MemberExpressionNode mb = (MemberExpressionNode)vb.initializer;
                    Slot vs = mb.ref != null ? mb.ref.getSlot(cx, -79) : null;
                    Value v = vs != null ? vs.getValue() : null;
                    ObjectValue ov = v instanceof ObjectValue ? (ObjectValue)v : null;
                    buf.append(ov != null ? ov.getValue() : "unknown");
                } else {
                    Slot vs = vb.ref.getSlot(cx, -79);
                    Value v = vs != null ? vs.getValue() : null;
                    ObjectValue ov = v instanceof ObjectValue ? (ObjectValue)v : null;
                    buf.append(ov != null ? ov.getValue() : "unknown");
                }
                buf.append("' ");
            }
            buf.append(">");
        }
        if (this.def instanceof PackageDefinitionNode) {
            PackageDefinitionNode pd = (PackageDefinitionNode)this.def;
            tagname = "packageRec";
            debug_name = "";
            metaData = null;
            buf.append("\n<");
            buf.append(tagname);
            buf.append(" name='");
            buf.append(pd.name.id != null ? pd.name.id.pkg_part : "");
            buf.append(".");
            buf.append(pd.name.id != null ? pd.name.id.def_part : "");
            buf.append("' fullname='");
            buf.append(pd.name.id != null ? pd.name.id.pkg_part : "");
            buf.append(".");
            buf.append(pd.name.id != null ? pd.name.id.def_part : "");
            buf.append("'>\n");
        }
        if (this.def instanceof ClassDefinitionNode) {
            Slot s;
            ReferenceValue rv;
            Value firstV;
            ClassDefinitionNode cd = (ClassDefinitionNode)this.def;
            debug_name = cd.debug_name;
            metaData = cd.metaData;
            InterfaceDefinitionNode id = null;
            if (this.def instanceof InterfaceDefinitionNode) {
                tagname = "interfaceRec";
                id = (InterfaceDefinitionNode)this.def;
            } else {
                tagname = "classRec";
            }
            buf.append("\n<");
            buf.append(tagname);
            buf.append(" name='");
            buf.append(cd.name.name);
            buf.append("' fullname='");
            buf.append(cd.debug_name);
            if (cd.cx.input != null && cd.cx.input.origin.length() != 0) {
                buf.append("' sourcefile='");
                buf.append(cd.cx.input.origin);
            }
            buf.append("' namespace='");
            buf.append(cd.cframe.builder.classname.ns.name);
            buf.append("' access='");
            buf.append(this.getAccessKindFromNS(cd.cframe.builder.classname.ns));
            if (id != null) {
                buf.append("' baseClasses='");
                if (id.interfaces != null) {
                    firstV = (Value)id.interfaces.values.get(0);
                    for (Value v : id.interfaces.values) {
                        rv = (ReferenceValue)v;
                        if (v != firstV) {
                            buf.append(";");
                        }
                        buf.append((s = rv.getSlot(cx, -79)) == null || s.getDebugName().length() == 0 ? rv.name : s.getDebugName());
                    }
                } else {
                    buf.append("Object");
                }
                buf.append("' ");
            } else {
                buf.append("' baseclass='");
                if (cd.baseref != null) {
                    Slot s2 = cd.baseref.getSlot(cx, -79);
                    buf.append(s2 == null || s2.getDebugName().length() == 0 ? "Object" : s2.getDebugName());
                } else {
                    buf.append("Object");
                }
                buf.append("' ");
                if (cd.interfaces != null) {
                    buf.append("interfaces='");
                    firstV = (Value)cd.interfaces.values.get(0);
                    for (Value v : cd.interfaces.values) {
                        rv = (ReferenceValue)v;
                        if (v != firstV) {
                            buf.append(";");
                        }
                        buf.append((s = rv.getSlot(cx, -79)) == null || s.getDebugName().length() == 0 ? rv.name : s.getDebugName());
                    }
                    buf.append("' ");
                }
            }
            attrs = cd.attrs;
            if (attrs != null) {
                buf.append("isFinal='");
                buf.append(attrs.hasFinal ? "true" : "false");
                buf.append("' ");
                buf.append("isDynamic='");
                buf.append(attrs.hasDynamic ? "true" : "false");
                buf.append("' ");
            } else {
                buf.append("isFinal='false' ");
                buf.append("isDynamic='false' ");
            }
            buf.append(">");
        }
        if (this.values != null) {
            for (Value v : this.values) {
                if (v instanceof MetaDataEvaluator.KeylessValue) {
                    MetaDataEvaluator.KeylessValue ov = (MetaDataEvaluator.KeylessValue)v;
                    buf.append(ov.obj);
                    continue;
                }
                if (!(v instanceof MetaDataEvaluator.KeyValuePair)) continue;
                MetaDataEvaluator.KeyValuePair kv = (MetaDataEvaluator.KeyValuePair)v;
                buf.append("\n<").append(kv.key).append(">").append(kv.obj).append("</").append(kv.key).append(">");
            }
        } else if (this.id != null) {
            buf.append(this.id);
        }
        if (this.def != null && this.def.metaData != null) {
            int numItems = this.def.metaData.items.size();
            for (int x = 0; x < numItems; ++x) {
                MetaDataNode mdi;
                Node md = this.def.metaData.items.at(x);
                MetaDataNode metaDataNode = mdi = md instanceof MetaDataNode ? (MetaDataNode)md : null;
                if (mdi == null || mdi.id == null) continue;
                if (mdi.id.equals("Style") || mdi.id.equals("Event") || mdi.id.equals("Effect")) {
                    if (x + 1 < numItems) {
                        DocCommentNode metaDataComment;
                        Node next = this.def.metaData.items.at(x + 1);
                        DocCommentNode docCommentNode = metaDataComment = next instanceof DocCommentNode ? (DocCommentNode)next : null;
                        if (metaDataComment != null && metaDataComment.metaData != mdi) {
                            metaDataComment = null;
                        }
                        if (metaDataComment != null) {
                            metaDataComment.emitMetaDataComment(buf, debug_name, mdi, false);
                            ++x;
                            continue;
                        }
                        this.emitMetaDataComment(buf, debug_name, mdi, true);
                        continue;
                    }
                    this.emitMetaDataComment(buf, debug_name, mdi, true);
                    continue;
                }
                if (!mdi.id.equals("Bindable") && !mdi.id.equals("Deprecated") && !mdi.id.equals("Exclude") && !mdi.id.equals("DefaultProperty") && !mdi.id.equals("SkinStates")) continue;
                this.emitMetaDataComment(buf, debug_name, mdi, true);
            }
        }
        if (!"".equals(tagname)) {
            buf.append("\n</");
            buf.append(tagname);
            buf.append(">");
        } else if (this.def instanceof NamespaceDefinitionNode && (nd = (NamespaceDefinitionNode)this.def) != null) {
            buf.append("<!-- Namespace comments not supported yet: ").append(nd.debug_name).append("-->");
        }
        return buf;
    }

    private String getAccessKindFromNS(ObjectValue ns) {
        String access_specifier;
        switch (ns.getNamespaceKind()) {
            case 0: {
                access_specifier = "public";
                break;
            }
            case 1: {
                access_specifier = "internal";
                break;
            }
            case 3: {
                access_specifier = "protected";
                break;
            }
            case 2: {
                access_specifier = "private";
                break;
            }
            default: {
                access_specifier = "public";
            }
        }
        return access_specifier;
    }

    public static String getRefName(Context cx, ReferenceValue ref) {
        Slot s = ref.getSlot(cx, -79);
        if (s == null || s.getDebugName().length() == 0) {
            String name = ref.name;
            if (ref.type_params != null && s != null && s.getValue() instanceof TypeValue) {
                TypeValue t = (TypeValue)s.getValue();
                name = name + DocCommentNode.getIndexedTypeName(cx, t.indexed_type);
            }
            return name;
        }
        return s.getDebugName();
    }

    private static String getIndexedTypeName(Context cx, TypeValue t) {
        ParameterizedName pn = t.name instanceof ParameterizedName ? (ParameterizedName)t.name : null;
        String name = "$";
        if (pn != null) {
            name = name + t.name.name;
            if (t.indexed_type != null) {
                name = name + DocCommentNode.getIndexedTypeName(cx, t.indexed_type);
            }
        } else {
            name = name + t;
        }
        return name;
    }

    public static String escapeXml(String s) {
        StringBuilder out = new StringBuilder(s.length() + 16);
        int length = s.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    out.append("&apos;");
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    public int count() {
        return this.values.length;
    }

    public final String toString() {
        return "DocComment";
    }
}

