/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2015 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
/*jslint node: true, vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50, unparam: true */
/*global define, console*/

/**
    Testing IMSLib - this is not a full test suite, just some examples
    TOFIX: flesh out with some Jasmine tests
**/

'use strict';

var IMSLib = require('../src/IMSLib');

// Temp: read the config from a JSON - this should have the fields, 'clientId', 'clientSecret', and 'scopes'
var env = require('../config.json');

// Get an IMS reference
var imsRef = IMSLib.createRef(true);

// Get device ID
var deviceID = IMSLib.getDeviceID(imsRef);
console.log('Device ID: ' + deviceID);

// Get user accounts
var userAccounts = IMSLib.fetchAccounts(imsRef, env.clientId);
console.log('Found ' + userAccounts.length + ' user accounts for ' + env.clientId);

// Get default user data
var defaultUserInfo = IMSLib.fetchDefaultUserInfoForClientId(imsRef, env.clientId);
console.log('Default User: ' + defaultUserInfo.Email + ' (' + defaultUserInfo.UserID + ')');

// Get access token for default user
var userId = defaultUserInfo.UserID;
IMSLib.fetchAccessToken(imsRef, env.clientId, env.clientSecret, userId, '', env.scopes, function (err, response) {
    if (err) {
        console.log(err);
        return;
    }

    console.log('Access Token: ' + response.access_token);
});
