uniform sampler2D texture_param;
uniform vec2 texture_normalizer;

in vec2 v_uv;
layout(location = 0) out vec4 fragColor;

void main() {

  vec4 sample_bounds = vec4(0.0, 0.0, 1.0, 1.0);

  vec2 offset00 = vec2(0, 0);
  vec2 offset01 = vec2(0, texture_normalizer.y);
  vec2 offset10 = vec2(texture_normalizer.x, 0);
  vec2 offset11 = vec2(texture_normalizer.x, texture_normalizer.y);

  vec2 uv00 = clamp( v_uv + offset00, sample_bounds.xy, sample_bounds.zw );
  vec2 uv01 = clamp( v_uv + offset01, sample_bounds.xy, sample_bounds.zw );
  vec2 uv10 = clamp( v_uv + offset10, sample_bounds.xy, sample_bounds.zw );
  vec2 uv11 = clamp( v_uv + offset11, sample_bounds.xy, sample_bounds.zw );

  vec4 sample00 = texture(texture_param, uv00);
  vec4 sample01 = texture(texture_param, uv01);
  vec4 sample10 = texture(texture_param, uv10);
  vec4 sample11 = texture(texture_param, uv11);

  vec4 average_color = 0.25 * (sample00 + sample01 + sample10 + sample11);

  fragColor = (average_color.a > 0.0)
    ? average_color
    : vec4(0.0, 0.0, 0.0, 0.0);
}
