//agf_include "logarithmic_z.inc"

uniform vec4 color;
uniform vec4 stroke_color;
out vec4 fragColor;

uniform mat4 viewport_matrix;
in float v_depth;
in vec3 v_P_clip;
in vec2 v_uv;

LOGZ_FRAGMENT_DECLARE_FLOGZ
LOGZ_FRAGMENT_DECLARE_FCOEF_HALF

float map_range(float value, float src_low, float src_high, float dest_low, float dest_high) {
  return dest_low + (dest_high - dest_low) * (value - src_low) / (src_high - src_low);
}

float in_square(vec2 uv, float edge) {
 float right = step(uv.x, 1.0 - edge);
 float top = 1.0 - step(uv.y, edge);
 float bottom = step(uv.y, 1.0 - edge);
 float left = 1.0 - step(uv.x, edge);
 return right * left * top * bottom;
}

void main() {

  float square = in_square(v_uv.xy, 1.0/13.0);

  vec3 border_color = stroke_color.xyz;
  vec3 fill_color = color.xyz;
  vec3 col = mix(border_color, fill_color, square);

  // Output to screen
  fragColor = vec4(col, color.a);

  LOGZ_FRAGMENT_ADJUST_DEPTH_WITH_FLOGZ_FCOEF
}
