//agf_include "logarithmic_z.inc"

layout(location=0) in vec3 agf_position;
layout(location=3) in vec2 agf_uv;

uniform mat4 model_view_proj_matrix;
uniform mat4 model_view_it_matrix;

out vec3 v_N;
out vec2 v_uv;

LOGZ_VERTEX_DECLARE_FLOGZ
LOGZ_VERTEX_DECLARE_FCOEF
void main() {
  vec4 position = vec4(agf_position, 1.0);
  vec4 position_clip = model_view_proj_matrix * position;

  v_uv = agf_uv;
  v_N = (model_view_it_matrix * vec4(0.0, 1.0, 0.0, 0.0)).xyz;

  gl_Position = position_clip;

  LOGZ_VERTEX_ADJUST_GL_POSITION_Z
  LOGZ_VERTEX_PASS_FLOGZ_AFTER_GL_POSITION
}
