//agf_include "logarithmic_z.inc"
//agf_include "color/hsv.inc"

uniform bool is_camera_below_ground;
uniform float far_clip;
uniform float camera_height;
uniform float camera_pitch_mult;
uniform vec4 line_color;
uniform float line_thickness;

in vec2 v_uv;
in vec3 v_N;
in vec2 texcoord;

out vec4 fragColor;

LOGZ_FRAGMENT_DECLARE_FLOGZ
LOGZ_FRAGMENT_DECLARE_FCOEF_HALF


float grid(vec2 uv_coord, float line_thickness)
{
  uv_coord = uv_coord + line_thickness/2.0;
  float line_ratio = 1.0/line_thickness;
  vec2 uv_pixel_offset = max(abs(dFdx(uv_coord)), abs(dFdy(uv_coord)));
  vec2 sample_a_uv_coord = uv_coord + 0.5*uv_pixel_offset;
  vec2 sample_b_uv_coord = uv_coord - 0.5*uv_pixel_offset;
  vec2 grid_mult = (floor(sample_a_uv_coord)+min(fract(sample_a_uv_coord)*line_ratio,1.0)-
            floor(sample_b_uv_coord)-min(fract(sample_b_uv_coord)*line_ratio,1.0))/(line_ratio*uv_pixel_offset);
  float grid_amount = 1.0-((1.0-grid_mult.x)*(1.0-grid_mult.y));
  return grid_amount;
}


void main() {
  float depth = gl_FragCoord.z / gl_FragCoord.w;
  float height_mult = 1.0;
  float height_offset = 0.0;
  float cam_height = abs(camera_height);
  //adjust for viewing angle of groundplane
  float cam_pitch_mult = 1.0-sqrt(1.0-(camera_pitch_mult-1.0)*(camera_pitch_mult-1.0));
  cam_height = mix(cam_height, cam_height*10.0, cam_pitch_mult);
  //find height mult
  while (cam_height>=height_mult*10.0){
    height_offset += height_mult;
    height_mult *= 10.0;
  }
  float norm_height = (cam_height-height_mult)/((height_mult*10.0)-height_offset);
  //calculate grid lines
  float line_mult = 0.0;
  float largest_line_mult = 1.0;
  for (float cur_line_mult=largest_line_mult; cur_line_mult<=1000.0; cur_line_mult*=10.0) {
    float cur_line_thickness = line_thickness;
    if (cur_line_mult == largest_line_mult) {
      cur_line_thickness = mix(cur_line_thickness/10.0, cur_line_thickness, norm_height);
    }
    float cur_grid = grid(v_uv*(cur_line_mult/height_mult), cur_line_thickness);
    line_mult = max(cur_grid, line_mult);
  }
  //fade out when near far_clip
  float fade_threshold = 0.8;
  float fade_amount = max((depth/(far_clip/2.0)-fade_threshold), 0.0)/(1.0-fade_threshold);
  line_mult *= 1.0-fade_amount;
  //determine final color
  vec3 final_line_color = line_color.rgb;
  if (is_camera_below_ground) {
      vec3 hsv_color = rgb_to_hsv(final_line_color);
      float new_s = hsv_color.g<=0.5 ? hsv_color.g+0.33 : hsv_color.g-0.33;
      float new_v = hsv_color.b<=0.5 ? hsv_color.b+0.33 : hsv_color.b-0.33;
      final_line_color = hsv_to_rgb(vec3(hsv_color.r, new_s, new_v));
  }
  fragColor = vec4(final_line_color, line_mult);
  LOGZ_FRAGMENT_ADJUST_DEPTH_WITH_FLOGZ_FCOEF
}
