//agf_include "logarithmic_z.inc"

layout(location=0) in vec3 agf_position;
layout(location=2) in vec3 agf_normal;

uniform mat4 model_matrix;
uniform mat4 model_view_matrix;
uniform mat4 model_view_proj_matrix;
uniform mat4 model_view_it_matrix;

out vec3 v_N;
out vec3 v_P_camera;
out vec3 v_P_clip;
out vec3 v_U;
out float v_depth;

LOGZ_VERTEX_DECLARE_FLOGZ
LOGZ_VERTEX_DECLARE_FCOEF

void main() {
  vec4 position = vec4(agf_position, 1.0);
  vec4 position_clip = model_view_proj_matrix * position;
  vec4 position_camera = model_view_matrix * position;
  vec4 U = model_view_matrix * vec4(0.0, 1.0, 0.0, 0.0);

  vec4 mesh_normal = vec4(agf_normal, 0.0);
  vec4 normal_camera = model_view_it_matrix * mesh_normal;

  v_N = normalize(normal_camera.xyz);
  v_P_camera = position_camera.xyz;
  v_U = normalize(U.xyz);

  float position_clip_w = position_clip.w;
  position_clip /= position_clip.w;

  v_P_clip = position_clip.xyz;

  gl_Position = position_clip;

  // convert the depth of the vertex into log space and store in glPosition.z
  //v_depth = log2(max(1.0e-6, 1.0 + position_clip_w)) * Fcoef - 1.0;
  //gl_Position.z = gl_Position.z + v_depth*1.175494351e-38;
  v_depth = gl_Position.z;
  //flogz = 1.0 + position_clip_w;
}
