//agf_include "logarithmic_z.inc"

uniform vec4 color;
uniform vec4 occluded_color;
uniform bool should_stroke;
uniform vec4 stroke_color;
uniform float stroke_width;
out vec4 fragColor;

uniform float width; // line width
uniform float dash_length; // TODO: use this
uniform float line_length;
uniform bool should_dash;
uniform bool should_dash_whole_line;
uniform sampler2D depth_texture;
uniform mat4 viewport_matrix;

in float v_line_distance_from_center; // line distance is signed, varying between -1, and 1 across the triangle
in float v_line_distance; // distance from beginning of path, in untransformed path units.
in float v_depth; // depth in log z of line
in vec3 v_P_clip;

LOGZ_FRAGMENT_DECLARE_FLOGZ
LOGZ_FRAGMENT_DECLARE_FCOEF_HALF

float map_range(float value, float src_low, float src_high, float dest_low, float dest_high) {
  return dest_low + (dest_high - dest_low) * (value - src_low) / (src_high - src_low);
}

float pyramid_clamped(float t) {
  return clamp(1.0 - abs(t), 0.0, 1.0);
}

void main() {
  // line distance is "across" the line, rather than down the path of the line
  // when we are close to 1, we are far from the center of the line.
  // close to 0, we are in the center of the line

  // this anti-aliases the line based on distance from center of line.
  float start_fading = max(width - 1.5, 0.0);
  float line_mask = 1.0 - smoothstep((start_fading / width), 1.0, abs(v_line_distance_from_center));

  // get position in texture's range from clip coordinate, to compare to sample from texture
  float normalized_x = map_range(v_P_clip.x, -1, 1, 0, 1);
  float normalized_y = map_range(v_P_clip.y, -1, 1, 0, 1);
  float normalized_z = map_range(v_P_clip.z, -1, 1, 1, 0);

  // the depth of the current pixel in log space
  float log_depth = map_range(v_depth, -1, 1, 0, 1);

  vec4 tiled_uv = vec4(normalized_x, normalized_y, normalized_z, 1.0);
  tiled_uv = viewport_matrix * tiled_uv;
  tiled_uv /= tiled_uv.w;

  // check for occlusion
  float scene_log_depth = texture(depth_texture, tiled_uv.xy).r;

  //LOGZ_FRAGMENT_ADJUST_DEPTH_WITH_FLOGZ_FCOEF

  vec4 line_color = scene_log_depth < log_depth ? occluded_color : color;

  if (should_stroke) {
    // control the sharpness of line - higher is more sharp. max 0.5;
    float sharpness = 0.45;
    // |----|____|----|
    float stroke_mask = 1.0 - smoothstep(sharpness, 1.0-sharpness, pyramid_clamped(2.0 * v_line_distance_from_center));
    line_color = mix(line_color, stroke_color, stroke_mask);
  }
  // enable fading of line (pseudo-antialiasing)
  line_color.a *= line_mask;

  if (should_dash && dash_length > 0.0 && (should_dash_whole_line || (scene_log_depth < log_depth))) {
    if (mod(v_line_distance * line_length, dash_length) < dash_length / 2.0) {
      line_color.a = 0.0;
    }
  }

  fragColor = line_color;

  // Debug
  // fragColor = vec4(scene_log_depth, log_depth, scene_log_depth < log_depth ? 1.0 : 0.0, 1.0);
}
