//agf_include "logarithmic_z.inc"

uniform vec4 color;
out vec4 fragColor;

uniform float width; // line width
uniform float dash_length; // TODO: use this

LOGZ_FRAGMENT_DECLARE_FLOGZ
LOGZ_FRAGMENT_DECLARE_FCOEF_HALF

in float v_line_distance_from_center; // line distance is signed, varying between -1, and 1 across the triangle
in float v_line_distance; // distance from beginning of path, in untransformed path units.

void main() {
  // line distance is "across" the line, rather than down the path of the line
  // when we are close to 1, we are far from the center of the line.
  // close to 0, we are in the center of the line

  float start_fading = max(width - 1.5, 0.0);
  float alpha = 1.0 - smoothstep((start_fading / width), 1.0, abs(v_line_distance_from_center));
  fragColor = vec4(color.r, color.g, color.b, alpha * color.a);

  LOGZ_FRAGMENT_ADJUST_DEPTH_WITH_FLOGZ_FCOEF
}
