//agf_include "logarithmic_z.inc"

layout(location=0) in vec3 agf_position;
layout(location=2) in vec3 agf_normal;

uniform mat4 model_matrix;
uniform mat4 model_view_matrix;
uniform mat4 model_view_proj_matrix;
uniform mat4 model_view_it_matrix;

LOGZ_VERTEX_DECLARE_FLOGZ
LOGZ_VERTEX_DECLARE_FCOEF

out vec3 v_N;
out vec3 v_P_camera;
out vec3 v_P_clip;
out vec3 v_U;

void main() {
  vec4 position = vec4(agf_position, 1.0);
  vec4 position_clip = model_view_proj_matrix * position;
  vec4 position_camera = model_view_matrix * position;
  vec4 U = model_view_matrix * vec4(0.0, 1.0, 0.0, 0.0);

  vec4 mesh_normal = vec4(agf_normal, 0.0);
  vec4 normal_camera = model_view_it_matrix * mesh_normal;

  v_N = normalize(normal_camera.xyz);
  v_P_clip = position_clip.xyz;
  v_P_camera = position_camera.xyz;
  v_U = normalize(U.xyz);

  gl_Position = position_clip;

  LOGZ_VERTEX_ADJUST_GL_POSITION_Z
  LOGZ_VERTEX_PASS_FLOGZ_AFTER_GL_POSITION

}
