//agf_include "logarithmic_z.inc"

uniform vec4 color;
uniform bool should_shade;
uniform float shade_amount;

LOGZ_FRAGMENT_DECLARE_FLOGZ
LOGZ_FRAGMENT_DECLARE_FCOEF_HALF

out vec4 fragColor;

in vec3 v_N;
in vec3 v_P_camera;
in vec3 v_P_clip;
in vec3 v_U;

void main() {
  vec3 N = normalize(v_N);
  vec3 U = normalize(v_U);

  float dim = dot(N, U) < -0.1 ? shade_amount : 1.0;
  vec3 final_color = should_shade && color.a > 0.9 ? color.rgb * dim : color.rgb;
  fragColor = vec4(final_color.r, final_color.g, final_color.b, color.a);

  LOGZ_FRAGMENT_ADJUST_DEPTH_WITH_FLOGZ_FCOEF
}
