// #extension GL_ARB_shader_texture_lod: require

uniform sampler2D texture_param;
uniform sampler2D depth_texture_param;
uniform float aperture;
uniform float focal_distance;
uniform float focal_length;
uniform float far_clip;
uniform vec2 frame_mult; //(1/width, 1/height)
uniform vec2 blur_dir;
const float epsilon = 0.000001f;
const float num_samples = 20.0f; //max blur radius in pixels
in vec2 v_uv;
layout(location = 0) out vec4 fragColor;

float get_linear_depth(float log_depth) {
  return pow(far_clip + 1.0f, log_depth) - 1.0f;
}

float get_circle_of_confusion_radius_in_pixels(float linear_depth) {
  float radius_mm = abs(aperture * (abs(linear_depth-focal_distance)/linear_depth) * (focal_length/(focal_distance-focal_length)) * 0.5f);
  //based on 36mm measurement of a standard 35mm camera
  return min(ceil(radius_mm / 36.0f * (1.0f/frame_mult.x)), num_samples);
}

float get_pixel_weight(float coc_radius) {
  return 1.0f / (coc_radius * coc_radius + epsilon);
}

void main() {
  float weight = 0.0f;
  vec4 result = vec4(0.0f);
  for(float i = 1.0f; i <= num_samples; i += 1.0f) {
    //negative pixel then positive pixel at pixel distance i
    for(float pixel_sample_dir = -1.0f; pixel_sample_dir <= 1.0f; pixel_sample_dir += 2.0f) {
      vec2 uv_cur = v_uv + (pixel_sample_dir * blur_dir) * i * frame_mult;
      //ignore samples outside image
      if (clamp(uv_cur, 0.0f, 1.0f) != uv_cur) {
        continue;
      }
      float depth_cur = get_linear_depth(texture(depth_texture_param, uv_cur).r);
      float radius_cur = get_circle_of_confusion_radius_in_pixels(depth_cur);
      vec4 color_cur = texture(texture_param, uv_cur);
      if (i <= radius_cur) {
        float weight_cur = get_pixel_weight(radius_cur);
        result += color_cur * weight_cur;
        weight += weight_cur;
      }
    }
  }
  vec4 orig_color = texture(texture_param, v_uv);
  float orig_depth = get_linear_depth(texture(depth_texture_param, v_uv).r);
  float orig_radius = get_circle_of_confusion_radius_in_pixels(orig_depth);
  if (weight < epsilon || orig_radius <= 1.0) {
    fragColor = texture(texture_param, v_uv);
  }
  else {
    fragColor = result / weight;
  }
}
