//agf_include "logarithmic_z.inc"

uniform vec4 color;
uniform vec4 stroke_color;
out vec4 fragColor;

uniform mat4 viewport_matrix;
in float v_depth;
in vec3 v_P_clip;
in vec2 v_uv;

LOGZ_FRAGMENT_DECLARE_FLOGZ
LOGZ_FRAGMENT_DECLARE_FCOEF_HALF

float map_range(float value, float src_low, float src_high, float dest_low, float dest_high) {
  return dest_low + (dest_high - dest_low) * (value - src_low) / (src_high - src_low);
}

float in_circle(vec2 uv, float radius) {
  float dist_from_center = length(uv.xy - vec2(0.5));
  return step(dist_from_center, radius);
}

void main() {
  float radius = 0.8/2.0;
  float outer_radius = 1.0/2.0;
  float circ = in_circle(v_uv.xy, radius);
  float circ_alpha = in_circle(v_uv.xy, outer_radius);

  float circle = in_circle(v_uv.xy, 0.1);

  vec3 border_color = stroke_color.xyz;
  vec3 fill_color = color.xyz;
  vec3 col = mix(border_color, fill_color, circ) * circ_alpha;

  // Output to screen
  fragColor = vec4(col, min(color.a, circ_alpha));

  LOGZ_FRAGMENT_ADJUST_DEPTH_WITH_FLOGZ_FCOEF
}
