//agf_include "logarithmic_z.inc"
layout(location=0) in vec3 agf_position;
layout(location=1) in vec4 agf_color;

uniform mat4 model_view_proj_matrix;

out vec4 v_color;

LOGZ_VERTEX_DECLARE_FLOGZ
LOGZ_VERTEX_DECLARE_FCOEF

void main() {
  vec4 position = vec4(agf_position, 1.0);
  vec4 position_clip = model_view_proj_matrix * position;

  v_color = agf_color;

  gl_Position = position_clip;

  LOGZ_VERTEX_ADJUST_GL_POSITION_Z
  LOGZ_VERTEX_PASS_FLOGZ_AFTER_GL_POSITION
}
