in vec4 v_color;
in vec3 v_P_clip;
in vec2 v_uv;

out vec4 fragColor;

uniform vec4 base_color;
uniform sampler2D base_texture;
uniform bool base_texture_enabled;
uniform bool invert_output_color;

vec2 WrapUV(vec2 old, float mode ){
  vec2 wrapped = old;
  if(mode <= 0.0){
    wrapped = fract(wrapped);
    if( mode < 0.0){
      if (mod(old.x, 2) < 1)
      {
        // even
      }
      else
      {
        wrapped.x = 1.0-wrapped.x;
      }

      if (mod(old.y, 2) < 1)
      {
        // even
      }
      else
      {
        wrapped.y = 1.0-wrapped.y;
      }
    }
  }else{

  }
  return wrapped;
}

void main() {
  vec3 color = vec3(base_color.rgb);
  if (base_texture_enabled) {
    vec4 texture_sample = texture(base_texture, WrapUV(v_uv, 0.0));
    color = texture_sample.rgb;
  }

  vec4 final_color = vec4(color, 1.0);

  if (invert_output_color) { //Store translucency in all channels -@nikolai3d
    final_color = vec4(color.r, color.r, color.r, 1.0);
  }
  fragColor = final_color;
}
