in vec2 v_uv;

#if DIFFUSE_TEXTURE
uniform sampler2D diffuse_texture; //Sampler Node name "diffuse", property name "texture"
uniform vec4 diffuse_color; //Sampler Node name "diffuse", property name "color"
#else
uniform vec4 diffuse_color; //Sampler Node name "diffuse", property name "color"
#endif

out vec4 fragColor;

void main() {
#if DIFFUSE_TEXTURE
  vec4 diffuse_tex = texture(diffuse_texture, v_uv);
  vec3 color = mix(diffuse_color.rgb, diffuse_tex.rgb, diffuse_tex.a);
#else
  vec3 color = diffuse_color.rgb;
#endif
  fragColor = vec4(color, 1.0);
}
