//agf_include "logarithmic_z.inc"

layout(location=0) in vec3 agf_position;
layout(location=1) in vec4 agf_color;
layout(location=2) in vec3 agf_normal;
layout(location=3) in vec2 agf_uv;

// #define AGF_TANGENT_VERTEX_GENERIC_ATTRIBUTE 4
// #define AGF_BINORMAL_VERTEX_GENERIC_ATTRIBUTE 5
// #define AGF_BONE_INDEX_VERTEX_GENERIC_ATTRIBUTE 6
// #define AGF_BONE_WEIGHT_VERTEX_GENERIC_ATTRIBUTE 7

uniform mat4 model_matrix;
uniform mat4 model_view_matrix;
uniform mat4 model_view_proj_matrix;
uniform mat4 model_view_it_matrix;
uniform mat4 world_to_shadow_matrix;
uniform mat4 uv_transform; // NOTE: mat3 is not presently supported

out vec4 v_color;
out vec3 v_N;
out vec3 v_P_clip;
out vec3 v_P_camera;
out vec3 v_P_shadow;
out vec2 v_uv;

LOGZ_VERTEX_DECLARE_FLOGZ
LOGZ_VERTEX_DECLARE_FCOEF

void main() {
  vec4 position = vec4(agf_position, 1.0);
  vec4 position_clip = model_view_proj_matrix * position;
  vec4 position_camera = model_view_matrix * position;

  vec4 mesh_normal = vec4(agf_normal, 0.0);
  vec4 normal_camera = model_view_it_matrix * mesh_normal;

  v_P_clip = position_clip.xyz;
  v_P_camera = position_camera.xyz;
  v_P_shadow = (world_to_shadow_matrix * model_matrix * position).xyz;
  v_N = normalize(normal_camera.xyz);

  vec4 uv = uv_transform * vec4(agf_uv, 1.0, 1.0);
  v_uv = uv.xy; // just the x and y components, please
  v_color = agf_color;

  gl_Position = position_clip;

  LOGZ_VERTEX_ADJUST_GL_POSITION_Z
  LOGZ_VERTEX_PASS_FLOGZ_AFTER_GL_POSITION
}
