//agf_include "color/srgb.inc"
//agf_include "color/tonemap_identity.inc"

uniform sampler2D texture_param;
in vec2 v_uv;
layout(location = 0) out vec4 fragColor;

void main() {
  // Sample color from texture.
  vec2 uv = v_uv;
  uv.y = 1.0 - uv.y;
  vec4 color = texture(texture_param, uv);

  // Tonemap and gamma encode the color components then clamp both color and alpha.
  fragColor = clamp(vec4(color.a * linear_to_srgb(tonemap(color.rgb)), color.a), 0.0, 1.0);
}
