uniform sampler2D texture_param;
in vec2 v_uv;
layout(location = 0) out vec4 fragColor;

void main() {
  // Sample color from texture.
  vec4 color = texture(texture_param, v_uv);

  // Unpremultiply alpha (first checking for divide-by-zero) then clamp both color and alpha.
  fragColor = (color.a == 0.0) ? vec4(0.0) : clamp(vec4(color.rgb / color.a, color.a), 0.0, 1.0);
}
