//agf_include "color/srgb.inc"
//agf_include "color/tonemap_identity.inc"

uniform sampler2D incoming_lantern_texture;
uniform sampler2D incoming_rasterized_texture;
uniform float     lantern_alpha;
uniform float     rasterized_alpha;
in vec2 v_uv;
layout(location = 0) out vec4 fragColor;

void main() {
  // Sample color from texture.
  vec2 uv = v_uv;

  vec2 lantern_uv = v_uv;
  lantern_uv.y = 1.0 - lantern_uv.y;

  vec4 lantern_texel = texture(incoming_lantern_texture, lantern_uv);

  // Lantern pixels are alpha-premultiplied
  vec4 lantern_pixel = clamp(vec4(linear_to_srgb(lantern_texel.rgb), lantern_texel.a), 0.0, 1.0);

  vec4 rasterized_pixel = texture(incoming_rasterized_texture, uv);

  vec4 color;
  // color.rgb = mix((rasterized_pixel.rgb), srgb_to_linear(lantern_pixel.rgb), lantern_pixel.a);
  // color.a = max(lantern_pixel.a, rasterized_pixel.a);

  color = lantern_pixel*lantern_alpha + rasterized_pixel*rasterized_alpha;
  //color.rgb = lantern_pixel.rgb*lantern_alpha + rasterized_pixel.rgb*rasterized_alpha;
  //color.a = 1.0;

  fragColor =  color;//    clamp(vec4(color.a * linear_to_srgb(tonemap(color.rgb)), color.a), 0.0, 1.0);

  // fragColor = lantern_pixel;
  // fragColor.rgb = lantern_pixel.aaa;
  // fragColor.a = 1.0;
}
