uniform sampler2D texture_param;
uniform float opacity;
in vec2 v_uv;
layout(location = 0) out vec4 fragColor;

void main() {
  // Sample color from texture.
  vec4 color = vec4(texture(texture_param, v_uv));

  // Remove premultiplied alpha (first checking for divide-by-zero or divide-by-one) then clamp both color and alpha.
  fragColor = (color.a == 0.0) ? vec4(0.0) : ((color.a == 1.0) ? color : clamp(vec4(color.rgb / color.a, color.a), 0.0, 1.0));
}
