vec3 tonemapUsingL(vec3 color, float Lwhite) {
  // Luminance is R * 0.2126 + 0.7152 * G + 0.0722 * B -- that's a dot product! :D
  float L = dot(vec3(0.2126, 0.7152, 0.0722), color);
  float correction = L * (1.0 + L / Lwhite) / (1.0 + L);
  return correction * color;
}

vec3 tonemapUsingAvgL(vec3 color, float Lwhite) {
  float L = dot(vec3(0.3333), color);
  float correction = L * (1.0 + L / Lwhite) / (1.0 + L);
  return correction * color;
}

vec3 tonemapUsingColor(vec3 color, float Lwhite) {
  return color * (vec3(1.0) + color / Lwhite) / (1.0 + vec3(color));
}

vec3 tonemap(vec3 color) {
  float Lwhite = 1.0; // blown out regions are above this value. change to include more in viewable range.
  Lwhite *= Lwhite; // squared
  return tonemapUsingL(color, Lwhite);
}
