// Vertex shader declarations //

#define DECLARE_MDL_TEXTURE_SAMPLER_UV(name) \
uniform mat4 name##_uv_transform; \
out vec2 name##_v_uv;

#define SET_MDL_TEXTURE_SAMPLER_UV(name, src_uv) \
vec4 name##_uv = name##_uv_transform * vec4(src_uv, 1.0, 1.0); \
name##_v_uv = name##_uv.xy;

// Fragment shader declarations //

#define DECLARE_MDL_TEXTURE_SCALAR_SAMPLER(name) \
uniform float name##_strength; \
uniform sampler2D name##_texture; \
uniform bool name##_enabled; \
in vec2 name##_v_uv;

#define DECLARE_MDL_TEXTURE_NORMAL_SAMPLER(name) \
uniform sampler2D name##_texture; \
uniform bool name##_enabled; \
in vec2 name##_v_uv;

#define DECLARE_MDL_TEXTURE_COLOR_SAMPLER(name) \
uniform float name##_strength; \
uniform vec4 name##_color; \
uniform sampler2D name##_texture; \
uniform bool name##_enabled; \
in vec2 name##_v_uv;

