#ifndef PI
#define PI 3.1415926
#endif

vec3 uv_to_normal(vec2 uv) {
  vec3 N;

  vec2 uvRange = uv;

  float theta = uvRange.x * 2.0 * PI;
  float phi = uvRange.y * PI;

  N.x = cos(theta) * sin(phi);
  N.z = sin(theta) * sin(phi);
  N.y = -cos(phi);
  return N;
}

vec2 normal_to_uv(vec3 N) {
  // This only works if everything is normalized.
  vec3 R = normalize(N);

  // The spherical coordinate math breaks down near vertical, so check within
  // an epsilon to prevent flickering in upward-pointing faces....
  if (1.0-abs(R.y) < 1e-7) {
    return vec2(0.0,(sign(R.y)+1.0)/2.0);
  }

  float theta = atan2(-R.x, R.z) + PI / 2.0;
  theta /= 2.0 * PI;

  float phi = acos(-R.y);
  phi /= PI;
  return vec2(theta, phi);
}
