CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{9B880A3F-F9CA-469A-B324-8AF8249036C8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{450AE2E5-05A7-4050-A255-424822DD376F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{30166071-2B33-43E8-B767-61B1C3B851A8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{C3665AAA-A82D-4238-9E37-E5CB973CEDA1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{EC39D326-D851-4863-8731-95CC7FCA4789}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{7199C2DE-F954-445D-95D2-19C3FFCA72B7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{F72FECA5-5513-45E0-9B74-B68E4F976649}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{F04EFCB5-A8B8-438C-BEAC-72A5BBAE7995}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{713A3DA7-A360-4600-89FE-4C9C200C1E3C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{7D459337-06E5-43B4-873D-B1965567F241}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{0C800CD6-94FD-4D43-A1B8-F7C357858C12}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{98E66CA0-0C4B-4596-A40A-84D8E94E7F87}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{35F51B95-3043-439E-AAD1-021E0E838FF8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{D456DCE3-FC49-4C03-AB0A-9C0DA7E2B527}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{E2E9365E-9CD3-4FC1-B636-A781999CC1E2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{73C2CD40-5302-4CA1-AA4E-C63E6C62D01E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{932B722A-E84E-461D-932B-1E33C2920A3E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{3F8532D1-7D45-4B22-A11F-7C7460AB17BE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{5F5D6354-0C69-4EFD-A1A1-CBED790C9F35}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{2F09E283-B790-4157-931B-AB23FA228A71}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{A2DCE5BD-B777-4E48-AAD2-2B0282F8AEDE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{A0BDFE0D-A4B0-4593-A978-0B368979A443}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{8C820038-480C-4217-A49C-7656B48319E0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{541BA591-83A4-4821-B70C-4932E317939E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{3CEE1FB7-6983-4DB8-8A39-7E4E8F1AC720}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{76F43B9B-529A-4297-B822-78596CFEC85C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{1611F3D9-9F42-4E61-BA80-C9B0D77422D3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{E68205AB-C3D3-4B28-9534-3D6033D280DB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{DB0CD924-139B-49D9-BC26-B3288C88E00D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{7C1F9C3D-7F6B-46CD-9821-7819DD57FAA1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{D9673ADD-C404-4687-AF59-7DF8ABEA629D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{90041BF0-4DA9-4515-B186-F1FF89C7FF96}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{FDBFAACB-9B66-4CEA-939D-A15D2B564597}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{12BCD705-53E1-4EFF-A8A7-6DE18199DF4B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{8E04D8CB-054A-42B6-BD3F-67A15EB9D774}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{1008AD25-E884-424C-9049-5370C2F4FBA2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{542951DA-B37E-4A43-A7B9-8C09BD4BEB25}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{82236C10-A128-4BBB-977F-B8238DF83AD9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{A8D32DC6-DDFB-4E5E-A620-AB886DE0BC14}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{F6D59E5D-B99E-4F3C-AE05-B1DDC209D00B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{965BBDD9-48D7-4CF3-A0B6-1BE228974E2C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{D37D7797-1848-4BB6-9858-C00E0BA15733}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{2A369C06-58A2-4C90-9DD4-C79ACF512109}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{C1CBE7F6-E0B5-43CC-B742-431D93EF2D63}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{AE4EDF42-CAC3-4D3B-969F-FBC8BA2D879B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{5335A1F3-BB4E-49F0-8EBD-6D97EF797958}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{CA1E3F9D-3E25-4A71-8F1F-DF2ADCBC2DC1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{DB1447B3-0A79-455C-8E0E-ED061437FB47}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{52E968AA-4DBE-4997-9528-6ECD8F1FE39B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{52F67FD5-052D-4C90-8F8B-7DD20069C7BB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{D66A44AF-9893-4674-B261-D8D746AD36B8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{CF641ADC-925A-4017-B8B0-06924D76B7E1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{D23E3CA7-EDCE-4E90-AADA-A2FB0FA5698A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{031AC0D4-789B-4E0C-AC5D-D029C9FA6FD5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{69F18F70-4A1E-4A1E-8AD5-42C3CDAD3810}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{B251C441-CFCC-404E-A769-E4254BBA96F9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{EC3CC33B-E508-411A-A6EF-FA996EFEB85A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{3C19FCDF-3378-4D42-8F00-7849E3A7A54F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{C8BE6F7C-87FA-4688-AA4A-46607DF08F14}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{999C14A2-AC52-42ED-92D2-C5E1D9E0A223}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{B8C282A6-FEFF-477F-95A6-492CD74C05DC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{B1F601C1-4B45-4D91-91E5-CFCD22C61D70}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{8F13C336-92E0-452B-A63D-1BEE43351B84}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{64CC0955-25F0-4EE4-A2B8-2C94195F0114}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{5BDB9395-EC0C-4A96-9416-9900248D35D5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{F8530151-8D1E-4827-BDB5-B28E5A9920BD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{9A4A0512-BD3C-44B8-8E48-96795CCB78DE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{3BEAB1F0-C3A4-409F-8133-BBE3A104A9EF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{A080FD40-5C8F-4603-8141-BC0D6597B2C4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{7E7D999E-7D36-4BAE-8410-C2E5D609CDDE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{2F87C719-F902-47A1-9F8D-428DBA67C318}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{72B01781-F9D9-4348-8B04-D40A5DEE755A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{818C811F-425C-4875-A59A-7F9A4C6FC63E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{6B42252D-5CAD-4EFC-9FFB-9786CB00C420}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{03D73FB2-ABA0-41E9-B99E-360DEC241CC5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{2B594CD6-8DA5-4B2F-A705-FDD5A6A88818}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{CC317876-AB94-47CE-A561-6A7E5556CDEC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{73C102CB-98E1-445E-AF6B-3DE32F562A0C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{A44ED97D-6890-4742-B6B6-1E82DEC7857C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{3A613691-B23B-4D80-B760-42B6C1E34413}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{CC420390-035D-4D23-8F8D-331E8BABC598}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{55655FFE-B65D-4B36-9162-02B973B77E32}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{32F0B085-7000-4D57-BE68-4092D3CB23A3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{C04F2375-8F49-49DB-BF58-92B9A10F1389}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{2980C31A-727B-412E-84AA-7B0DCD006C01}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{2990DD3F-F20B-4BAC-ADFE-43EF03F25A29}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{60D3E9B6-188A-4669-BDFC-B698D3A36A75}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{4B676573-6410-499B-8066-3C73534F42CE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{BBC8B511-6AF7-4011-AC7A-12140793265B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{CA61816B-CEAC-4C13-A568-835C8BE4E961}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{C81F005D-72B3-4F70-BE41-50C1992B62E6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{9598B29D-612C-42DF-9F43-EC3E4B1228B2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{A60715CF-C6D2-4E76-90E0-6263C97DF26C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{62B2A449-D12E-4940-B3DB-5E175F2F0318}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{38CB4C04-7C96-4EB9-855C-0695A70DDB9B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{A3C88FA9-0231-442C-8993-12ABB4EBEA00}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{1A12A0C7-4F9E-48B8-970C-374E1850295E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{580600FE-307E-4D2A-908A-029767FCCE0F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{56979B59-0B80-4B74-87C9-21E818BE8ED1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{265F22FB-84D6-47DB-9C8B-F79007AFE5AD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{FEBBE9CC-B222-4367-8D66-736CCE03C095}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{6D1C7863-4243-4570-B121-6370017D3B66}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{01AC37E3-757B-4B80-8A60-BC7D499DF1C5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{57E38293-69FF-4F85-ACB1-044C16FB87D5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{C3E91305-C32C-4C19-843F-6FAE32A28104}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{1ABDE049-AB75-452B-B4A3-117B1B940074}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{7EAC3794-234A-40C9-B603-1473E6411074}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{9E40A070-5E0D-4EF8-8D25-22EABC6A9C55}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{5B83019B-EC76-4F34-A8E6-88CDA8167852}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{0030D594-1598-4B0E-8CB7-80629722E67E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{CCBBB764-05A8-4ED1-A164-E6EDB2195369}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{1B399A9E-A550-45E4-B960-0DDF8405D9A9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{FFCDC2DF-C4D2-47BE-B04B-B79E18CD5351}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{29944D4A-CC50-4A20-8714-9EDAB07462F2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{8B0C383B-1F3E-4C94-B6C0-476996B50822}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{081FEA02-2E49-406C-B77A-269AF9B3DB9F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{E0BA66A9-9D9E-4461-AFE8-BA43F843F10E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{8049466F-EA2C-46D0-AD10-205692C84C86}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{321AE2F7-A1B5-4C29-AF1D-60FE2B7765D2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{1DFA4C64-22D9-4362-A7F4-0B4FAF136DA5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{01AEC16A-7555-4ED6-9A8D-7205347A298A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{945709FC-3430-4500-9698-4ECE22672461}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{9C88763B-659A-4AF6-8BCC-448C0B7FD38D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{85BFF698-FED1-4373-86BF-4F9396842C62}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{8D0DEC57-337E-4970-B3A6-2F8F0DE7C73B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{38B87C41-835C-4713-956B-91626A5AC90F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{8F36B9AD-7B76-432B-9FFB-ED20960CF8B0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{E5FE0840-FD97-45E7-AF73-B58C2762D711}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{D443A7F7-ED83-40DC-9983-A6474B0FFF60}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{B9A042FB-22EC-4B02-9848-55516D76A535}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{53F4CDFD-D706-47DD-8434-F3EC172588F4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{10B68E19-CEC8-4EA8-86A4-3F98F0F8CCDF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{9AE175C1-8FE3-4012-A811-0DA933EBB9BF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{2F45F805-1417-43FD-B982-9C2D336DF72D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{0B8D79E9-E33A-4C8F-AD48-FF1210C101BB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{1D499854-A7CD-4EB5-9055-B344F86661A7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{9C54F58F-4310-4D2B-B34A-DE836DC5DA2F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{BF2AE352-1E8F-4E57-A49D-78411B76C7E4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{FB7E9CE2-67C2-441E-8FC5-C4051858B0B9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{03AE8623-32C9-4053-A57B-376BCEFC2CD0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{44F7DCFF-2116-42E5-B5F3-98FEF8231D23}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{CF27F251-D82A-49AF-9033-78F74B178C54}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{56718909-8215-4578-9E33-73BE4D914C93}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{24762692-3B35-4627-A738-55FBBB013C2F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{F37EFFDD-F0EE-45DC-9233-EE8A3C37BAEB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{F17AFD38-19CB-47C5-A5F0-20DB5525426B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{D2270C21-7145-4761-B955-24A750A08449}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{D10B9016-9208-43B7-A8AD-2AB512B6E46A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{7042BAC2-D42D-4211-8A5B-9CEAD15D4277}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{B7425A63-16FA-4BB7-A012-3637C2CF1A91}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{F0683622-9D57-4025-8E28-A327744241B1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{C305652B-7484-4BB2-8894-00702C82097B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{B2DF2B0F-AB96-4696-AA3A-6C2768D41C0A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{F15DC5DD-5DB5-4454-BD34-3BB6C38703C7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{C81A160B-8E10-417B-86A5-E86AB6B7E7E7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{58B139D9-B347-443E-A93C-28ECCDEAB690}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{4B40096E-3FD3-418F-AA7B-BAB358069B83}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{3657BA33-DFE2-439F-B1AE-4F7D533F786F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{6DB3184C-5A61-45B7-8765-ED89004526FE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{542CAC93-1C19-464A-A873-9A812795603A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{043E790E-0270-4C88-B3C4-3CC80A4C6292}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{581BCB92-6F1D-49DF-AA63-F03317B3F48C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{D6AE3DBB-AE06-4763-BB01-104CE897927A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{D87E9E19-F8E8-43A1-A3B6-428A601ECE40}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{D9A301ED-E874-447F-8196-A52E56ADA10F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{A7F7D374-F603-4BB2-9C76-37580FB40888}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{55D06854-2158-4456-9C00-793A2B11770A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{754A14A9-2864-45AD-8C9D-0DF5F0FE528A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{82D39BC5-9E7B-4B99-9BC0-FE544F981ACD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "{90433A8D-F88B-4C3C-92E1-1437D333F9B2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "", "langPack", "DVA", "Adobe Audition", "")
INSERT INTO Payloads VALUES	("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "DVA", "Adobe Audition_AdobeAudition4ko_KRLanguagePack", "9", "langPack")
INSERT INTO PayloadData VALUES("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "0" , "PayloadInfo", '<PayloadInfo version="4.0.19.0"><BuildInfo>
    <Property name="Created">2011-03-24 13:27:03.815000</Property>
    <Property name="TargetName">AdobeAudition4ko_KRLanguagePack</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}</Property>
    <Property name="ProductName">Adobe Audition CS5.5 LangPack (ko_KR) </Property>
    <Property name="ProductVersion">9</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
  </InstallDir><Languages>
    <Language>ko_KR</Language>
  </Languages><Satisfies>
    <ProductInfo>
		<Family>DVA</Family>
		<ProductName>Adobe Audition_AdobeAudition4ko_KRLanguagePack</ProductName>
	<ProductVersion>9</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{9B880A3F-F9CA-469A-B324-8AF8249036C8}</AdobeCode>
  </Upgrades><Conflicts>
    <AdobeCode>{450AE2E5-05A7-4050-A255-424822DD376F}</AdobeCode>
    <AdobeCode>{30166071-2B33-43E8-B767-61B1C3B851A8}</AdobeCode>
    <AdobeCode>{C3665AAA-A82D-4238-9E37-E5CB973CEDA1}</AdobeCode>
    <AdobeCode>{EC39D326-D851-4863-8731-95CC7FCA4789}</AdobeCode>
    <AdobeCode>{7199C2DE-F954-445D-95D2-19C3FFCA72B7}</AdobeCode>
    <AdobeCode>{F72FECA5-5513-45E0-9B74-B68E4F976649}</AdobeCode>
    <AdobeCode>{F04EFCB5-A8B8-438C-BEAC-72A5BBAE7995}</AdobeCode>
    <AdobeCode>{713A3DA7-A360-4600-89FE-4C9C200C1E3C}</AdobeCode>
    <AdobeCode>{7D459337-06E5-43B4-873D-B1965567F241}</AdobeCode>
    <AdobeCode>{0C800CD6-94FD-4D43-A1B8-F7C357858C12}</AdobeCode>
    <AdobeCode>{98E66CA0-0C4B-4596-A40A-84D8E94E7F87}</AdobeCode>
    <AdobeCode>{35F51B95-3043-439E-AAD1-021E0E838FF8}</AdobeCode>
    <AdobeCode>{D456DCE3-FC49-4C03-AB0A-9C0DA7E2B527}</AdobeCode>
    <AdobeCode>{E2E9365E-9CD3-4FC1-B636-A781999CC1E2}</AdobeCode>
    <AdobeCode>{73C2CD40-5302-4CA1-AA4E-C63E6C62D01E}</AdobeCode>
    <AdobeCode>{932B722A-E84E-461D-932B-1E33C2920A3E}</AdobeCode>
    <AdobeCode>{3F8532D1-7D45-4B22-A11F-7C7460AB17BE}</AdobeCode>
    <AdobeCode>{5F5D6354-0C69-4EFD-A1A1-CBED790C9F35}</AdobeCode>
    <AdobeCode>{2F09E283-B790-4157-931B-AB23FA228A71}</AdobeCode>
    <AdobeCode>{A2DCE5BD-B777-4E48-AAD2-2B0282F8AEDE}</AdobeCode>
    <AdobeCode>{A0BDFE0D-A4B0-4593-A978-0B368979A443}</AdobeCode>
    <AdobeCode>{8C820038-480C-4217-A49C-7656B48319E0}</AdobeCode>
    <AdobeCode>{541BA591-83A4-4821-B70C-4932E317939E}</AdobeCode>
    <AdobeCode>{3CEE1FB7-6983-4DB8-8A39-7E4E8F1AC720}</AdobeCode>
    <AdobeCode>{76F43B9B-529A-4297-B822-78596CFEC85C}</AdobeCode>
    <AdobeCode>{1611F3D9-9F42-4E61-BA80-C9B0D77422D3}</AdobeCode>
    <AdobeCode>{E68205AB-C3D3-4B28-9534-3D6033D280DB}</AdobeCode>
    <AdobeCode>{DB0CD924-139B-49D9-BC26-B3288C88E00D}</AdobeCode>
    <AdobeCode>{7C1F9C3D-7F6B-46CD-9821-7819DD57FAA1}</AdobeCode>
    <AdobeCode>{D9673ADD-C404-4687-AF59-7DF8ABEA629D}</AdobeCode>
    <AdobeCode>{90041BF0-4DA9-4515-B186-F1FF89C7FF96}</AdobeCode>
    <AdobeCode>{FDBFAACB-9B66-4CEA-939D-A15D2B564597}</AdobeCode>
    <AdobeCode>{12BCD705-53E1-4EFF-A8A7-6DE18199DF4B}</AdobeCode>
    <AdobeCode>{8E04D8CB-054A-42B6-BD3F-67A15EB9D774}</AdobeCode>
    <AdobeCode>{1008AD25-E884-424C-9049-5370C2F4FBA2}</AdobeCode>
    <AdobeCode>{542951DA-B37E-4A43-A7B9-8C09BD4BEB25}</AdobeCode>
    <AdobeCode>{82236C10-A128-4BBB-977F-B8238DF83AD9}</AdobeCode>
    <AdobeCode>{A8D32DC6-DDFB-4E5E-A620-AB886DE0BC14}</AdobeCode>
    <AdobeCode>{F6D59E5D-B99E-4F3C-AE05-B1DDC209D00B}</AdobeCode>
    <AdobeCode>{965BBDD9-48D7-4CF3-A0B6-1BE228974E2C}</AdobeCode>
    <AdobeCode>{D37D7797-1848-4BB6-9858-C00E0BA15733}</AdobeCode>
    <AdobeCode>{2A369C06-58A2-4C90-9DD4-C79ACF512109}</AdobeCode>
    <AdobeCode>{C1CBE7F6-E0B5-43CC-B742-431D93EF2D63}</AdobeCode>
    <AdobeCode>{AE4EDF42-CAC3-4D3B-969F-FBC8BA2D879B}</AdobeCode>
    <AdobeCode>{5335A1F3-BB4E-49F0-8EBD-6D97EF797958}</AdobeCode>
    <AdobeCode>{CA1E3F9D-3E25-4A71-8F1F-DF2ADCBC2DC1}</AdobeCode>
    <AdobeCode>{DB1447B3-0A79-455C-8E0E-ED061437FB47}</AdobeCode>
    <AdobeCode>{52E968AA-4DBE-4997-9528-6ECD8F1FE39B}</AdobeCode>
    <AdobeCode>{52F67FD5-052D-4C90-8F8B-7DD20069C7BB}</AdobeCode>
    <AdobeCode>{D66A44AF-9893-4674-B261-D8D746AD36B8}</AdobeCode>
    <AdobeCode>{CF641ADC-925A-4017-B8B0-06924D76B7E1}</AdobeCode>
    <AdobeCode>{D23E3CA7-EDCE-4E90-AADA-A2FB0FA5698A}</AdobeCode>
    <AdobeCode>{031AC0D4-789B-4E0C-AC5D-D029C9FA6FD5}</AdobeCode>
    <AdobeCode>{69F18F70-4A1E-4A1E-8AD5-42C3CDAD3810}</AdobeCode>
    <AdobeCode>{B251C441-CFCC-404E-A769-E4254BBA96F9}</AdobeCode>
    <AdobeCode>{EC3CC33B-E508-411A-A6EF-FA996EFEB85A}</AdobeCode>
    <AdobeCode>{3C19FCDF-3378-4D42-8F00-7849E3A7A54F}</AdobeCode>
    <AdobeCode>{C8BE6F7C-87FA-4688-AA4A-46607DF08F14}</AdobeCode>
    <AdobeCode>{999C14A2-AC52-42ED-92D2-C5E1D9E0A223}</AdobeCode>
    <AdobeCode>{B8C282A6-FEFF-477F-95A6-492CD74C05DC}</AdobeCode>
    <AdobeCode>{B1F601C1-4B45-4D91-91E5-CFCD22C61D70}</AdobeCode>
    <AdobeCode>{8F13C336-92E0-452B-A63D-1BEE43351B84}</AdobeCode>
    <AdobeCode>{64CC0955-25F0-4EE4-A2B8-2C94195F0114}</AdobeCode>
    <AdobeCode>{5BDB9395-EC0C-4A96-9416-9900248D35D5}</AdobeCode>
    <AdobeCode>{F8530151-8D1E-4827-BDB5-B28E5A9920BD}</AdobeCode>
    <AdobeCode>{9A4A0512-BD3C-44B8-8E48-96795CCB78DE}</AdobeCode>
    <AdobeCode>{3BEAB1F0-C3A4-409F-8133-BBE3A104A9EF}</AdobeCode>
    <AdobeCode>{A080FD40-5C8F-4603-8141-BC0D6597B2C4}</AdobeCode>
    <AdobeCode>{7E7D999E-7D36-4BAE-8410-C2E5D609CDDE}</AdobeCode>
    <AdobeCode>{2F87C719-F902-47A1-9F8D-428DBA67C318}</AdobeCode>
    <AdobeCode>{72B01781-F9D9-4348-8B04-D40A5DEE755A}</AdobeCode>
    <AdobeCode>{818C811F-425C-4875-A59A-7F9A4C6FC63E}</AdobeCode>
    <AdobeCode>{6B42252D-5CAD-4EFC-9FFB-9786CB00C420}</AdobeCode>
    <AdobeCode>{03D73FB2-ABA0-41E9-B99E-360DEC241CC5}</AdobeCode>
    <AdobeCode>{2B594CD6-8DA5-4B2F-A705-FDD5A6A88818}</AdobeCode>
    <AdobeCode>{CC317876-AB94-47CE-A561-6A7E5556CDEC}</AdobeCode>
    <AdobeCode>{73C102CB-98E1-445E-AF6B-3DE32F562A0C}</AdobeCode>
    <AdobeCode>{A44ED97D-6890-4742-B6B6-1E82DEC7857C}</AdobeCode>
    <AdobeCode>{3A613691-B23B-4D80-B760-42B6C1E34413}</AdobeCode>
    <AdobeCode>{CC420390-035D-4D23-8F8D-331E8BABC598}</AdobeCode>
    <AdobeCode>{55655FFE-B65D-4B36-9162-02B973B77E32}</AdobeCode>
    <AdobeCode>{32F0B085-7000-4D57-BE68-4092D3CB23A3}</AdobeCode>
    <AdobeCode>{C04F2375-8F49-49DB-BF58-92B9A10F1389}</AdobeCode>
    <AdobeCode>{2980C31A-727B-412E-84AA-7B0DCD006C01}</AdobeCode>
    <AdobeCode>{2990DD3F-F20B-4BAC-ADFE-43EF03F25A29}</AdobeCode>
    <AdobeCode>{60D3E9B6-188A-4669-BDFC-B698D3A36A75}</AdobeCode>
    <AdobeCode>{4B676573-6410-499B-8066-3C73534F42CE}</AdobeCode>
    <AdobeCode>{BBC8B511-6AF7-4011-AC7A-12140793265B}</AdobeCode>
    <AdobeCode>{CA61816B-CEAC-4C13-A568-835C8BE4E961}</AdobeCode>
    <AdobeCode>{C81F005D-72B3-4F70-BE41-50C1992B62E6}</AdobeCode>
    <AdobeCode>{9598B29D-612C-42DF-9F43-EC3E4B1228B2}</AdobeCode>
    <AdobeCode>{A60715CF-C6D2-4E76-90E0-6263C97DF26C}</AdobeCode>
    <AdobeCode>{62B2A449-D12E-4940-B3DB-5E175F2F0318}</AdobeCode>
    <AdobeCode>{38CB4C04-7C96-4EB9-855C-0695A70DDB9B}</AdobeCode>
    <AdobeCode>{A3C88FA9-0231-442C-8993-12ABB4EBEA00}</AdobeCode>
    <AdobeCode>{1A12A0C7-4F9E-48B8-970C-374E1850295E}</AdobeCode>
    <AdobeCode>{580600FE-307E-4D2A-908A-029767FCCE0F}</AdobeCode>
    <AdobeCode>{56979B59-0B80-4B74-87C9-21E818BE8ED1}</AdobeCode>
    <AdobeCode>{265F22FB-84D6-47DB-9C8B-F79007AFE5AD}</AdobeCode>
    <AdobeCode>{FEBBE9CC-B222-4367-8D66-736CCE03C095}</AdobeCode>
    <AdobeCode>{6D1C7863-4243-4570-B121-6370017D3B66}</AdobeCode>
    <AdobeCode>{01AC37E3-757B-4B80-8A60-BC7D499DF1C5}</AdobeCode>
    <AdobeCode>{57E38293-69FF-4F85-ACB1-044C16FB87D5}</AdobeCode>
    <AdobeCode>{C3E91305-C32C-4C19-843F-6FAE32A28104}</AdobeCode>
    <AdobeCode>{1ABDE049-AB75-452B-B4A3-117B1B940074}</AdobeCode>
    <AdobeCode>{7EAC3794-234A-40C9-B603-1473E6411074}</AdobeCode>
    <AdobeCode>{9E40A070-5E0D-4EF8-8D25-22EABC6A9C55}</AdobeCode>
    <AdobeCode>{5B83019B-EC76-4F34-A8E6-88CDA8167852}</AdobeCode>
    <AdobeCode>{0030D594-1598-4B0E-8CB7-80629722E67E}</AdobeCode>
    <AdobeCode>{CCBBB764-05A8-4ED1-A164-E6EDB2195369}</AdobeCode>
    <AdobeCode>{1B399A9E-A550-45E4-B960-0DDF8405D9A9}</AdobeCode>
    <AdobeCode>{FFCDC2DF-C4D2-47BE-B04B-B79E18CD5351}</AdobeCode>
    <AdobeCode>{29944D4A-CC50-4A20-8714-9EDAB07462F2}</AdobeCode>
    <AdobeCode>{8B0C383B-1F3E-4C94-B6C0-476996B50822}</AdobeCode>
    <AdobeCode>{081FEA02-2E49-406C-B77A-269AF9B3DB9F}</AdobeCode>
    <AdobeCode>{E0BA66A9-9D9E-4461-AFE8-BA43F843F10E}</AdobeCode>
    <AdobeCode>{8049466F-EA2C-46D0-AD10-205692C84C86}</AdobeCode>
    <AdobeCode>{321AE2F7-A1B5-4C29-AF1D-60FE2B7765D2}</AdobeCode>
    <AdobeCode>{1DFA4C64-22D9-4362-A7F4-0B4FAF136DA5}</AdobeCode>
    <AdobeCode>{01AEC16A-7555-4ED6-9A8D-7205347A298A}</AdobeCode>
    <AdobeCode>{945709FC-3430-4500-9698-4ECE22672461}</AdobeCode>
    <AdobeCode>{9C88763B-659A-4AF6-8BCC-448C0B7FD38D}</AdobeCode>
    <AdobeCode>{85BFF698-FED1-4373-86BF-4F9396842C62}</AdobeCode>
    <AdobeCode>{8D0DEC57-337E-4970-B3A6-2F8F0DE7C73B}</AdobeCode>
    <AdobeCode>{38B87C41-835C-4713-956B-91626A5AC90F}</AdobeCode>
    <AdobeCode>{8F36B9AD-7B76-432B-9FFB-ED20960CF8B0}</AdobeCode>
    <AdobeCode>{E5FE0840-FD97-45E7-AF73-B58C2762D711}</AdobeCode>
    <AdobeCode>{D443A7F7-ED83-40DC-9983-A6474B0FFF60}</AdobeCode>
    <AdobeCode>{B9A042FB-22EC-4B02-9848-55516D76A535}</AdobeCode>
    <AdobeCode>{53F4CDFD-D706-47DD-8434-F3EC172588F4}</AdobeCode>
    <AdobeCode>{10B68E19-CEC8-4EA8-86A4-3F98F0F8CCDF}</AdobeCode>
    <AdobeCode>{9AE175C1-8FE3-4012-A811-0DA933EBB9BF}</AdobeCode>
    <AdobeCode>{2F45F805-1417-43FD-B982-9C2D336DF72D}</AdobeCode>
    <AdobeCode>{0B8D79E9-E33A-4C8F-AD48-FF1210C101BB}</AdobeCode>
    <AdobeCode>{1D499854-A7CD-4EB5-9055-B344F86661A7}</AdobeCode>
    <AdobeCode>{9C54F58F-4310-4D2B-B34A-DE836DC5DA2F}</AdobeCode>
    <AdobeCode>{BF2AE352-1E8F-4E57-A49D-78411B76C7E4}</AdobeCode>
    <AdobeCode>{FB7E9CE2-67C2-441E-8FC5-C4051858B0B9}</AdobeCode>
    <AdobeCode>{03AE8623-32C9-4053-A57B-376BCEFC2CD0}</AdobeCode>
    <AdobeCode>{44F7DCFF-2116-42E5-B5F3-98FEF8231D23}</AdobeCode>
    <AdobeCode>{CF27F251-D82A-49AF-9033-78F74B178C54}</AdobeCode>
    <AdobeCode>{56718909-8215-4578-9E33-73BE4D914C93}</AdobeCode>
    <AdobeCode>{24762692-3B35-4627-A738-55FBBB013C2F}</AdobeCode>
    <AdobeCode>{F37EFFDD-F0EE-45DC-9233-EE8A3C37BAEB}</AdobeCode>
    <AdobeCode>{F17AFD38-19CB-47C5-A5F0-20DB5525426B}</AdobeCode>
    <AdobeCode>{D2270C21-7145-4761-B955-24A750A08449}</AdobeCode>
    <AdobeCode>{D10B9016-9208-43B7-A8AD-2AB512B6E46A}</AdobeCode>
    <AdobeCode>{7042BAC2-D42D-4211-8A5B-9CEAD15D4277}</AdobeCode>
    <AdobeCode>{B7425A63-16FA-4BB7-A012-3637C2CF1A91}</AdobeCode>
    <AdobeCode>{F0683622-9D57-4025-8E28-A327744241B1}</AdobeCode>
    <AdobeCode>{C305652B-7484-4BB2-8894-00702C82097B}</AdobeCode>
    <AdobeCode>{B2DF2B0F-AB96-4696-AA3A-6C2768D41C0A}</AdobeCode>
    <AdobeCode>{F15DC5DD-5DB5-4454-BD34-3BB6C38703C7}</AdobeCode>
    <AdobeCode>{C81A160B-8E10-417B-86A5-E86AB6B7E7E7}</AdobeCode>
    <AdobeCode>{58B139D9-B347-443E-A93C-28ECCDEAB690}</AdobeCode>
    <AdobeCode>{4B40096E-3FD3-418F-AA7B-BAB358069B83}</AdobeCode>
    <AdobeCode>{3657BA33-DFE2-439F-B1AE-4F7D533F786F}</AdobeCode>
    <AdobeCode>{6DB3184C-5A61-45B7-8765-ED89004526FE}</AdobeCode>
    <AdobeCode>{542CAC93-1C19-464A-A873-9A812795603A}</AdobeCode>
    <AdobeCode>{043E790E-0270-4C88-B3C4-3CC80A4C6292}</AdobeCode>
    <AdobeCode>{581BCB92-6F1D-49DF-AA63-F03317B3F48C}</AdobeCode>
    <AdobeCode>{D6AE3DBB-AE06-4763-BB01-104CE897927A}</AdobeCode>
    <AdobeCode>{D87E9E19-F8E8-43A1-A3B6-428A601ECE40}</AdobeCode>
    <AdobeCode>{D9A301ED-E874-447F-8196-A52E56ADA10F}</AdobeCode>
    <AdobeCode>{A7F7D374-F603-4BB2-9C76-37580FB40888}</AdobeCode>
    <AdobeCode>{55D06854-2158-4456-9C00-793A2B11770A}</AdobeCode>
    <AdobeCode>{754A14A9-2864-45AD-8C9D-0DF5F0FE528A}</AdobeCode>
    <AdobeCode>{82D39BC5-9E7B-4B99-9BC0-FE544F981ACD}</AdobeCode>
    <AdobeCode>{90433A8D-F88B-4C3C-92E1-1437D333F9B2}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeAuditionCS5.5LangPackko_KR-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (ko_KR) </DisplayName>
  </Channel><Extends type="langPack">
    <ParentProductInfo>
					<Family>DVA</Family>
					<ProductName>Adobe Audition</ProductName>
				</ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="0" sysDriveSize="774"><Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>774</TotalSize>
      <MaxPathComponent>/HelpCfg/ko_KR\Audition_4.0.helpcfg</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="774"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ko_KR">9</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ko_KR">Adobe Audition CS5.5 LangPack (ko_KR) </Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "0", "ChannelID", "AdobeAuditionCS5.5LangPackko_KR-9")
INSERT INTO PayloadData VALUES("{9BE7DF16-83AF-4934-9AC7-2E4342F1975A}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeAuditionCS5.5LangPackko_KR-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (ko_KR) </DisplayName>
  </Channel>')
