CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{2E99FE9A-F13B-48DC-89B1-5697733629A9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{B19A0E8E-3914-4CBF-8627-6250199BA977}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{CAD9BA96-21B6-437C-9D15-398AF82A80F1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{32690678-AA9F-472A-AECD-43FB4627B76A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{0FF4E7C2-3E1A-4B9A-ADE7-1CC1F3677560}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{00CEA6B6-FEA0-4671-8E44-72B868AAA154}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{34BECD6B-CA8B-4B0B-B1E0-57D6DFDAA0A2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{11CF51FF-22AB-448A-8560-AB869F35B298}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{ADC8DF3F-3E71-4AE5-8EFE-DEEDE454AF67}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{90E7EB36-C190-4EE3-B6B1-0BB7AD9F122C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{84F566A1-7526-4C78-B01A-5C94157C6B34}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{ED8B4830-8E4E-4536-9FA8-2DFA50F22B21}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{26531D92-F9FA-4D50-8E6A-21D79C2EC4A6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{08E99790-BD0E-4A17-A1E7-B260E10F9648}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{75A2BA6D-32FF-43D4-89FD-DDADE3B7BA1A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{CCAC1616-CFE1-4437-B435-A3E473D3CB11}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{759C256B-C846-41BD-91EB-2E54DE32D5C0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{46CF64E0-FF17-45C3-A5BB-B14ECA564BDF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{50665696-C06A-475D-92C5-A551627C3D64}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{0BF794D2-A749-41F1-9D9E-4A982CC75912}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{E5AD4AB6-3AA9-430E-B858-BC24D3EEE54F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{849A649C-F9BC-4508-B5E7-79179EC86667}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{F0CB68E8-0C92-4C6A-98B1-E15B0F47E827}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{5C25E853-DD34-4CE8-8D96-7C4EC4367883}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{4BBFEEAC-6E10-4D43-8CBE-1B509B5BDB17}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{CA95B577-515E-42A0-B987-9927C00CF2EE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{478D5468-972A-4F8F-8873-5E10C9ADBAE3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{F31A56CB-E4C3-4D2F-9B9D-C0F195C16D5A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{7E54921C-E37C-4B30-9D00-70B133ED73D2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{644BC51A-0AF1-49B8-A66D-DCF7BA9426F0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{76B3EF7E-55D3-4F0F-A68E-F2A3AF72E88E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{20A7995B-AEDF-4B4E-B81F-0AF9078DE14D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{D238DB67-7D7A-42C9-894C-12B9F3BCD01D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{322DD4D2-89CA-4CB6-826E-CEE08DB95619}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{FFEB4AAC-7664-4A20-A0B9-E5814926569B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{E8377D61-6BE8-495D-B13A-838FC6ACC323}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{1C2A1E38-012F-4D48-ABAF-62E7CA98218F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{F9D20395-B7AB-4648-9D9F-94D504766C3F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{0C4E0CB6-E3B1-4F94-AD7A-21CFEA7B1503}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{9A6E52B7-C625-4C88-BFC0-6E8B83472307}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{FE1AF0AD-006A-425A-89DA-77C7DF28C7A2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{DAADB14E-2B65-4E46-90A5-1408BB45A998}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{B19611E8-23BD-4D73-B049-479A491330E2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{964604DD-9040-49E4-9190-E4F67FB5BFE6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{D618C031-21E5-4634-8837-451B990517B3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{1A51453B-E712-48EC-AC7A-9AA7DED899BE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{AEA2F984-06D1-4AE8-A462-0544A43368F1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{2671E774-3AD5-4BFD-BFA2-0E435287E89D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{5B84247F-C401-4800-915C-B76B15FC34FD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{8EA54EB3-5A6B-4695-BA83-A6E491A11906}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{F8CAE842-9160-47A0-AD3C-73368EAB4F1E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{4977E89B-6D44-4ACB-81D9-A56584EA6225}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{59AD89FA-EE20-481B-B12B-3AE7C0969CDA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{3B8390C0-D855-4A07-9211-1A07ABFB9B01}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{0ADD70F2-85BA-4FCF-BF32-B88F5407F1B3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{62ACD2E2-1799-44B7-8779-FA26E2929729}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{908740B6-8590-4ED5-83A4-6F80644C04D0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{C6E3D773-0A13-4859-BD62-5B3565C53466}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{C2320108-1A1F-49EB-A266-AFCEDA2AA55C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{5AFC8716-5291-49B2-B11B-9C81C9B4DF79}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{86FE4EB5-5457-45D2-9E2D-2A173448E340}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{03554FBE-B9FF-4AD1-A050-2509A51CC6A8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{F66E1B44-E110-4C06-9CBB-B714DDAA5245}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{B73CE5A3-1BBD-4D05-AA09-B1FE7BB6AB7B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{FE1F1D05-2F1C-4170-9BE3-B4382391E1D9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{664CA879-559D-47C6-AE55-40EDE02FBD4A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{91ED4B62-E5A2-4C93-8BA0-55A286742D84}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{823E9815-4BE3-4C53-8C28-4D7409560503}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{E0357C71-F491-46D2-80AF-36D2E1AE67BB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{DD9A64EF-3A6E-4D15-9B25-B7FB0572129E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{01094E77-9758-44B7-9F7E-DB4DA4A8F434}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{50C129EC-4F51-49F4-8D95-CAD8CD935BB8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{157317CD-F65F-4C83-9DF0-74A5684AE79A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{3272B0B6-EC8F-4D08-B9D2-D576FDA94234}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{432B070B-A287-44E1-A96A-70CC4F974F0C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{91EBFAEF-7844-445B-9B0F-625EBDC35528}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{0CA69817-C50B-42C3-B960-24FE601324D6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{F0C2D4BA-0C28-4A30-9023-5C15B304DFE3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{BDBEE477-788F-46DE-AC3E-38496D6A7E7B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{38BE7A80-01D5-4F0B-8D2C-9B5D03639273}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{798518A2-B27C-4B39-887B-4ED7AF649925}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{B00E77EB-68FF-4FFF-8C0F-4B6475CEEFF6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{4BEE225C-560A-41E0-9CC0-883A7F055095}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{716C3E7F-C54F-41B0-A7E2-E4DF0A19D93C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{683CC6F3-23B4-4CC6-8D1F-BBA4D5B50FF4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{FB43E7FE-E96E-4E5B-9770-D79DFF3706AF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{5BD892C2-570D-433F-BBC5-2FB43209BC84}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{319E4994-1630-40DD-BA1F-F2732563825A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{8A7978FC-E652-4FDE-B440-8FC8F6D5BE79}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{FEEE5B36-9AB5-4836-9399-B21888C123E7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{94780D48-3905-46E6-A0EE-B6E28E6059BA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{CB042F72-D3D3-4AD5-A5BC-6E6E01AE848C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{16BFBE33-D6EE-43C2-9BE9-02F9085E45AB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{A3187AFD-4319-47F2-9907-8DBC0062C4DA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{4B9442CD-09AE-4641-B8A5-8675189610CE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{42075714-38F0-4401-ACC9-316BBD2DBAE8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{91D4DB6E-14B8-4A5F-B684-393DF108A77A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{6562DDC4-FF45-4751-A776-DC96ED34456E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{C439EC0D-5EB4-4F53-90E3-F38BEA38F291}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{AE71EFCF-400B-457F-AC47-0B90E5E5D2E4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{9115B6EC-0E78-48F6-B2BC-79E99867B28F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{4AF3746F-0DDA-430A-A8D3-E22E77638715}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{5F142735-F807-42A8-9856-8E0DDC68E7EC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{EACF010A-86FE-4C0B-8257-9880FDCB56ED}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{85D6EDD6-36AA-444B-9F63-863BDEC34302}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{E9936793-4EF1-464D-95CD-CDAD04EC4E5E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{C9796781-69F1-4A13-A87F-33E157A35648}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{6F06A0DA-CE79-49F0-A326-39D23081F05E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{9A8B0A32-C89A-4183-884A-C904AD8ABCC5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{C3AD4107-7E9A-418D-9DED-379CDE0F4D52}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{310F69B7-61BD-458B-936A-E2A0AFD3C150}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{80DA7E20-FF11-49B0-9E1D-8A75C04CF4B3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{13EE590D-4938-418E-8213-8423CEA4D9E3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{1CF4A6A4-86AF-479C-A273-105B6EF015D4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{362CEC8B-4D04-4FE3-A7FC-4A35FA5D4487}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{DB7F6B56-576B-498E-987C-FDC562CC1C6B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{542910B3-B533-4764-A5CE-5F0A9E080AA5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{15F4A738-96C3-4361-8EEE-1C336169E602}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{370B46DC-7E88-4E51-A3CB-BEC0EEF296F8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{1A78DAF4-4A8D-498C-A062-C93E35F1EB27}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{A6E265C4-3BF7-4D69-9B08-F2E28A618EE0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{12941E9A-E3A0-4A31-BB9A-CB36C962E9B9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{98F21C8E-AD3F-4964-B2D6-FA07096F6E78}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{213CB4BA-901B-4DA5-B8FD-EF9EA4EAF4B0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{E360CE88-2370-4E3B-9954-5A8C87C1A26B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{54AC7400-AB0D-49FA-8FB4-A97AF32E95B7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{282C7B7F-AE01-4238-92D5-6A96631BD11C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{16C13E22-29C5-48B7-B1EF-2A3AD4BC546C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{1E04B91E-7DE9-4682-AC61-18EB0E736E49}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{5B4964D9-DDA2-4D8A-ABCB-6FE01F374077}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{C6DF2A51-7E43-4853-9862-B17A9AB2C531}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{EBCA77CA-E200-4322-94FB-179380F1F4FB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{75CBC612-BF00-4F1C-BEC8-1444E8FD4920}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{CBF47BCB-2ACA-4A32-B810-200AE71B9DAB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{6CC7B5BC-C240-4A2F-BCB0-9DADCD2B67EA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{1D69ADDF-1E8F-4B1B-9E3D-C91D0DD66165}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{FC160017-BD5F-4E94-AA30-34423C9A7004}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{4EED08BC-2F42-4EBC-B11C-E1D9589BF0BF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{61434C8A-C04E-4252-8A3E-29A28DE4BCF9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{14C39E31-6773-4C89-9702-C8159C43C412}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{BB1C6FB3-D1EF-42A0-96DF-3BC2CED0E60B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{6866781C-85B7-4F65-AED4-A7F6C09C327E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{3E125D4A-001A-400D-8175-366565E7FE19}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{0A10B6E1-C3D5-4E17-B010-E7A1EB05F43C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{AA4F2615-5FBC-493F-95AF-3A92835A1CBE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{DE60EAC4-1F71-4B43-AA76-4012DB890AD5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{8061D64C-364F-4844-AFD1-9FD7D2FA21D1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{E6A3136C-85BF-4931-8982-1D1E0C1D996C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{6BFF5CAC-623E-42E9-81E3-9B591087E657}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{C97C41D9-070A-46B5-AF82-0EA3B369987B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{A82FE3B4-E596-4CFA-93E9-3EE01AED1760}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{9C75A336-3B98-4300-8F60-95597FBA9A7E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{86B4E4AF-A810-47C4-8E85-3C7D87C9D0E9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{0E8EC7E9-643B-46EF-8574-B9E8069596D9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{97FABCA3-984F-4300-B971-1569341F3AD1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{F538A60D-E200-4C94-AAE5-CDA5D6188F61}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{0B147D30-314C-4D56-AE68-4E2271D55B95}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{4C4D2C58-7E94-4655-845D-74543069D02F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{37504780-6A56-45CD-A42F-D292ED4AC1A1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{130AE4D1-12C0-40DC-9432-D35F4E6BAD59}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{DE2572A0-AE60-4FE7-9E3C-FEBBF1A16AAC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{3989EA5A-9FEC-4668-A9C7-52DB0746F8B8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{9745905C-5377-4F31-BA89-71D85698E49F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{BEBE8B9D-76F7-447C-B537-EE2A2B7BFC6B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{AE1D3542-8597-4145-9FD6-16A2BFC84B8C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{C9E0E1E5-5A6E-44B2-91AE-70DF9F4C8D3B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{86CCD30D-941C-4655-8387-EC0A9A30A087}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{EF417C88-8062-4238-A858-691A85A483C5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{1C576650-6E2C-4C2C-9E52-6E76DB0EA592}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "{332EFB56-3DE3-4BDF-A390-69719AC5B2B0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "", "langPack", "DVA", "Adobe Audition", "")
INSERT INTO Payloads VALUES	("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "DVA", "Adobe Audition_AdobeAudition4ja_JPLanguagePack", "9", "langPack")
INSERT INTO PayloadData VALUES("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "0" , "PayloadInfo", '<PayloadInfo version="4.0.19.0"><BuildInfo>
    <Property name="Created">2011-03-24 13:26:51.569000</Property>
    <Property name="TargetName">AdobeAudition4ja_JPLanguagePack</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{61867E03-EDD6-4600-BCC8-07BDC261B4C7}</Property>
    <Property name="ProductName">Adobe Audition CS5.5 LangPack (ja_JP) </Property>
    <Property name="ProductVersion">9</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
  </InstallDir><Languages>
    <Language>ja_JP</Language>
  </Languages><Satisfies>
    <ProductInfo>
		<Family>DVA</Family>
		<ProductName>Adobe Audition_AdobeAudition4ja_JPLanguagePack</ProductName>
	<ProductVersion>9</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{2E99FE9A-F13B-48DC-89B1-5697733629A9}</AdobeCode>
  </Upgrades><Conflicts>
    <AdobeCode>{B19A0E8E-3914-4CBF-8627-6250199BA977}</AdobeCode>
    <AdobeCode>{CAD9BA96-21B6-437C-9D15-398AF82A80F1}</AdobeCode>
    <AdobeCode>{32690678-AA9F-472A-AECD-43FB4627B76A}</AdobeCode>
    <AdobeCode>{0FF4E7C2-3E1A-4B9A-ADE7-1CC1F3677560}</AdobeCode>
    <AdobeCode>{00CEA6B6-FEA0-4671-8E44-72B868AAA154}</AdobeCode>
    <AdobeCode>{34BECD6B-CA8B-4B0B-B1E0-57D6DFDAA0A2}</AdobeCode>
    <AdobeCode>{11CF51FF-22AB-448A-8560-AB869F35B298}</AdobeCode>
    <AdobeCode>{ADC8DF3F-3E71-4AE5-8EFE-DEEDE454AF67}</AdobeCode>
    <AdobeCode>{90E7EB36-C190-4EE3-B6B1-0BB7AD9F122C}</AdobeCode>
    <AdobeCode>{84F566A1-7526-4C78-B01A-5C94157C6B34}</AdobeCode>
    <AdobeCode>{ED8B4830-8E4E-4536-9FA8-2DFA50F22B21}</AdobeCode>
    <AdobeCode>{26531D92-F9FA-4D50-8E6A-21D79C2EC4A6}</AdobeCode>
    <AdobeCode>{08E99790-BD0E-4A17-A1E7-B260E10F9648}</AdobeCode>
    <AdobeCode>{75A2BA6D-32FF-43D4-89FD-DDADE3B7BA1A}</AdobeCode>
    <AdobeCode>{CCAC1616-CFE1-4437-B435-A3E473D3CB11}</AdobeCode>
    <AdobeCode>{759C256B-C846-41BD-91EB-2E54DE32D5C0}</AdobeCode>
    <AdobeCode>{46CF64E0-FF17-45C3-A5BB-B14ECA564BDF}</AdobeCode>
    <AdobeCode>{50665696-C06A-475D-92C5-A551627C3D64}</AdobeCode>
    <AdobeCode>{0BF794D2-A749-41F1-9D9E-4A982CC75912}</AdobeCode>
    <AdobeCode>{E5AD4AB6-3AA9-430E-B858-BC24D3EEE54F}</AdobeCode>
    <AdobeCode>{849A649C-F9BC-4508-B5E7-79179EC86667}</AdobeCode>
    <AdobeCode>{F0CB68E8-0C92-4C6A-98B1-E15B0F47E827}</AdobeCode>
    <AdobeCode>{5C25E853-DD34-4CE8-8D96-7C4EC4367883}</AdobeCode>
    <AdobeCode>{4BBFEEAC-6E10-4D43-8CBE-1B509B5BDB17}</AdobeCode>
    <AdobeCode>{CA95B577-515E-42A0-B987-9927C00CF2EE}</AdobeCode>
    <AdobeCode>{478D5468-972A-4F8F-8873-5E10C9ADBAE3}</AdobeCode>
    <AdobeCode>{F31A56CB-E4C3-4D2F-9B9D-C0F195C16D5A}</AdobeCode>
    <AdobeCode>{7E54921C-E37C-4B30-9D00-70B133ED73D2}</AdobeCode>
    <AdobeCode>{644BC51A-0AF1-49B8-A66D-DCF7BA9426F0}</AdobeCode>
    <AdobeCode>{76B3EF7E-55D3-4F0F-A68E-F2A3AF72E88E}</AdobeCode>
    <AdobeCode>{20A7995B-AEDF-4B4E-B81F-0AF9078DE14D}</AdobeCode>
    <AdobeCode>{D238DB67-7D7A-42C9-894C-12B9F3BCD01D}</AdobeCode>
    <AdobeCode>{322DD4D2-89CA-4CB6-826E-CEE08DB95619}</AdobeCode>
    <AdobeCode>{FFEB4AAC-7664-4A20-A0B9-E5814926569B}</AdobeCode>
    <AdobeCode>{E8377D61-6BE8-495D-B13A-838FC6ACC323}</AdobeCode>
    <AdobeCode>{1C2A1E38-012F-4D48-ABAF-62E7CA98218F}</AdobeCode>
    <AdobeCode>{F9D20395-B7AB-4648-9D9F-94D504766C3F}</AdobeCode>
    <AdobeCode>{0C4E0CB6-E3B1-4F94-AD7A-21CFEA7B1503}</AdobeCode>
    <AdobeCode>{9A6E52B7-C625-4C88-BFC0-6E8B83472307}</AdobeCode>
    <AdobeCode>{FE1AF0AD-006A-425A-89DA-77C7DF28C7A2}</AdobeCode>
    <AdobeCode>{DAADB14E-2B65-4E46-90A5-1408BB45A998}</AdobeCode>
    <AdobeCode>{B19611E8-23BD-4D73-B049-479A491330E2}</AdobeCode>
    <AdobeCode>{964604DD-9040-49E4-9190-E4F67FB5BFE6}</AdobeCode>
    <AdobeCode>{D618C031-21E5-4634-8837-451B990517B3}</AdobeCode>
    <AdobeCode>{1A51453B-E712-48EC-AC7A-9AA7DED899BE}</AdobeCode>
    <AdobeCode>{AEA2F984-06D1-4AE8-A462-0544A43368F1}</AdobeCode>
    <AdobeCode>{2671E774-3AD5-4BFD-BFA2-0E435287E89D}</AdobeCode>
    <AdobeCode>{5B84247F-C401-4800-915C-B76B15FC34FD}</AdobeCode>
    <AdobeCode>{8EA54EB3-5A6B-4695-BA83-A6E491A11906}</AdobeCode>
    <AdobeCode>{F8CAE842-9160-47A0-AD3C-73368EAB4F1E}</AdobeCode>
    <AdobeCode>{4977E89B-6D44-4ACB-81D9-A56584EA6225}</AdobeCode>
    <AdobeCode>{59AD89FA-EE20-481B-B12B-3AE7C0969CDA}</AdobeCode>
    <AdobeCode>{3B8390C0-D855-4A07-9211-1A07ABFB9B01}</AdobeCode>
    <AdobeCode>{0ADD70F2-85BA-4FCF-BF32-B88F5407F1B3}</AdobeCode>
    <AdobeCode>{62ACD2E2-1799-44B7-8779-FA26E2929729}</AdobeCode>
    <AdobeCode>{908740B6-8590-4ED5-83A4-6F80644C04D0}</AdobeCode>
    <AdobeCode>{C6E3D773-0A13-4859-BD62-5B3565C53466}</AdobeCode>
    <AdobeCode>{C2320108-1A1F-49EB-A266-AFCEDA2AA55C}</AdobeCode>
    <AdobeCode>{5AFC8716-5291-49B2-B11B-9C81C9B4DF79}</AdobeCode>
    <AdobeCode>{86FE4EB5-5457-45D2-9E2D-2A173448E340}</AdobeCode>
    <AdobeCode>{03554FBE-B9FF-4AD1-A050-2509A51CC6A8}</AdobeCode>
    <AdobeCode>{F66E1B44-E110-4C06-9CBB-B714DDAA5245}</AdobeCode>
    <AdobeCode>{B73CE5A3-1BBD-4D05-AA09-B1FE7BB6AB7B}</AdobeCode>
    <AdobeCode>{FE1F1D05-2F1C-4170-9BE3-B4382391E1D9}</AdobeCode>
    <AdobeCode>{664CA879-559D-47C6-AE55-40EDE02FBD4A}</AdobeCode>
    <AdobeCode>{91ED4B62-E5A2-4C93-8BA0-55A286742D84}</AdobeCode>
    <AdobeCode>{823E9815-4BE3-4C53-8C28-4D7409560503}</AdobeCode>
    <AdobeCode>{E0357C71-F491-46D2-80AF-36D2E1AE67BB}</AdobeCode>
    <AdobeCode>{DD9A64EF-3A6E-4D15-9B25-B7FB0572129E}</AdobeCode>
    <AdobeCode>{01094E77-9758-44B7-9F7E-DB4DA4A8F434}</AdobeCode>
    <AdobeCode>{50C129EC-4F51-49F4-8D95-CAD8CD935BB8}</AdobeCode>
    <AdobeCode>{157317CD-F65F-4C83-9DF0-74A5684AE79A}</AdobeCode>
    <AdobeCode>{3272B0B6-EC8F-4D08-B9D2-D576FDA94234}</AdobeCode>
    <AdobeCode>{432B070B-A287-44E1-A96A-70CC4F974F0C}</AdobeCode>
    <AdobeCode>{91EBFAEF-7844-445B-9B0F-625EBDC35528}</AdobeCode>
    <AdobeCode>{0CA69817-C50B-42C3-B960-24FE601324D6}</AdobeCode>
    <AdobeCode>{F0C2D4BA-0C28-4A30-9023-5C15B304DFE3}</AdobeCode>
    <AdobeCode>{BDBEE477-788F-46DE-AC3E-38496D6A7E7B}</AdobeCode>
    <AdobeCode>{38BE7A80-01D5-4F0B-8D2C-9B5D03639273}</AdobeCode>
    <AdobeCode>{798518A2-B27C-4B39-887B-4ED7AF649925}</AdobeCode>
    <AdobeCode>{B00E77EB-68FF-4FFF-8C0F-4B6475CEEFF6}</AdobeCode>
    <AdobeCode>{4BEE225C-560A-41E0-9CC0-883A7F055095}</AdobeCode>
    <AdobeCode>{716C3E7F-C54F-41B0-A7E2-E4DF0A19D93C}</AdobeCode>
    <AdobeCode>{683CC6F3-23B4-4CC6-8D1F-BBA4D5B50FF4}</AdobeCode>
    <AdobeCode>{FB43E7FE-E96E-4E5B-9770-D79DFF3706AF}</AdobeCode>
    <AdobeCode>{5BD892C2-570D-433F-BBC5-2FB43209BC84}</AdobeCode>
    <AdobeCode>{319E4994-1630-40DD-BA1F-F2732563825A}</AdobeCode>
    <AdobeCode>{8A7978FC-E652-4FDE-B440-8FC8F6D5BE79}</AdobeCode>
    <AdobeCode>{FEEE5B36-9AB5-4836-9399-B21888C123E7}</AdobeCode>
    <AdobeCode>{94780D48-3905-46E6-A0EE-B6E28E6059BA}</AdobeCode>
    <AdobeCode>{CB042F72-D3D3-4AD5-A5BC-6E6E01AE848C}</AdobeCode>
    <AdobeCode>{16BFBE33-D6EE-43C2-9BE9-02F9085E45AB}</AdobeCode>
    <AdobeCode>{A3187AFD-4319-47F2-9907-8DBC0062C4DA}</AdobeCode>
    <AdobeCode>{4B9442CD-09AE-4641-B8A5-8675189610CE}</AdobeCode>
    <AdobeCode>{42075714-38F0-4401-ACC9-316BBD2DBAE8}</AdobeCode>
    <AdobeCode>{91D4DB6E-14B8-4A5F-B684-393DF108A77A}</AdobeCode>
    <AdobeCode>{6562DDC4-FF45-4751-A776-DC96ED34456E}</AdobeCode>
    <AdobeCode>{C439EC0D-5EB4-4F53-90E3-F38BEA38F291}</AdobeCode>
    <AdobeCode>{AE71EFCF-400B-457F-AC47-0B90E5E5D2E4}</AdobeCode>
    <AdobeCode>{9115B6EC-0E78-48F6-B2BC-79E99867B28F}</AdobeCode>
    <AdobeCode>{4AF3746F-0DDA-430A-A8D3-E22E77638715}</AdobeCode>
    <AdobeCode>{5F142735-F807-42A8-9856-8E0DDC68E7EC}</AdobeCode>
    <AdobeCode>{EACF010A-86FE-4C0B-8257-9880FDCB56ED}</AdobeCode>
    <AdobeCode>{85D6EDD6-36AA-444B-9F63-863BDEC34302}</AdobeCode>
    <AdobeCode>{E9936793-4EF1-464D-95CD-CDAD04EC4E5E}</AdobeCode>
    <AdobeCode>{C9796781-69F1-4A13-A87F-33E157A35648}</AdobeCode>
    <AdobeCode>{6F06A0DA-CE79-49F0-A326-39D23081F05E}</AdobeCode>
    <AdobeCode>{9A8B0A32-C89A-4183-884A-C904AD8ABCC5}</AdobeCode>
    <AdobeCode>{C3AD4107-7E9A-418D-9DED-379CDE0F4D52}</AdobeCode>
    <AdobeCode>{310F69B7-61BD-458B-936A-E2A0AFD3C150}</AdobeCode>
    <AdobeCode>{80DA7E20-FF11-49B0-9E1D-8A75C04CF4B3}</AdobeCode>
    <AdobeCode>{13EE590D-4938-418E-8213-8423CEA4D9E3}</AdobeCode>
    <AdobeCode>{1CF4A6A4-86AF-479C-A273-105B6EF015D4}</AdobeCode>
    <AdobeCode>{362CEC8B-4D04-4FE3-A7FC-4A35FA5D4487}</AdobeCode>
    <AdobeCode>{DB7F6B56-576B-498E-987C-FDC562CC1C6B}</AdobeCode>
    <AdobeCode>{542910B3-B533-4764-A5CE-5F0A9E080AA5}</AdobeCode>
    <AdobeCode>{15F4A738-96C3-4361-8EEE-1C336169E602}</AdobeCode>
    <AdobeCode>{370B46DC-7E88-4E51-A3CB-BEC0EEF296F8}</AdobeCode>
    <AdobeCode>{1A78DAF4-4A8D-498C-A062-C93E35F1EB27}</AdobeCode>
    <AdobeCode>{A6E265C4-3BF7-4D69-9B08-F2E28A618EE0}</AdobeCode>
    <AdobeCode>{12941E9A-E3A0-4A31-BB9A-CB36C962E9B9}</AdobeCode>
    <AdobeCode>{98F21C8E-AD3F-4964-B2D6-FA07096F6E78}</AdobeCode>
    <AdobeCode>{213CB4BA-901B-4DA5-B8FD-EF9EA4EAF4B0}</AdobeCode>
    <AdobeCode>{E360CE88-2370-4E3B-9954-5A8C87C1A26B}</AdobeCode>
    <AdobeCode>{54AC7400-AB0D-49FA-8FB4-A97AF32E95B7}</AdobeCode>
    <AdobeCode>{282C7B7F-AE01-4238-92D5-6A96631BD11C}</AdobeCode>
    <AdobeCode>{16C13E22-29C5-48B7-B1EF-2A3AD4BC546C}</AdobeCode>
    <AdobeCode>{1E04B91E-7DE9-4682-AC61-18EB0E736E49}</AdobeCode>
    <AdobeCode>{5B4964D9-DDA2-4D8A-ABCB-6FE01F374077}</AdobeCode>
    <AdobeCode>{C6DF2A51-7E43-4853-9862-B17A9AB2C531}</AdobeCode>
    <AdobeCode>{EBCA77CA-E200-4322-94FB-179380F1F4FB}</AdobeCode>
    <AdobeCode>{75CBC612-BF00-4F1C-BEC8-1444E8FD4920}</AdobeCode>
    <AdobeCode>{CBF47BCB-2ACA-4A32-B810-200AE71B9DAB}</AdobeCode>
    <AdobeCode>{6CC7B5BC-C240-4A2F-BCB0-9DADCD2B67EA}</AdobeCode>
    <AdobeCode>{1D69ADDF-1E8F-4B1B-9E3D-C91D0DD66165}</AdobeCode>
    <AdobeCode>{FC160017-BD5F-4E94-AA30-34423C9A7004}</AdobeCode>
    <AdobeCode>{4EED08BC-2F42-4EBC-B11C-E1D9589BF0BF}</AdobeCode>
    <AdobeCode>{61434C8A-C04E-4252-8A3E-29A28DE4BCF9}</AdobeCode>
    <AdobeCode>{14C39E31-6773-4C89-9702-C8159C43C412}</AdobeCode>
    <AdobeCode>{BB1C6FB3-D1EF-42A0-96DF-3BC2CED0E60B}</AdobeCode>
    <AdobeCode>{6866781C-85B7-4F65-AED4-A7F6C09C327E}</AdobeCode>
    <AdobeCode>{3E125D4A-001A-400D-8175-366565E7FE19}</AdobeCode>
    <AdobeCode>{0A10B6E1-C3D5-4E17-B010-E7A1EB05F43C}</AdobeCode>
    <AdobeCode>{AA4F2615-5FBC-493F-95AF-3A92835A1CBE}</AdobeCode>
    <AdobeCode>{DE60EAC4-1F71-4B43-AA76-4012DB890AD5}</AdobeCode>
    <AdobeCode>{8061D64C-364F-4844-AFD1-9FD7D2FA21D1}</AdobeCode>
    <AdobeCode>{E6A3136C-85BF-4931-8982-1D1E0C1D996C}</AdobeCode>
    <AdobeCode>{6BFF5CAC-623E-42E9-81E3-9B591087E657}</AdobeCode>
    <AdobeCode>{C97C41D9-070A-46B5-AF82-0EA3B369987B}</AdobeCode>
    <AdobeCode>{A82FE3B4-E596-4CFA-93E9-3EE01AED1760}</AdobeCode>
    <AdobeCode>{9C75A336-3B98-4300-8F60-95597FBA9A7E}</AdobeCode>
    <AdobeCode>{86B4E4AF-A810-47C4-8E85-3C7D87C9D0E9}</AdobeCode>
    <AdobeCode>{0E8EC7E9-643B-46EF-8574-B9E8069596D9}</AdobeCode>
    <AdobeCode>{97FABCA3-984F-4300-B971-1569341F3AD1}</AdobeCode>
    <AdobeCode>{F538A60D-E200-4C94-AAE5-CDA5D6188F61}</AdobeCode>
    <AdobeCode>{0B147D30-314C-4D56-AE68-4E2271D55B95}</AdobeCode>
    <AdobeCode>{4C4D2C58-7E94-4655-845D-74543069D02F}</AdobeCode>
    <AdobeCode>{37504780-6A56-45CD-A42F-D292ED4AC1A1}</AdobeCode>
    <AdobeCode>{130AE4D1-12C0-40DC-9432-D35F4E6BAD59}</AdobeCode>
    <AdobeCode>{DE2572A0-AE60-4FE7-9E3C-FEBBF1A16AAC}</AdobeCode>
    <AdobeCode>{3989EA5A-9FEC-4668-A9C7-52DB0746F8B8}</AdobeCode>
    <AdobeCode>{9745905C-5377-4F31-BA89-71D85698E49F}</AdobeCode>
    <AdobeCode>{BEBE8B9D-76F7-447C-B537-EE2A2B7BFC6B}</AdobeCode>
    <AdobeCode>{AE1D3542-8597-4145-9FD6-16A2BFC84B8C}</AdobeCode>
    <AdobeCode>{C9E0E1E5-5A6E-44B2-91AE-70DF9F4C8D3B}</AdobeCode>
    <AdobeCode>{86CCD30D-941C-4655-8387-EC0A9A30A087}</AdobeCode>
    <AdobeCode>{EF417C88-8062-4238-A858-691A85A483C5}</AdobeCode>
    <AdobeCode>{1C576650-6E2C-4C2C-9E52-6E76DB0EA592}</AdobeCode>
    <AdobeCode>{332EFB56-3DE3-4BDF-A390-69719AC5B2B0}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeAuditionCS5.5LangPackja_JP-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (ja_JP) </DisplayName>
  </Channel><Extends type="langPack">
    <ParentProductInfo>
					<Family>DVA</Family>
					<ProductName>Adobe Audition</ProductName>
				</ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="0" sysDriveSize="798"><Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>798</TotalSize>
      <MaxPathComponent>/HelpCfg/ja_JP\Audition_4.0.helpcfg</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="798"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ja_JP">9</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ja_JP">Adobe Audition CS5.5 LangPack (ja_JP) </Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "0", "ChannelID", "AdobeAuditionCS5.5LangPackja_JP-9")
INSERT INTO PayloadData VALUES("{61867E03-EDD6-4600-BCC8-07BDC261B4C7}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeAuditionCS5.5LangPackja_JP-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (ja_JP) </DisplayName>
  </Channel>')
