CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{42529100-4B21-4373-B900-F60EDD6A7379}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{2E82C9A3-4222-44CF-A920-98DEDF0A4B9F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{96C93D82-20F4-4D4A-89A4-03B72AAC1212}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{D13C65B3-8E5B-4F58-8CBF-67299578B9A4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{B5856C74-57DE-4713-B741-1FC512C81713}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{35093B70-5BC7-42EC-B41B-0E699BA5B85A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{F4628710-49AB-403A-8D3C-79FE605CAC53}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{B07E6A99-CDBD-47F3-9C08-C7BA30E96E53}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{CDCF6BE3-E0A0-42BA-B651-2C6636C3F01E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{6FBAF106-AE30-46C7-8211-7B2C1D73C4F5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{E9952741-EB2D-448C-8FFD-15A9BB986B14}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{D1F8EF17-0B26-46E3-8C19-74E0915C66F5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{D0D4BF4C-28DF-488E-BCD2-3E3083D6EE75}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{930A1EE5-1A3E-47AD-BBEF-C8FE39072ADA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{6E8D3EB8-4622-408A-97A5-EBBB3912B966}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{EA5594B0-CAC8-4A4E-8E91-7078BB8501C5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{A6861241-1522-44C7-A5F9-6F36B3EAC0F6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{A0886F7C-BC80-49C6-A032-E0A7EC845F17}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{442DABEE-988C-4939-8C4D-C9321308BAE2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{4D5542AC-4F78-4E47-A4F1-DA8AF22C9344}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{87CA4FEF-0729-4AC6-8D8C-54D82B084CD3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{AF56850B-8254-4661-8050-7DAF7E8441A6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{97FB28C6-B9DB-40F2-80D8-81FB184311E4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{57E7B8E0-F787-4490-A4D9-83F9FE6D5F2C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{1CA66754-7762-4D04-AB46-1C7621810CE8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{E7382D3D-5DEB-4F57-9537-6212C8B6CE7A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{88F86EC0-E0FB-4A39-BA95-3C71DB73EAF0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{FDE507D3-46F2-42DE-90CC-C8B2E1210FFA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{9E01A48F-A5CC-4736-9EED-7C2C510C32A2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{03771831-AE4A-439A-8C85-B8656AFD9DE2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{0F79377C-1A0C-497C-83BC-F424C04CE899}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{B28119EB-DF36-47B1-97A5-5407D429D09F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{E0841A26-3C0B-46F8-83BA-9BD60ABB8148}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{B040CBEE-E6BE-4491-96A6-B45E09973D32}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{F2D37D0E-B8D1-4F78-8528-5A27C5394EC8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{549943C5-52B3-4D34-8CE8-195C19633CCB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{3C367983-8EF6-401C-AE47-2214FFEB7B14}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{A72D5B56-1BD1-41E3-90D8-9875F01F6490}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{123BC4F7-E5E6-4B65-96C0-C6FCB0F5A487}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{963BE6BF-CD99-49DB-876A-FEC468E42C32}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{28B53929-2664-4186-B7E6-5D2B10381767}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{CA52F770-17AE-4440-B977-D8BC4EFAA21F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{5C52359B-15E6-4D3D-8446-BA82947609EF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{C6BC84AF-619D-44EA-AE58-B0E7724684E1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{1C0CAE0F-C07E-4E1A-AEEE-299D47470107}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{CB641D72-35EE-4AE6-B2AE-61A99FB561B0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{9728737A-C6EF-4FC3-81DE-A8DAD202E3E4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{038B6236-B9F4-4142-A5ED-6D6B480859AD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{126433E5-6FF3-4E59-A913-D495F21EE182}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{8C7BDA68-AFF7-4DB0-B928-247378F9A28C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{84354EC6-3540-48AA-B577-56E0BD85473B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{139A1B88-D0FB-4969-8799-DF6B1A6E7666}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{84C98B95-AAC0-4916-BE5A-33FA6DB4E8F5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{B8E73F26-6BF3-4B6B-BBE9-633C83241910}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{7F56ADB8-E7D0-423C-8978-9672D4034C81}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{D492FA67-D02A-4503-BE97-F61BE059EDA0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{56618C8F-7BF2-4ECF-8CCA-885D5F9243AB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{F5A321E7-3A7B-43D1-B3F0-929523657999}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{37625CB0-8155-4E53-8DEE-1AAE7933A7E8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{62FA6952-438D-4234-B370-CD0BFCC84BA8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{870844F7-A2B3-4B99-AD8C-11CC5940CDB6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{5F48E5D4-142F-499F-9297-B2555116FDE9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{0BF756C4-3AC5-43D7-8027-188DF6C259D8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{5F70EDB2-1EE2-4DE7-8D1C-3E56D040CB5A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{FDB5D22C-A8B4-42C0-B696-43B1B68D6464}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{25E21DE8-19E3-4AEC-A9C0-1D5D1E391997}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{7EEF9BC5-27B0-4FF3-892F-317117A0EA1B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{8DC786FA-52F0-4D37-82C4-9BE3A5B75560}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{B0F9CDEC-B41C-4F23-B19E-A9B2BE9E54FE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{F0F3329F-57B8-42CA-9D35-85E5C59EE20D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{AEFD1B93-ED5E-456D-A328-7944027CE921}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{EEBEDBCD-3729-45D9-87D6-10E6309FD849}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{40C760B3-1D33-4644-9A7E-FD570B3E6588}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{24340B05-7D67-40B7-9E74-E0FDE2F34454}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{E12AA819-FC40-4947-8D71-4524B30FFAB4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{15448C2C-BED7-4AD5-A2C8-FD940D464760}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{6725F423-95A0-4A95-BAA3-AF96644E229B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{E7B1AC39-4A3F-4F68-963E-9E2DEE29DD89}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{1D21FFB6-B28F-4A35-A0BE-9F8B88002917}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{A20BBB36-7614-4BF5-A2A0-85E31171DDB4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{8504DDCA-940A-466F-B661-99B1C84BCC64}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{8C9AA3BE-3E34-4137-A5C6-58878310A602}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{D6279DB2-DAF6-4D99-986C-0662462C54AD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{0098AF03-9BD0-473C-B8C3-35EC8A2C7BE4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{D24ADF72-B345-4538-8E3B-DFB027955428}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{924DC610-2F53-4231-BE5D-30CFC8EE4614}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{A9957233-FED9-4D7C-9963-1FB994B64D63}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{2E33436C-4E64-4965-9F6E-6F2835149FE1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{E4264F4F-A868-4094-B6B2-45FF26D872E2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{23C49143-0F0B-440C-9064-3096FF54EC1E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{761643CB-4B4A-4E69-B9DC-100B79236727}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{8534A797-37FD-44E8-A7AF-E3D49FEC3D5B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{4C8DC7E2-07B9-42FB-8FD5-BCAB1B200422}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{5003CAC3-618A-48E3-BB6F-F0CEE4729734}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{71A752A0-8197-471A-A149-7D95C8A54D57}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{3BBCBE21-5E63-4CF2-A541-4CFF7D192602}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{D0AF7F3B-80DF-4431-8AF2-C033B99A4C2E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{4D8A228C-A081-4C57-9118-5B2DA90C4E1F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{0A64F1B4-8A37-4667-BF41-0DE0F443F7DC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{05D4134B-F1EF-4700-88C0-9416D3F96C87}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{B406A115-02D4-4C66-88ED-74CE21E8AA6C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{39FE0AF5-4B35-4F9D-8BD0-6B95F57C1171}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{0BC369A3-AA37-40A6-A531-5D3A679EEA4D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{81385055-9409-429F-9F38-763EA3786201}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{D89E6968-2C50-4ECD-BBD3-0E7A58A9723C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{76B94429-BF94-4287-BC54-BBD44A56DD07}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{08723C05-473C-4028-8D07-EFC5362C7CD5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{F94BE657-1200-4590-BEBE-1DB309432349}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{B4FA75CD-65F1-4AA0-AD4B-0CC528F658D8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{F5F8365B-601C-4FB6-8CFA-74F2F1D980EF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{6263E3C8-8526-4AF3-8CDA-7C5B0DA7D6FB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{F4122F72-C0BE-4346-9693-69A475ECDE8F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{46191BCB-2DBA-4850-8D62-56DB288DCE8E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{8C5ABF4F-A756-4C18-B089-5038843329A9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{367B205E-AEE2-49C2-96CF-8CFC94A2843B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{9ACDED01-B66B-483C-9D8B-EAE56216BA07}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{C9A4C0CD-2955-4A5C-B467-E52C053A0A4E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{1738F108-20B0-4016-AAF9-AFFB128F437C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{2495F492-313E-4C45-99FE-BCCC1EFB46AC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{40AE3784-EBD5-4705-A99F-600F7510786B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{ABC7CE8D-1F6E-4571-843E-44DD48652584}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{E2C14240-0326-43A2-864E-D9A942563752}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{9AA6D2F1-ECDC-408E-878F-DB1A079B3FD3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{54F7B4A0-ACCF-414A-98B4-906E437F471A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{A601D1AC-62DD-4E36-B10C-921CCA56A679}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{36315F2C-11E6-4950-846C-DDC538A793C3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{3AE262CC-C111-4B92-9466-A173333B6413}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{2A7C829B-9B98-4D71-8828-1E14D5CD391C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{196B9D6A-CC7B-49E0-87D1-6E2B3DBB87FF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{AB9FF29A-6A09-478F-8C8C-586C8C5FDF26}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{81E1B68A-6C7D-4EC9-8529-8606FE83F0B7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{476559D2-CB17-4B32-B38C-7B526FE391AA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{D73851FF-83EB-4C9C-BD31-7F7D694EFC2A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{3E827901-0448-4FE9-B90E-1F8F628B5FB1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{895C6AE3-8596-4FF4-BBB3-4710C1D122A3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{E185708C-E93B-444C-9CF4-1ADA4CAFEC1D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{D0E163AD-9377-4C12-B8AA-E6B0F5C02593}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{F155FD37-3B77-4263-8212-C32F59008E32}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{3967DDE6-A22A-4FDF-BA75-FBB1D99B040F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{EF2BE7ED-9D00-405A-9C96-691C43EF6A3C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{02B903EA-D51C-4576-A201-C0F5BED77D73}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{524DCFF7-4F55-4C96-866B-E2A9DF7E3AD7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{1C666223-0853-44D4-9944-2BD214E7B363}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{ABC2A61B-BDF5-47CB-A8AD-C689C28FA243}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{6B46B987-C168-40B1-B9E3-0FB0CD9CEB91}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{6026D97A-940D-4193-AF10-908C3B5FB15E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{24C574A0-11F3-4AB0-B868-6D45381A3882}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{AE4CAD5D-9D5E-466A-9F69-90A11D8F7050}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{E7CBFAB4-6228-4817-9062-BF412EFFF385}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{A88BCB68-8CBC-48FD-AE7D-7ACD6BDB0856}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{C52C6996-5A9D-49AC-8844-1D005BCD06D8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{BE168F88-BBAB-42AA-9BC2-7A00A38AEFC3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{0CCBBB82-5C13-40B2-9FAF-83E9C0F18809}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{903FA5C0-10D0-402D-A351-A39ABD94A844}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{83769634-9E05-48CC-881B-367A162FD5FD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{35F83222-5D10-4DD1-ABE8-C0D64D8FA303}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{57E94FBC-D8B9-423B-9399-D6FFCF7222C0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{72B75E8C-FBCC-4725-8974-99F510AEEC8C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{7FCBAA10-7E88-4B08-96EA-5389174E3536}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{414743EB-E354-4EE3-8F1B-83BCB6AF3E3F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{10C24852-F1D3-4A69-8732-3A03ABA68FE2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{66CCC38E-D659-489F-917A-013E10B04B43}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{04665462-E964-4115-A4A0-B8114205C6B3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{72FB5EB5-D309-427F-8F2A-597BCF693C4D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{686B8EC2-3800-453E-A5D8-ACE2518B1077}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{E5A48862-732A-46DC-BD53-59AAD3FF3801}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{4DE18C5E-4226-458A-95F3-0C3C7C12DBFB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{B3AB6FDD-4646-4424-93FD-20A0DBA1BB53}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{637202BF-D741-4A1E-96C1-B0A096F2DC6E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "{70D6FACD-0221-405E-8F90-C0ED8AFC6965}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "", "langPack", "DVA", "Adobe Audition", "")
INSERT INTO Payloads VALUES	("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "DVA", "Adobe Audition_AdobeAudition4it_ITLanguagePack", "9", "langPack")
INSERT INTO PayloadData VALUES("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "0" , "PayloadInfo", '<PayloadInfo version="4.0.19.0"><BuildInfo>
    <Property name="Created">2011-03-24 13:26:39.214000</Property>
    <Property name="TargetName">AdobeAudition4it_ITLanguagePack</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{8A144389-1133-4D18-9602-23F64D4A3DE6}</Property>
    <Property name="ProductName">Adobe Audition CS5.5 LangPack (it_IT) </Property>
    <Property name="ProductVersion">9</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
  </InstallDir><Languages>
    <Language>it_IT</Language>
  </Languages><Satisfies>
    <ProductInfo>
		<Family>DVA</Family>
		<ProductName>Adobe Audition_AdobeAudition4it_ITLanguagePack</ProductName>
	<ProductVersion>9</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{42529100-4B21-4373-B900-F60EDD6A7379}</AdobeCode>
  </Upgrades><Conflicts>
    <AdobeCode>{2E82C9A3-4222-44CF-A920-98DEDF0A4B9F}</AdobeCode>
    <AdobeCode>{96C93D82-20F4-4D4A-89A4-03B72AAC1212}</AdobeCode>
    <AdobeCode>{D13C65B3-8E5B-4F58-8CBF-67299578B9A4}</AdobeCode>
    <AdobeCode>{B5856C74-57DE-4713-B741-1FC512C81713}</AdobeCode>
    <AdobeCode>{35093B70-5BC7-42EC-B41B-0E699BA5B85A}</AdobeCode>
    <AdobeCode>{F4628710-49AB-403A-8D3C-79FE605CAC53}</AdobeCode>
    <AdobeCode>{B07E6A99-CDBD-47F3-9C08-C7BA30E96E53}</AdobeCode>
    <AdobeCode>{CDCF6BE3-E0A0-42BA-B651-2C6636C3F01E}</AdobeCode>
    <AdobeCode>{6FBAF106-AE30-46C7-8211-7B2C1D73C4F5}</AdobeCode>
    <AdobeCode>{E9952741-EB2D-448C-8FFD-15A9BB986B14}</AdobeCode>
    <AdobeCode>{D1F8EF17-0B26-46E3-8C19-74E0915C66F5}</AdobeCode>
    <AdobeCode>{D0D4BF4C-28DF-488E-BCD2-3E3083D6EE75}</AdobeCode>
    <AdobeCode>{930A1EE5-1A3E-47AD-BBEF-C8FE39072ADA}</AdobeCode>
    <AdobeCode>{6E8D3EB8-4622-408A-97A5-EBBB3912B966}</AdobeCode>
    <AdobeCode>{EA5594B0-CAC8-4A4E-8E91-7078BB8501C5}</AdobeCode>
    <AdobeCode>{A6861241-1522-44C7-A5F9-6F36B3EAC0F6}</AdobeCode>
    <AdobeCode>{A0886F7C-BC80-49C6-A032-E0A7EC845F17}</AdobeCode>
    <AdobeCode>{442DABEE-988C-4939-8C4D-C9321308BAE2}</AdobeCode>
    <AdobeCode>{4D5542AC-4F78-4E47-A4F1-DA8AF22C9344}</AdobeCode>
    <AdobeCode>{87CA4FEF-0729-4AC6-8D8C-54D82B084CD3}</AdobeCode>
    <AdobeCode>{AF56850B-8254-4661-8050-7DAF7E8441A6}</AdobeCode>
    <AdobeCode>{97FB28C6-B9DB-40F2-80D8-81FB184311E4}</AdobeCode>
    <AdobeCode>{57E7B8E0-F787-4490-A4D9-83F9FE6D5F2C}</AdobeCode>
    <AdobeCode>{1CA66754-7762-4D04-AB46-1C7621810CE8}</AdobeCode>
    <AdobeCode>{E7382D3D-5DEB-4F57-9537-6212C8B6CE7A}</AdobeCode>
    <AdobeCode>{88F86EC0-E0FB-4A39-BA95-3C71DB73EAF0}</AdobeCode>
    <AdobeCode>{FDE507D3-46F2-42DE-90CC-C8B2E1210FFA}</AdobeCode>
    <AdobeCode>{9E01A48F-A5CC-4736-9EED-7C2C510C32A2}</AdobeCode>
    <AdobeCode>{03771831-AE4A-439A-8C85-B8656AFD9DE2}</AdobeCode>
    <AdobeCode>{0F79377C-1A0C-497C-83BC-F424C04CE899}</AdobeCode>
    <AdobeCode>{B28119EB-DF36-47B1-97A5-5407D429D09F}</AdobeCode>
    <AdobeCode>{E0841A26-3C0B-46F8-83BA-9BD60ABB8148}</AdobeCode>
    <AdobeCode>{B040CBEE-E6BE-4491-96A6-B45E09973D32}</AdobeCode>
    <AdobeCode>{F2D37D0E-B8D1-4F78-8528-5A27C5394EC8}</AdobeCode>
    <AdobeCode>{549943C5-52B3-4D34-8CE8-195C19633CCB}</AdobeCode>
    <AdobeCode>{3C367983-8EF6-401C-AE47-2214FFEB7B14}</AdobeCode>
    <AdobeCode>{A72D5B56-1BD1-41E3-90D8-9875F01F6490}</AdobeCode>
    <AdobeCode>{123BC4F7-E5E6-4B65-96C0-C6FCB0F5A487}</AdobeCode>
    <AdobeCode>{963BE6BF-CD99-49DB-876A-FEC468E42C32}</AdobeCode>
    <AdobeCode>{28B53929-2664-4186-B7E6-5D2B10381767}</AdobeCode>
    <AdobeCode>{CA52F770-17AE-4440-B977-D8BC4EFAA21F}</AdobeCode>
    <AdobeCode>{5C52359B-15E6-4D3D-8446-BA82947609EF}</AdobeCode>
    <AdobeCode>{C6BC84AF-619D-44EA-AE58-B0E7724684E1}</AdobeCode>
    <AdobeCode>{1C0CAE0F-C07E-4E1A-AEEE-299D47470107}</AdobeCode>
    <AdobeCode>{CB641D72-35EE-4AE6-B2AE-61A99FB561B0}</AdobeCode>
    <AdobeCode>{9728737A-C6EF-4FC3-81DE-A8DAD202E3E4}</AdobeCode>
    <AdobeCode>{038B6236-B9F4-4142-A5ED-6D6B480859AD}</AdobeCode>
    <AdobeCode>{126433E5-6FF3-4E59-A913-D495F21EE182}</AdobeCode>
    <AdobeCode>{8C7BDA68-AFF7-4DB0-B928-247378F9A28C}</AdobeCode>
    <AdobeCode>{84354EC6-3540-48AA-B577-56E0BD85473B}</AdobeCode>
    <AdobeCode>{139A1B88-D0FB-4969-8799-DF6B1A6E7666}</AdobeCode>
    <AdobeCode>{84C98B95-AAC0-4916-BE5A-33FA6DB4E8F5}</AdobeCode>
    <AdobeCode>{B8E73F26-6BF3-4B6B-BBE9-633C83241910}</AdobeCode>
    <AdobeCode>{7F56ADB8-E7D0-423C-8978-9672D4034C81}</AdobeCode>
    <AdobeCode>{D492FA67-D02A-4503-BE97-F61BE059EDA0}</AdobeCode>
    <AdobeCode>{56618C8F-7BF2-4ECF-8CCA-885D5F9243AB}</AdobeCode>
    <AdobeCode>{F5A321E7-3A7B-43D1-B3F0-929523657999}</AdobeCode>
    <AdobeCode>{37625CB0-8155-4E53-8DEE-1AAE7933A7E8}</AdobeCode>
    <AdobeCode>{62FA6952-438D-4234-B370-CD0BFCC84BA8}</AdobeCode>
    <AdobeCode>{870844F7-A2B3-4B99-AD8C-11CC5940CDB6}</AdobeCode>
    <AdobeCode>{5F48E5D4-142F-499F-9297-B2555116FDE9}</AdobeCode>
    <AdobeCode>{0BF756C4-3AC5-43D7-8027-188DF6C259D8}</AdobeCode>
    <AdobeCode>{5F70EDB2-1EE2-4DE7-8D1C-3E56D040CB5A}</AdobeCode>
    <AdobeCode>{FDB5D22C-A8B4-42C0-B696-43B1B68D6464}</AdobeCode>
    <AdobeCode>{25E21DE8-19E3-4AEC-A9C0-1D5D1E391997}</AdobeCode>
    <AdobeCode>{7EEF9BC5-27B0-4FF3-892F-317117A0EA1B}</AdobeCode>
    <AdobeCode>{8DC786FA-52F0-4D37-82C4-9BE3A5B75560}</AdobeCode>
    <AdobeCode>{B0F9CDEC-B41C-4F23-B19E-A9B2BE9E54FE}</AdobeCode>
    <AdobeCode>{F0F3329F-57B8-42CA-9D35-85E5C59EE20D}</AdobeCode>
    <AdobeCode>{AEFD1B93-ED5E-456D-A328-7944027CE921}</AdobeCode>
    <AdobeCode>{EEBEDBCD-3729-45D9-87D6-10E6309FD849}</AdobeCode>
    <AdobeCode>{40C760B3-1D33-4644-9A7E-FD570B3E6588}</AdobeCode>
    <AdobeCode>{24340B05-7D67-40B7-9E74-E0FDE2F34454}</AdobeCode>
    <AdobeCode>{E12AA819-FC40-4947-8D71-4524B30FFAB4}</AdobeCode>
    <AdobeCode>{15448C2C-BED7-4AD5-A2C8-FD940D464760}</AdobeCode>
    <AdobeCode>{6725F423-95A0-4A95-BAA3-AF96644E229B}</AdobeCode>
    <AdobeCode>{E7B1AC39-4A3F-4F68-963E-9E2DEE29DD89}</AdobeCode>
    <AdobeCode>{1D21FFB6-B28F-4A35-A0BE-9F8B88002917}</AdobeCode>
    <AdobeCode>{A20BBB36-7614-4BF5-A2A0-85E31171DDB4}</AdobeCode>
    <AdobeCode>{8504DDCA-940A-466F-B661-99B1C84BCC64}</AdobeCode>
    <AdobeCode>{8C9AA3BE-3E34-4137-A5C6-58878310A602}</AdobeCode>
    <AdobeCode>{D6279DB2-DAF6-4D99-986C-0662462C54AD}</AdobeCode>
    <AdobeCode>{0098AF03-9BD0-473C-B8C3-35EC8A2C7BE4}</AdobeCode>
    <AdobeCode>{D24ADF72-B345-4538-8E3B-DFB027955428}</AdobeCode>
    <AdobeCode>{924DC610-2F53-4231-BE5D-30CFC8EE4614}</AdobeCode>
    <AdobeCode>{A9957233-FED9-4D7C-9963-1FB994B64D63}</AdobeCode>
    <AdobeCode>{2E33436C-4E64-4965-9F6E-6F2835149FE1}</AdobeCode>
    <AdobeCode>{E4264F4F-A868-4094-B6B2-45FF26D872E2}</AdobeCode>
    <AdobeCode>{23C49143-0F0B-440C-9064-3096FF54EC1E}</AdobeCode>
    <AdobeCode>{761643CB-4B4A-4E69-B9DC-100B79236727}</AdobeCode>
    <AdobeCode>{8534A797-37FD-44E8-A7AF-E3D49FEC3D5B}</AdobeCode>
    <AdobeCode>{4C8DC7E2-07B9-42FB-8FD5-BCAB1B200422}</AdobeCode>
    <AdobeCode>{5003CAC3-618A-48E3-BB6F-F0CEE4729734}</AdobeCode>
    <AdobeCode>{71A752A0-8197-471A-A149-7D95C8A54D57}</AdobeCode>
    <AdobeCode>{3BBCBE21-5E63-4CF2-A541-4CFF7D192602}</AdobeCode>
    <AdobeCode>{D0AF7F3B-80DF-4431-8AF2-C033B99A4C2E}</AdobeCode>
    <AdobeCode>{4D8A228C-A081-4C57-9118-5B2DA90C4E1F}</AdobeCode>
    <AdobeCode>{0A64F1B4-8A37-4667-BF41-0DE0F443F7DC}</AdobeCode>
    <AdobeCode>{05D4134B-F1EF-4700-88C0-9416D3F96C87}</AdobeCode>
    <AdobeCode>{B406A115-02D4-4C66-88ED-74CE21E8AA6C}</AdobeCode>
    <AdobeCode>{39FE0AF5-4B35-4F9D-8BD0-6B95F57C1171}</AdobeCode>
    <AdobeCode>{0BC369A3-AA37-40A6-A531-5D3A679EEA4D}</AdobeCode>
    <AdobeCode>{81385055-9409-429F-9F38-763EA3786201}</AdobeCode>
    <AdobeCode>{D89E6968-2C50-4ECD-BBD3-0E7A58A9723C}</AdobeCode>
    <AdobeCode>{76B94429-BF94-4287-BC54-BBD44A56DD07}</AdobeCode>
    <AdobeCode>{08723C05-473C-4028-8D07-EFC5362C7CD5}</AdobeCode>
    <AdobeCode>{F94BE657-1200-4590-BEBE-1DB309432349}</AdobeCode>
    <AdobeCode>{B4FA75CD-65F1-4AA0-AD4B-0CC528F658D8}</AdobeCode>
    <AdobeCode>{F5F8365B-601C-4FB6-8CFA-74F2F1D980EF}</AdobeCode>
    <AdobeCode>{6263E3C8-8526-4AF3-8CDA-7C5B0DA7D6FB}</AdobeCode>
    <AdobeCode>{F4122F72-C0BE-4346-9693-69A475ECDE8F}</AdobeCode>
    <AdobeCode>{46191BCB-2DBA-4850-8D62-56DB288DCE8E}</AdobeCode>
    <AdobeCode>{8C5ABF4F-A756-4C18-B089-5038843329A9}</AdobeCode>
    <AdobeCode>{367B205E-AEE2-49C2-96CF-8CFC94A2843B}</AdobeCode>
    <AdobeCode>{9ACDED01-B66B-483C-9D8B-EAE56216BA07}</AdobeCode>
    <AdobeCode>{C9A4C0CD-2955-4A5C-B467-E52C053A0A4E}</AdobeCode>
    <AdobeCode>{1738F108-20B0-4016-AAF9-AFFB128F437C}</AdobeCode>
    <AdobeCode>{2495F492-313E-4C45-99FE-BCCC1EFB46AC}</AdobeCode>
    <AdobeCode>{40AE3784-EBD5-4705-A99F-600F7510786B}</AdobeCode>
    <AdobeCode>{ABC7CE8D-1F6E-4571-843E-44DD48652584}</AdobeCode>
    <AdobeCode>{E2C14240-0326-43A2-864E-D9A942563752}</AdobeCode>
    <AdobeCode>{9AA6D2F1-ECDC-408E-878F-DB1A079B3FD3}</AdobeCode>
    <AdobeCode>{54F7B4A0-ACCF-414A-98B4-906E437F471A}</AdobeCode>
    <AdobeCode>{A601D1AC-62DD-4E36-B10C-921CCA56A679}</AdobeCode>
    <AdobeCode>{36315F2C-11E6-4950-846C-DDC538A793C3}</AdobeCode>
    <AdobeCode>{3AE262CC-C111-4B92-9466-A173333B6413}</AdobeCode>
    <AdobeCode>{2A7C829B-9B98-4D71-8828-1E14D5CD391C}</AdobeCode>
    <AdobeCode>{196B9D6A-CC7B-49E0-87D1-6E2B3DBB87FF}</AdobeCode>
    <AdobeCode>{AB9FF29A-6A09-478F-8C8C-586C8C5FDF26}</AdobeCode>
    <AdobeCode>{81E1B68A-6C7D-4EC9-8529-8606FE83F0B7}</AdobeCode>
    <AdobeCode>{476559D2-CB17-4B32-B38C-7B526FE391AA}</AdobeCode>
    <AdobeCode>{D73851FF-83EB-4C9C-BD31-7F7D694EFC2A}</AdobeCode>
    <AdobeCode>{3E827901-0448-4FE9-B90E-1F8F628B5FB1}</AdobeCode>
    <AdobeCode>{895C6AE3-8596-4FF4-BBB3-4710C1D122A3}</AdobeCode>
    <AdobeCode>{E185708C-E93B-444C-9CF4-1ADA4CAFEC1D}</AdobeCode>
    <AdobeCode>{D0E163AD-9377-4C12-B8AA-E6B0F5C02593}</AdobeCode>
    <AdobeCode>{F155FD37-3B77-4263-8212-C32F59008E32}</AdobeCode>
    <AdobeCode>{3967DDE6-A22A-4FDF-BA75-FBB1D99B040F}</AdobeCode>
    <AdobeCode>{EF2BE7ED-9D00-405A-9C96-691C43EF6A3C}</AdobeCode>
    <AdobeCode>{02B903EA-D51C-4576-A201-C0F5BED77D73}</AdobeCode>
    <AdobeCode>{524DCFF7-4F55-4C96-866B-E2A9DF7E3AD7}</AdobeCode>
    <AdobeCode>{1C666223-0853-44D4-9944-2BD214E7B363}</AdobeCode>
    <AdobeCode>{ABC2A61B-BDF5-47CB-A8AD-C689C28FA243}</AdobeCode>
    <AdobeCode>{6B46B987-C168-40B1-B9E3-0FB0CD9CEB91}</AdobeCode>
    <AdobeCode>{6026D97A-940D-4193-AF10-908C3B5FB15E}</AdobeCode>
    <AdobeCode>{24C574A0-11F3-4AB0-B868-6D45381A3882}</AdobeCode>
    <AdobeCode>{AE4CAD5D-9D5E-466A-9F69-90A11D8F7050}</AdobeCode>
    <AdobeCode>{E7CBFAB4-6228-4817-9062-BF412EFFF385}</AdobeCode>
    <AdobeCode>{A88BCB68-8CBC-48FD-AE7D-7ACD6BDB0856}</AdobeCode>
    <AdobeCode>{C52C6996-5A9D-49AC-8844-1D005BCD06D8}</AdobeCode>
    <AdobeCode>{BE168F88-BBAB-42AA-9BC2-7A00A38AEFC3}</AdobeCode>
    <AdobeCode>{0CCBBB82-5C13-40B2-9FAF-83E9C0F18809}</AdobeCode>
    <AdobeCode>{903FA5C0-10D0-402D-A351-A39ABD94A844}</AdobeCode>
    <AdobeCode>{83769634-9E05-48CC-881B-367A162FD5FD}</AdobeCode>
    <AdobeCode>{35F83222-5D10-4DD1-ABE8-C0D64D8FA303}</AdobeCode>
    <AdobeCode>{57E94FBC-D8B9-423B-9399-D6FFCF7222C0}</AdobeCode>
    <AdobeCode>{72B75E8C-FBCC-4725-8974-99F510AEEC8C}</AdobeCode>
    <AdobeCode>{7FCBAA10-7E88-4B08-96EA-5389174E3536}</AdobeCode>
    <AdobeCode>{414743EB-E354-4EE3-8F1B-83BCB6AF3E3F}</AdobeCode>
    <AdobeCode>{10C24852-F1D3-4A69-8732-3A03ABA68FE2}</AdobeCode>
    <AdobeCode>{66CCC38E-D659-489F-917A-013E10B04B43}</AdobeCode>
    <AdobeCode>{04665462-E964-4115-A4A0-B8114205C6B3}</AdobeCode>
    <AdobeCode>{72FB5EB5-D309-427F-8F2A-597BCF693C4D}</AdobeCode>
    <AdobeCode>{686B8EC2-3800-453E-A5D8-ACE2518B1077}</AdobeCode>
    <AdobeCode>{E5A48862-732A-46DC-BD53-59AAD3FF3801}</AdobeCode>
    <AdobeCode>{4DE18C5E-4226-458A-95F3-0C3C7C12DBFB}</AdobeCode>
    <AdobeCode>{B3AB6FDD-4646-4424-93FD-20A0DBA1BB53}</AdobeCode>
    <AdobeCode>{637202BF-D741-4A1E-96C1-B0A096F2DC6E}</AdobeCode>
    <AdobeCode>{70D6FACD-0221-405E-8F90-C0ED8AFC6965}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeAuditionCS5.5LangPackit_IT-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (it_IT) </DisplayName>
  </Channel><Extends type="langPack">
    <ParentProductInfo>
					<Family>DVA</Family>
					<ProductName>Adobe Audition</ProductName>
				</ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="0" sysDriveSize="784"><Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>784</TotalSize>
      <MaxPathComponent>/HelpCfg/it_IT\Audition_4.0.helpcfg</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="784"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="it_IT">9</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="it_IT">Adobe Audition CS5.5 LangPack (it_IT) </Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "0", "ChannelID", "AdobeAuditionCS5.5LangPackit_IT-9")
INSERT INTO PayloadData VALUES("{8A144389-1133-4D18-9602-23F64D4A3DE6}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeAuditionCS5.5LangPackit_IT-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (it_IT) </DisplayName>
  </Channel>')
