CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{638585FB-FC32-4DDD-B9BD-D260EBB0B2C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{92C54407-A468-46DB-9A4B-C5273CB1380D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{76D4FDFE-5273-4D21-ABAD-8C208F234488}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{6F4F28D5-E600-46D5-96F5-1A67252F113E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{1378256C-1A12-47B4-BDB9-5EA435B0A239}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{9035CED1-80BD-4537-8D78-E00697B95E08}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{91CF00CF-2E06-40D6-B581-6EA047819653}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{9AEA2397-CFAE-4D0A-838E-CDEF5575C226}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{ABFD0B7A-C5E5-4447-8806-4DF1302822F0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{0D694AE9-A29B-48AC-B7C5-52E0DC080F39}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{10449AC4-1E7D-410C-B84A-1193170FBEAB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{05FF5347-2C7E-4F3B-8C19-93C4A81CA852}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{EAD4D819-DB17-41A6-BB8E-7929D106FC2C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{814A9F8B-9932-42D1-9F41-9055FFC05869}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{43CE177B-AE6A-461E-8A55-E09971E99D87}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{01723633-742C-4569-B1C1-BFB4D35741CC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{B42507AD-01BA-40AC-9B50-188146865FE9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{0C5B5BB6-F7AB-4C8F-BF18-167D7FB43919}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{3B559CB2-F3C3-463A-9ADB-86B5563ADD1B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{5F4926C9-B298-4594-951D-E495B4EB2EA4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{8652E7D7-2B49-4045-9CA7-BD8007114BE7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{9A4EBCB0-9599-4A16-AF4F-53DD99CBD259}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{025EA8B6-72DD-4360-97A1-93E469C33B44}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{FB4F93E5-C7F5-4AF5-8D24-C602D03B2478}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{A60F70D6-9789-4AB2-A2FC-989428FC038B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F3F32844-9A06-4987-9C36-B1D4F2EF41D1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{3644B64B-EA49-4D19-B931-100690EBA56F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{9A83E74E-4398-472D-BFB9-D45A1C9D406F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{DE0040BB-1B30-4437-8E2A-9271CE74930A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{CD1FD112-2DDC-4DF2-A1AA-5C1E41EABFFE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{547CF276-3B92-47B9-B0D6-808E3390EB81}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{48C69090-6EAC-4A96-B324-6CFC0891A44E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{628DA208-E521-42E7-89DE-BA6B098D8C5B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{E933C4F9-4BB6-4CCD-96C4-AFF6703026B3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{97D44683-E3B4-4D5A-8FF2-AA8759E46EDD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{54624548-81DC-4BE8-9A07-6EA6D7B37E17}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{167554B1-ED65-459E-A52A-FF4F7142D0B7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{6EFA0FDB-DC1A-4811-9D1B-CD2C5DB18A05}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{AEDA48C7-F815-4FA8-8767-47EB20971B83}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{E06C0A58-0C9E-45E2-AB4B-F2FDD682F744}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{785187D3-DE0C-4034-A4EF-110AAA88D3E6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{C5A7F849-9F8F-4B01-A665-006CCC13AC98}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{5ED2D136-82DC-44E1-B3C1-630575561AE5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{75230C1E-6FCD-47E5-B85C-3214B47FB5CD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{1E9FA2E7-30B0-42F8-BD20-44A8F773BA32}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{18376E5D-102C-4034-A2FD-0EA6C9A94A46}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{7B709CB9-BA73-44F9-BCC2-5FE49BF913D3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{DD56B7B9-F85F-4ED2-92A0-775CD9DF07B3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{CFCC7198-080D-42F1-9423-151835D08805}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{05FA1C2A-2E93-4103-A076-40514C8B530F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{AE6899D3-8AA0-4F2A-86FC-DBB3BD17B769}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{2C46E868-DA0F-4870-9D12-F12371E1FAD5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{58C8FEE3-50D4-476B-BF88-010A7FA7C8A4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{959298E2-772F-4DD8-B2DE-F32355BA3001}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{AD47AC44-ADED-4E65-B0F2-6E80AE95A11B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F22C6298-6BF0-40D1-9096-8B5347C22415}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{64D9C31F-6928-4874-9001-2FC8A86F9786}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{CF2D20CB-C2BA-4BBF-A828-8B2D3DC3B771}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{E6744064-625E-4B93-868D-8C98630DB06B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{2EEC5214-1F32-44F0-A0CE-728B6DD6C062}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{D87C592E-E7A0-4AE0-BD1C-A4A38D44CF55}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{B898B01A-1E82-4683-8B03-AA7FC3C93986}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{72733DE8-4656-4325-8C21-4D848965426D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{57B9044F-95A4-4649-9343-B8E15A701A69}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{D1C7E99B-EC38-4E88-8C6A-C8CF5EA9C08E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F82FFB68-F1F9-4607-A80D-B96701C82D28}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{BA345CFF-A99F-4CB6-8AAF-CC3BB785BA16}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{11833B32-1766-4CD1-B05A-37AD0EEF91B9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{C7DA96BC-643D-4EB7-928E-A44A8F7793E1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{00251C78-B281-49E1-8DB6-DBB66C333E17}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{3F5610BB-FDB3-48C6-9621-D47AF94ABC24}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{1B78B4A3-A5EE-45AE-B892-E59B7C225953}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{A159BDFC-1F4B-46F1-BFEF-EB9CFC18EB33}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{B8A3240D-665F-45C3-9540-425D0B3D463D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{7E2BBC2D-CD1C-4F86-BF3A-DDB7634697EF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{4D412637-F3C9-4CBD-95C2-1DAC29CDEB8D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{A0018A04-5DD4-4A13-AC6F-41B666890B0C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{346219F2-78BE-4BDD-A5E0-53E045A87953}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{DB19B5AC-1FF6-4D83-8EE2-F935B29B4961}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F17B836E-441B-4EA3-8644-F274D4B82AFE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{EAE99C8A-7CF1-4353-A874-3556AC0B4ADB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{FC425441-6DEC-432C-B254-7D33419388F2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{01F69895-8D8E-4DCA-9ABF-A2A0CC0C83B4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{5B5C911E-CA1F-44C9-9C04-554BDE1F6117}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{CF79006D-D347-4C99-B703-9095D2F1A4B7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{428D6FE6-20B5-4A12-9901-0D63FAF1082E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{9C5179CC-A2F6-42A0-A54F-F04C8487E984}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{62A53DF5-4CE0-4D57-AE01-78BD21EC4CCA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{FCAB4D64-E36C-4B34-A5C4-A3073D0F606C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{A59376C6-EF33-4A62-91F1-F4F062BED12E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{7A1B0A46-2BD4-46A5-BD65-83D6C270F708}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{86BBD1E7-658B-4027-92F9-8993C532EF3D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{1F8F8FE3-3E85-4AE9-BAD3-7A1773C2ABEB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F39664C5-923D-47AD-AEE0-19C9B36FDD62}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{8A690CB1-5272-42D7-9590-AFAF5CA0B281}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{281927EE-D553-44FA-8B5F-E778A201C40C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F8DBB926-6A14-472B-B542-E32652828256}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{9A05823D-4862-409A-A420-0927400CBAF9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{E56DDD93-80CF-43BA-A9C3-7E62D9A7A1E9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{26077CA1-E46B-498E-9672-9342BD5154F3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{9E98A4F3-20C2-4873-A96A-B87128FB0ECD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{8AD5FE68-85DE-427A-A0AA-1D7C31707B46}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{D08D0752-58BD-4BAC-A441-EBAAEA56DBC2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{5E51373E-FDA0-4857-BEB9-F2BE9EB1E1F2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{8E9950D8-4CC4-473E-8398-AB7EC06033E3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{7FCCE2B8-11D0-459E-93BD-32CC3013896F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F085A7B5-CB50-4B49-B6EE-E32DDAA62381}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{B228DD66-336E-430F-ABEB-A983CBDB34DB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{9F3624E9-11A4-49D9-9927-D2876C50F1EC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F3853D3D-BDE4-4742-8297-BF107C65F93C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{38A767A7-722C-428A-A2E7-A7729BD7019D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{4A8A8A82-8E98-484C-8605-A8FF9B087E08}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{B3B1754B-D6DA-4CF1-8A70-C4F2161F0B59}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{10AD924C-5904-40C1-B00E-E0BDFDE999F7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{50E79A04-BCB0-4636-87AE-9A92ACC9BAE6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{C635058F-62DD-4CC3-8333-749D217BCF8D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{23BBF3CD-6F68-4D14-8371-0315B487756D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{C9796CF2-6241-42F0-A543-75EC544B782B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{3BB79F55-F6A9-4F2C-A06B-109C274011AE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{3DBEB19B-806D-4BE4-BAEC-FAD929E42ECC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{B1A8CD2C-EE5E-4B62-800B-EB78798E5F04}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{1E76C65D-19C2-4E09-9F61-843986B549B9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{C95ECC0B-710B-4B7F-BC49-B79BA794E8FE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{FB7F231E-6745-4197-8166-933EEEA3E460}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{D37E7916-7DD2-42C4-A81D-545E745D5BA4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{E62A4545-A757-48E3-AAED-EEAA94AFE438}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{ED324EAB-74A9-4E35-A4B0-5F5D1E8E9B61}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F630B8E8-E086-4E52-9D41-19F59288AE17}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{E684480C-1AD5-4131-A3FA-07417B4467E7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{40EE89CD-C9DC-4C06-99F9-C8FB685D596A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{59567653-5632-44EA-BAD0-D008E7856F9E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F0D497A0-DCD4-4CC9-A99C-02DEB449E835}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{501E2D35-48AA-44AC-AE87-0D7F7BCE595B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{465A53CB-027D-4815-A5D3-2C677C31611B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F4293DEB-D626-4B68-B1C3-DC62DCB139CD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{3BC5906A-69FD-4980-9FB0-BD0E07DAD9D8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{C1CC4D8B-8C3C-4824-8F30-69787BD491A6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{AEBC4C54-60CA-4471-9AC7-573CEEC6749B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{BFB6DF83-8691-49B3-A7B7-EE00061E2F48}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{B9B4AD88-EC12-40CC-93FF-703EBB0803D3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{AB1AD497-2EC1-4956-8D07-9894F7B6182F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{FF44DBE8-D36E-46CD-8D67-1D9F58EBABC8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{BC933D7F-B7DE-4374-8A5B-CAF754776670}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{22A1FD18-B4D7-42DF-A539-BEF8E4DEF21A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{1DE1B094-EF61-409A-8941-E540A48D6E35}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{A7642546-22A1-4807-8914-7AA438EA14B4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{8BC09E96-9EBD-4D07-A420-25C9C9009234}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{C83512ED-740F-4786-9371-807BBE284974}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{09A98E74-E5C3-42AD-B119-3D1FF71F36E8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{09423D6F-8575-49DC-8B4F-C29FBD9A9761}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{A51A4CCE-1E51-48AA-AB79-6DED54EA5045}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{8C2A3176-6377-4DF2-BD4D-1F3A6ECC8E4B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{F6779D21-1164-4903-82F3-C32F05FEE668}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{3FDF6DC0-AE1B-409E-9280-76C27F633228}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{8F825B3F-CBC7-4952-A369-E041F2B6A5A9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{A86C24FC-75C5-41D1-9E37-B9C214A7E27F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{FD22CE78-FFE1-4B72-8231-4A9C76FCFEEA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{EF5CE2F2-CC25-4B19-90FC-A8AA1A3F97F3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{7345156C-7885-418C-BF5A-67D87EB055AA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{80F71AC1-3600-453D-B803-2B65C39D3ABC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{BC3138B5-1076-470E-8316-A9C5073D3A49}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{4EDF4A67-2BA6-4668-B8AC-F78345BA3F35}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{531944CD-81D2-405B-8B80-D68F3BA5F2E5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{A646C788-EAB1-4D9C-A1DB-20B40A64B366}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{410CD09D-ED71-4F6D-9971-47E5D21C7645}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{87906982-D514-4A5A-A1F0-3F7F6278BEBA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{70AA9507-A723-4518-AECC-176B99996DA0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{C4904DEE-DABA-4A58-90BB-495B7D2D6AE0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{7CA49B8F-0088-4099-825F-0E757FF14883}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "{375EB43D-C9BB-40D8-941D-44AF6328F170}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "", "langPack", "DVA", "Adobe Audition", "")
INSERT INTO Payloads VALUES	("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "DVA", "Adobe Audition_AdobeAudition4fr_FRLanguagePack", "9", "langPack")
INSERT INTO PayloadData VALUES("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "0" , "PayloadInfo", '<PayloadInfo version="4.0.19.0"><BuildInfo>
    <Property name="Created">2011-03-24 13:26:26.765000</Property>
    <Property name="TargetName">AdobeAudition4fr_FRLanguagePack</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}</Property>
    <Property name="ProductName">Adobe Audition CS5.5 LangPack (fr_FR) </Property>
    <Property name="ProductVersion">9</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
  </InstallDir><Languages>
    <Language>fr_FR</Language>
    <Language>fr_CA</Language>
  </Languages><Satisfies>
    <ProductInfo>
		<Family>DVA</Family>
		<ProductName>Adobe Audition_AdobeAudition4fr_FRLanguagePack</ProductName>
	<ProductVersion>9</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{638585FB-FC32-4DDD-B9BD-D260EBB0B2C3}</AdobeCode>
  </Upgrades><Conflicts>
    <AdobeCode>{92C54407-A468-46DB-9A4B-C5273CB1380D}</AdobeCode>
    <AdobeCode>{76D4FDFE-5273-4D21-ABAD-8C208F234488}</AdobeCode>
    <AdobeCode>{6F4F28D5-E600-46D5-96F5-1A67252F113E}</AdobeCode>
    <AdobeCode>{1378256C-1A12-47B4-BDB9-5EA435B0A239}</AdobeCode>
    <AdobeCode>{9035CED1-80BD-4537-8D78-E00697B95E08}</AdobeCode>
    <AdobeCode>{91CF00CF-2E06-40D6-B581-6EA047819653}</AdobeCode>
    <AdobeCode>{9AEA2397-CFAE-4D0A-838E-CDEF5575C226}</AdobeCode>
    <AdobeCode>{ABFD0B7A-C5E5-4447-8806-4DF1302822F0}</AdobeCode>
    <AdobeCode>{0D694AE9-A29B-48AC-B7C5-52E0DC080F39}</AdobeCode>
    <AdobeCode>{10449AC4-1E7D-410C-B84A-1193170FBEAB}</AdobeCode>
    <AdobeCode>{05FF5347-2C7E-4F3B-8C19-93C4A81CA852}</AdobeCode>
    <AdobeCode>{EAD4D819-DB17-41A6-BB8E-7929D106FC2C}</AdobeCode>
    <AdobeCode>{814A9F8B-9932-42D1-9F41-9055FFC05869}</AdobeCode>
    <AdobeCode>{43CE177B-AE6A-461E-8A55-E09971E99D87}</AdobeCode>
    <AdobeCode>{01723633-742C-4569-B1C1-BFB4D35741CC}</AdobeCode>
    <AdobeCode>{B42507AD-01BA-40AC-9B50-188146865FE9}</AdobeCode>
    <AdobeCode>{0C5B5BB6-F7AB-4C8F-BF18-167D7FB43919}</AdobeCode>
    <AdobeCode>{3B559CB2-F3C3-463A-9ADB-86B5563ADD1B}</AdobeCode>
    <AdobeCode>{5F4926C9-B298-4594-951D-E495B4EB2EA4}</AdobeCode>
    <AdobeCode>{8652E7D7-2B49-4045-9CA7-BD8007114BE7}</AdobeCode>
    <AdobeCode>{9A4EBCB0-9599-4A16-AF4F-53DD99CBD259}</AdobeCode>
    <AdobeCode>{025EA8B6-72DD-4360-97A1-93E469C33B44}</AdobeCode>
    <AdobeCode>{FB4F93E5-C7F5-4AF5-8D24-C602D03B2478}</AdobeCode>
    <AdobeCode>{A60F70D6-9789-4AB2-A2FC-989428FC038B}</AdobeCode>
    <AdobeCode>{F3F32844-9A06-4987-9C36-B1D4F2EF41D1}</AdobeCode>
    <AdobeCode>{3644B64B-EA49-4D19-B931-100690EBA56F}</AdobeCode>
    <AdobeCode>{9A83E74E-4398-472D-BFB9-D45A1C9D406F}</AdobeCode>
    <AdobeCode>{DE0040BB-1B30-4437-8E2A-9271CE74930A}</AdobeCode>
    <AdobeCode>{CD1FD112-2DDC-4DF2-A1AA-5C1E41EABFFE}</AdobeCode>
    <AdobeCode>{547CF276-3B92-47B9-B0D6-808E3390EB81}</AdobeCode>
    <AdobeCode>{48C69090-6EAC-4A96-B324-6CFC0891A44E}</AdobeCode>
    <AdobeCode>{628DA208-E521-42E7-89DE-BA6B098D8C5B}</AdobeCode>
    <AdobeCode>{E933C4F9-4BB6-4CCD-96C4-AFF6703026B3}</AdobeCode>
    <AdobeCode>{97D44683-E3B4-4D5A-8FF2-AA8759E46EDD}</AdobeCode>
    <AdobeCode>{54624548-81DC-4BE8-9A07-6EA6D7B37E17}</AdobeCode>
    <AdobeCode>{167554B1-ED65-459E-A52A-FF4F7142D0B7}</AdobeCode>
    <AdobeCode>{6EFA0FDB-DC1A-4811-9D1B-CD2C5DB18A05}</AdobeCode>
    <AdobeCode>{AEDA48C7-F815-4FA8-8767-47EB20971B83}</AdobeCode>
    <AdobeCode>{E06C0A58-0C9E-45E2-AB4B-F2FDD682F744}</AdobeCode>
    <AdobeCode>{785187D3-DE0C-4034-A4EF-110AAA88D3E6}</AdobeCode>
    <AdobeCode>{C5A7F849-9F8F-4B01-A665-006CCC13AC98}</AdobeCode>
    <AdobeCode>{5ED2D136-82DC-44E1-B3C1-630575561AE5}</AdobeCode>
    <AdobeCode>{75230C1E-6FCD-47E5-B85C-3214B47FB5CD}</AdobeCode>
    <AdobeCode>{1E9FA2E7-30B0-42F8-BD20-44A8F773BA32}</AdobeCode>
    <AdobeCode>{18376E5D-102C-4034-A2FD-0EA6C9A94A46}</AdobeCode>
    <AdobeCode>{7B709CB9-BA73-44F9-BCC2-5FE49BF913D3}</AdobeCode>
    <AdobeCode>{DD56B7B9-F85F-4ED2-92A0-775CD9DF07B3}</AdobeCode>
    <AdobeCode>{CFCC7198-080D-42F1-9423-151835D08805}</AdobeCode>
    <AdobeCode>{05FA1C2A-2E93-4103-A076-40514C8B530F}</AdobeCode>
    <AdobeCode>{AE6899D3-8AA0-4F2A-86FC-DBB3BD17B769}</AdobeCode>
    <AdobeCode>{2C46E868-DA0F-4870-9D12-F12371E1FAD5}</AdobeCode>
    <AdobeCode>{58C8FEE3-50D4-476B-BF88-010A7FA7C8A4}</AdobeCode>
    <AdobeCode>{959298E2-772F-4DD8-B2DE-F32355BA3001}</AdobeCode>
    <AdobeCode>{AD47AC44-ADED-4E65-B0F2-6E80AE95A11B}</AdobeCode>
    <AdobeCode>{F22C6298-6BF0-40D1-9096-8B5347C22415}</AdobeCode>
    <AdobeCode>{64D9C31F-6928-4874-9001-2FC8A86F9786}</AdobeCode>
    <AdobeCode>{CF2D20CB-C2BA-4BBF-A828-8B2D3DC3B771}</AdobeCode>
    <AdobeCode>{E6744064-625E-4B93-868D-8C98630DB06B}</AdobeCode>
    <AdobeCode>{2EEC5214-1F32-44F0-A0CE-728B6DD6C062}</AdobeCode>
    <AdobeCode>{D87C592E-E7A0-4AE0-BD1C-A4A38D44CF55}</AdobeCode>
    <AdobeCode>{B898B01A-1E82-4683-8B03-AA7FC3C93986}</AdobeCode>
    <AdobeCode>{72733DE8-4656-4325-8C21-4D848965426D}</AdobeCode>
    <AdobeCode>{57B9044F-95A4-4649-9343-B8E15A701A69}</AdobeCode>
    <AdobeCode>{D1C7E99B-EC38-4E88-8C6A-C8CF5EA9C08E}</AdobeCode>
    <AdobeCode>{F82FFB68-F1F9-4607-A80D-B96701C82D28}</AdobeCode>
    <AdobeCode>{BA345CFF-A99F-4CB6-8AAF-CC3BB785BA16}</AdobeCode>
    <AdobeCode>{11833B32-1766-4CD1-B05A-37AD0EEF91B9}</AdobeCode>
    <AdobeCode>{C7DA96BC-643D-4EB7-928E-A44A8F7793E1}</AdobeCode>
    <AdobeCode>{00251C78-B281-49E1-8DB6-DBB66C333E17}</AdobeCode>
    <AdobeCode>{3F5610BB-FDB3-48C6-9621-D47AF94ABC24}</AdobeCode>
    <AdobeCode>{1B78B4A3-A5EE-45AE-B892-E59B7C225953}</AdobeCode>
    <AdobeCode>{A159BDFC-1F4B-46F1-BFEF-EB9CFC18EB33}</AdobeCode>
    <AdobeCode>{B8A3240D-665F-45C3-9540-425D0B3D463D}</AdobeCode>
    <AdobeCode>{7E2BBC2D-CD1C-4F86-BF3A-DDB7634697EF}</AdobeCode>
    <AdobeCode>{4D412637-F3C9-4CBD-95C2-1DAC29CDEB8D}</AdobeCode>
    <AdobeCode>{A0018A04-5DD4-4A13-AC6F-41B666890B0C}</AdobeCode>
    <AdobeCode>{346219F2-78BE-4BDD-A5E0-53E045A87953}</AdobeCode>
    <AdobeCode>{DB19B5AC-1FF6-4D83-8EE2-F935B29B4961}</AdobeCode>
    <AdobeCode>{F17B836E-441B-4EA3-8644-F274D4B82AFE}</AdobeCode>
    <AdobeCode>{EAE99C8A-7CF1-4353-A874-3556AC0B4ADB}</AdobeCode>
    <AdobeCode>{FC425441-6DEC-432C-B254-7D33419388F2}</AdobeCode>
    <AdobeCode>{01F69895-8D8E-4DCA-9ABF-A2A0CC0C83B4}</AdobeCode>
    <AdobeCode>{5B5C911E-CA1F-44C9-9C04-554BDE1F6117}</AdobeCode>
    <AdobeCode>{CF79006D-D347-4C99-B703-9095D2F1A4B7}</AdobeCode>
    <AdobeCode>{428D6FE6-20B5-4A12-9901-0D63FAF1082E}</AdobeCode>
    <AdobeCode>{9C5179CC-A2F6-42A0-A54F-F04C8487E984}</AdobeCode>
    <AdobeCode>{62A53DF5-4CE0-4D57-AE01-78BD21EC4CCA}</AdobeCode>
    <AdobeCode>{FCAB4D64-E36C-4B34-A5C4-A3073D0F606C}</AdobeCode>
    <AdobeCode>{A59376C6-EF33-4A62-91F1-F4F062BED12E}</AdobeCode>
    <AdobeCode>{7A1B0A46-2BD4-46A5-BD65-83D6C270F708}</AdobeCode>
    <AdobeCode>{86BBD1E7-658B-4027-92F9-8993C532EF3D}</AdobeCode>
    <AdobeCode>{1F8F8FE3-3E85-4AE9-BAD3-7A1773C2ABEB}</AdobeCode>
    <AdobeCode>{F39664C5-923D-47AD-AEE0-19C9B36FDD62}</AdobeCode>
    <AdobeCode>{8A690CB1-5272-42D7-9590-AFAF5CA0B281}</AdobeCode>
    <AdobeCode>{281927EE-D553-44FA-8B5F-E778A201C40C}</AdobeCode>
    <AdobeCode>{F8DBB926-6A14-472B-B542-E32652828256}</AdobeCode>
    <AdobeCode>{9A05823D-4862-409A-A420-0927400CBAF9}</AdobeCode>
    <AdobeCode>{E56DDD93-80CF-43BA-A9C3-7E62D9A7A1E9}</AdobeCode>
    <AdobeCode>{26077CA1-E46B-498E-9672-9342BD5154F3}</AdobeCode>
    <AdobeCode>{9E98A4F3-20C2-4873-A96A-B87128FB0ECD}</AdobeCode>
    <AdobeCode>{8AD5FE68-85DE-427A-A0AA-1D7C31707B46}</AdobeCode>
    <AdobeCode>{D08D0752-58BD-4BAC-A441-EBAAEA56DBC2}</AdobeCode>
    <AdobeCode>{5E51373E-FDA0-4857-BEB9-F2BE9EB1E1F2}</AdobeCode>
    <AdobeCode>{8E9950D8-4CC4-473E-8398-AB7EC06033E3}</AdobeCode>
    <AdobeCode>{7FCCE2B8-11D0-459E-93BD-32CC3013896F}</AdobeCode>
    <AdobeCode>{F085A7B5-CB50-4B49-B6EE-E32DDAA62381}</AdobeCode>
    <AdobeCode>{B228DD66-336E-430F-ABEB-A983CBDB34DB}</AdobeCode>
    <AdobeCode>{9F3624E9-11A4-49D9-9927-D2876C50F1EC}</AdobeCode>
    <AdobeCode>{F3853D3D-BDE4-4742-8297-BF107C65F93C}</AdobeCode>
    <AdobeCode>{38A767A7-722C-428A-A2E7-A7729BD7019D}</AdobeCode>
    <AdobeCode>{4A8A8A82-8E98-484C-8605-A8FF9B087E08}</AdobeCode>
    <AdobeCode>{B3B1754B-D6DA-4CF1-8A70-C4F2161F0B59}</AdobeCode>
    <AdobeCode>{10AD924C-5904-40C1-B00E-E0BDFDE999F7}</AdobeCode>
    <AdobeCode>{50E79A04-BCB0-4636-87AE-9A92ACC9BAE6}</AdobeCode>
    <AdobeCode>{C635058F-62DD-4CC3-8333-749D217BCF8D}</AdobeCode>
    <AdobeCode>{23BBF3CD-6F68-4D14-8371-0315B487756D}</AdobeCode>
    <AdobeCode>{C9796CF2-6241-42F0-A543-75EC544B782B}</AdobeCode>
    <AdobeCode>{3BB79F55-F6A9-4F2C-A06B-109C274011AE}</AdobeCode>
    <AdobeCode>{3DBEB19B-806D-4BE4-BAEC-FAD929E42ECC}</AdobeCode>
    <AdobeCode>{B1A8CD2C-EE5E-4B62-800B-EB78798E5F04}</AdobeCode>
    <AdobeCode>{1E76C65D-19C2-4E09-9F61-843986B549B9}</AdobeCode>
    <AdobeCode>{C95ECC0B-710B-4B7F-BC49-B79BA794E8FE}</AdobeCode>
    <AdobeCode>{FB7F231E-6745-4197-8166-933EEEA3E460}</AdobeCode>
    <AdobeCode>{D37E7916-7DD2-42C4-A81D-545E745D5BA4}</AdobeCode>
    <AdobeCode>{E62A4545-A757-48E3-AAED-EEAA94AFE438}</AdobeCode>
    <AdobeCode>{ED324EAB-74A9-4E35-A4B0-5F5D1E8E9B61}</AdobeCode>
    <AdobeCode>{F630B8E8-E086-4E52-9D41-19F59288AE17}</AdobeCode>
    <AdobeCode>{E684480C-1AD5-4131-A3FA-07417B4467E7}</AdobeCode>
    <AdobeCode>{40EE89CD-C9DC-4C06-99F9-C8FB685D596A}</AdobeCode>
    <AdobeCode>{59567653-5632-44EA-BAD0-D008E7856F9E}</AdobeCode>
    <AdobeCode>{F0D497A0-DCD4-4CC9-A99C-02DEB449E835}</AdobeCode>
    <AdobeCode>{501E2D35-48AA-44AC-AE87-0D7F7BCE595B}</AdobeCode>
    <AdobeCode>{465A53CB-027D-4815-A5D3-2C677C31611B}</AdobeCode>
    <AdobeCode>{F4293DEB-D626-4B68-B1C3-DC62DCB139CD}</AdobeCode>
    <AdobeCode>{3BC5906A-69FD-4980-9FB0-BD0E07DAD9D8}</AdobeCode>
    <AdobeCode>{C1CC4D8B-8C3C-4824-8F30-69787BD491A6}</AdobeCode>
    <AdobeCode>{AEBC4C54-60CA-4471-9AC7-573CEEC6749B}</AdobeCode>
    <AdobeCode>{BFB6DF83-8691-49B3-A7B7-EE00061E2F48}</AdobeCode>
    <AdobeCode>{B9B4AD88-EC12-40CC-93FF-703EBB0803D3}</AdobeCode>
    <AdobeCode>{AB1AD497-2EC1-4956-8D07-9894F7B6182F}</AdobeCode>
    <AdobeCode>{FF44DBE8-D36E-46CD-8D67-1D9F58EBABC8}</AdobeCode>
    <AdobeCode>{BC933D7F-B7DE-4374-8A5B-CAF754776670}</AdobeCode>
    <AdobeCode>{22A1FD18-B4D7-42DF-A539-BEF8E4DEF21A}</AdobeCode>
    <AdobeCode>{1DE1B094-EF61-409A-8941-E540A48D6E35}</AdobeCode>
    <AdobeCode>{A7642546-22A1-4807-8914-7AA438EA14B4}</AdobeCode>
    <AdobeCode>{8BC09E96-9EBD-4D07-A420-25C9C9009234}</AdobeCode>
    <AdobeCode>{C83512ED-740F-4786-9371-807BBE284974}</AdobeCode>
    <AdobeCode>{09A98E74-E5C3-42AD-B119-3D1FF71F36E8}</AdobeCode>
    <AdobeCode>{09423D6F-8575-49DC-8B4F-C29FBD9A9761}</AdobeCode>
    <AdobeCode>{A51A4CCE-1E51-48AA-AB79-6DED54EA5045}</AdobeCode>
    <AdobeCode>{8C2A3176-6377-4DF2-BD4D-1F3A6ECC8E4B}</AdobeCode>
    <AdobeCode>{F6779D21-1164-4903-82F3-C32F05FEE668}</AdobeCode>
    <AdobeCode>{3FDF6DC0-AE1B-409E-9280-76C27F633228}</AdobeCode>
    <AdobeCode>{8F825B3F-CBC7-4952-A369-E041F2B6A5A9}</AdobeCode>
    <AdobeCode>{A86C24FC-75C5-41D1-9E37-B9C214A7E27F}</AdobeCode>
    <AdobeCode>{FD22CE78-FFE1-4B72-8231-4A9C76FCFEEA}</AdobeCode>
    <AdobeCode>{EF5CE2F2-CC25-4B19-90FC-A8AA1A3F97F3}</AdobeCode>
    <AdobeCode>{7345156C-7885-418C-BF5A-67D87EB055AA}</AdobeCode>
    <AdobeCode>{80F71AC1-3600-453D-B803-2B65C39D3ABC}</AdobeCode>
    <AdobeCode>{BC3138B5-1076-470E-8316-A9C5073D3A49}</AdobeCode>
    <AdobeCode>{4EDF4A67-2BA6-4668-B8AC-F78345BA3F35}</AdobeCode>
    <AdobeCode>{531944CD-81D2-405B-8B80-D68F3BA5F2E5}</AdobeCode>
    <AdobeCode>{A646C788-EAB1-4D9C-A1DB-20B40A64B366}</AdobeCode>
    <AdobeCode>{410CD09D-ED71-4F6D-9971-47E5D21C7645}</AdobeCode>
    <AdobeCode>{87906982-D514-4A5A-A1F0-3F7F6278BEBA}</AdobeCode>
    <AdobeCode>{70AA9507-A723-4518-AECC-176B99996DA0}</AdobeCode>
    <AdobeCode>{C4904DEE-DABA-4A58-90BB-495B7D2D6AE0}</AdobeCode>
    <AdobeCode>{7CA49B8F-0088-4099-825F-0E757FF14883}</AdobeCode>
    <AdobeCode>{375EB43D-C9BB-40D8-941D-44AF6328F170}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeAuditionCS5.5LangPackfr_FR-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (fr_FR) </DisplayName>
  </Channel><Extends type="langPack">
    <ParentProductInfo>
					<Family>DVA</Family>
					<ProductName>Adobe Audition</ProductName>
				</ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="0" sysDriveSize="786"><Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>786</TotalSize>
      <MaxPathComponent>/HelpCfg/fr_FR\Audition_4.0.helpcfg</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="786"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="fr_FR">9</Value>
      <Value lang="fr_CA">9</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="fr_FR">Adobe Audition CS5.5 LangPack (fr_FR) </Value>
      <Value lang="fr_CA">Adobe Audition CS5.5 LangPack (fr_FR) </Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "0", "ChannelID", "AdobeAuditionCS5.5LangPackfr_FR-9")
INSERT INTO PayloadData VALUES("{33ACD529-5CB3-4602-A7DC-26F38E61F4E1}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeAuditionCS5.5LangPackfr_FR-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (fr_FR) </DisplayName>
  </Channel>')
