CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{7DB32A48-7442-474E-9065-203DD99923AC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{107679C3-B8BA-480A-A82D-AE5F47D840C4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{5041D628-2729-4C4C-A32C-750E19FC7BEF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{76A6BD62-3B0D-4ACA-856E-49287209E187}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{0D961180-7DCC-4FEC-9ECB-C505510E75B9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{C1775DCA-A441-45FB-A0C5-A9F417D38704}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{71945A46-D8B1-4509-8D3B-64B2D1DB5F20}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{465562B9-CBDB-4834-A3C3-8A484ACB1B1A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{9E275B1D-A251-4EE9-A203-85C5A581C030}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{0F8AB347-AF18-42A9-9736-E074A64EA154}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{A147E3A2-28E0-4A77-B24C-357D2B8CD7EB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{0309E1E9-3470-4B24-9DE6-8CDA0FAB7126}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{15596A36-9100-42CE-BAE6-2DDF41D6D401}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{9549D9FB-AFAC-4F74-9738-F234479DF724}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{7F598D47-4596-4C18-92FC-2ECF4F7ABD72}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{46678EDD-C7BB-46FF-8881-83F08FCFDB0A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{BA27E425-F740-4431-A09C-245DB9E73189}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{9D3D4E4F-6840-4B50-85E5-B09FF3F55095}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{8D8CE4DC-8086-4C16-8944-6FAEAD840CA4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{62B7EA08-5F2C-447A-A2F3-A295477F92A3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{424B7CE8-AF57-4F89-82DE-4731EC1946C8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{5654C86B-BB5E-4F78-9F6D-E3F206BCF501}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{10946FCA-9959-4810-992A-F34BD10BDF4D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{068C9EF0-7573-4267-BADC-D8EF2FBB0BC7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{29C873AD-530F-4F80-9E2B-544AEAD23D91}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{A62E2414-7C00-4EFF-A7BF-B060753A2B11}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{9BE46E5F-35B2-4704-9E8A-4D4FD5265583}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{4468D9C9-5CF3-4387-93FC-31954BF3590C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{84CE0A02-6376-4226-9DB7-F85FD751DD50}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{1DD9FF62-D70D-464A-820E-D3488B2FA191}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{EDC7ECE6-5030-4BE9-93D9-5C6DDCB1AFB7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{0EB36299-A40C-4849-A01C-BE41EB8D7F74}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{D321E582-0EFC-4685-BF86-AE7F95AE83E5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{6E7F0A47-6BA8-4340-97B0-C4B730074434}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{5223D6BA-01A8-43A3-AA55-AD94211CE387}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{39B9DF08-B0A7-4E72-A69C-F36D2DB138A4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{0E083D87-8CDC-473A-8022-B9649DF19318}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{91416628-452A-49A8-B6C7-F5FA3E3A5DF3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{39E38413-7A50-4764-B830-541963D26DFE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{28D9D3B8-9F92-48BC-9940-BC3FFDAA42D1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{27D3343F-C7E3-4C43-BDFF-5A8038F7EC81}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{FB772792-8EF1-48D8-8FC1-6AC83AF86CE5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{BE01AB44-66BE-460D-AFF2-5FE569EAAD4F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{10BDACAB-45E9-4E27-B94B-0491E760376E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{EEEF55E8-421B-4ED0-AEC3-B933A7C2934C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{8D1863A3-05B4-4174-B541-BC6766F53E69}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{6315FCAC-7950-4FC2-B96B-2BE9110D3E06}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{72754CAD-5F22-4EF8-8544-949B3024F843}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{2AC01B0D-0DA3-4598-83FB-5B66215F4B7D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{84018A5B-6571-4516-91AA-7D122BECAF94}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{D3E512BF-8BB1-49FF-A195-3474DD76C476}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{8759AFA8-B7DE-4B99-9C4A-9C064B3BEB96}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{1569F477-C584-4072-97D9-6207DB62868E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{2962D45E-C8F4-4B96-9756-346B3246E050}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{9CC9A31D-19F4-4F9C-8306-AA2377928BA1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{48782D71-6B14-4B51-9D27-2C4A79E230D1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{736D1921-6C7B-48D2-B5A3-B378F8B99B47}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{AB51FDFF-0AC2-455C-A3CD-DF7B123F747F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{2D7D20D8-6888-4E45-AE19-778A31E043B3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{3AB706C5-8994-468B-9782-A93EBB1CB28F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{CF5AE487-53E7-4567-BD46-A5297F890E0B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{4311994A-8723-444B-A6AE-7D9FC3A0DC4C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{9985A4A6-A749-4A78-AA76-F2B3D1754DED}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{CEA131D5-2376-449D-92D8-05592B7AC49D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{D42ABC1C-E195-4950-B754-B9B1367595E3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{2B740BBC-93D8-482E-9643-76B851578713}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{0FAF5147-F58D-47FD-9286-938BC560DA32}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{FF6DB29C-8533-4787-8CE9-61451D3AF7C7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{5B9F699B-27A0-442C-89EA-D31CF5C6CE2C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{E7C3DB5D-A5D0-4902-B6D7-AB4B124AC96A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{72B976B5-3EAB-4CE6-8FDB-DA6723EF01AB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{0A0D9E10-7D63-45CC-BE81-726849864B30}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{AD7D7755-913F-48A7-9974-EF8754FAE858}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{ECF699E9-BDBB-4F05-AA74-5E28DC0CA33C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{90D6339F-4D9E-4DBA-ABC7-660625BFC1E0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{B89C7CC0-5735-4DC2-9B66-8359AAB6E1EE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{FE017382-EC33-4941-B20E-7D49F26AE376}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{060DB03C-8882-4C89-BCA5-3F41673428D5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{7D726541-7A7F-476C-87B5-94A4D343886D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{FD025609-14DF-4D98-B02D-48D070E722D9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{7091A1CC-0BC7-4F07-B760-D29C33623B2F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{C1615AB2-D862-42ED-962A-404DA253A292}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{98C7E858-7190-465E-B364-B61F14800788}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{8E3803DB-F5D6-4308-8504-9EB390AF096F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{BF11960C-D060-420E-8B93-C7555EAB1296}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{7E6E5B12-72E7-48B7-B956-79DB3F368203}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{8F713B92-4C48-483E-8B93-B5BE71371085}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{7BB26837-1395-4BE9-86C5-A946340E2031}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{CCEE282C-48F8-4C90-A7E7-30475ACC1298}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{8B423A3D-A6EF-4067-BAC1-5971C2F87674}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{35D05943-28A5-404E-93E7-C1E72E454D01}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{F2ED25FD-F18C-4822-B289-57BC86309B8E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{DC3D9BB9-9433-4337-8B6F-48503E018E3D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{068D830A-E8A5-42C8-B6CF-E5835AC2C380}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{8B51464B-A14E-4BDE-A613-0F18236D1615}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{F6036FB2-3392-4851-ABA1-69CD79B000B3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{C82B0A67-F547-40A7-83FF-94136B01A398}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{20D31695-5865-4F88-8EAD-8309553359F0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{96B6FF5B-4A34-49EB-B5AC-212000DBA113}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{B1172F36-66F0-40BE-B509-9A3B6430874D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{5A9C7E05-E3E1-4CE3-B690-39863F6B1669}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{0D38F37C-F54F-4509-B7D8-DC0C4E41CB40}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{5510D622-F341-4009-81E6-036F1EB32FDB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{8AD86913-B513-429A-96C0-A0CFF7C0BB19}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{316F9808-B2BB-4A27-9601-07985B09999A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{C91E9D93-9ED3-49B9-BCE8-EA1C3C838F63}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{5B75A459-1D30-4277-8C70-C9557FCAC643}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{D4BFE108-E35F-4C8F-8CB7-98DC2B2F6598}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{5A4B30F5-14A6-489D-8A21-D34195245708}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{01ADC4A0-9B01-466E-8F63-9F66B91B30CF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{5124F508-3DB7-4474-B6DD-95E6059361F9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{9DD8870A-0E87-4BBC-9D39-F9F1C3B43816}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{8B9B45DB-79B8-4294-B46B-DB98087A51A8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{C1AB67A0-5359-4D47-9E03-31934ECEA134}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{FE6B1A93-00AB-4674-83AD-ADC48A2795C3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{A3DC00C8-FC4A-4210-8817-3F2D1AC6EB4A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{107DEF4B-E069-47B4-AC08-B9EA5D9D8644}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{08F0E32F-7F21-4287-AAA6-896C33B87551}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{4496EA1C-C8AE-4C46-98F6-64F57751F4BC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{AB6D62C6-EE30-41FA-825C-A19A35F126A3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{FC00BCCC-2913-412A-BC14-FE009A2F0D6A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{66F95E54-0BB6-4F8E-93AE-573CF694DB6F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{4DA3969B-BA88-42CE-9938-E9E239DD1F66}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{2B68FF93-266F-4ABF-8C75-2BA29D89A88D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{F40FBAF5-B4EF-4F86-99B6-5E34CE8B9913}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{E6041AA0-ED3F-4DE9-9558-415117AB6ACD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{0F9B0376-3028-4918-B5E9-A3004C6AE2CC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{4685B9DA-A108-49ED-AE85-97ACF3EF3835}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{AA6F0C1E-42AC-45FE-BED0-7603933ECFA9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{6BD18014-5304-43C2-8F70-E81E33EA15B8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{D3EDADC9-9151-4E2A-89AE-B2E8488D8BAF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{41BC959D-A697-473A-B178-6BB363ED94A0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{1426DD7C-7353-4F42-BDBB-0D6DB433AF79}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{BA55627A-EE3F-4133-A0F7-299B4A66E93C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{901CBC31-F0F6-476A-9CCD-69F160282998}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{5806D299-B427-4B5F-9F1F-90A24A3BFB7B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{93FD2DA5-FD15-48DE-887A-EA220967BA12}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{D82E556A-A171-4051-B7CF-05371DC07434}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{4C2875C0-BDFC-46BB-B778-F8FDEE26BC63}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{B5BCAC79-E160-46F8-A49B-81A24CA245C8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{1567A38E-ADF8-46F3-B664-C982126DD6EA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{FB543543-3FFD-4AAB-8D10-94447546428D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{84D54697-4A6C-4609-A03D-F702BA2B6452}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{3A3E286E-90EB-453D-BC1C-B073F48E71DD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{B4D0B263-1534-4145-A88C-5708B6FABF01}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{ACE4F991-96BD-4CB8-A9E6-79EB90355EE3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{F2B4E33C-EAC9-44D0-A9C9-E1410FFC926C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{35DC7A94-FF6D-4A6B-9188-17078612AA41}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{CD56CB54-7F4C-4CBE-BD43-250EAE1D9D28}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{BC911EDC-E090-4999-A512-F912D0AF1347}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{1B4CEDAE-8BBA-47EE-AEF1-5C07ADEFA5CE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{521FCDE8-E816-4C00-886F-161BCC7B9D2E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{22B2CA89-A0EC-41D0-8115-201CE7BA9BA4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{E9B4CA10-37B5-4F24-9940-02CA9E35A31B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{E815D2EA-F97B-408D-B2F3-4E2CFC26DDCC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{4124D86F-CA35-4D39-BEA6-5B12B4D8B3D8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{360DFF82-A17C-40F0-B326-016686BBC9EF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{7C94B8FF-3084-4F17-9C30-A5036B5E8B31}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{7B23B7ED-8BB2-4D5F-9BED-058FF89D4916}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{1CC500E3-0458-4E6F-9A2C-05DBE66825E8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{DBB14B1B-F930-402A-9500-22BFC3634820}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{DE5B8126-C06C-48C4-8A6D-D3A55A8625FB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{7E03735B-2664-4716-B766-7BEBC9BA0909}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{12254182-2B9D-4712-957E-9D5A6F833EBD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{8F0FE46F-14AE-4DCB-914E-5D5FEF649A6B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{09266B38-EB7D-4120-A839-779B5D37C9E9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{6EACC851-1853-46DD-8FD1-CA35E6A55063}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{30E5E3B3-FB85-45D4-A2C5-04A69C6E9F7A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{2C879B62-ADAD-4B85-A5ED-CB7CD24BF17A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "{325C3576-1EC9-4CB8-932E-CB74C77A1983}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "", "langPack", "DVA", "Adobe Audition", "")
INSERT INTO Payloads VALUES	("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "DVA", "Adobe Audition_AdobeAudition4es_ESLanguagePack", "9", "langPack")
INSERT INTO PayloadData VALUES("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "0" , "PayloadInfo", '<PayloadInfo version="4.0.19.0"><BuildInfo>
    <Property name="Created">2011-03-24 13:26:13.973000</Property>
    <Property name="TargetName">AdobeAudition4es_ESLanguagePack</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{200FB1BB-208D-4E34-B244-ED90FEF69855}</Property>
    <Property name="ProductName">Adobe Audition CS5.5 LangPack (es_ES) </Property>
    <Property name="ProductVersion">9</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
  </InstallDir><Languages>
    <Language>es_ES</Language>
    <Language>es_MX</Language>
  </Languages><Satisfies>
    <ProductInfo>
		<Family>DVA</Family>
		<ProductName>Adobe Audition_AdobeAudition4es_ESLanguagePack</ProductName>
	<ProductVersion>9</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{7DB32A48-7442-474E-9065-203DD99923AC}</AdobeCode>
  </Upgrades><Conflicts>
    <AdobeCode>{107679C3-B8BA-480A-A82D-AE5F47D840C4}</AdobeCode>
    <AdobeCode>{5041D628-2729-4C4C-A32C-750E19FC7BEF}</AdobeCode>
    <AdobeCode>{76A6BD62-3B0D-4ACA-856E-49287209E187}</AdobeCode>
    <AdobeCode>{0D961180-7DCC-4FEC-9ECB-C505510E75B9}</AdobeCode>
    <AdobeCode>{C1775DCA-A441-45FB-A0C5-A9F417D38704}</AdobeCode>
    <AdobeCode>{71945A46-D8B1-4509-8D3B-64B2D1DB5F20}</AdobeCode>
    <AdobeCode>{465562B9-CBDB-4834-A3C3-8A484ACB1B1A}</AdobeCode>
    <AdobeCode>{9E275B1D-A251-4EE9-A203-85C5A581C030}</AdobeCode>
    <AdobeCode>{0F8AB347-AF18-42A9-9736-E074A64EA154}</AdobeCode>
    <AdobeCode>{A147E3A2-28E0-4A77-B24C-357D2B8CD7EB}</AdobeCode>
    <AdobeCode>{0309E1E9-3470-4B24-9DE6-8CDA0FAB7126}</AdobeCode>
    <AdobeCode>{15596A36-9100-42CE-BAE6-2DDF41D6D401}</AdobeCode>
    <AdobeCode>{9549D9FB-AFAC-4F74-9738-F234479DF724}</AdobeCode>
    <AdobeCode>{7F598D47-4596-4C18-92FC-2ECF4F7ABD72}</AdobeCode>
    <AdobeCode>{46678EDD-C7BB-46FF-8881-83F08FCFDB0A}</AdobeCode>
    <AdobeCode>{BA27E425-F740-4431-A09C-245DB9E73189}</AdobeCode>
    <AdobeCode>{9D3D4E4F-6840-4B50-85E5-B09FF3F55095}</AdobeCode>
    <AdobeCode>{8D8CE4DC-8086-4C16-8944-6FAEAD840CA4}</AdobeCode>
    <AdobeCode>{62B7EA08-5F2C-447A-A2F3-A295477F92A3}</AdobeCode>
    <AdobeCode>{424B7CE8-AF57-4F89-82DE-4731EC1946C8}</AdobeCode>
    <AdobeCode>{5654C86B-BB5E-4F78-9F6D-E3F206BCF501}</AdobeCode>
    <AdobeCode>{10946FCA-9959-4810-992A-F34BD10BDF4D}</AdobeCode>
    <AdobeCode>{068C9EF0-7573-4267-BADC-D8EF2FBB0BC7}</AdobeCode>
    <AdobeCode>{29C873AD-530F-4F80-9E2B-544AEAD23D91}</AdobeCode>
    <AdobeCode>{A62E2414-7C00-4EFF-A7BF-B060753A2B11}</AdobeCode>
    <AdobeCode>{9BE46E5F-35B2-4704-9E8A-4D4FD5265583}</AdobeCode>
    <AdobeCode>{4468D9C9-5CF3-4387-93FC-31954BF3590C}</AdobeCode>
    <AdobeCode>{84CE0A02-6376-4226-9DB7-F85FD751DD50}</AdobeCode>
    <AdobeCode>{1DD9FF62-D70D-464A-820E-D3488B2FA191}</AdobeCode>
    <AdobeCode>{EDC7ECE6-5030-4BE9-93D9-5C6DDCB1AFB7}</AdobeCode>
    <AdobeCode>{0EB36299-A40C-4849-A01C-BE41EB8D7F74}</AdobeCode>
    <AdobeCode>{D321E582-0EFC-4685-BF86-AE7F95AE83E5}</AdobeCode>
    <AdobeCode>{6E7F0A47-6BA8-4340-97B0-C4B730074434}</AdobeCode>
    <AdobeCode>{5223D6BA-01A8-43A3-AA55-AD94211CE387}</AdobeCode>
    <AdobeCode>{39B9DF08-B0A7-4E72-A69C-F36D2DB138A4}</AdobeCode>
    <AdobeCode>{0E083D87-8CDC-473A-8022-B9649DF19318}</AdobeCode>
    <AdobeCode>{91416628-452A-49A8-B6C7-F5FA3E3A5DF3}</AdobeCode>
    <AdobeCode>{39E38413-7A50-4764-B830-541963D26DFE}</AdobeCode>
    <AdobeCode>{28D9D3B8-9F92-48BC-9940-BC3FFDAA42D1}</AdobeCode>
    <AdobeCode>{27D3343F-C7E3-4C43-BDFF-5A8038F7EC81}</AdobeCode>
    <AdobeCode>{FB772792-8EF1-48D8-8FC1-6AC83AF86CE5}</AdobeCode>
    <AdobeCode>{BE01AB44-66BE-460D-AFF2-5FE569EAAD4F}</AdobeCode>
    <AdobeCode>{10BDACAB-45E9-4E27-B94B-0491E760376E}</AdobeCode>
    <AdobeCode>{EEEF55E8-421B-4ED0-AEC3-B933A7C2934C}</AdobeCode>
    <AdobeCode>{8D1863A3-05B4-4174-B541-BC6766F53E69}</AdobeCode>
    <AdobeCode>{6315FCAC-7950-4FC2-B96B-2BE9110D3E06}</AdobeCode>
    <AdobeCode>{72754CAD-5F22-4EF8-8544-949B3024F843}</AdobeCode>
    <AdobeCode>{2AC01B0D-0DA3-4598-83FB-5B66215F4B7D}</AdobeCode>
    <AdobeCode>{84018A5B-6571-4516-91AA-7D122BECAF94}</AdobeCode>
    <AdobeCode>{D3E512BF-8BB1-49FF-A195-3474DD76C476}</AdobeCode>
    <AdobeCode>{8759AFA8-B7DE-4B99-9C4A-9C064B3BEB96}</AdobeCode>
    <AdobeCode>{1569F477-C584-4072-97D9-6207DB62868E}</AdobeCode>
    <AdobeCode>{2962D45E-C8F4-4B96-9756-346B3246E050}</AdobeCode>
    <AdobeCode>{9CC9A31D-19F4-4F9C-8306-AA2377928BA1}</AdobeCode>
    <AdobeCode>{48782D71-6B14-4B51-9D27-2C4A79E230D1}</AdobeCode>
    <AdobeCode>{736D1921-6C7B-48D2-B5A3-B378F8B99B47}</AdobeCode>
    <AdobeCode>{AB51FDFF-0AC2-455C-A3CD-DF7B123F747F}</AdobeCode>
    <AdobeCode>{2D7D20D8-6888-4E45-AE19-778A31E043B3}</AdobeCode>
    <AdobeCode>{3AB706C5-8994-468B-9782-A93EBB1CB28F}</AdobeCode>
    <AdobeCode>{CF5AE487-53E7-4567-BD46-A5297F890E0B}</AdobeCode>
    <AdobeCode>{4311994A-8723-444B-A6AE-7D9FC3A0DC4C}</AdobeCode>
    <AdobeCode>{9985A4A6-A749-4A78-AA76-F2B3D1754DED}</AdobeCode>
    <AdobeCode>{CEA131D5-2376-449D-92D8-05592B7AC49D}</AdobeCode>
    <AdobeCode>{D42ABC1C-E195-4950-B754-B9B1367595E3}</AdobeCode>
    <AdobeCode>{2B740BBC-93D8-482E-9643-76B851578713}</AdobeCode>
    <AdobeCode>{0FAF5147-F58D-47FD-9286-938BC560DA32}</AdobeCode>
    <AdobeCode>{FF6DB29C-8533-4787-8CE9-61451D3AF7C7}</AdobeCode>
    <AdobeCode>{5B9F699B-27A0-442C-89EA-D31CF5C6CE2C}</AdobeCode>
    <AdobeCode>{E7C3DB5D-A5D0-4902-B6D7-AB4B124AC96A}</AdobeCode>
    <AdobeCode>{72B976B5-3EAB-4CE6-8FDB-DA6723EF01AB}</AdobeCode>
    <AdobeCode>{0A0D9E10-7D63-45CC-BE81-726849864B30}</AdobeCode>
    <AdobeCode>{AD7D7755-913F-48A7-9974-EF8754FAE858}</AdobeCode>
    <AdobeCode>{ECF699E9-BDBB-4F05-AA74-5E28DC0CA33C}</AdobeCode>
    <AdobeCode>{90D6339F-4D9E-4DBA-ABC7-660625BFC1E0}</AdobeCode>
    <AdobeCode>{B89C7CC0-5735-4DC2-9B66-8359AAB6E1EE}</AdobeCode>
    <AdobeCode>{FE017382-EC33-4941-B20E-7D49F26AE376}</AdobeCode>
    <AdobeCode>{060DB03C-8882-4C89-BCA5-3F41673428D5}</AdobeCode>
    <AdobeCode>{7D726541-7A7F-476C-87B5-94A4D343886D}</AdobeCode>
    <AdobeCode>{FD025609-14DF-4D98-B02D-48D070E722D9}</AdobeCode>
    <AdobeCode>{7091A1CC-0BC7-4F07-B760-D29C33623B2F}</AdobeCode>
    <AdobeCode>{C1615AB2-D862-42ED-962A-404DA253A292}</AdobeCode>
    <AdobeCode>{98C7E858-7190-465E-B364-B61F14800788}</AdobeCode>
    <AdobeCode>{8E3803DB-F5D6-4308-8504-9EB390AF096F}</AdobeCode>
    <AdobeCode>{BF11960C-D060-420E-8B93-C7555EAB1296}</AdobeCode>
    <AdobeCode>{7E6E5B12-72E7-48B7-B956-79DB3F368203}</AdobeCode>
    <AdobeCode>{8F713B92-4C48-483E-8B93-B5BE71371085}</AdobeCode>
    <AdobeCode>{7BB26837-1395-4BE9-86C5-A946340E2031}</AdobeCode>
    <AdobeCode>{CCEE282C-48F8-4C90-A7E7-30475ACC1298}</AdobeCode>
    <AdobeCode>{8B423A3D-A6EF-4067-BAC1-5971C2F87674}</AdobeCode>
    <AdobeCode>{35D05943-28A5-404E-93E7-C1E72E454D01}</AdobeCode>
    <AdobeCode>{F2ED25FD-F18C-4822-B289-57BC86309B8E}</AdobeCode>
    <AdobeCode>{DC3D9BB9-9433-4337-8B6F-48503E018E3D}</AdobeCode>
    <AdobeCode>{068D830A-E8A5-42C8-B6CF-E5835AC2C380}</AdobeCode>
    <AdobeCode>{8B51464B-A14E-4BDE-A613-0F18236D1615}</AdobeCode>
    <AdobeCode>{F6036FB2-3392-4851-ABA1-69CD79B000B3}</AdobeCode>
    <AdobeCode>{C82B0A67-F547-40A7-83FF-94136B01A398}</AdobeCode>
    <AdobeCode>{20D31695-5865-4F88-8EAD-8309553359F0}</AdobeCode>
    <AdobeCode>{96B6FF5B-4A34-49EB-B5AC-212000DBA113}</AdobeCode>
    <AdobeCode>{B1172F36-66F0-40BE-B509-9A3B6430874D}</AdobeCode>
    <AdobeCode>{5A9C7E05-E3E1-4CE3-B690-39863F6B1669}</AdobeCode>
    <AdobeCode>{0D38F37C-F54F-4509-B7D8-DC0C4E41CB40}</AdobeCode>
    <AdobeCode>{5510D622-F341-4009-81E6-036F1EB32FDB}</AdobeCode>
    <AdobeCode>{8AD86913-B513-429A-96C0-A0CFF7C0BB19}</AdobeCode>
    <AdobeCode>{316F9808-B2BB-4A27-9601-07985B09999A}</AdobeCode>
    <AdobeCode>{C91E9D93-9ED3-49B9-BCE8-EA1C3C838F63}</AdobeCode>
    <AdobeCode>{5B75A459-1D30-4277-8C70-C9557FCAC643}</AdobeCode>
    <AdobeCode>{D4BFE108-E35F-4C8F-8CB7-98DC2B2F6598}</AdobeCode>
    <AdobeCode>{5A4B30F5-14A6-489D-8A21-D34195245708}</AdobeCode>
    <AdobeCode>{01ADC4A0-9B01-466E-8F63-9F66B91B30CF}</AdobeCode>
    <AdobeCode>{5124F508-3DB7-4474-B6DD-95E6059361F9}</AdobeCode>
    <AdobeCode>{9DD8870A-0E87-4BBC-9D39-F9F1C3B43816}</AdobeCode>
    <AdobeCode>{8B9B45DB-79B8-4294-B46B-DB98087A51A8}</AdobeCode>
    <AdobeCode>{C1AB67A0-5359-4D47-9E03-31934ECEA134}</AdobeCode>
    <AdobeCode>{FE6B1A93-00AB-4674-83AD-ADC48A2795C3}</AdobeCode>
    <AdobeCode>{A3DC00C8-FC4A-4210-8817-3F2D1AC6EB4A}</AdobeCode>
    <AdobeCode>{107DEF4B-E069-47B4-AC08-B9EA5D9D8644}</AdobeCode>
    <AdobeCode>{08F0E32F-7F21-4287-AAA6-896C33B87551}</AdobeCode>
    <AdobeCode>{4496EA1C-C8AE-4C46-98F6-64F57751F4BC}</AdobeCode>
    <AdobeCode>{AB6D62C6-EE30-41FA-825C-A19A35F126A3}</AdobeCode>
    <AdobeCode>{FC00BCCC-2913-412A-BC14-FE009A2F0D6A}</AdobeCode>
    <AdobeCode>{66F95E54-0BB6-4F8E-93AE-573CF694DB6F}</AdobeCode>
    <AdobeCode>{4DA3969B-BA88-42CE-9938-E9E239DD1F66}</AdobeCode>
    <AdobeCode>{2B68FF93-266F-4ABF-8C75-2BA29D89A88D}</AdobeCode>
    <AdobeCode>{F40FBAF5-B4EF-4F86-99B6-5E34CE8B9913}</AdobeCode>
    <AdobeCode>{E6041AA0-ED3F-4DE9-9558-415117AB6ACD}</AdobeCode>
    <AdobeCode>{0F9B0376-3028-4918-B5E9-A3004C6AE2CC}</AdobeCode>
    <AdobeCode>{4685B9DA-A108-49ED-AE85-97ACF3EF3835}</AdobeCode>
    <AdobeCode>{AA6F0C1E-42AC-45FE-BED0-7603933ECFA9}</AdobeCode>
    <AdobeCode>{6BD18014-5304-43C2-8F70-E81E33EA15B8}</AdobeCode>
    <AdobeCode>{D3EDADC9-9151-4E2A-89AE-B2E8488D8BAF}</AdobeCode>
    <AdobeCode>{41BC959D-A697-473A-B178-6BB363ED94A0}</AdobeCode>
    <AdobeCode>{1426DD7C-7353-4F42-BDBB-0D6DB433AF79}</AdobeCode>
    <AdobeCode>{BA55627A-EE3F-4133-A0F7-299B4A66E93C}</AdobeCode>
    <AdobeCode>{901CBC31-F0F6-476A-9CCD-69F160282998}</AdobeCode>
    <AdobeCode>{5806D299-B427-4B5F-9F1F-90A24A3BFB7B}</AdobeCode>
    <AdobeCode>{93FD2DA5-FD15-48DE-887A-EA220967BA12}</AdobeCode>
    <AdobeCode>{D82E556A-A171-4051-B7CF-05371DC07434}</AdobeCode>
    <AdobeCode>{4C2875C0-BDFC-46BB-B778-F8FDEE26BC63}</AdobeCode>
    <AdobeCode>{B5BCAC79-E160-46F8-A49B-81A24CA245C8}</AdobeCode>
    <AdobeCode>{1567A38E-ADF8-46F3-B664-C982126DD6EA}</AdobeCode>
    <AdobeCode>{FB543543-3FFD-4AAB-8D10-94447546428D}</AdobeCode>
    <AdobeCode>{84D54697-4A6C-4609-A03D-F702BA2B6452}</AdobeCode>
    <AdobeCode>{3A3E286E-90EB-453D-BC1C-B073F48E71DD}</AdobeCode>
    <AdobeCode>{B4D0B263-1534-4145-A88C-5708B6FABF01}</AdobeCode>
    <AdobeCode>{ACE4F991-96BD-4CB8-A9E6-79EB90355EE3}</AdobeCode>
    <AdobeCode>{F2B4E33C-EAC9-44D0-A9C9-E1410FFC926C}</AdobeCode>
    <AdobeCode>{35DC7A94-FF6D-4A6B-9188-17078612AA41}</AdobeCode>
    <AdobeCode>{CD56CB54-7F4C-4CBE-BD43-250EAE1D9D28}</AdobeCode>
    <AdobeCode>{BC911EDC-E090-4999-A512-F912D0AF1347}</AdobeCode>
    <AdobeCode>{1B4CEDAE-8BBA-47EE-AEF1-5C07ADEFA5CE}</AdobeCode>
    <AdobeCode>{521FCDE8-E816-4C00-886F-161BCC7B9D2E}</AdobeCode>
    <AdobeCode>{22B2CA89-A0EC-41D0-8115-201CE7BA9BA4}</AdobeCode>
    <AdobeCode>{E9B4CA10-37B5-4F24-9940-02CA9E35A31B}</AdobeCode>
    <AdobeCode>{E815D2EA-F97B-408D-B2F3-4E2CFC26DDCC}</AdobeCode>
    <AdobeCode>{4124D86F-CA35-4D39-BEA6-5B12B4D8B3D8}</AdobeCode>
    <AdobeCode>{360DFF82-A17C-40F0-B326-016686BBC9EF}</AdobeCode>
    <AdobeCode>{7C94B8FF-3084-4F17-9C30-A5036B5E8B31}</AdobeCode>
    <AdobeCode>{7B23B7ED-8BB2-4D5F-9BED-058FF89D4916}</AdobeCode>
    <AdobeCode>{1CC500E3-0458-4E6F-9A2C-05DBE66825E8}</AdobeCode>
    <AdobeCode>{DBB14B1B-F930-402A-9500-22BFC3634820}</AdobeCode>
    <AdobeCode>{DE5B8126-C06C-48C4-8A6D-D3A55A8625FB}</AdobeCode>
    <AdobeCode>{7E03735B-2664-4716-B766-7BEBC9BA0909}</AdobeCode>
    <AdobeCode>{12254182-2B9D-4712-957E-9D5A6F833EBD}</AdobeCode>
    <AdobeCode>{8F0FE46F-14AE-4DCB-914E-5D5FEF649A6B}</AdobeCode>
    <AdobeCode>{09266B38-EB7D-4120-A839-779B5D37C9E9}</AdobeCode>
    <AdobeCode>{6EACC851-1853-46DD-8FD1-CA35E6A55063}</AdobeCode>
    <AdobeCode>{30E5E3B3-FB85-45D4-A2C5-04A69C6E9F7A}</AdobeCode>
    <AdobeCode>{2C879B62-ADAD-4B85-A5ED-CB7CD24BF17A}</AdobeCode>
    <AdobeCode>{325C3576-1EC9-4CB8-932E-CB74C77A1983}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeAuditionCS5.5LangPackes_ES-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (es_ES) </DisplayName>
  </Channel><Extends type="langPack">
    <ParentProductInfo>
					<Family>DVA</Family>
					<ProductName>Adobe Audition</ProductName>
				</ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="0" sysDriveSize="780"><Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>780</TotalSize>
      <MaxPathComponent>/HelpCfg/es_ES\Audition_4.0.helpcfg</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="780"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="es_ES">9</Value>
      <Value lang="es_MX">9</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="es_ES">Adobe Audition CS5.5 LangPack (es_ES) </Value>
      <Value lang="es_MX">Adobe Audition CS5.5 LangPack (es_ES) </Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "0", "ChannelID", "AdobeAuditionCS5.5LangPackes_ES-9")
INSERT INTO PayloadData VALUES("{200FB1BB-208D-4E34-B244-ED90FEF69855}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeAuditionCS5.5LangPackes_ES-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (es_ES) </DisplayName>
  </Channel>')
