CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{64D49B55-BD35-4B76-B3C2-BEB246F8913C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{43C92BE4-E053-476D-88B9-1ED816078372}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{F0DB7C9D-B274-48C3-BCB7-8F2D9316532C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{5585413F-4658-4AE4-9F64-B9C7B7C7E0F6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{EE940AF9-2AD1-44D8-8233-3E90580CE663}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{FB7E2580-8503-4926-ACDF-750ABE1C74A7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{07D764BB-AC67-4B85-B84F-E6417B8E8759}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{4D55C486-813E-422D-82AB-C4EF5DCA4708}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{B0210192-FE56-4EDC-8B51-E48A065B8297}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{80238629-B497-42AE-9EFD-E2DB02364658}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{0894DDDB-6E84-4DDC-A404-255F5BEF8628}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{C896061B-5A7B-4A8B-906D-63A698D89CF0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{8867D8EE-8DC5-4002-9B7E-2F31F139C061}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{98605B7F-1AA3-4627-938B-D6873C17EC3A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{669F411E-0982-48ED-8C5A-534968D9B8DD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{40F83780-B748-4B4F-9DB9-0B35C1439DE5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{C5C287AD-785B-4C0B-82EA-59511ECF216B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{DF7AB05A-0206-4BF2-BCA1-7E0B38378671}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{EDAE66F2-056D-4DBE-A8F8-3C93DF597613}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{BB52A2AB-2447-4B36-BC8C-4427FDE55061}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{DCE4632B-42FB-442C-835E-14E826AAD1DA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E5D0155A-3A97-4B38-A0AB-FAD267D12658}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{F37E1326-74A8-469B-8144-48A25CC17112}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{26088EA7-0A5B-4B72-BA0B-18BC1D7E021D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{822AEDF5-73A3-40A0-B018-1084F556FF88}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{D1825834-43BB-43E2-8382-5D1EDC880663}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E1C4A559-666A-4E02-8EB6-340843CC5562}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{C567242A-90EE-4950-8B56-501108E6924F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E3810612-1C53-4E2C-8CFE-0CFBB64DFE56}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{854A08B3-857F-42B7-BBFE-BA6270C24993}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9763B435-70C5-4F5C-AF05-46B0165E5FBE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{0251AB8B-2C06-467E-B444-3E9985833235}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{A5D6A2F0-22CD-4E66-A273-D0ECF317478A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{ABA8EDFD-09B6-4200-AE16-BCC507770433}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{4DDD8130-A3B8-4656-A59C-26D1D24DAE89}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{783F1E3F-859F-4754-A93A-6D895D208322}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9FD272F7-CDD3-461E-ABA8-5BD13ECEF1BA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{6C739A23-6E1B-432F-A2DA-0D48293B62A9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{39013298-A703-4B98-AC11-514B8F8E20B8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{3F1E1095-BCCB-49E7-96F1-A7C07A3E8887}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{DE22ED32-914A-47B9-B458-A72948F22267}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{2E777705-1392-4627-BE30-FE5515C90DF5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{721F1E19-69FC-446A-AFFE-DBE0858F1D64}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{D76EB2FE-53EA-4CE8-9222-626E83A80940}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{5788B153-2DD6-4528-A8B1-8FCFFEBBEB8E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{C7B14327-9872-4C9B-BEDA-9847B469DDD1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{B47EB5A7-1638-4529-B27A-E714FBFD4642}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{6DE2525F-74EA-49E3-BDC8-93308CDE5804}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{2F0526FD-883E-42B4-A57D-B837CA922A6A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{7F7BA924-C7DF-4017-88A6-DC47E15E1ED4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{EF1771B6-3129-44F4-808E-8899F6C98DC7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{4268BAF6-43C1-4FB3-A33C-2D8F024C3075}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{0B97D0C5-8ADE-4B86-981A-D5C04438B6AF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{ACC66DA5-6B2B-4742-9FC1-73C6B28B32C1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{3BAF64CE-6A38-4FA9-B297-7ADFEF7EE23D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{CB538A1F-289F-4191-823F-83A06722FF53}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{658A4BFD-D9D2-4A3C-8D1A-5CC04CB42EEB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{4A37A414-6993-43E2-BBBE-259B0A1AD896}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{1B4F2541-50CC-4466-8AA6-EC884A58EA3E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{94B289A9-39DD-47F5-AC8D-DF5F5B1CA664}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{EFFCCD01-246E-457E-99F1-871160AA29AE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{73AB9E2D-6BF6-4E76-9FEA-B67BBB4DE451}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{2200C016-69E3-4902-B255-2030CA900D58}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{8E339C62-B681-4B93-A801-2C733FD2A51D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{66981F76-B75E-4BF4-BD69-A6049F3F276E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{CC4A0E02-56A8-495A-AB67-EA199DF4AA1F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{C64637E3-231E-46CC-B950-444399126138}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{62BE96C7-59C8-4706-A6C5-8E3D86313353}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{FDBAB5A7-5E0F-4407-BC4D-18B3DAFB8CE2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{48874EE6-8A3A-4016-AB37-51ECDF468C15}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{757E72F5-75F8-4536-B4EC-59D369738242}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{20015D55-1DF7-427B-996B-28F1FEA274A5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{B86CA7DE-43B2-4CC9-874E-BD1A2AF99386}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{2E3B2965-D16D-45B6-B2D4-505EA0D09344}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{5DFC951C-B7BA-4D2A-9540-45DE0E107DB9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{219CD6BC-1F70-4CCB-83D9-C2F1B028E1D5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{8DB51CD4-291B-4FD9-A921-33F7997402B2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{7E96EB4C-6030-4416-81C6-28524F8753AD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E356C258-ECE1-43E4-B2C3-369CF5283924}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{913434E4-9D76-405D-A21B-30FFED675DF0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{BAA46716-6FCE-453D-9CD6-DE1467DDC0D3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9F183921-41A3-44EB-B627-78494AAA94CB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{2051291D-946D-44AE-BC00-2137485F5773}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{1425DC91-D9CE-4368-8AC9-62734EDD7B57}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{39636DD8-B5E5-4824-9247-229045A06B39}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{7CEF9D0B-8C7F-408A-BF0B-F894F64E0545}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{AF5AD397-4050-4AAC-9CDB-8C63721ED7CF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{A5F222F5-2C42-4F60-BD72-8E56F8E4DE11}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{95425AAB-2EAE-4BCD-A39D-9AC129949CF5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{D5D06783-3603-496E-BC2F-7D7BB5E5CEAC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{280FCA74-582C-4A18-9CB6-9693C40C6CDC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{55B533FB-2720-4CF9-96B1-61E854D3C1C3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9A1A7BB9-5A6C-4184-B6F2-51034AAB1273}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{7FB64309-5619-4C42-A344-E3D257F17B28}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{AF20ED2B-3005-4977-90CD-A46121FDB1F4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{79E47C40-A769-496D-B963-1753661A5983}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{BC60A2D7-4654-4BD0-82C3-2DB45C6C3F3C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{C3EFB8C3-A634-41EA-AA2B-576EFCEDEC1A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9D2CB355-CD21-4D7D-B6B4-A1EAE2EA028F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E6D41D9B-C7CE-45B8-B6F7-1AB8944AB98B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{62C8D118-6CC9-473B-988F-924B0ED41DB4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{2B709A66-438D-4FB8-ABC2-72DD99C0A1CA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{20F2E6D3-2631-4E12-B38F-FF77B90B254B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E2798B5C-B015-4340-B8CB-6890184237AE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{F38F3F01-8C59-4D41-BC56-FD1EBF7A7268}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{06F9A542-F52D-44D9-BF20-078DEAFC7715}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{ECE1734F-F7E6-4CBC-94AC-0B6B7B861197}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{CED0B7EE-0087-4AB0-998D-0E64C113E0C5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{B6F17888-4B60-400B-8C98-DD8FF5C51E2E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{BD65CB8D-A182-43D1-9E7E-EE6E006CFE97}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{F923A9C1-D66E-4EE0-A67B-CA7DFAACCF75}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{8924D50D-0846-482C-85C4-486687280EBF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{2646C0E8-6C86-46BD-B4F2-43CB503F92B1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{841A4052-6518-476F-8FA3-2DD19A88D2D9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9C3FB8CD-671F-4F92-923C-65AA7640BDBB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{13A230B2-C25A-43AB-8424-36D1F8F11921}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{09A10FBB-B2AF-4CD7-B645-E51563954E65}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{F6011ECE-7641-4196-BEE4-215B5A895C08}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{1097ED9D-87AB-499D-B9D1-3E6B6A975896}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{6280926C-CE25-4E27-B1AE-AC4102ACB6A1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{173C7D6E-DA22-43F0-8363-4CF442328BAD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{7B29FE33-E7B4-4FCB-82EC-2B7093A64B71}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9AEA8FC4-ABBC-4F59-9210-6D354FFB95DD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{CA0E8B60-595F-4A40-8DFF-FF39BCEAD13D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{3048D80A-891A-4EB2-A937-0461478FD235}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{92DBEEAB-3B9F-46BE-93DA-C648804204F9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{2B3D668C-708B-4C36-88B0-945EBAEB1777}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{DF7401EC-145A-4395-BE30-452D9D5BAC72}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{A6D36229-70E3-4C47-A00E-AAF364A36228}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9A4FB1B1-5CE6-4065-8491-F4F53D341157}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{C581F3FF-C9B7-4079-8172-B0CB601B5F39}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E4CA795B-4A30-4D7C-923D-2C76A6F85124}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{D31934CE-FC38-47F5-8404-040AF4FEFE09}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{2AA07E06-C603-44F5-BAB6-48AF005E9030}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9D99587C-25A2-4430-8B95-946909ED31E9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{526FBE18-64B4-44A0-AA4B-B74FADC5C3E7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{61E49F71-49F4-46F3-B476-EB711CB5B7D8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{3D83E489-9F6B-46CC-88DC-F593E0BFDCD0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9210329A-DF76-4DCF-B340-ACAE6020D3FB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{D107789A-BB44-44A9-8057-A3167CECF14A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9B12F154-A294-4AF8-84A3-313C329D0891}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{5AF3D2AD-962A-450A-83E2-6A9D06884D23}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{8DC70961-12FA-46A0-874B-02543A73CF97}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{35ADD03C-B12A-4AD6-9C33-5DA6DDB85C71}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{7BE96726-CF2C-480E-8E14-DB7E2CA56100}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E027B6D9-4BDE-4992-82C9-82DDF1B2434E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{BF9DB794-C8D6-4742-8DEE-212EFBE958ED}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E03C642A-97D6-4F2C-A291-FF54DFA88564}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{BCC3926D-ED28-4643-BAE0-A7272E1F7676}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9AC99C10-4BAF-4F88-A31C-EC5F33CDB8B2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{987B4012-48AF-4387-9621-5EA0711A5030}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{5F1736C7-125C-43F7-929E-A601806A132D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{9BA7648F-ADC7-4C2A-93C6-D625C5F9F98F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{D4768788-C700-463F-BE4E-69288304017F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{740E816A-8D59-4009-8207-4411C67F3952}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{BEAB5EBF-0356-4059-B20A-1A6A0BCD57EA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{C8885CA0-BFEB-48B8-8A0F-46271B5D11E2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E9263770-D02D-459B-8D1D-7EBA082A8508}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{6857BEEE-FD19-45F0-BDB8-96EE22918C63}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{09FF0547-94B0-48D3-B7F8-5BECCDD5674F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E7F4E4FB-61C3-4888-A802-58B1D1278A8D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{D7B86BE6-B571-47E0-A323-657F5016CC68}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{C1415E51-D2E9-40CD-8223-CA714A46076F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{24FC8F2F-79AF-4F9B-B3A0-3DF862F005A4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{8685F2E2-F1FD-417E-B519-7EED23882BE4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{863B7CCF-9B24-4BEC-9BBC-5850AD318407}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{A05C0B12-1C0E-4DBF-A8C4-BC1AF37688F0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{87B1C872-3617-4E20-80E4-6A7F667E1780}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{45B857A4-D6A1-432A-B978-2CFA81033F7E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "{E1DB326F-03D5-48DF-86CB-F7157A98B5E0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "", "langPack", "DVA", "Adobe Audition", "")
INSERT INTO Payloads VALUES	("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "DVA", "Adobe Audition_AdobeAudition4en_USLanguagePack", "9", "langPack")
INSERT INTO PayloadData VALUES("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "0" , "PayloadInfo", '<PayloadInfo version="4.0.19.0"><BuildInfo>
    <Property name="Created">2011-03-24 13:25:46.548000</Property>
    <Property name="TargetName">AdobeAudition4en_USLanguagePack</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}</Property>
    <Property name="ProductName">Adobe Audition CS5.5 LangPack (en_US) </Property>
    <Property name="ProductVersion">9</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
  </InstallDir><Languages>
    <Language>en_US</Language>
    <Language>en_GB</Language>
    <Language>pt_BR</Language>
    <Language>nl_NL</Language>
    <Language>zh_TW</Language>
    <Language>sv_SE</Language>
    <Language>cs_CZ</Language>
    <Language>pl_PL</Language>
    <Language>ru_RU</Language>
    <Language>tr_TR</Language>
  </Languages><Satisfies>
    <ProductInfo>
		<Family>DVA</Family>
		<ProductName>Adobe Audition_AdobeAudition4en_USLanguagePack</ProductName>
	<ProductVersion>9</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{64D49B55-BD35-4B76-B3C2-BEB246F8913C}</AdobeCode>
  </Upgrades><Conflicts>
    <AdobeCode>{43C92BE4-E053-476D-88B9-1ED816078372}</AdobeCode>
    <AdobeCode>{F0DB7C9D-B274-48C3-BCB7-8F2D9316532C}</AdobeCode>
    <AdobeCode>{5585413F-4658-4AE4-9F64-B9C7B7C7E0F6}</AdobeCode>
    <AdobeCode>{EE940AF9-2AD1-44D8-8233-3E90580CE663}</AdobeCode>
    <AdobeCode>{FB7E2580-8503-4926-ACDF-750ABE1C74A7}</AdobeCode>
    <AdobeCode>{07D764BB-AC67-4B85-B84F-E6417B8E8759}</AdobeCode>
    <AdobeCode>{4D55C486-813E-422D-82AB-C4EF5DCA4708}</AdobeCode>
    <AdobeCode>{B0210192-FE56-4EDC-8B51-E48A065B8297}</AdobeCode>
    <AdobeCode>{80238629-B497-42AE-9EFD-E2DB02364658}</AdobeCode>
    <AdobeCode>{0894DDDB-6E84-4DDC-A404-255F5BEF8628}</AdobeCode>
    <AdobeCode>{C896061B-5A7B-4A8B-906D-63A698D89CF0}</AdobeCode>
    <AdobeCode>{8867D8EE-8DC5-4002-9B7E-2F31F139C061}</AdobeCode>
    <AdobeCode>{98605B7F-1AA3-4627-938B-D6873C17EC3A}</AdobeCode>
    <AdobeCode>{669F411E-0982-48ED-8C5A-534968D9B8DD}</AdobeCode>
    <AdobeCode>{40F83780-B748-4B4F-9DB9-0B35C1439DE5}</AdobeCode>
    <AdobeCode>{C5C287AD-785B-4C0B-82EA-59511ECF216B}</AdobeCode>
    <AdobeCode>{DF7AB05A-0206-4BF2-BCA1-7E0B38378671}</AdobeCode>
    <AdobeCode>{EDAE66F2-056D-4DBE-A8F8-3C93DF597613}</AdobeCode>
    <AdobeCode>{BB52A2AB-2447-4B36-BC8C-4427FDE55061}</AdobeCode>
    <AdobeCode>{DCE4632B-42FB-442C-835E-14E826AAD1DA}</AdobeCode>
    <AdobeCode>{E5D0155A-3A97-4B38-A0AB-FAD267D12658}</AdobeCode>
    <AdobeCode>{F37E1326-74A8-469B-8144-48A25CC17112}</AdobeCode>
    <AdobeCode>{26088EA7-0A5B-4B72-BA0B-18BC1D7E021D}</AdobeCode>
    <AdobeCode>{822AEDF5-73A3-40A0-B018-1084F556FF88}</AdobeCode>
    <AdobeCode>{D1825834-43BB-43E2-8382-5D1EDC880663}</AdobeCode>
    <AdobeCode>{E1C4A559-666A-4E02-8EB6-340843CC5562}</AdobeCode>
    <AdobeCode>{C567242A-90EE-4950-8B56-501108E6924F}</AdobeCode>
    <AdobeCode>{E3810612-1C53-4E2C-8CFE-0CFBB64DFE56}</AdobeCode>
    <AdobeCode>{854A08B3-857F-42B7-BBFE-BA6270C24993}</AdobeCode>
    <AdobeCode>{9763B435-70C5-4F5C-AF05-46B0165E5FBE}</AdobeCode>
    <AdobeCode>{0251AB8B-2C06-467E-B444-3E9985833235}</AdobeCode>
    <AdobeCode>{A5D6A2F0-22CD-4E66-A273-D0ECF317478A}</AdobeCode>
    <AdobeCode>{ABA8EDFD-09B6-4200-AE16-BCC507770433}</AdobeCode>
    <AdobeCode>{4DDD8130-A3B8-4656-A59C-26D1D24DAE89}</AdobeCode>
    <AdobeCode>{783F1E3F-859F-4754-A93A-6D895D208322}</AdobeCode>
    <AdobeCode>{9FD272F7-CDD3-461E-ABA8-5BD13ECEF1BA}</AdobeCode>
    <AdobeCode>{6C739A23-6E1B-432F-A2DA-0D48293B62A9}</AdobeCode>
    <AdobeCode>{39013298-A703-4B98-AC11-514B8F8E20B8}</AdobeCode>
    <AdobeCode>{3F1E1095-BCCB-49E7-96F1-A7C07A3E8887}</AdobeCode>
    <AdobeCode>{DE22ED32-914A-47B9-B458-A72948F22267}</AdobeCode>
    <AdobeCode>{2E777705-1392-4627-BE30-FE5515C90DF5}</AdobeCode>
    <AdobeCode>{721F1E19-69FC-446A-AFFE-DBE0858F1D64}</AdobeCode>
    <AdobeCode>{D76EB2FE-53EA-4CE8-9222-626E83A80940}</AdobeCode>
    <AdobeCode>{5788B153-2DD6-4528-A8B1-8FCFFEBBEB8E}</AdobeCode>
    <AdobeCode>{C7B14327-9872-4C9B-BEDA-9847B469DDD1}</AdobeCode>
    <AdobeCode>{B47EB5A7-1638-4529-B27A-E714FBFD4642}</AdobeCode>
    <AdobeCode>{6DE2525F-74EA-49E3-BDC8-93308CDE5804}</AdobeCode>
    <AdobeCode>{2F0526FD-883E-42B4-A57D-B837CA922A6A}</AdobeCode>
    <AdobeCode>{7F7BA924-C7DF-4017-88A6-DC47E15E1ED4}</AdobeCode>
    <AdobeCode>{EF1771B6-3129-44F4-808E-8899F6C98DC7}</AdobeCode>
    <AdobeCode>{4268BAF6-43C1-4FB3-A33C-2D8F024C3075}</AdobeCode>
    <AdobeCode>{0B97D0C5-8ADE-4B86-981A-D5C04438B6AF}</AdobeCode>
    <AdobeCode>{ACC66DA5-6B2B-4742-9FC1-73C6B28B32C1}</AdobeCode>
    <AdobeCode>{3BAF64CE-6A38-4FA9-B297-7ADFEF7EE23D}</AdobeCode>
    <AdobeCode>{CB538A1F-289F-4191-823F-83A06722FF53}</AdobeCode>
    <AdobeCode>{658A4BFD-D9D2-4A3C-8D1A-5CC04CB42EEB}</AdobeCode>
    <AdobeCode>{4A37A414-6993-43E2-BBBE-259B0A1AD896}</AdobeCode>
    <AdobeCode>{1B4F2541-50CC-4466-8AA6-EC884A58EA3E}</AdobeCode>
    <AdobeCode>{94B289A9-39DD-47F5-AC8D-DF5F5B1CA664}</AdobeCode>
    <AdobeCode>{EFFCCD01-246E-457E-99F1-871160AA29AE}</AdobeCode>
    <AdobeCode>{73AB9E2D-6BF6-4E76-9FEA-B67BBB4DE451}</AdobeCode>
    <AdobeCode>{2200C016-69E3-4902-B255-2030CA900D58}</AdobeCode>
    <AdobeCode>{8E339C62-B681-4B93-A801-2C733FD2A51D}</AdobeCode>
    <AdobeCode>{66981F76-B75E-4BF4-BD69-A6049F3F276E}</AdobeCode>
    <AdobeCode>{CC4A0E02-56A8-495A-AB67-EA199DF4AA1F}</AdobeCode>
    <AdobeCode>{C64637E3-231E-46CC-B950-444399126138}</AdobeCode>
    <AdobeCode>{62BE96C7-59C8-4706-A6C5-8E3D86313353}</AdobeCode>
    <AdobeCode>{FDBAB5A7-5E0F-4407-BC4D-18B3DAFB8CE2}</AdobeCode>
    <AdobeCode>{48874EE6-8A3A-4016-AB37-51ECDF468C15}</AdobeCode>
    <AdobeCode>{757E72F5-75F8-4536-B4EC-59D369738242}</AdobeCode>
    <AdobeCode>{20015D55-1DF7-427B-996B-28F1FEA274A5}</AdobeCode>
    <AdobeCode>{B86CA7DE-43B2-4CC9-874E-BD1A2AF99386}</AdobeCode>
    <AdobeCode>{2E3B2965-D16D-45B6-B2D4-505EA0D09344}</AdobeCode>
    <AdobeCode>{5DFC951C-B7BA-4D2A-9540-45DE0E107DB9}</AdobeCode>
    <AdobeCode>{219CD6BC-1F70-4CCB-83D9-C2F1B028E1D5}</AdobeCode>
    <AdobeCode>{8DB51CD4-291B-4FD9-A921-33F7997402B2}</AdobeCode>
    <AdobeCode>{7E96EB4C-6030-4416-81C6-28524F8753AD}</AdobeCode>
    <AdobeCode>{E356C258-ECE1-43E4-B2C3-369CF5283924}</AdobeCode>
    <AdobeCode>{913434E4-9D76-405D-A21B-30FFED675DF0}</AdobeCode>
    <AdobeCode>{BAA46716-6FCE-453D-9CD6-DE1467DDC0D3}</AdobeCode>
    <AdobeCode>{9F183921-41A3-44EB-B627-78494AAA94CB}</AdobeCode>
    <AdobeCode>{2051291D-946D-44AE-BC00-2137485F5773}</AdobeCode>
    <AdobeCode>{1425DC91-D9CE-4368-8AC9-62734EDD7B57}</AdobeCode>
    <AdobeCode>{39636DD8-B5E5-4824-9247-229045A06B39}</AdobeCode>
    <AdobeCode>{7CEF9D0B-8C7F-408A-BF0B-F894F64E0545}</AdobeCode>
    <AdobeCode>{AF5AD397-4050-4AAC-9CDB-8C63721ED7CF}</AdobeCode>
    <AdobeCode>{A5F222F5-2C42-4F60-BD72-8E56F8E4DE11}</AdobeCode>
    <AdobeCode>{95425AAB-2EAE-4BCD-A39D-9AC129949CF5}</AdobeCode>
    <AdobeCode>{D5D06783-3603-496E-BC2F-7D7BB5E5CEAC}</AdobeCode>
    <AdobeCode>{280FCA74-582C-4A18-9CB6-9693C40C6CDC}</AdobeCode>
    <AdobeCode>{55B533FB-2720-4CF9-96B1-61E854D3C1C3}</AdobeCode>
    <AdobeCode>{9A1A7BB9-5A6C-4184-B6F2-51034AAB1273}</AdobeCode>
    <AdobeCode>{7FB64309-5619-4C42-A344-E3D257F17B28}</AdobeCode>
    <AdobeCode>{AF20ED2B-3005-4977-90CD-A46121FDB1F4}</AdobeCode>
    <AdobeCode>{79E47C40-A769-496D-B963-1753661A5983}</AdobeCode>
    <AdobeCode>{BC60A2D7-4654-4BD0-82C3-2DB45C6C3F3C}</AdobeCode>
    <AdobeCode>{C3EFB8C3-A634-41EA-AA2B-576EFCEDEC1A}</AdobeCode>
    <AdobeCode>{9D2CB355-CD21-4D7D-B6B4-A1EAE2EA028F}</AdobeCode>
    <AdobeCode>{E6D41D9B-C7CE-45B8-B6F7-1AB8944AB98B}</AdobeCode>
    <AdobeCode>{62C8D118-6CC9-473B-988F-924B0ED41DB4}</AdobeCode>
    <AdobeCode>{2B709A66-438D-4FB8-ABC2-72DD99C0A1CA}</AdobeCode>
    <AdobeCode>{20F2E6D3-2631-4E12-B38F-FF77B90B254B}</AdobeCode>
    <AdobeCode>{E2798B5C-B015-4340-B8CB-6890184237AE}</AdobeCode>
    <AdobeCode>{F38F3F01-8C59-4D41-BC56-FD1EBF7A7268}</AdobeCode>
    <AdobeCode>{06F9A542-F52D-44D9-BF20-078DEAFC7715}</AdobeCode>
    <AdobeCode>{ECE1734F-F7E6-4CBC-94AC-0B6B7B861197}</AdobeCode>
    <AdobeCode>{CED0B7EE-0087-4AB0-998D-0E64C113E0C5}</AdobeCode>
    <AdobeCode>{B6F17888-4B60-400B-8C98-DD8FF5C51E2E}</AdobeCode>
    <AdobeCode>{BD65CB8D-A182-43D1-9E7E-EE6E006CFE97}</AdobeCode>
    <AdobeCode>{F923A9C1-D66E-4EE0-A67B-CA7DFAACCF75}</AdobeCode>
    <AdobeCode>{8924D50D-0846-482C-85C4-486687280EBF}</AdobeCode>
    <AdobeCode>{2646C0E8-6C86-46BD-B4F2-43CB503F92B1}</AdobeCode>
    <AdobeCode>{841A4052-6518-476F-8FA3-2DD19A88D2D9}</AdobeCode>
    <AdobeCode>{9C3FB8CD-671F-4F92-923C-65AA7640BDBB}</AdobeCode>
    <AdobeCode>{13A230B2-C25A-43AB-8424-36D1F8F11921}</AdobeCode>
    <AdobeCode>{09A10FBB-B2AF-4CD7-B645-E51563954E65}</AdobeCode>
    <AdobeCode>{F6011ECE-7641-4196-BEE4-215B5A895C08}</AdobeCode>
    <AdobeCode>{1097ED9D-87AB-499D-B9D1-3E6B6A975896}</AdobeCode>
    <AdobeCode>{6280926C-CE25-4E27-B1AE-AC4102ACB6A1}</AdobeCode>
    <AdobeCode>{173C7D6E-DA22-43F0-8363-4CF442328BAD}</AdobeCode>
    <AdobeCode>{7B29FE33-E7B4-4FCB-82EC-2B7093A64B71}</AdobeCode>
    <AdobeCode>{9AEA8FC4-ABBC-4F59-9210-6D354FFB95DD}</AdobeCode>
    <AdobeCode>{CA0E8B60-595F-4A40-8DFF-FF39BCEAD13D}</AdobeCode>
    <AdobeCode>{3048D80A-891A-4EB2-A937-0461478FD235}</AdobeCode>
    <AdobeCode>{92DBEEAB-3B9F-46BE-93DA-C648804204F9}</AdobeCode>
    <AdobeCode>{2B3D668C-708B-4C36-88B0-945EBAEB1777}</AdobeCode>
    <AdobeCode>{DF7401EC-145A-4395-BE30-452D9D5BAC72}</AdobeCode>
    <AdobeCode>{A6D36229-70E3-4C47-A00E-AAF364A36228}</AdobeCode>
    <AdobeCode>{9A4FB1B1-5CE6-4065-8491-F4F53D341157}</AdobeCode>
    <AdobeCode>{C581F3FF-C9B7-4079-8172-B0CB601B5F39}</AdobeCode>
    <AdobeCode>{E4CA795B-4A30-4D7C-923D-2C76A6F85124}</AdobeCode>
    <AdobeCode>{D31934CE-FC38-47F5-8404-040AF4FEFE09}</AdobeCode>
    <AdobeCode>{2AA07E06-C603-44F5-BAB6-48AF005E9030}</AdobeCode>
    <AdobeCode>{9D99587C-25A2-4430-8B95-946909ED31E9}</AdobeCode>
    <AdobeCode>{526FBE18-64B4-44A0-AA4B-B74FADC5C3E7}</AdobeCode>
    <AdobeCode>{61E49F71-49F4-46F3-B476-EB711CB5B7D8}</AdobeCode>
    <AdobeCode>{3D83E489-9F6B-46CC-88DC-F593E0BFDCD0}</AdobeCode>
    <AdobeCode>{9210329A-DF76-4DCF-B340-ACAE6020D3FB}</AdobeCode>
    <AdobeCode>{D107789A-BB44-44A9-8057-A3167CECF14A}</AdobeCode>
    <AdobeCode>{9B12F154-A294-4AF8-84A3-313C329D0891}</AdobeCode>
    <AdobeCode>{5AF3D2AD-962A-450A-83E2-6A9D06884D23}</AdobeCode>
    <AdobeCode>{8DC70961-12FA-46A0-874B-02543A73CF97}</AdobeCode>
    <AdobeCode>{35ADD03C-B12A-4AD6-9C33-5DA6DDB85C71}</AdobeCode>
    <AdobeCode>{7BE96726-CF2C-480E-8E14-DB7E2CA56100}</AdobeCode>
    <AdobeCode>{E027B6D9-4BDE-4992-82C9-82DDF1B2434E}</AdobeCode>
    <AdobeCode>{BF9DB794-C8D6-4742-8DEE-212EFBE958ED}</AdobeCode>
    <AdobeCode>{E03C642A-97D6-4F2C-A291-FF54DFA88564}</AdobeCode>
    <AdobeCode>{BCC3926D-ED28-4643-BAE0-A7272E1F7676}</AdobeCode>
    <AdobeCode>{9AC99C10-4BAF-4F88-A31C-EC5F33CDB8B2}</AdobeCode>
    <AdobeCode>{987B4012-48AF-4387-9621-5EA0711A5030}</AdobeCode>
    <AdobeCode>{5F1736C7-125C-43F7-929E-A601806A132D}</AdobeCode>
    <AdobeCode>{9BA7648F-ADC7-4C2A-93C6-D625C5F9F98F}</AdobeCode>
    <AdobeCode>{D4768788-C700-463F-BE4E-69288304017F}</AdobeCode>
    <AdobeCode>{740E816A-8D59-4009-8207-4411C67F3952}</AdobeCode>
    <AdobeCode>{BEAB5EBF-0356-4059-B20A-1A6A0BCD57EA}</AdobeCode>
    <AdobeCode>{C8885CA0-BFEB-48B8-8A0F-46271B5D11E2}</AdobeCode>
    <AdobeCode>{E9263770-D02D-459B-8D1D-7EBA082A8508}</AdobeCode>
    <AdobeCode>{6857BEEE-FD19-45F0-BDB8-96EE22918C63}</AdobeCode>
    <AdobeCode>{09FF0547-94B0-48D3-B7F8-5BECCDD5674F}</AdobeCode>
    <AdobeCode>{E7F4E4FB-61C3-4888-A802-58B1D1278A8D}</AdobeCode>
    <AdobeCode>{D7B86BE6-B571-47E0-A323-657F5016CC68}</AdobeCode>
    <AdobeCode>{C1415E51-D2E9-40CD-8223-CA714A46076F}</AdobeCode>
    <AdobeCode>{24FC8F2F-79AF-4F9B-B3A0-3DF862F005A4}</AdobeCode>
    <AdobeCode>{8685F2E2-F1FD-417E-B519-7EED23882BE4}</AdobeCode>
    <AdobeCode>{863B7CCF-9B24-4BEC-9BBC-5850AD318407}</AdobeCode>
    <AdobeCode>{A05C0B12-1C0E-4DBF-A8C4-BC1AF37688F0}</AdobeCode>
    <AdobeCode>{87B1C872-3617-4E20-80E4-6A7F667E1780}</AdobeCode>
    <AdobeCode>{45B857A4-D6A1-432A-B978-2CFA81033F7E}</AdobeCode>
    <AdobeCode>{E1DB326F-03D5-48DF-86CB-F7157A98B5E0}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeAuditionCS5.5LangPacken_US-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (en_US) </DisplayName>
  </Channel><Extends type="langPack">
    <ParentProductInfo>
					<Family>DVA</Family>
					<ProductName>Adobe Audition</ProductName>
				</ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="0" sysDriveSize="773"><Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>773</TotalSize>
      <MaxPathComponent>/HelpCfg/en_US\Audition_4.0.helpcfg</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="773"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="en_US">9</Value>
      <Value lang="en_GB">9</Value>
      <Value lang="pt_BR">9</Value>
      <Value lang="nl_NL">9</Value>
      <Value lang="zh_TW">9</Value>
      <Value lang="sv_SE">9</Value>
      <Value lang="cs_CZ">9</Value>
      <Value lang="pl_PL">9</Value>
      <Value lang="ru_RU">9</Value>
      <Value lang="tr_TR">9</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="en_US">Adobe Audition CS5.5 LangPack (en_US) </Value>
      <Value lang="en_GB">Adobe Audition CS5.5 LangPack (en_US) </Value>
      <Value lang="pt_BR">Adobe Audition CS5.5 LangPack (en_US) </Value>
      <Value lang="nl_NL">Adobe Audition CS5.5 LangPack (en_US) </Value>
      <Value lang="zh_TW">Adobe Audition CS5.5 LangPack (en_US) </Value>
      <Value lang="sv_SE">Adobe Audition CS5.5 LangPack (en_US) </Value>
      <Value lang="cs_CZ">Adobe Audition CS5.5 LangPack (en_US) </Value>
      <Value lang="pl_PL">Adobe Audition CS5.5 LangPack (en_US) </Value>
      <Value lang="ru_RU">Adobe Audition CS5.5 LangPack (en_US) </Value>
      <Value lang="tr_TR">Adobe Audition CS5.5 LangPack (en_US) </Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "0", "ChannelID", "AdobeAuditionCS5.5LangPacken_US-9")
INSERT INTO PayloadData VALUES("{AD60EB24-4CEE-4CA0-A6AA-526EAF41F2DB}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeAuditionCS5.5LangPacken_US-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (en_US) </DisplayName>
  </Channel>')
