CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{EA8368CE-4D6D-42A5-B45A-2F648341E57C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{C55E0DF9-84A7-4BC3-B816-D86E649A72D3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{CF4335F5-10E2-44F1-90BD-5539C54C2E65}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{864400F4-7C9F-4CBB-8CFB-D8FC655D1AAD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{50DD7ABA-2F27-47A9-A964-006E8AB6B95D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{F6BE9856-A047-4914-AED6-00C141647868}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{BCC9F135-0518-49FA-B171-EAB6DD9E12FE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{FBADBC3D-3296-477B-9B40-2C582F42A301}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{C46D985B-F9DC-4093-8473-A20D111129EA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{3DBBAAAB-F621-4191-BD7B-379CD8384541}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{990C38A9-74DD-4089-AD92-A5FFB27B745D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{8A7CEF4F-3675-45F5-B89D-5EE049AAA9F6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{3A1BAE32-4777-4C87-81A5-424342E10780}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{2F7FFA19-FBD3-4194-BAC1-C47EC3C3CDAC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{901AB1A7-52DC-46CB-9154-8B3ACFF29038}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{20B2D3C1-3B87-468D-B72B-510F31DB9119}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{38BB389E-5B63-4C57-BBC1-5AFD01D3F589}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{4C6A1ECC-4968-4CA4-A2F6-2F84B2E61557}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{E9024591-D386-42AC-AD95-57A24D7F2E25}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{1BECBD19-07EE-44C9-987D-C3899580014B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{093D3208-ED75-4D24-80B6-7E0C0F46536A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{A8F13132-A094-4FD8-8D1E-B4AD0D3CD52D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{63C71020-B117-43DA-A26F-8388B72521FF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{D05985BE-5C4C-4F91-9ACF-8B2F39D16776}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{53AE3BC0-8293-4041-88DC-E625481B1A93}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{BBF66042-18C9-4F48-9252-4E6B20FA136A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{33920D5C-B3EE-4EF7-8017-F6E60A2831D8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{47B8A110-56C2-4ADF-904A-1E8A676B09B5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{EB2D7D1F-BABD-471B-BD7B-6C2ED09FF9FC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{DF90541E-9FB0-46F8-8751-4812257FB36A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{7F062257-38A3-4769-A882-15E1A14B90E5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{AF36C92D-A058-46C8-9049-D6B8FD9D04D1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{6093A892-2839-478D-AC82-1B2F4B0E2F61}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{08B043DF-0518-40CA-BE3F-26C1CA9C0FD7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{371491FE-EABB-4128-966F-1F634B3A012E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{BF3F2AF8-568B-45A7-A397-6511DF1C53DC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{B49F0200-2BCD-4212-8F04-97B84944014C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{A0B2DB07-EE00-48FB-8C14-F48647F3C3C0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{C6B32426-31F5-4BE3-B21B-559ED08ED9EF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{2F188E4A-8819-497B-9059-5D4AB0074BD2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{1A55507B-B987-4D0D-AA6C-562F2A70E0D0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{B8B545DF-946A-4999-9143-05C23A8CC786}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{B79D7374-9E87-4736-BD1E-62C83DD5CEB2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{12EF6B85-2147-432B-81F7-647E1A6877E5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{1D44F07B-9CE6-4C17-82FB-334610547DB4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{9C849056-9191-4456-9FF1-9EFEACE9CEBB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{6ECCD836-21FC-4F53-A334-769627C248D2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{34D771F4-8FB9-4C3F-82F4-7B09F8C0B54D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{A139D282-DCD6-494A-B0D4-8852C403C5C1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{AA55BC57-4B14-489A-898B-FFEE7DB0EFE1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{845708AC-E1A8-4C52-95A5-04FA475B9BE5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{DABC2CD5-CCFC-44DF-A3A8-1BD44CCEC6A9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{102EDEB8-79C1-4334-8BD9-2201F288B9D3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{DE2BD7F2-7272-47CC-8E8E-1A7A71AC8E0F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{E7EECD96-746D-4496-9001-1F31B505D869}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{A7E2E771-8B22-4601-9D70-7691815AB075}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{1D0EAD6D-4F7A-4A52-883E-30627AA8D3FC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{EADE0655-B2BC-440B-96F4-3199C23563E1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{8822D857-5FBA-45CA-8D6D-0ACD7738DBEA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{5C879EB6-7D06-4533-82CA-711DF8683A56}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{B6F9FB85-B052-4D64-9BA1-22994E3DA251}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{AED31F61-981B-41DE-86ED-2129A5FAF507}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{D77C808B-09A2-4148-AD2E-47A07D8FBC39}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{F3F7F515-371D-46AC-852A-0CE8950234EC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{536884D3-0491-47C2-AAA2-56731BE8D4D3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{8556888C-04BD-4177-9B43-C842D131192A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{0F429228-DE82-485B-A25C-9EB22152D007}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{B46D24FD-BA4A-4655-8824-06BAAB79AB4F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{DE7FB9BA-5DB1-40D5-B624-767D34D9A67D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{7C3E2965-B7D2-4C69-B4A0-A8BA2E12AFF3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{1AB45BEF-0836-45B4-8261-F377BBC7ED8F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{445DF5FA-5767-4DFD-B549-E00B33CFDE3B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{29B6D906-4655-4B8E-88BA-91A120ADD935}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{AE1E83D4-61F4-4E5B-811D-F922472884C6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{400FEB04-A0D5-48CD-BAC8-C150314CFB39}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{3C9C04E1-C723-44C3-B665-7391EBCC8859}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{0BDA3E51-6BBA-45A8-9904-B9AC4D6462DD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{810E2BB1-7553-4826-AEFA-7E24BDE04615}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{E63E1496-09F7-418C-A0E0-27751A4B01F6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{B99639CD-2516-4E88-AFB8-B903B8144408}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{38929B56-5D66-4831-A6CA-4E56F40EA0EB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{241F90C7-B281-477C-B60B-43FB264474CF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{C7BE0B4D-1713-4E9E-BDD8-030CABCF1C34}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{A6A6EABA-3FBD-4094-A195-70C2439EE6DB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{3A2E2A8F-690D-4387-8BA4-64A2D01FE2A1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{8FD4C4F3-B3A4-4E31-B962-6DDE05AF3894}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{9CACC32B-1174-4299-B61C-3ED39060E3F0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{7C7D6E03-26B2-4910-B90F-294563AA78B4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{708B41F4-DA0F-4E19-8537-6969E246EBB1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{C0F560CB-D2EF-4984-8AF1-8FDD6B1F9461}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{89FB0F0E-3C0F-4BFA-BB16-0945778252CB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{A60F8CEA-D131-421B-BC7D-707CA0786930}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{CD31F671-689E-485D-A919-E821394590D7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{E58CD778-2123-4453-A7D3-0939F2AD6C1D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{0FC99101-AF56-40FD-B070-176678B21B2C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{FADE3576-3AF9-4C2C-96B6-E1B6AA6E9A71}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{E03423FB-FC2E-4795-8334-7202CDD5CBAB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{648E4F37-4760-4395-B055-089265FB7E8F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{0800C807-BDCE-4FF6-8BB4-3EBCEEAB4D43}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{D8C8A988-82E5-4BE9-88A8-D7B5D4EB432A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{AFEF1ACF-09F9-4F96-BA9B-EEEF7B437B7E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{9E6A4A4F-472A-4DD0-B346-5DD0479BC4B4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{AF3A60A2-F8A0-4BD2-B918-211498E03ED7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{E0614748-D305-47FA-B684-B936425B5906}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{48E9681F-8160-486B-953D-77695AF75FA9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{536820F1-EC3E-436E-BBC6-5D3F39C6374B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{85630752-0B32-44B4-90C4-CCD7281CA61F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{54F5DE23-EF1E-4A7C-87AA-F3BA7E89B281}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{C0F2CD5A-8E2E-4A08-9006-3D4D00BBEF91}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{AA5EEC0A-2134-4976-AE81-6AD018137FF2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{F3EF725E-0D39-4FD7-80F1-2E4B11BC3392}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{46472C85-8906-4676-87E9-52E3F8DE753A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{84257FBF-BCDB-4C1B-A2C2-A1993CDA2C78}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{3106B90A-5990-4C30-8580-109D017A20CF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{805FDD98-9E22-4DD5-9119-9E64FBC78D3B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{98A56898-02D7-4488-B7C7-3964A95DC545}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{327F83C9-6B75-42E3-8969-15E08611F91A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{EEF3B2AD-30C9-46AF-830D-2BB2CBAD472B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{B0896B84-F568-4034-8BA6-6151C39AAC86}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{7762AC04-D9D0-412B-BAB6-AF6FE906530D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{848F8186-5EC6-490E-979B-D527FA83D104}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{4BCC7FDF-23FD-4DF2-9D8A-ACCF86662A87}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{41B32438-A809-497D-9477-F9D847B6B29F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{9D418E30-F311-43E9-9173-C1F8CEAB0A34}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{3C09EBF0-545C-4E9C-A9B7-E6F4662F1BFB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{182A25E0-89D0-4E0A-A3BC-FCC645581B5D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{429DB082-7C3F-4DBF-87A9-1C198FAFC95A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{A4E82B96-1EC3-4659-AA33-2CB6C162A012}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{610A3760-76AE-4AC1-BF7F-575244743FD4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{F0E9C5B8-9483-440C-9FF2-2F5F530EAC5A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{40A56A18-CC45-46E2-B5A3-5E6B702AEA08}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{2E757A7C-1197-4F16-969E-CCF1C78B9525}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{BD1A958B-86EA-4358-B15C-F8BC9A7ED564}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{9D7E5CC3-7907-421E-B478-84DE855832B2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{572AE699-831D-4FAD-BFE1-B9983945CFFB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{848ECC19-350C-49FD-B21D-64B7F0CE5BE1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{257CF1D9-AFBD-404A-9300-2D794CE67B01}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{3821EAE8-60BF-48A1-BCD9-624D04193585}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{9CDE25BE-64FD-4AD1-8D57-E0FAC477A044}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{557A69FA-485C-4DE5-B80C-68471B7E3134}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{DB2766F6-6504-4EE8-98BD-71BBCF25185D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{FAA2C4A8-03F8-4268-8D4E-5D9B852A4D72}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{C5755787-039D-47E7-9D43-C5B83AC13B98}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{A2824092-B860-4F4D-B11F-79B75009B9A2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{57389CC5-6789-4523-8D5B-E4EC3E2A13DE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{B83C2CC1-C3B9-4000-852B-3FC45C138825}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{EA613753-819A-43E4-A30C-34370B634EEE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{EDD963A3-E81D-46B9-B4EB-85876DAFBEDD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{247C254F-4AD7-45CE-8462-20FDC3AF3462}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{DAB0D09C-27DF-436B-9B9D-1E99C1A64310}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{63FBDB64-97DC-405E-AC05-6045D70CF22D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{23ABFC43-3CE8-4A3C-AB6A-C493FF4F49A9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{3A5D5C63-03C0-4FD8-A15E-A298060D9E62}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{B302AC66-549C-427F-B10D-45D23AB28057}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{BD44E234-47F2-44F4-888E-94F98AB4B24B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{8577D9F2-E0C8-4EBE-8D01-E6D247BE7F21}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{18732E21-BEE7-473A-9455-08CAB4EC99E9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{358A1686-1CA6-4E1B-9E4D-D4C0F2E8185A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{4F3BD34D-AEB3-463F-B5A5-13C48F3FFD42}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{AA249B1C-4D43-4051-AE55-290145C7A692}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{1AA7DCDC-CE1F-4BBE-9489-8A60D90F8EDA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{94868760-2A9E-4BAE-B5FD-7C3CA3D42589}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{F934FF1B-3DA0-4E75-B30A-31EB3E4A8CB2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{56E07153-37EE-446D-AB51-091853B86A15}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{A39106A8-E562-4C5D-9FA4-BEDD51BFC064}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{C813CDE5-3927-4246-8512-27D77DAE1C4E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{F79D3FFD-A18A-4A74-B95D-A5C2244FE6B4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{4650079F-BB46-46F8-A5B8-F5769ECDDD7D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{E98C4CD5-0443-4D07-93DE-8349432909CE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "{C8E36286-B8E5-49AC-B061-472376281FF1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "", "langPack", "DVA", "Adobe Audition", "")
INSERT INTO Payloads VALUES	("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "DVA", "Adobe Audition_AdobeAudition4de_DELanguagePack", "9", "langPack")
INSERT INTO PayloadData VALUES("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "0" , "PayloadInfo", '<PayloadInfo version="4.0.19.0"><BuildInfo>
    <Property name="Created">2011-03-24 13:26:01.321000</Property>
    <Property name="TargetName">AdobeAudition4de_DELanguagePack</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}</Property>
    <Property name="ProductName">Adobe Audition CS5.5 LangPack (de_DE) </Property>
    <Property name="ProductVersion">9</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
  </InstallDir><Languages>
    <Language>de_DE</Language>
  </Languages><Satisfies>
    <ProductInfo>
		<Family>DVA</Family>
		<ProductName>Adobe Audition_AdobeAudition4de_DELanguagePack</ProductName>
	<ProductVersion>9</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{EA8368CE-4D6D-42A5-B45A-2F648341E57C}</AdobeCode>
  </Upgrades><Conflicts>
    <AdobeCode>{C55E0DF9-84A7-4BC3-B816-D86E649A72D3}</AdobeCode>
    <AdobeCode>{CF4335F5-10E2-44F1-90BD-5539C54C2E65}</AdobeCode>
    <AdobeCode>{864400F4-7C9F-4CBB-8CFB-D8FC655D1AAD}</AdobeCode>
    <AdobeCode>{50DD7ABA-2F27-47A9-A964-006E8AB6B95D}</AdobeCode>
    <AdobeCode>{F6BE9856-A047-4914-AED6-00C141647868}</AdobeCode>
    <AdobeCode>{BCC9F135-0518-49FA-B171-EAB6DD9E12FE}</AdobeCode>
    <AdobeCode>{FBADBC3D-3296-477B-9B40-2C582F42A301}</AdobeCode>
    <AdobeCode>{C46D985B-F9DC-4093-8473-A20D111129EA}</AdobeCode>
    <AdobeCode>{3DBBAAAB-F621-4191-BD7B-379CD8384541}</AdobeCode>
    <AdobeCode>{990C38A9-74DD-4089-AD92-A5FFB27B745D}</AdobeCode>
    <AdobeCode>{8A7CEF4F-3675-45F5-B89D-5EE049AAA9F6}</AdobeCode>
    <AdobeCode>{3A1BAE32-4777-4C87-81A5-424342E10780}</AdobeCode>
    <AdobeCode>{2F7FFA19-FBD3-4194-BAC1-C47EC3C3CDAC}</AdobeCode>
    <AdobeCode>{901AB1A7-52DC-46CB-9154-8B3ACFF29038}</AdobeCode>
    <AdobeCode>{20B2D3C1-3B87-468D-B72B-510F31DB9119}</AdobeCode>
    <AdobeCode>{38BB389E-5B63-4C57-BBC1-5AFD01D3F589}</AdobeCode>
    <AdobeCode>{4C6A1ECC-4968-4CA4-A2F6-2F84B2E61557}</AdobeCode>
    <AdobeCode>{E9024591-D386-42AC-AD95-57A24D7F2E25}</AdobeCode>
    <AdobeCode>{1BECBD19-07EE-44C9-987D-C3899580014B}</AdobeCode>
    <AdobeCode>{093D3208-ED75-4D24-80B6-7E0C0F46536A}</AdobeCode>
    <AdobeCode>{A8F13132-A094-4FD8-8D1E-B4AD0D3CD52D}</AdobeCode>
    <AdobeCode>{63C71020-B117-43DA-A26F-8388B72521FF}</AdobeCode>
    <AdobeCode>{D05985BE-5C4C-4F91-9ACF-8B2F39D16776}</AdobeCode>
    <AdobeCode>{53AE3BC0-8293-4041-88DC-E625481B1A93}</AdobeCode>
    <AdobeCode>{BBF66042-18C9-4F48-9252-4E6B20FA136A}</AdobeCode>
    <AdobeCode>{33920D5C-B3EE-4EF7-8017-F6E60A2831D8}</AdobeCode>
    <AdobeCode>{47B8A110-56C2-4ADF-904A-1E8A676B09B5}</AdobeCode>
    <AdobeCode>{EB2D7D1F-BABD-471B-BD7B-6C2ED09FF9FC}</AdobeCode>
    <AdobeCode>{DF90541E-9FB0-46F8-8751-4812257FB36A}</AdobeCode>
    <AdobeCode>{7F062257-38A3-4769-A882-15E1A14B90E5}</AdobeCode>
    <AdobeCode>{AF36C92D-A058-46C8-9049-D6B8FD9D04D1}</AdobeCode>
    <AdobeCode>{6093A892-2839-478D-AC82-1B2F4B0E2F61}</AdobeCode>
    <AdobeCode>{08B043DF-0518-40CA-BE3F-26C1CA9C0FD7}</AdobeCode>
    <AdobeCode>{371491FE-EABB-4128-966F-1F634B3A012E}</AdobeCode>
    <AdobeCode>{BF3F2AF8-568B-45A7-A397-6511DF1C53DC}</AdobeCode>
    <AdobeCode>{B49F0200-2BCD-4212-8F04-97B84944014C}</AdobeCode>
    <AdobeCode>{A0B2DB07-EE00-48FB-8C14-F48647F3C3C0}</AdobeCode>
    <AdobeCode>{C6B32426-31F5-4BE3-B21B-559ED08ED9EF}</AdobeCode>
    <AdobeCode>{2F188E4A-8819-497B-9059-5D4AB0074BD2}</AdobeCode>
    <AdobeCode>{1A55507B-B987-4D0D-AA6C-562F2A70E0D0}</AdobeCode>
    <AdobeCode>{B8B545DF-946A-4999-9143-05C23A8CC786}</AdobeCode>
    <AdobeCode>{B79D7374-9E87-4736-BD1E-62C83DD5CEB2}</AdobeCode>
    <AdobeCode>{12EF6B85-2147-432B-81F7-647E1A6877E5}</AdobeCode>
    <AdobeCode>{1D44F07B-9CE6-4C17-82FB-334610547DB4}</AdobeCode>
    <AdobeCode>{9C849056-9191-4456-9FF1-9EFEACE9CEBB}</AdobeCode>
    <AdobeCode>{6ECCD836-21FC-4F53-A334-769627C248D2}</AdobeCode>
    <AdobeCode>{34D771F4-8FB9-4C3F-82F4-7B09F8C0B54D}</AdobeCode>
    <AdobeCode>{A139D282-DCD6-494A-B0D4-8852C403C5C1}</AdobeCode>
    <AdobeCode>{AA55BC57-4B14-489A-898B-FFEE7DB0EFE1}</AdobeCode>
    <AdobeCode>{845708AC-E1A8-4C52-95A5-04FA475B9BE5}</AdobeCode>
    <AdobeCode>{DABC2CD5-CCFC-44DF-A3A8-1BD44CCEC6A9}</AdobeCode>
    <AdobeCode>{102EDEB8-79C1-4334-8BD9-2201F288B9D3}</AdobeCode>
    <AdobeCode>{DE2BD7F2-7272-47CC-8E8E-1A7A71AC8E0F}</AdobeCode>
    <AdobeCode>{E7EECD96-746D-4496-9001-1F31B505D869}</AdobeCode>
    <AdobeCode>{A7E2E771-8B22-4601-9D70-7691815AB075}</AdobeCode>
    <AdobeCode>{1D0EAD6D-4F7A-4A52-883E-30627AA8D3FC}</AdobeCode>
    <AdobeCode>{EADE0655-B2BC-440B-96F4-3199C23563E1}</AdobeCode>
    <AdobeCode>{8822D857-5FBA-45CA-8D6D-0ACD7738DBEA}</AdobeCode>
    <AdobeCode>{5C879EB6-7D06-4533-82CA-711DF8683A56}</AdobeCode>
    <AdobeCode>{B6F9FB85-B052-4D64-9BA1-22994E3DA251}</AdobeCode>
    <AdobeCode>{AED31F61-981B-41DE-86ED-2129A5FAF507}</AdobeCode>
    <AdobeCode>{D77C808B-09A2-4148-AD2E-47A07D8FBC39}</AdobeCode>
    <AdobeCode>{F3F7F515-371D-46AC-852A-0CE8950234EC}</AdobeCode>
    <AdobeCode>{536884D3-0491-47C2-AAA2-56731BE8D4D3}</AdobeCode>
    <AdobeCode>{8556888C-04BD-4177-9B43-C842D131192A}</AdobeCode>
    <AdobeCode>{0F429228-DE82-485B-A25C-9EB22152D007}</AdobeCode>
    <AdobeCode>{B46D24FD-BA4A-4655-8824-06BAAB79AB4F}</AdobeCode>
    <AdobeCode>{DE7FB9BA-5DB1-40D5-B624-767D34D9A67D}</AdobeCode>
    <AdobeCode>{7C3E2965-B7D2-4C69-B4A0-A8BA2E12AFF3}</AdobeCode>
    <AdobeCode>{1AB45BEF-0836-45B4-8261-F377BBC7ED8F}</AdobeCode>
    <AdobeCode>{445DF5FA-5767-4DFD-B549-E00B33CFDE3B}</AdobeCode>
    <AdobeCode>{29B6D906-4655-4B8E-88BA-91A120ADD935}</AdobeCode>
    <AdobeCode>{AE1E83D4-61F4-4E5B-811D-F922472884C6}</AdobeCode>
    <AdobeCode>{400FEB04-A0D5-48CD-BAC8-C150314CFB39}</AdobeCode>
    <AdobeCode>{3C9C04E1-C723-44C3-B665-7391EBCC8859}</AdobeCode>
    <AdobeCode>{0BDA3E51-6BBA-45A8-9904-B9AC4D6462DD}</AdobeCode>
    <AdobeCode>{810E2BB1-7553-4826-AEFA-7E24BDE04615}</AdobeCode>
    <AdobeCode>{E63E1496-09F7-418C-A0E0-27751A4B01F6}</AdobeCode>
    <AdobeCode>{B99639CD-2516-4E88-AFB8-B903B8144408}</AdobeCode>
    <AdobeCode>{38929B56-5D66-4831-A6CA-4E56F40EA0EB}</AdobeCode>
    <AdobeCode>{241F90C7-B281-477C-B60B-43FB264474CF}</AdobeCode>
    <AdobeCode>{C7BE0B4D-1713-4E9E-BDD8-030CABCF1C34}</AdobeCode>
    <AdobeCode>{A6A6EABA-3FBD-4094-A195-70C2439EE6DB}</AdobeCode>
    <AdobeCode>{3A2E2A8F-690D-4387-8BA4-64A2D01FE2A1}</AdobeCode>
    <AdobeCode>{8FD4C4F3-B3A4-4E31-B962-6DDE05AF3894}</AdobeCode>
    <AdobeCode>{9CACC32B-1174-4299-B61C-3ED39060E3F0}</AdobeCode>
    <AdobeCode>{7C7D6E03-26B2-4910-B90F-294563AA78B4}</AdobeCode>
    <AdobeCode>{708B41F4-DA0F-4E19-8537-6969E246EBB1}</AdobeCode>
    <AdobeCode>{C0F560CB-D2EF-4984-8AF1-8FDD6B1F9461}</AdobeCode>
    <AdobeCode>{89FB0F0E-3C0F-4BFA-BB16-0945778252CB}</AdobeCode>
    <AdobeCode>{A60F8CEA-D131-421B-BC7D-707CA0786930}</AdobeCode>
    <AdobeCode>{CD31F671-689E-485D-A919-E821394590D7}</AdobeCode>
    <AdobeCode>{E58CD778-2123-4453-A7D3-0939F2AD6C1D}</AdobeCode>
    <AdobeCode>{0FC99101-AF56-40FD-B070-176678B21B2C}</AdobeCode>
    <AdobeCode>{FADE3576-3AF9-4C2C-96B6-E1B6AA6E9A71}</AdobeCode>
    <AdobeCode>{E03423FB-FC2E-4795-8334-7202CDD5CBAB}</AdobeCode>
    <AdobeCode>{648E4F37-4760-4395-B055-089265FB7E8F}</AdobeCode>
    <AdobeCode>{0800C807-BDCE-4FF6-8BB4-3EBCEEAB4D43}</AdobeCode>
    <AdobeCode>{D8C8A988-82E5-4BE9-88A8-D7B5D4EB432A}</AdobeCode>
    <AdobeCode>{AFEF1ACF-09F9-4F96-BA9B-EEEF7B437B7E}</AdobeCode>
    <AdobeCode>{9E6A4A4F-472A-4DD0-B346-5DD0479BC4B4}</AdobeCode>
    <AdobeCode>{AF3A60A2-F8A0-4BD2-B918-211498E03ED7}</AdobeCode>
    <AdobeCode>{E0614748-D305-47FA-B684-B936425B5906}</AdobeCode>
    <AdobeCode>{48E9681F-8160-486B-953D-77695AF75FA9}</AdobeCode>
    <AdobeCode>{536820F1-EC3E-436E-BBC6-5D3F39C6374B}</AdobeCode>
    <AdobeCode>{85630752-0B32-44B4-90C4-CCD7281CA61F}</AdobeCode>
    <AdobeCode>{54F5DE23-EF1E-4A7C-87AA-F3BA7E89B281}</AdobeCode>
    <AdobeCode>{C0F2CD5A-8E2E-4A08-9006-3D4D00BBEF91}</AdobeCode>
    <AdobeCode>{AA5EEC0A-2134-4976-AE81-6AD018137FF2}</AdobeCode>
    <AdobeCode>{F3EF725E-0D39-4FD7-80F1-2E4B11BC3392}</AdobeCode>
    <AdobeCode>{46472C85-8906-4676-87E9-52E3F8DE753A}</AdobeCode>
    <AdobeCode>{84257FBF-BCDB-4C1B-A2C2-A1993CDA2C78}</AdobeCode>
    <AdobeCode>{3106B90A-5990-4C30-8580-109D017A20CF}</AdobeCode>
    <AdobeCode>{805FDD98-9E22-4DD5-9119-9E64FBC78D3B}</AdobeCode>
    <AdobeCode>{98A56898-02D7-4488-B7C7-3964A95DC545}</AdobeCode>
    <AdobeCode>{327F83C9-6B75-42E3-8969-15E08611F91A}</AdobeCode>
    <AdobeCode>{EEF3B2AD-30C9-46AF-830D-2BB2CBAD472B}</AdobeCode>
    <AdobeCode>{B0896B84-F568-4034-8BA6-6151C39AAC86}</AdobeCode>
    <AdobeCode>{7762AC04-D9D0-412B-BAB6-AF6FE906530D}</AdobeCode>
    <AdobeCode>{848F8186-5EC6-490E-979B-D527FA83D104}</AdobeCode>
    <AdobeCode>{4BCC7FDF-23FD-4DF2-9D8A-ACCF86662A87}</AdobeCode>
    <AdobeCode>{41B32438-A809-497D-9477-F9D847B6B29F}</AdobeCode>
    <AdobeCode>{9D418E30-F311-43E9-9173-C1F8CEAB0A34}</AdobeCode>
    <AdobeCode>{3C09EBF0-545C-4E9C-A9B7-E6F4662F1BFB}</AdobeCode>
    <AdobeCode>{182A25E0-89D0-4E0A-A3BC-FCC645581B5D}</AdobeCode>
    <AdobeCode>{429DB082-7C3F-4DBF-87A9-1C198FAFC95A}</AdobeCode>
    <AdobeCode>{A4E82B96-1EC3-4659-AA33-2CB6C162A012}</AdobeCode>
    <AdobeCode>{610A3760-76AE-4AC1-BF7F-575244743FD4}</AdobeCode>
    <AdobeCode>{F0E9C5B8-9483-440C-9FF2-2F5F530EAC5A}</AdobeCode>
    <AdobeCode>{40A56A18-CC45-46E2-B5A3-5E6B702AEA08}</AdobeCode>
    <AdobeCode>{2E757A7C-1197-4F16-969E-CCF1C78B9525}</AdobeCode>
    <AdobeCode>{BD1A958B-86EA-4358-B15C-F8BC9A7ED564}</AdobeCode>
    <AdobeCode>{9D7E5CC3-7907-421E-B478-84DE855832B2}</AdobeCode>
    <AdobeCode>{572AE699-831D-4FAD-BFE1-B9983945CFFB}</AdobeCode>
    <AdobeCode>{848ECC19-350C-49FD-B21D-64B7F0CE5BE1}</AdobeCode>
    <AdobeCode>{257CF1D9-AFBD-404A-9300-2D794CE67B01}</AdobeCode>
    <AdobeCode>{3821EAE8-60BF-48A1-BCD9-624D04193585}</AdobeCode>
    <AdobeCode>{9CDE25BE-64FD-4AD1-8D57-E0FAC477A044}</AdobeCode>
    <AdobeCode>{557A69FA-485C-4DE5-B80C-68471B7E3134}</AdobeCode>
    <AdobeCode>{DB2766F6-6504-4EE8-98BD-71BBCF25185D}</AdobeCode>
    <AdobeCode>{FAA2C4A8-03F8-4268-8D4E-5D9B852A4D72}</AdobeCode>
    <AdobeCode>{C5755787-039D-47E7-9D43-C5B83AC13B98}</AdobeCode>
    <AdobeCode>{A2824092-B860-4F4D-B11F-79B75009B9A2}</AdobeCode>
    <AdobeCode>{57389CC5-6789-4523-8D5B-E4EC3E2A13DE}</AdobeCode>
    <AdobeCode>{B83C2CC1-C3B9-4000-852B-3FC45C138825}</AdobeCode>
    <AdobeCode>{EA613753-819A-43E4-A30C-34370B634EEE}</AdobeCode>
    <AdobeCode>{EDD963A3-E81D-46B9-B4EB-85876DAFBEDD}</AdobeCode>
    <AdobeCode>{247C254F-4AD7-45CE-8462-20FDC3AF3462}</AdobeCode>
    <AdobeCode>{DAB0D09C-27DF-436B-9B9D-1E99C1A64310}</AdobeCode>
    <AdobeCode>{63FBDB64-97DC-405E-AC05-6045D70CF22D}</AdobeCode>
    <AdobeCode>{23ABFC43-3CE8-4A3C-AB6A-C493FF4F49A9}</AdobeCode>
    <AdobeCode>{3A5D5C63-03C0-4FD8-A15E-A298060D9E62}</AdobeCode>
    <AdobeCode>{B302AC66-549C-427F-B10D-45D23AB28057}</AdobeCode>
    <AdobeCode>{BD44E234-47F2-44F4-888E-94F98AB4B24B}</AdobeCode>
    <AdobeCode>{8577D9F2-E0C8-4EBE-8D01-E6D247BE7F21}</AdobeCode>
    <AdobeCode>{18732E21-BEE7-473A-9455-08CAB4EC99E9}</AdobeCode>
    <AdobeCode>{358A1686-1CA6-4E1B-9E4D-D4C0F2E8185A}</AdobeCode>
    <AdobeCode>{4F3BD34D-AEB3-463F-B5A5-13C48F3FFD42}</AdobeCode>
    <AdobeCode>{AA249B1C-4D43-4051-AE55-290145C7A692}</AdobeCode>
    <AdobeCode>{1AA7DCDC-CE1F-4BBE-9489-8A60D90F8EDA}</AdobeCode>
    <AdobeCode>{94868760-2A9E-4BAE-B5FD-7C3CA3D42589}</AdobeCode>
    <AdobeCode>{F934FF1B-3DA0-4E75-B30A-31EB3E4A8CB2}</AdobeCode>
    <AdobeCode>{56E07153-37EE-446D-AB51-091853B86A15}</AdobeCode>
    <AdobeCode>{A39106A8-E562-4C5D-9FA4-BEDD51BFC064}</AdobeCode>
    <AdobeCode>{C813CDE5-3927-4246-8512-27D77DAE1C4E}</AdobeCode>
    <AdobeCode>{F79D3FFD-A18A-4A74-B95D-A5C2244FE6B4}</AdobeCode>
    <AdobeCode>{4650079F-BB46-46F8-A5B8-F5769ECDDD7D}</AdobeCode>
    <AdobeCode>{E98C4CD5-0443-4D07-93DE-8349432909CE}</AdobeCode>
    <AdobeCode>{C8E36286-B8E5-49AC-B061-472376281FF1}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeAuditionCS5.5LangPackde_DE-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (de_DE) </DisplayName>
  </Channel><Extends type="langPack">
    <ParentProductInfo>
					<Family>DVA</Family>
					<ProductName>Adobe Audition</ProductName>
				</ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="0" sysDriveSize="786"><Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>786</TotalSize>
      <MaxPathComponent>/HelpCfg/de_DE\Audition_4.0.helpcfg</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="786"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="de_DE">9</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="de_DE">Adobe Audition CS5.5 LangPack (de_DE) </Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "0", "ChannelID", "AdobeAuditionCS5.5LangPackde_DE-9")
INSERT INTO PayloadData VALUES("{324AE517-1D0F-4DF8-8394-CD64D7B1BA23}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeAuditionCS5.5LangPackde_DE-9">
    <DisplayName>Adobe Audition CS5.5 LangPack (de_DE) </DisplayName>
  </Channel>')
