/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////
//
// Initialize extension
//
function onLoaded() 
{
	var settings = new Settings();
	settings.load();

	var contentStorage = new LocalContentStorage(getSurfaceFolder());
	contentStorage.getString(null, '$$$/onboarding/audition/title', function(title)
	{
		var cs = new CSInterface();
		cs.setWindowTitle(title);
	});

    initAppearance();
    setPageFont(FONT_WIN, FONT_MAC);
    
    gCtrl = new Controller(onEventDispatch);
}

//////////////////////////////////////////////////////////////
//
// Content storage creator
//
IContentStorage.create = function()
{
    return new MultiContentStorage([getOnBoardingFolder(true) + 'Content/', getOnBoardingFolder(false) + 'Content/'], 
    							   (gUseRemoteContentStorage ? getBaseURL() : null), 
    							   (gCacheRemoteContent ? (getCacheFolder() + 'Content/') : null));
}

//////////////////////////////////////////////////////////////
//
// Workflow storage creator
//
IWorkflowStorage.create = function()
{
	return new MultiWorkflowStorage([getOnBoardingFolder(true) + 'Workflows/', getOnBoardingFolder(false) + 'Workflows/'], 
									(gUseRemoteWorkflowStorage ? getBaseURL() : null), 
									(gCacheRemoteContent ? (getCacheFolder() + 'Workflows/') : null));
}

//////////////////////////////////////////////////////////////
//
// Dispatch workflow selected
//
function onWorkflowSelect(inWorkflowID)
{
	if (isValidProperty(Controller.instance))
	{
		Controller.instance.selectWorkflow(inWorkflowID);
	}
}

//////////////////////////////////////////////////////////////
//
// Dispatch events
//
function onEventDispatch(/*[String]*/ inReason, /*[Any]*/ inData)
{
	switch (inReason)
	{
		case CLICKEVENT_WORKFLOW_SUCCESS_COMMIT:
		case CLICKEVENT_WORKFLOW_CANCEL_COMMIT:
		case WorkflowProcessor.FINISHED_SUCCESS:
		case WorkflowProcessor.FINISHED_FAILURE:
		case WorkflowProcessor.FINISHED_CANCELED:
		{
			if (isValidProperty(Controller.instance))
			{
				Controller.instance.onWorkflowFinished(inReason, inData);
			}
		}
		break;
		
		case WorkflowProcessor.FINISHED_STEP_SUCCESS:
		{
			if (isValidProperty(Controller.instance))
			{
				Controller.instance.onWorkflowStepSucceeded();
			}
		}
		break;
		
		case CLICKEVENT_WORKFLOW_START:
		case CLICKEVENT_WORKFLOW_RESTART:
		case CLICKEVENT_WORKFLOW_CANCEL:
		case CLICKEVENT_WORKFLOW_STEP_REPEAT:
		case CLICKEVENT_WORKFLOW_STEP_EXEC:
		case CLICKEVENT_WORKFLOW_STEP_BACK:
		case CLICKEVENT_WORKFLOW_STEP_SKIP:
		case WorkflowProcessor.FINISHED_NEXT_STEP:
		case WorkflowProcessor.STARTED:
		case WorkflowProcessor.SWITCH_STEP_NEXT:
		case WorkflowProcessor.SWITCH_STEP_PREV:
		{		
			if (isValidProperty(Controller.instance))
			{
				Controller.instance.workflowCommand(inReason);
			}
		}
		break;
	}
}

//////////////////////////////////////////////////////////////////////////////
//
// Get path to Onboarding content
//
function getOnBoardingFolder(/*[Boolean]*/ inInternal)
{
	var obFolder = '';
	var cs = new CSInterface();
	
	if (inInternal)
	{
		if (!__debug__)
		{
			obFolder = cs.getSystemPath(SystemPath.EXTENSION) + '/content/';
		}
		else
		{
			obFolder = cs.getSystemPath(SystemPath.EXTENSION) + '/test_content/';
		}
	}
	else
	{
		var path = getApplicationFolder();
		var pos = path.lastIndexOf('/');

		if (pos >= 0)
		{
			path = path.substring(0, pos);
		}
		else
		{
			path = '';
		}
		
		if (path.length)
		{
			if (!__debug__)
			{
				obFolder = path + '/content/';
			}
			else
			{
				obFolder = path + '/test_content/';
			}
		}
	}
			
	return obFolder;
}

//////////////////////////////////////////////////////////////////////////////
//
// Get path to WorkflowTriggerComponent files
//
function getComponentFolder()
{
	var cs = new CSInterface();
	return cs.getSystemPath(SystemPath.EXTENSION) + '/component/';
}

//////////////////////////////////////////////////////////////////////////////
//
// Get path to surface files
//
function getSurfaceFolder()
{
	var cs = new CSInterface();
	return cs.getSystemPath(SystemPath.EXTENSION) + '/surfaces/';
}

//////////////////////////////////////////////////////////////////////////////
//
// Get path to cached content
//
function getCacheFolder()
{
	return getPreferencesFolder() + 'onboarding_cache/';
}

//////////////////////////////////////////////////////////////////////////////
//
// Get base url for remote content
//
function getBaseURL()
{
	var baseURL = '';
	
	if (__debug__)
	{
		baseURL = REMOTE_URL_DEBUG;
	}
	else
	{
		baseURL = REMOTE_URL_RELEASE;
	}
	
	baseURL = baseURL.trim();
	
	if (baseURL.lastIndexOf('/') != baseURL.length-1)
	{
		baseURL += '/';
	}
	
	return baseURL;
}

//////////////////////////////////////////////////////////////////////////////
//
// Global error handler
//
window.onerror = function() 
{
    dbglog("EXCEPTION: Unhandled exception");
    
    // restart
    gCtrl = new Controller(onEventDispatch);
};