/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////////////////////
//
// Replace content symbols with actual strings
//
function replaceStringSymbols(/*[String]*/ inContent, /*[IContentStorage]*/ inStorage, /*[Function]*/ inCallback)
{
    return replaceSymbols(["${", "}$"], inStorage.getString, inContent, null, inCallback);
}

function replaceURLSymbols(/*[String]*/ inContent, /*[IContentStorage]*/ inStorage, /*[Function]*/ inCallback)
{
    return replaceSymbols(["#{", "}#"], inStorage.getURL, inContent, null, inCallback);
}

function replaceWorkflowStringSymbols(/*[String]*/ inContent, /*[IContentStorage]*/ inStorage, /*[String]*/ inWorkflowID, /*[Function]*/ inCallback)
{
    return replaceSymbols(["${", "}$"], inStorage.getString, inContent, inWorkflowID, inCallback);
}

function replaceWorkflowURLSymbols(/*[String]*/ inContent, /*[IContentStorage]*/ inStorage, /*[String]*/ inWorkflowID, /*[Function]*/ inCallback)
{
    return replaceSymbols(["#{", "}#"], inStorage.getURL, inContent, inWorkflowID, inCallback);
}

function replaceSymbols(/*[Array]*/ inDelimter, /*[Function]*/ inContentFunction, /*[String]*/ inContent, /*[String]*/ inWorkflowID, /*[Function]*/ inCallback)
{
    var intro = inDelimter[0];
    var tail = inDelimter[1];
    var workflowID = inWorkflowID;
    var ret = inContent;
    var contentFct = inContentFunction;
    var callback = inCallback;

    var part1 = '';
    var part2 = '';
    var startPos = -1;
    var endPos = -1;

    function insertSymbolContent(/*[String]*/ inSymbolContent)
    {
        ret = part1 + inSymbolContent + part2;
        startPos = ret.indexOf(intro);

        findNextSymbol();
    }

    function findNextSymbol()
    {
        startPos = ret.indexOf(intro);
        endPos = ret.indexOf(tail);

        if (startPos >= 0 && endPos > 0)
        {
            part1 = ret.substring(0, startPos);
            part2 = ret.substring(endPos + tail.length);

            var symbol = ret.substring(startPos + intro.length, endPos);

            if (symbol.length)
            {
                contentFct(workflowID, symbol, insertSymbolContent);
            }
            else
            {
                insertSymbolContent('');
            }
        }
        else
        {
            callback(ret);
        }
    }

    findNextSymbol();
}

//////////////////////////////////////////////////////////////////////////////
//
// Get current locale
//
function getLocale()
{
    var cs = new CSInterface();
    var env = cs.getHostEnvironment();
    return env.appUILocale;
}

//////////////////////////////////////////////////////////////////////////////
//
// Debug logging
//
function dbgLogWorkflows(/*[String]*/ inFunction, /*[String]*/ inText, /*[Array]*/ inWorkflows)
{
    var idStr = '';

    forEach(inWorkflows, function(workflow)
    {
        if (isValidProperty(workflow))
        {
            if (isValidProperty(workflow.name))
            {
                idStr += workflow.name + ' ';
            }
            if (isValidProperty(workflow.id))
            {
                idStr += '[' + workflow.id + ']';
            }
        }
        idStr += ', ';
    });

    dbglog(inFunction + ' ' + inText + ': ' + idStr);
}

function dbgLogContent(/*[String]*/ inFunction, /*[String]*/ inWorkflowID, /*[String]*/ inContentID, /*[Boolean]*/ inLocalized, /*[String]*/ inText)
{
    var logStr = '';

    if (isValidProperty(inFunction))
    {
        logStr += inFunction + ' ';
    }

    logStr += '[' + inWorkflowID + ', ' + inContentID + ', ' + inLocalized + ']';
    logStr += ' : ' + inText;
    dbglog(logStr);
}